/* ==========================================================================
*      : CardBookWindow.h
*      : 
*    : 谡
*    : 2008-06-10
* ǻ :
*===========================================================================*/
#pragma once
#include "TabWindow.h"

enum eBookPage
{
	ePAGE_DATA = 0,
	ePAGE_TAROT, 
	ePAGE_MONSTER,
	ePAGE_STORY,
	ePAGE_MAX,
};

enum eBookLock
{
	eBook_Open,
	eBook_Close,
};

class cTarotSheetWindow;
class cCardBookWindow : public cTabWindow
{
public:
	cCardBookWindow();
	virtual ~cCardBookWindow();

	///
	void Clear();
	bool UIStageIn();

	///   
	eBookPage GetCurrentPage() { return mPage; }

	/// sheet 
	cTarotSheetWindow* GetTarotSheet() { return mTarotSheet; }

	//
	void SendCardBookOpen();
	void SendCardBookHide();

	void Toggle();
	void HideESC( bool onsound );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* , unsigned int );
	void OnTabButtonPressed( cUINode*, unsigned int id );
	void OnRender( cUIFontItemKeeper* pkeeper );

	///  
	void SetCurrent( unsigned int index );

private:
	eBookPage	mPage;

	cTarotSheetWindow*	mTarotSheet;
};