/* ==========================================================================
*      : CardImage.h
*      : ī̹ ¿ 
*    : 谡
*    : 2007-07-31
* ǻ :
*===========================================================================*/
#pragma once
#include "Label.h"

const int CARD_WIDTH = 120;
const int CARD_HEIGHT = 200;

class cAniPlane;
class cCardParam
{
public:
	/// ؽ
	NiTexture*	mpTexture;

	/// ǥ
	cUIPos	mTexPos;
};

class cCardImage : public cLabel
{
public:
	cCardImage( eUINodeType type = eUINODE_LABEL );
	virtual ~cCardImage();

	enum
	{
		eFade_None = 0,
		eFade_In,
		eFade_Out,

		/// Ȯ!!
		eFade_In_Out, /// fadein -> fadeout
		eFade_Out_In, /// fadeout -> fadein
	};

	///
	bool OnCreate( cUINodeProperty* pproperty );

	/// ̹  
	void SetImage( unsigned long tarotItemIdx, cCardParam* param );

	virtual void UpdateRect();
	
	/// ̹  Ʈ
	void UpdateImage();

	/// ī 
	void ShowImage( bool show, bool showAni= false, unsigned char fadeState = eFade_None );
	bool IsShow() const;

	/// ī / 
	void SetDirection( int dir );

	/// ī  
	void SetLock( bool lock );

	inline bool IsLock() { return mLock; }
	inline unsigned long GetTarotItemIdx() { return mTarotItemIdx; }

protected:
	virtual bool IsValid() const;
	virtual bool SetSkin(const cUINodeSkin* pskin );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool AltPress, bool shiftPress );
	virtual void OnLButtonDoubleClick( const cUIPos& pos );
	virtual void OnMouseLeft(const cUIPos& pos );
	virtual void OnMouseHovered(const cUIPos& pos );

private:
	/// ̹  
	bool mShowImage;

	unsigned char mFadeState;
	unsigned long mAccumTime;
	unsigned long mFadeTime;

	///  
	bool mLock;

	/// ī ̹  
	cCardParam* mpOpenParam;

	/// ޸ ̹  
	cCardParam* mpCloseParam;

	unsigned long mTarotItemIdx;

	cAniPlane* mOpenImage;
	cAniPlane* mCloseImage;

	cAniPlane*	mOverImage;
};

inline void cCardImage::SetLock( bool lock )
{
	mLock = lock;
}

inline bool cCardImage::IsShow() const
{
	return mShowImage;
}