#include "StdAfx.h"
#include "CastingBar.h"
#include "Gauge.h"
#include "UITransformImage.h"

#include "SkillScript.h"
#include "GatheringScript.h"
#include "Gathering_Common.h"
#include "SkillManager.h"
#include "GameResourceManager.h"
#include "Icon.h"
#include "Label.h"

cCastingBar::cCastingBar()
: mpCastingBar(0)
, mType(eCasting_Max)
, mCastingIndex(0)
, mpName(0)
, mpTime(0)
, mpIconImage(0)
, mIconPos(0, 0)
, mStartTime(0)
, mRestTime(0)
{
}

cCastingBar::~cCastingBar()
{
	SAFE_DELETE( mpIconImage );
}

void cCastingBar::SetTime( unsigned long index, eCASTINGTYPE type, unsigned long sec )
{
	if( sec <= 0 )
	{
		assert(0);
		return;
	}
	if( type >= eCasting_Max )
	{
		assert(0);
		return;
	}

	if( mpCastingBar )
	{
		float speed = 100.0f / ((float)sec*0.001f);

		if( speed == 0.0f )
			return;

		mpCastingBar->SetGaugeSpeed( speed );

		mType = type;
		mCastingIndex = index;

		mStartTime = ULONG_MAX;
		mRestTime = sec;
		Show();
	}
}

void cCastingBar::OnShow()
{
	if( mpCastingBar )
		mpCastingBar->SetGaugeAni( 100.0f );

	switch( mType )
	{
	case eCasting_Skill:
		{
			/// ų  
			sPlayerSkillBaseInfo* info = SKILLSCRIPT->GetPlayerSkillInfo( mCastingIndex );
			if( info )
			{
				/// ų
				LPCTSTR name = GAMERESOURCEMAN->GetSkillNameText( info->mNameIdx );
				if( mpName )
					mpName->SetText( name );

				/// ų 
				cIconParam* pParam = UIMAN->GetIconParam( info->mIconIdx );
				assert(pParam);

				if( pParam )
				{
					if( mpIconImage == 0 )
					{	
						mpIconImage = new cUITransformImage;
					}

					mpIconImage->SetTexture( pParam->mpTexture );

					unsigned int x = GetAbsoluteRect().mLeft + mIconPos.mX;
					unsigned int y = GetAbsoluteRect().mTop + mIconPos.mY;
					unsigned int tx = pParam->mTexPos.mX;
					unsigned int ty = pParam->mTexPos.mY;
					mpIconImage->SetTextureRect( tx, ty, tx + 28, ty + 28 );
					mpIconImage->SetScreenRect( cUIRect( x, y, x + 28, y + 28 ) );
				}
			}
		}
		break;
	case eCasting_Gather:
		{
			sGatheringList* info = GATHERINGSCRIPT->GetGatheringInfo( mCastingIndex );
			if( info )
			{
				LPCTSTR name = GAMERESOURCEMAN->GetGatheringName( info->mNameIdx );
				if( mpName )
					mpName->SetText( name );

				cIconParam* pParam = UIMAN->GetIconParam( info->mIconIndex );
				assert(pParam);
				if( pParam )
				{
					if( mpIconImage == 0 )
					{	
						mpIconImage = new cUITransformImage;
					}

					mpIconImage->SetTexture( pParam->mpTexture );

					unsigned int x = GetAbsoluteRect().mLeft + mIconPos.mX;
					unsigned int y = GetAbsoluteRect().mTop + mIconPos.mY;
					unsigned int tx = pParam->mTexPos.mX;
					unsigned int ty = pParam->mTexPos.mY;
					mpIconImage->SetTextureRect( tx, ty, tx + 28, ty + 28 );
					mpIconImage->SetScreenRect( cUIRect( x, y, x + 28, y + 28 ) );
				}
			}
		}
		break;
	default:
		{
			Hide();
		}
		return;
	}

	cUIWindow::OnShow();
}

void cCastingBar::OnHide()
{
	cUIWindow::OnHide();

	if( mpCastingBar )
		mpCastingBar->ClearFront();

	mStartTime = ULONG_MAX;
	mRestTime = 0;

	mCastingIndex = 0;
	mType = eCasting_Max;
}

/// ǻ :
bool cCastingBar::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpCastingBar = (cGauge*)GetChild( eUIID_GAME_CASTINGBAR_GAUGEBAR );
	mpName = (cLabel*)GetChild( eUIID_GAME_CASTINGBAR_SKILLNAME );
	mpTime = (cLabel*)GetChild( eUIID_GAME_CASTINGBAR_SKILLTIME );

	if( mpCastingBar )
		mpCastingBar->SetMaxValue( 100.0f );

	/// ų  ̹ 
	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
		return false;

	cUINodeSkin* pIconSkin = pSkin->GetNodeSkin( "Casting_SkillIcon" );
	if( pIconSkin )
	{
		mIconPos.mX = pIconSkin->mSkinInfo->mX;
		mIconPos.mY = pIconSkin->mSkinInfo->mY;
	}
	else
	{
		assert(0);
		return false;
	}

	return true;
}

void cCastingBar::UpdateRect()
{
	cUIWindow::UpdateRect();

	if( mpIconImage )
	{
		unsigned int x = GetAbsoluteRect().mLeft + mIconPos.mX;
		unsigned int y = GetAbsoluteRect().mTop + mIconPos.mY;
		mpIconImage->SetPos( x, y );
	}
}

void cCastingBar::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	if( mType >= eCasting_Max )
		return;

	if( mStartTime == ULONG_MAX )
		mStartTime = accumTime;

	unsigned long elapsed = accumTime - mStartTime;

	if( mRestTime > elapsed )
	{
		mRestTime -= elapsed;
		mStartTime = accumTime;

		/// ð 
		//unsigned int s = ((unsigned int)(mRestTime/1000) % 60) % 60 + 1;
		float s = (float)( mRestTime * 0.001 );
		SetTimeText( s );
	}
}

void cCastingBar::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	if( mpIconImage )
		mpIconImage->Draw();
}

void cCastingBar::OnGaugeEnd( cUINode* n , unsigned int )
{
	if( mpCastingBar && n == mpCastingBar )
		Hide();
}

float cCastingBar::GetPercent()
{
	if( mpCastingBar )
		return mpCastingBar->GetPercent();

	return 100.0f;
}

void cCastingBar::SetTimeText( float time )
{
	if( mpTime )	
	{
		cStringT str1;
		str1.Format( GAMERESOURCEMAN->GetGameText( 6211 ), time );

		mpTime->SetText( (LPCTSTR)str1.Cstr() );
	}
}
