#include "StdAfx.h"
#include ".\centermsgplane.h"

#include "RenderSystem.h"
#include "CameraManager.h"
#include "FontAgent.h"

cCenterMsgPlane::cCenterMsgPlane()
{
}

cCenterMsgPlane::~cCenterMsgPlane()
{
	Clear();
}

void cCenterMsgPlane::Init( NiPoint3 pos )
{

}

void cCenterMsgPlane::Clear()
{
	cMsgItemList::cIterator i = mMsgList.Begin();
	cMsgItemList::cIterator end = mMsgList.End();
	for( ; i != end; ++i )
	{
		sMsgItem* p = (sMsgItem*)(*i);
		SAFE_DELETE(p);
	}
	mMsgList.Clear();

	i = mDeleteMsgList.Begin();
	end = mDeleteMsgList.End();
	for( ; i != end; ++i )
	{
		sMsgItem* p = (sMsgItem*)(*i);
		SAFE_DELETE(p);
	}
	mDeleteMsgList.Clear();
}


void cCenterMsgPlane::ActiveMsg( LPCTSTR msg, NiPoint3 pos, unsigned long color )
{
	if( msg == 0 )
		return;

	sMsgItem* p = new sMsgItem;
	if( p == 0 )
	{
		assert(0);
		return;
	}
	Sstrncpy( p->Messge, MSG_TEXT_LENGTH, msg, MSG_TEXT_LENGTH-1 );
	p->MsgLen = ::_tcslen( p->Messge );
	if( p->MsgLen == 0 )
	{
		SAFE_DELETE(p);
		return;
	}
	p->MsgWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, p->Messge, p->MsgLen );

	/// ī޶ ǥ - y ǥ 
	float x = 0.0f;
	float y = 0.0f;
	WorldPtToScreenPt( CAMERAMAN->GetCurrentNi(), pos, x, y );
	p->PosX = (int)( (RENDERSYS->GetScreenWidth() - p->MsgWidth) * 0.5f);
	p->PosY  = (int)( (1.0f - y) * RENDERSYS->GetScreenHeight() );
	p->MsgColor = color;

	p->valY = 0.0f;
	p->checkY = 0.0f;
	p->valAlpha = 0.0f;

	/// ޼ ġ   ó
	if( mMsgList.IsEmpty() == false )
	{
		sMsgItem* last = (sMsgItem*)mMsgList.Back();
		if( last )
		{
			int checkHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_System) + 1;
			if( int(p->PosY - last->PosY) < checkHeight )
				p->PrevCheck = true;
		}
	}

	if( mMsgList.PushBack( p ) == false )
	{
		assert(0);
		SAFE_DELETE(p);
		return;
	}
}

void cCenterMsgPlane::Update( unsigned long time )
{
	if( mMsgList.IsEmpty() == true )
		return;

	/// Update
	cMsgItemList::cIterator i = mMsgList.Begin();
	cMsgItemList::cIterator end = mMsgList.End();

	int prevPosY = 0;
	for( ; i != end; ++i )
	{
		sMsgItem* p = (sMsgItem*)(*i);
		if( p == 0 )
			continue;

		/// ޼ ġ   ó
		if( p->PrevCheck )
		{
			unsigned int checkHeight = FONTAGENT->GetTextHeight(cFontAgent::eFont_System) + 1;
			unsigned int gap = p->PosY - prevPosY;
			if( gap >= checkHeight )
				p->PrevCheck = false;

			continue;
		}

		//// change value
		unsigned long color = p->MsgColor & 0xFF000000;
		float alpha = (float)(color>>24);

		/// position process
		p->valY += 100.0f*(time*0.001f);
		p->checkY += 100.0f*(time*0.001f);

		int val = (int)p->valY;
		if( val > 0 )
		{
			p->PosY -= val;
			p->valY -= val;
		}

		if( p->checkY >= 100.0f )
		{
			if( alpha <= val*2 )
			{
				mDeleteMsgList.PushBack(p);
				continue;
			}
			else
				alpha -= val*2;
		}

		p->MsgColor = ((unsigned long)(alpha) << 24) | (p->MsgColor & 0x00FFFFFF) ;
		mBackColor = ((unsigned long)(alpha) << 24) | 0x00111111;

		prevPosY = p->PosY;
	}

	/// delete
	i = mDeleteMsgList.Begin();
	end = mDeleteMsgList.End();
	for( ; i != end; ++i )
	{
		sMsgItem* p = (sMsgItem*)(*i);
		mMsgList.Remove(p);
		SAFE_DELETE(p);
	}
	mDeleteMsgList.Clear();
}

void cCenterMsgPlane::Draw()
{
	if( mMsgList.IsEmpty() == true )
		return;

	cMsgItemList::cIterator i = mMsgList.Begin();
	cMsgItemList::cIterator end = mMsgList.End();
	for( ; i != end; ++i )
	{
		sMsgItem* p = (sMsgItem*)(*i);
		if( p == 0 )
			continue;

		FONTAGENT->DrawText( cFontAgent::eFont_System, p->Messge, p->MsgLen, p->PosX, p->PosY, p->MsgColor );//, true, mBackColor );
	}
}