#include "StdAfx.h"
#include "ChannelWindow.h"
#include "StageManager.h"
#include "SelectStage.h"

#include "Button.h"
#include "ListBox.h"
#include "UIMsgboxEvent.h"


cChannelWindow::cChannelWindow()
: mpChannelList(0)
, mpConnectBtn(0)
{
	for( int i = 0; i < MAXPAGE_NUM; ++i )
		mpRadioNode[i] = 0;

	mCheckRect.Set( 0, 0, 0, 0 );
}

cChannelWindow::~cChannelWindow()
{
	Clear();
}

void cChannelWindow::Clear()
{
	if( mpChannelList )
		mpChannelList->Clear();

	for( unsigned int i = 0; i < mChannelData.GetSize(); ++i )
	{
		delete (sChannelData*)mChannelData[i];
	}
	mChannelData.Clear();

	for( int i = 0 ; i < MAXPAGE_NUM; ++i )
	{
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}
}

void cChannelWindow::OnShow()
{
	if( mpChannelList && mpChannelList->GetRowCount() > 0 )
	{
		if( mpConnectBtn )
			mpConnectBtn->SetEnabled( true );
	}
	else
	{
		if( mpConnectBtn )
			mpConnectBtn->SetEnabled( false );
	}

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );
}

bool cChannelWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpChannelList = (cListBox*)GetChild( eUIID_CHANNEL_CHANNELLISTBOX );
	mpConnectBtn = (cButton*)GetChild( eUIID_CHANNEL_CONNECT_BUTTON );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/// Ŀ
	cUINodeSkin* pRectSkin = pSkin->GetNodeSkin( "Channel_ButtonRect" );
	if( pRectSkin )
	{
		mCheckRect.mLeft = pRectSkin->mSkinInfo->mX;
		mCheckRect.mTop = pRectSkin->mSkinInfo->mY;
		mCheckRect.mRight = mCheckRect.mLeft + pRectSkin->mSkinInfo->mWidth;
		mCheckRect.mBottom = mCheckRect.mTop + pRectSkin->mSkinInfo->mHeight;
	}

	for( int i = 0; i < MAXPAGE_NUM; ++i )
	{
		mpRadioNode[i] = GetChild( eUIID_CHANNEL_RADIOPAGE1 + i );
		if( mpRadioNode[i] )
			mpRadioNode[i]->Hide();
	}
	return true;
}

void cChannelWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = GetRelativeRect().mTop;
	SetRelativePos( cUIPos( x, y) );

	UpdateButton();
}

void cChannelWindow::OnListBoxSelected( cUINode* , unsigned int id )
{
	if( id == eUIID_CHANNEL_CHANNELLISTBOX )
	{
		if( GetSelectedChannelParam() <= -1 )
			return;

		cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
		if( p )
			p->SendConnect( GetSelectedChannelParam() );
	}
}

void cChannelWindow::AddChannel( long param, int status, LPCTSTR channelname, LPCTSTR condition, unsigned long color, bool select )
{
	/// ä   
	sChannelData* data = new sChannelData;
	data->mParam = param;
	data->mStatus = status;
	mChannelData.PushBack( data );

	/// Ʈڽ  
	int row = mpChannelList->AddRow( channelname, mDefaultColor, data );
	if( row <= -1 )
	{
		assert(0);
	}

	if( mpChannelList )
	{
		mpChannelList->AddColume( row, condition, color );

		if( select == true )
			mpChannelList->ChangeSelectRow( row );
	}
}

void cChannelWindow::UpdateButton()
{
	if( !mpChannelList )
	{
		assert(0);
		return;
	}

	/// ư ̰ Ⱥ̰ ϱ
	int total = mpChannelList->GetRowCount() - 1;
	int page = ( total / 10 );

	for( int i = 0; i < MAXPAGE_NUM; ++i )
	{
		if( mpRadioNode[i] )
		{
			if( i <= page )
				mpRadioNode[i]->Show();
			else
				mpRadioNode[i]->Hide();
		}
	}

	/// ġ 
	if( mpRadioNode[0] )
	{
		int w = mpRadioNode[0]->GetAbsoluteRect().GetWidth();	
		int x = mCheckRect.mLeft + (int)((mCheckRect.GetWidth() - (w*(page+1))) * 0.5f);
		for( int i = 0; i <= page; ++i )
		{
			cUIPos pos;
			pos.mX = x + (w*i);
			pos.mY = mpRadioNode[i]->GetRelativeRect().mTop;
			mpRadioNode[i]->SetRelativePos( pos );
		}

		mpRadioNode[0]->SetPress( true );
	}
}

/// ä 
long cChannelWindow::GetSelectedChannelParam()
{
	sChannelData* pData = (sChannelData*)mpChannelList->GetExtraData( mpChannelList->GetSelectIndex() );
	if( pData )
		return pData->mParam;
	return -1;
}

/// äλ
int cChannelWindow::GetSelectedChannelStatus()
{
	sChannelData* pData = (sChannelData*)mpChannelList->GetExtraData( mpChannelList->GetSelectIndex() );
	if( pData )
		return pData->mStatus;
	return -1;
}

void cChannelWindow::OnCommand( cUINode* pcaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_CHANNEL_CONNECT_BUTTON:
		{
			if( GetSelectedChannelParam() <= -1 )
				return;

			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
				p->SendConnect( GetSelectedChannelParam() );
		}
		break;
	case eUIID_CHANNEL_CANCEL_BUTTON:
		{
			cSelectStage* p = (cSelectStage*)STAGEMAN->GetStage( eStage_Select );
			if( p )
				p->CancelChannel();
		}
		break;
	default:
		assert(0);
		break;
	}
}
