#pragma once

/*
Ʋ
131 0 ( 4 * 23 )
135 0 ( 1 * 23 )
136 0 ( 4 * 23 )

143 0 ( 4 * 38 )
147 0 ( 1 * 38 )
148 0 ( 4 * 38 )

155 0 ( 4 * 53 )
159 0 ( 1 * 53 )
160 0 ( 4 * 53 )
*/

#include "DepthPlane.h"

const unsigned int BUBBLE_LINE_MAX = 3;		//  
const unsigned int BUBBLE_TEXT_LENGTH = 13;	//  
const unsigned long BUBBLE_ACTIVE_TIME = 5000;		// 5

struct sTextItem
{
	TCHAR	mText[512];
//	cStringT mText;
	unsigned long mColor;

	unsigned int mWidth;

	sTextItem*	mpNext;

	sTextItem() : mpNext(0) 
	{
		memset( mText, 0, sizeof(TCHAR)*512 );
		mWidth = 0;
	}
};

class cBubbleBase : public cPlane
{
public:
	virtual ~cBubbleBase();

	enum
	{
		LEFT_ELEMENT = 0,
		CENTER_ELEMENT,
		RIGHT_ELEMENT,

		ELEMENT_MAX,
	};

	virtual void Update( unsigned long time );
	virtual void Draw() = 0;

	virtual void Active( LPTSTR msg, unsigned long color, bool loop = false ) = 0;
	virtual void Active( sTextItem* text, bool loop = false ) = 0;

	inline void DeActive() { mActive = false; }
	inline bool IsActive() { return mActive; }

	unsigned int GetBubbleHeight();

	void SetPos( int screenX, int screenY );

protected:
	cBubbleBase();

	struct sBubbleBox
	{
		NiScreenElements*	mpBoxElement;

		unsigned int		mFrameWidth;		/// ڱ̿  ̴.
		unsigned int		mFrameHeight;		///    ʴ´.
	};

protected:
	/// ǳ ̹  
	sBubbleBox		mBubbleBox[BUBBLE_LINE_MAX];

	/// ǳ ġ
	unsigned int	mPosX;
	unsigned int	mPosY;

	/// ǥ  ũ
	unsigned int	mLineNum;

	/// κ ä ޼ 
	unsigned int	mChatMsgLen[BUBBLE_LINE_MAX];

	/// ä ޼ ǥ ̹ ȼ
	unsigned int	mChatMsgWidth;

	/// Ȱȭ 
	bool			mActive;
	unsigned long 	mActiveTime;

	bool			mLoop;

	int				mFontSpace;	/// Ʈ  ġ Ͽ

	unsigned long	mAlphaColor;
};

class cChatBubble : public cBubbleBase
{
public:
	cChatBubble();
	virtual ~cChatBubble();

	/// ǳ 
	virtual void Active( LPTSTR msg, unsigned long color, bool loop = false );
	virtual void Active( sTextItem*, bool ){}

//	void Update( NiPoint3& pos, unsigned long time );
	void Draw();

protected:
	/// κ ä ޼
	TCHAR			mChatMsg[BUBBLE_LINE_MAX][BUBBLE_TEXT_LENGTH+1];

	unsigned long	mChatColor;
};

class cFuncChatBubble : public cBubbleBase
{
public:
	cFuncChatBubble();
	virtual ~cFuncChatBubble();

	/// ǳ 
	virtual void Active( LPTSTR msg, unsigned long color, bool loop = false );
	virtual void Active( sTextItem*, bool loop = false );

//	void Update( NiPoint3& pos, unsigned long time );
	void Draw();


protected:
	tArray<sTextItem>	mChatMsg[BUBBLE_LINE_MAX];

};