#include "StdAfx.h"
#include "ChatExtraWindow.h"
#include "UINodeData.h"
#include "UIImage.h"
#include "PlaneObject.h"
#include "TextBox.h"
#include "ChatManager.h"
#include "ItemManager.h"
#include "Gameresourcemanager.h"
#include "GameUIManager.h"

cChatExtraWindow::cChatExtraWindow()
: mButtonH(0)
{
}

cChatExtraWindow::~cChatExtraWindow()
{
	SAFE_DELETE( mpChatBoxImageDown );
	SAFE_DELETE( mpChatBoxImageUp );
	SAFE_DELETE( mpChatBoxImage );
}

/// ǻ : 
bool cChatExtraWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	/// ä 
	CHATMANAGER->SetChatWindow( this );

	mpChatBox = (cTextBox*)GetChild( eUIID_EXTRA_CHATEXBOX );
	if( mpChatBox )
		mpChatBox->SetScrollBottom( true );

	mDefalutRowNum = mpChatBox->GetMaxRowInPage();

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	/// ä ڽ Ų ε
	cUINodeSkin* pplaneSkin = pSkin->GetNodeSkin( "ChatBoxImage" );
	if( pplaneSkin && pplaneSkin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)pplaneSkin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)pplaneSkin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)pplaneSkin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)pplaneSkin->mSkinInfo->mTexHeight;
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mTop;
		unsigned short w = mpChatBox->GetAbsoluteRect().GetWidth();
		unsigned short h = mpChatBox->GetAbsoluteRect().GetHeight();

		mpChatBoxImage = new cPlaneObject;
		if( mpChatBoxImage->Create( pplaneSkin->mpTexture, x, y, w, h,
			tx, ty, tx + tw, ty + th ) == false )
		{
			assert( 0 && "failed to create chat box image");
			return false;
		}
	}
	else
	{
		assert(0);
		return false;
	}

	/// äùڽ ̹ Ʋ 
	mpUpSkin = pSkin->GetNodeSkin( "ChatBoxImage_Up" );
	if( mpUpSkin && mpUpSkin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)mpUpSkin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)mpUpSkin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)mpUpSkin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)mpUpSkin->mSkinInfo->mTexHeight;
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mTop - th;
		unsigned short w = mpChatBox->GetAbsoluteRect().GetWidth();

		mpChatBoxImageUp = new cPlaneObject;
		if( mpChatBoxImageUp->Create( mpUpSkin->mpTexture, x, y, w, th,
			tx, ty, tx + tw, ty + th ) == false )
		{
			assert( 0 && "failed to create chat box up image");
			return false;
		}
	}

	cUINodeSkin* downSkin = pSkin->GetNodeSkin( "ChatBoxImage_Down" );
	if( downSkin && downSkin->mpTexture )
	{
		/// ؽó  
		unsigned short tx = (unsigned short)downSkin->mSkinInfo->mTexX;
		unsigned short ty = (unsigned short)downSkin->mSkinInfo->mTexY;
		unsigned short tw = (unsigned short)downSkin->mSkinInfo->mTexWidth;
		unsigned short th = (unsigned short)downSkin->mSkinInfo->mTexHeight;
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mBottom;
		unsigned short w = mpChatBox->GetAbsoluteRect().GetWidth();

		mpChatBoxImageDown = new cPlaneObject;
		if( mpChatBoxImageDown->Create( downSkin->mpTexture, x, y, w, th,
			tx, ty, tx + tw, ty + th ) == false )
		{
			assert( 0 && "failed to create chat box down image");
			return false;
		}
	}

	///   
	if( mpChatBox )
	{
		cUISize winSize;
		winSize.mWidth = GetAbsoluteRect().GetWidth();
		winSize.mHeight = mpChatBox->GetRelativeRect().mTop + mpChatBox->GetRelativeRect().GetHeight();
		SetRelativeSize( winSize );
	}

//	cUINode* pSystem = GetChild( eUIID_EXTRA_SYSTEM );
//	if( pSystem )
//		pSystem->SetPress( true );

	return true;
}

/// ǻ : 
void cChatExtraWindow::UpdateRect()
{
	cUIWindow::UpdateRect();

	/// äùڽ ̹
	if( mpChatBoxImage )
	{
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mTop;
		unsigned short w = mpChatBox->GetAbsoluteRect().GetWidth();
		unsigned short h = mpChatBox->GetAbsoluteRect().GetHeight();
		mpChatBoxImage->SetScreenRect( x, y, w, h );
	}

	/// Ʒ ̹
	if( mpChatBoxImageUp && mpUpSkin )
	{
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mTop - mpUpSkin->mSkinInfo->mTexHeight;
		mpChatBoxImageUp->SetScreenXY( x, y );
	}

	if( mpChatBoxImageDown )
	{
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mBottom;
		mpChatBoxImageDown->SetScreenXY( x, y );
	}
}

void cChatExtraWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	/// ̹ 
	if( mpChatBoxImage )
		mpChatBoxImage->Draw();

	if( mpChatBoxImageUp )
		mpChatBoxImageUp->Draw();

	if( mpChatBoxImageDown )
		mpChatBoxImageDown->Draw();

	cUIWindow::OnRender( pKeeper );
}

void cChatExtraWindow::OnButtonDowned(cUINode*, unsigned int id)
{
	switch( id )
	{
	case eUIID_EXTRA_SIZE_PLUS_BUTTON:
		{
			/// 
			unsigned int maxNum = mpChatBox->GetMaxRowInPage();

			if( maxNum < 8 )
			{
				int rowHeight = mpChatBox->GetRowHeight();
				UpdateSize( rowHeight );
			}
		}
		break;
	case eUIID_EXTRA_SIZE_MINUS_BUTTON:
		{
			/// 
			unsigned int maxNum = mpChatBox->GetMaxRowInPage();

			if( maxNum > mDefalutRowNum )
			{
				int rowHeight = mpChatBox->GetRowHeight();
				UpdateSize( -rowHeight );
			}
		}
		break;
	}
}

/// ǻ : 
void cChatExtraWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_EXTRA_CLOSE_BUTTON:
		{
			Hide();
		}
		break;
	case eUIID_EXTRA_SIZE_PLUS_BUTTON:
		{
			/// 
			unsigned int maxNum = mpChatBox->GetMaxRowInPage();

			if( maxNum < 8 )
			{
				int rowHeight = mpChatBox->GetRowHeight();
				UpdateSize( rowHeight );
			}
		}
		break;
	case eUIID_EXTRA_SIZE_MINUS_BUTTON:
		{
			/// 
			unsigned int maxNum = mpChatBox->GetMaxRowInPage();

			if( maxNum > mDefalutRowNum )
			{
				int rowHeight = mpChatBox->GetRowHeight();
				UpdateSize( -rowHeight );
			}
		}
		break;
	}
}

/// ǻ : 
void cChatExtraWindow::UpdateSize( int height )
{
	if( !mpChatBox )
	{
		assert(0);
		return;
	}

	/// äùڽ  
	cUISize boxsize;
	boxsize.mWidth = mpChatBox->GetAbsoluteRect().GetWidth();
	boxsize.mHeight = mpChatBox->GetAbsoluteRect().GetHeight() + height;
	mpChatBox->SetRelativeSize( boxsize );

	/// ä 
	cUISize winSize;
	winSize.mWidth = GetAbsoluteRect().GetWidth();
	winSize.mHeight = mpChatBox->GetRelativeRect().mTop + mpChatBox->GetRelativeRect().GetHeight();
	SetRelativeSize( winSize );

	/// ̹
	if( mpChatBoxImage )
	{
		unsigned short x = mpChatBox->GetAbsoluteRect().mLeft;
		unsigned short y = mpChatBox->GetAbsoluteRect().mTop;
		unsigned short w = mpChatBox->GetAbsoluteRect().GetWidth();
		unsigned short h = mpChatBox->GetAbsoluteRect().GetHeight();
		mpChatBoxImage->SetScreenRect( x, y, w, h );
	}

	///  濡  äùڽ   
	bool add = ( height >= 0 ) ? true : false;
	mpChatBox->UpdateTextBox( add );
}

/// ܺο äùڽ  ڿ   
void cChatExtraWindow::InsertText( eChatMsgKind msgkind, LPCTSTR text )
{
	if( !mpChatBox )
	{
		assert(0);
		return;
	}

	TCHAR temp[256]={0,};

	switch( msgkind )
	{
	case eCHAT_NORMAL:
		{
			cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );

			if( pNormal && pNormal->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 86 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_WHITE );
			}
		}
		break;
	case eCHAT_PARTY:
		{
			cUINode* pParty = GetChild( eUIID_EXTRA_PARTY );
			
			if( pParty && pParty->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 87 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_PARTY );
			}
		}
		break;
	case eCHAT_GUILD:
		{
			cUINode* pGuild = GetChild( eUIID_EXTRA_GUILD );

			if( pGuild && pGuild->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 88 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_GUILD );
			}
		}
		break;
	case eCHAT_SHOUT:
		{
			cUINode* pShout = GetChild( eUIID_EXTRA_SHOUT );

			if( pShout && pShout->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 89 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_SHOUT );
			}
		}
		break;
	case eCHAT_TRADE:
		{
			cUINode* pTrade = GetChild( eUIID_EXTRA_TRADE );
			if( pTrade && pTrade->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 90 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_TRADE );
			}
		}
		break;
	case eCHAT_WHISPER:
		{
			cUINode* pWhisper = GetChild( eUIID_EXTRA_WHISPER );
			if( pWhisper && pWhisper->IsPress() == true )
			{
				mpChatBox->AddNewRow( text, eCOLOR_WHISPER );
			}
		}
		break;
	case eCHAT_GM:
		{
			cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );

			if( pNormal && pNormal->IsPress() == true )
			{
				::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 180 ), text );
				mpChatBox->AddNewRow( temp, eCOLOR_GM );
			}
		}
		break;
	}
}

void cChatExtraWindow::InsertTextSystem( eSystemMsgKind kind, LPCTSTR chatmsg )
{
	if( !mpChatBox )
	{
		assert(0);
		return;
	}

	unsigned long color = eCOLOR_WHITE;

	switch( kind )
	{
	case eSYSTEM_NORMAL:	color = 0xFFFFFFFF;		break;
	case eSYSTEM_GETMONEY:	color = 0xFFFFFF0A;		break;
	case eSYSTEM_GETITEM:	color = 0xFF02FFA3;		break;
	case eSYSTEM_QUEST:		color = 0xFF00FFFF;		break;
	case eSYSTEM_DOITEM:	color = 0xFFA6B27D;		break;
	case eSYSTEM_CASH:		color = 0xFF643264;		break;
	case eSYSTEM_NPCSTORE:  color = 0xFFE9A921;		break;
	case eSYSTEM_PVP:		color = eCOLOR_RED;		break;
	case eSYSTEM_GM:		color = eCOLOR_RED;		break;
	default:				assert(0);				break;
	}

	cUINode* pSystem = GetChild( eUIID_EXTRA_SYSTEM );
	if( pSystem && pSystem->IsPress() == true )
	{
		TCHAR temp[256]={0,};
		::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 91 ), chatmsg );
		mpChatBox->AddNewRow( temp, color );
	}
}

void cChatExtraWindow::InsertItemText( unsigned long itemIndex, unsigned int slotIndex, LPCTSTR msg1, LPCTSTR msg2, bool IsQuest)
{
	if( !mpChatBox )
	{
		assert(0);
		return;
	}

	/// ý ޼ ̱ Ǿ  
	cUINode* pSystem = GetChild( eUIID_EXTRA_SYSTEM );
	if( pSystem && pSystem->IsPress() == true )
	{
		cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
		if( !itemDefine )
			return;

		/// ۾ ÷ ϱ
		unsigned long itemColor = eCOLOR_WHITE;
		unsigned long textColor = (IsQuest == false) ? eCOLOR_WHITE : 0xFF00FFFF;	/// Ʈ 
		ITEMMAN->GetTooltipColor( itemDefine->GetTipType(), itemColor );

		/// οٿ  
		TCHAR itemName[256] = {0,};
		::_stprintf( itemName, GAMERESOURCEMAN->GetGameText( 241 ), itemDefine->GetName() );

		TCHAR temp[256]={0,};
		if( msg1 )
			::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 91 ), msg1 );
		else
			::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 93 ) );

		mpChatBox->AddNewRow( temp, textColor );
		mpChatBox->AddItemRow( false, itemIndex, slotIndex, itemName, itemColor );
		mpChatBox->AddPasteRow( msg2, textColor );
	}
}

///  ŷ ޼ 
void cChatExtraWindow::InsertItemText( sInventory inventory, LPCTSTR name, LPCTSTR msg, eChatMsgKind kind )
{
	if( !mpChatBox )
	{
		assert(0);
		return;
	}

	TCHAR temp[256] = {0,};

	cItemDefine* define = ITEMMAN->GetItemDefine( inventory.ItemIndex );
	if( !define )
	{
		/// ũ   ׳ 
		if( kind != eCHAT_WHISPER )
		{
			::_stprintf( temp, UIMAN->GetUIText( 10000 ), name, msg );
			InsertText( kind, temp );
		}
		else
		{
			::_stprintf( temp, _T("%s%s"), name, msg );
			InsertText( kind, temp );
		}
	}
	else
	{
		/// ũ    
		unsigned long itemColor = eCOLOR_WHITE;
		ITEMMAN->GetTooltipColor( define->GetTipType(), itemColor );

		TCHAR itemName[256] = {0,};

		/// ȭܰ + ̸ 
		if( inventory.enhanced > 0 )
		{
			::_stprintf( itemName, GAMERESOURCEMAN->GetGameText(249), inventory.enhanced, define->GetName() );
		}
		else
		{
			::_stprintf( itemName, GAMERESOURCEMAN->GetGameText(241), define->GetName() );
		}

		switch( kind )
		{
		case eCHAT_NORMAL:
			{	
				cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );
				if( pNormal && pNormal->IsPress() == true )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 94 ), name );

					mpChatBox->AddNewRow( temp, eCOLOR_WHITE );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_WHITE );
				}
			}
			break;
		case eCHAT_PARTY:
			{
				cUINode* pParty = GetChild( eUIID_EXTRA_PARTY );
				if( pParty && pParty->IsPress() == true )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 95 ), name );

					mpChatBox->AddNewRow( temp, eCOLOR_PARTY );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_PARTY );
				}
			}
			break;
		case eCHAT_GUILD:
			{
				cUINode* pGuild = GetChild( eUIID_EXTRA_GUILD );
				if( pGuild && pGuild->IsPress() == true )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 96 ), name );

					mpChatBox->AddNewRow( temp, eCOLOR_GUILD );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_GUILD );
				}
			}
			break;
		case eCHAT_TRADE:
			{
				cUINode* pTrade = GetChild( eUIID_EXTRA_TRADE );
				if( pTrade && pTrade->IsPress() == true )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 97 ), name );

					mpChatBox->AddNewRow( temp, eCOLOR_TRADE );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_TRADE );
				}
			}
			break;
		case eCHAT_WHISPER:
			{
				cUINode* pWhisper = GetChild( eUIID_EXTRA_WHISPER );
				if( pWhisper && pWhisper->IsPress() == true )
				{
					mpChatBox->AddNewRow( name, eCOLOR_WHISPER );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_WHISPER );
				}
			}
			break;
		case eCHAT_GM:
			{	
				cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );
				if( pNormal && pNormal->IsPress() == true )
				{
					::_stprintf( temp, GAMERESOURCEMAN->GetGameText( 181 ), name );

					mpChatBox->AddNewRow( temp, eCOLOR_GM );
					mpChatBox->AddItemRow( inventory, itemName, itemColor );
					mpChatBox->AddPasteRow( msg, eCOLOR_GM );
				}
			}
			break;
		default: 
			assert(0);
			break;
		}
	}
}

void cChatExtraWindow::SetPos( int i )
{
	/// ġ ϱ ( ݾ з  
	cUISkin* pSkin = UIMAN->GetSkin();
	if( pSkin )
	{
		cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( "ChatExtraWindow" );
		if( pNodeSkin )
		{
			cUIPos pos;
			pos.mX = pNodeSkin->mSkinInfo->mX + (i*CHATEXTRA_GAP);
			pos.mY = pNodeSkin->mSkinInfo->mY + (i*CHATEXTRA_GAP);
			SetRelativePos( pos );
		}
	}
}

void cChatExtraWindow::SetPress( bool normal, bool party, bool guild, bool shout, bool trade, bool whisper, bool system )
{
	cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );
	if( pNormal )
		pNormal->SetPress( normal );

	cUINode* pParty = GetChild( eUIID_EXTRA_PARTY );
	if( pParty )
		pParty->SetPress( party );

	cUINode* pGuild = GetChild( eUIID_EXTRA_GUILD );
	if( pGuild )
		pGuild->SetPress( guild );

	cUINode* pShout = GetChild( eUIID_EXTRA_SHOUT );
	if( pShout )
		pShout->SetPress( shout );

	cUINode* pTrade = GetChild( eUIID_EXTRA_TRADE );
	if( pTrade )
		pTrade->SetPress( shout );

	cUINode* pWhisper = GetChild( eUIID_EXTRA_WHISPER );
	if( pWhisper )
		pWhisper->SetPress( whisper );

	cUINode* pSystem = GetChild( eUIID_EXTRA_SYSTEM );
	if( pSystem )
		pSystem->SetPress( system );
}

bool cChatExtraWindow::IsPressNormal()
{
	cUINode* pNormal = GetChild( eUIID_EXTRA_NOMAL );
	if( pNormal && pNormal->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressParty()
{
	cUINode* pParty = GetChild( eUIID_EXTRA_PARTY );
	if( pParty && pParty->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressGuild()
{
	cUINode* pGuild = GetChild( eUIID_EXTRA_GUILD );
	if( pGuild && pGuild->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressShout()
{
	cUINode* pShout = GetChild( eUIID_EXTRA_SHOUT );
	if( pShout && pShout->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressTrade()
{
	cUINode* pTrade = GetChild( eUIID_EXTRA_TRADE );
	if( pTrade && pTrade->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressWhisper()
{
	cUINode* pWhisper = GetChild( eUIID_EXTRA_WHISPER );
	if( pWhisper && pWhisper->IsPress() == true )
		return true;

	return false;
}

bool cChatExtraWindow::IsPressSystem()
{
	cUINode* pSystem = GetChild( eUIID_EXTRA_SYSTEM );
	if( pSystem && pSystem->IsPress() == true )
		return true;

	return false;
}
