/* ==========================================================================
*      : ChatManager.h
*      : ä Ŵ
*    : 谡
*    : 2006-11-20
* ǻ :
*===========================================================================*/
#pragma once

class cChatCommands;
class cUIWindow;
class cUINode;
struct sInventory;

enum eChatMsgKind
{
	eCHAT_NORMAL,
	eCHAT_PARTY,
	eCHAT_GUILD,
	eCHAT_SHOUT,
	eCHAT_TRADE,
	eCHAT_WHISPER,
	eCHAT_SYSTEM,
	eCHAT_NOTICE,
	eCHAT_GM,

	eCHAT_MAX,
};

enum eSystemMsgKind
{
	eSYSTEM_NORMAL,		/// Ϲ ý ޽(, ġ ȹ, ų  )
	eSYSTEM_GETMONEY,	///  ȹ
	eSYSTEM_GETITEM,	/// Ϲ  ȹ( ̸    )
	eSYSTEM_QUEST,		/// Ʈ  ޽(Ʈ  , Ʈ  ȹ)
	eSYSTEM_DOITEM,		/// , , æƮ, ī  ˸ ޽
	eSYSTEM_CASH,		/// ĳ    Ⱓ   ˸ ޽
	eSYSTEM_NPCSTORE,	/// NPC  Ǹ/Խ
	eSYSTEM_PVP,		/// PVP ˸
	eSYSTEM_GM,         /// GM  Ư ġ   ˸ ޽
};

class cChatManager
{
	static cChatManager* mInstance;

public:
	///  ü  
	static cChatManager* Get();

public:
	cChatManager();
	~cChatManager();

	/// ʱȭ
	bool Init();
	void Clear();

	/// ޽ ļ
	void NetworkMsgParser( char* pMsg );

	/// Ŀ  Ʈ ߰ ( Ŀ )
	void AddFocusNode( cUINode* n );

	/// ý ޼ 
	void AddSystemMsg( eSystemMsgKind kind, LPCTSTR chatmsg );

	///  ޼ 
	void AddTipMsg( LPCTSTR msg );

	///  ȹ ޼ 
	void AddItemMsg( unsigned long itemIndex, unsigned int slotIndex, LPCTSTR msg1, LPCTSTR msg2, bool IsQuest = false );
	void AddItemMsg( sInventory inventory, LPCTSTR name, LPCTSTR msg, eChatMsgKind msgkind );

	/// ä ޽  ( äâ ->  )
	void SendChatMsg( eChatMsgKind type, LPCTSTR msg );

	///   
	void SetChatWindow( cUIWindow* w );
	void SetMtoMChatWindow( cUIWindow* w );
	void SetNoteWindow( cUIWindow* w );
	void SetFriendWindow( cUIWindow* w );

	/// äâ Ŀ ٲٱ ( shift + tab : äâ <-> 1:1ȭâ )
	void ChangeFocus();

	/// ǥ õ 
	bool AddCommunityData( LPCTSTR key, unsigned long index );

	/// äâ  (  -> äâ )
	void AddChatMsg( LPCTSTR chatmsg, unsigned int msgkind = 0 );

	///  
	void AddNoticeMsg( LPCTSTR msg, unsigned long color );
	
private:
	void DeleteNote();

private:
	/// äâ ( ⺻ + иâ 3 )
	typedef tPointerList<void*> cChatWindowList;
	cChatWindowList		mChatWindowList;
	
	/// ϴϴȭâ ( 3 )
	typedef tPointerList<void*>	cMtoMChatList;
	cMtoMChatList	mMtoMChatList;

	/// â Ŀ ( äâ, ϴϴȭâ  )
	typedef tPointerArray<void*> cFocusArr;
	cFocusArr	mFocusArr;

	///  (sNoteList)
	typedef tPointerList<void*> cNoteList;
	cNoteList	mNoteList;

	///  
	cUIWindow*		mpNoteWindow;

	/// ģ 
	cUIWindow*		mpFriendWindow;

	///
	cChatCommands*	mpCommands;
};

inline cChatManager* cChatManager::Get()
{
	return mInstance;
}

#define CHATMANAGER cChatManager::Get()
