/* ==========================================================================
*      : ChatWindow.h
*      : 
*    : 谡
*    : 2006-11-28
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"

const int HEIGHT_GAP = 8;
const int MAXROWNUM = 12;
const int LINKICON_SIZE = 28;

enum eChatMsgKind;
enum eSystemMsgKind;
class cTextBox;
class cEditBox;
class cButton;
class cPlaneObject;
class cUIImage;
class cChatButtonWindow;
class cItemIcon;
class cChatWindow : public cUIWindow
{
public:
	cChatWindow();
	virtual ~cChatWindow();

	/// ܺο äùڽ  ڿ   
	virtual void InsertText( eChatMsgKind msgkind, LPCTSTR text );
	virtual void InsertTextSystem( eSystemMsgKind kind, LPCTSTR chatmsg );
	void InsertTextTip( LPCTSTR chatmsg );
	
	///  ȹ ޼
	virtual void InsertItemText( unsigned long itemIndex, unsigned int slotIndex, LPCTSTR msg1, LPCTSTR msg2, bool IsQuest = false );

	///  ˸ ޼
	virtual void InsertItemText( sInventory inventory, LPCTSTR name, LPCTSTR msg, eChatMsgKind kind );

	/// Ŭ
	virtual void Clear();

	/// Ʈ Ŀ ֱ 
	void SetFocusToEdit();

	/// ä Ʈ ش ڿ ԷѴ 
	void SetChatText( LPCTSTR text );

	/// ӼӸ ģ ̸ 
	void AddWhisperUser( const cStringT& name );
	void ApplyLastWhisperUser();
	void AddExtraWindow( cUIWindow* w );

	///	  ä Ÿ 
	void UpdateChatType( eChatMsgKind type );

	/// ũ  
	bool AddLinkItem( unsigned int slotIndex );
	void DeleteLinkItem();
	unsigned int GetLinkSlotNum() { return mItemSlotIndex; }

	///
	cUIRect GetSelectButtonRect();
	LPCTSTR GetWhisperName();
	unsigned int GetMaxRowInPage();

	///
	void InitBoxSize( unsigned int size );
	virtual void SetPress( bool normal, bool party, bool guild, bool shout, bool trade, bool whisper, bool system );
	virtual bool IsPressNormal();
	virtual bool IsPressParty();
	virtual bool IsPressGuild();
	virtual bool IsPressShout();
	virtual bool IsPressTrade();
	virtual bool IsPressWhisper();
	virtual bool IsPressSystem();

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void UpdateRect();
	bool HandleEvent( const cUIEvent& event );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void OnEditBoxEntered( cUINode* pcaller, unsigned int id );
	void OnCommand( cUINode* pcaller, unsigned int id );
	void OnButtonDowned(cUINode* pcaller, unsigned int id);
	void OnLButtonDoubleClick( const cUIPos& pos );
	void OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool );
	void OnIconDragged( cUINode* , unsigned int , const cUIPos& , bool );
	void OnIconHovered( cUINode* , unsigned int , const cUIPos& );
	void UpdateSkin();
	void OnShow();
	void OnHide();

	///  Ʈ 
	virtual void UpdateSize( int height );

	void KeyEvent( eKeyCode code );

private:
	/// и ä  Ʈ 
	/// typedef tPointerList<cChatWindow*> cExtraList;
	typedef tPointerList<void*> cExtraList;
	cExtraList mExtraList;

	/// ӼӸ ְ    ( ִ 5 )
	typedef tList<cStringT> cWhisperList;
	cWhisperList mWhisperList;

protected:
	cTextBox*		mpChatBox;
	cEditBox*		mpChatEdit;
	cEditBox*		mpChatEditWhisper;

	/// ä ؽƮڽ þ .
	cPlaneObject*	mpChatBoxImage;
	cPlaneObject*	mpChatBoxImageUp;		///   Ʋ
	cPlaneObject*	mpChatBoxImageDown;		///  Ʒ Ʋ

	/// ɼ κ ̹ 
	cUIImage*		mpOptionImage;

	///  äû¿ ̹
	cUIImage*		mpSelectImage;
	
	///
	cUINodeSkin*	mpSelectSkin;
	cUINodeSkin*	mpOptionSkin;
	cUINodeSkin*	mpUpSkin;

	///  äû¸ Ÿ ؽ ǥ 
	cUINodeSkin*	mpTexSkin[8];

	/// ⺻   
	unsigned int mDefalutRowNum;

	/// ӼӸ 
	int	mCount;

	///  ä 
	eChatMsgKind	mSelectType;

	////
	cChatButtonWindow*	mpButtonWindow;

	///   ε
	unsigned int mItemSlotIndex;

	/// ũ 
	cItemIcon* mpLinkItemIcon;
};

/// ư 
class cChatButtonWindow : public cUIWindow
{
public:
	cChatButtonWindow();
	virtual ~cChatButtonWindow();

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* , unsigned int );
	void OnMouseOtherClick( const cUIPos& pos );
	void UpdateSkin();
};
