#include "StdAfx.h"
#include "CheckBox.h"
#include "Token.h"
#include "UISkinLexer.h"
#include "Parser.h"

#include "UIEvent.h"
#include "UIImage.h"
#include "UIContainer.h"
#include "SoundSystem.h"

cCheckBox::cCheckBox( eUINodeType type )
: cUINode( type )
, mCheckPos(0, 0)
, mNoCheckPos(0, 0)
, mOriginalTexWidth(0)
, mOriginalTexHeight(0)
{
	mCheckSoundIdx = (unsigned long)-1;
	mNoCheckSoundIdx = (unsigned long)-1;
}

cCheckBox::~cCheckBox()
{
}

/// ǻ : 
bool cCheckBox::SetSkin( const cUINodeSkin* pskin )
{
	if( pskin->IsKindof( eUINODE_CHECKBOX ) == false )
	{
		assert( 0 && "not checkbox skin type" );
		return false;
	}

	if( cUINode::SetSkin( pskin ) == false )
	{
		return false;
	}

	cCheckBoxSkin* p = (cCheckBoxSkin*)pskin;
	///   
	SetPress( p->mPressed );

	/// üũ ̹ ǥ
	mCheckPos = p->mCheckPos;
	/// üũ ȵ ̹ ǥ
	mNoCheckPos = p->mNoCheckPos;
	/// ؽ 
	mOriginalTexWidth = mpImage->GetWidth();
	mOriginalTexHeight = mpImage->GetHeight();

	mCheckSoundIdx = p->mCheckSoundIdx;
	mNoCheckSoundIdx = p->mNoCheckSoundIdx;

	///  ǥ  
	/// ʱ ũƮ üũ ¸ ˻
	if( mPressed )
	{
		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mCheckPos.mX, (unsigned short)mCheckPos.mY, 
								 (unsigned short)(mCheckPos.mX + mOriginalTexWidth), (unsigned short)(mCheckPos.mY + mOriginalTexHeight) );
	}
	else
	{
		mpImage->SetTextureRect( (unsigned short)mNoCheckPos.mX, (unsigned short)mNoCheckPos.mY, 
								 (unsigned short)(mNoCheckPos.mX + mOriginalTexWidth), (unsigned short)(mNoCheckPos.mY + mOriginalTexHeight) );
	}

	return true;
}

/// ǻ : 
bool cCheckBox::IsValid() const
{
	if( !mpImage )
	{
		assert( 0 && "invalid image" );
		return false;
	}

	if( cUINode::IsValid() == false )
	{
		return false;
	}
	return true;
}

/// ǻ : 
void cCheckBox::OnRender( cUIFontItemKeeper* )
{
	/// ̹ 
	mpImage->Draw();
}

/// ǻ : 
void cCheckBox::OnLButtonDown( const cUIPos& pos, bool ctrl, bool alt, bool shift )
{
	cUINode::OnLButtonDown( pos, ctrl, alt, shift );

	mPressed = !mPressed;

	if( mPressed )
	{
		SOUNDSYS->Play2DSound( mCheckSoundIdx );

		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mCheckPos.mX, (unsigned short)mCheckPos.mY, 
			(unsigned short)(mCheckPos.mX + mOriginalTexWidth), (unsigned short)(mCheckPos.mY + mOriginalTexHeight) );
	}
	else
	{
		SOUNDSYS->Play2DSound( mNoCheckSoundIdx );

		mpImage->SetTextureRect( (unsigned short)mNoCheckPos.mX, (unsigned short)mNoCheckPos.mY, 
			(unsigned short)(mNoCheckPos.mX + mOriginalTexWidth), (unsigned short)(mNoCheckPos.mY + mOriginalTexHeight) );
	}

	/// ̺Ʈ ߻
	cUIEvent event;
	event.mType = eUIEVENT_CHECKBOX_CHANGED;
	event.mpCaller = this;
	event.mID = mID;
	mpParent->HandleEvent( event );
}

void cCheckBox::SetPress( bool press )
{
	if( mEnabled == false )
		return;

	mPressed = press;

	if( mPressed )
	{
		// ҽ ̹ ٲٱ
		mpImage->SetTextureRect( (unsigned short)mCheckPos.mX, (unsigned short)mCheckPos.mY, 
			(unsigned short)(mCheckPos.mX + mOriginalTexWidth), (unsigned short)(mCheckPos.mY + mOriginalTexHeight) );
	}
	else
	{
		mpImage->SetTextureRect( (unsigned short)mNoCheckPos.mX, (unsigned short)mNoCheckPos.mY, 
			(unsigned short)(mNoCheckPos.mX + mOriginalTexWidth), (unsigned short)(mNoCheckPos.mY + mOriginalTexHeight) );
	}
}


//////////////////////////////////////////////////////////////////////////
cCheckBoxSkin::cCheckBoxSkin( eUINodeType type )
: cUINodeSkin( type )
, mPressed( false )
, mCheckPos(0, 0)
, mNoCheckPos(0, 0)
{
	mCheckSoundIdx = (unsigned long)-1;
	mNoCheckSoundIdx = (unsigned long)-1;
}

cCheckBoxSkin::~cCheckBoxSkin()
{
}

/// ǻ : 
bool cCheckBoxSkin::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			///  Ż ^^
			break;
		}

		switch( token.mType )
		{
		case eTOKEN_ONSOUND:
			{
				/// üũ 
				mCheckSoundIdx = parser.ParseInt();
			}
			break;
		case eTOKEN_OFFSOUND:
			{
				/// üũ  
				mNoCheckSoundIdx = parser.ParseInt();
			}
			break;
		case eTOKEN_CHECKPOS:
			{
				mCheckPos.mX = parser.ParseInt();
				mCheckPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_NOCHECKPOS:
			{
				mNoCheckPos.mX = parser.ParseInt();
				mNoCheckPos.mY = parser.ParseInt();
			}
			break;
		case eTOKEN_CHECKED:
			{
				/// checked    о̱ 
				lexer->GetNextToken( &token );

				if( token.mType == eTOKEN_TRUE )
				{
					mPressed = true;
				}
				else if( token.mType == eTOKEN_FALSE )
				{
					mPressed = false;
				}
				else
				{
					assert( 0 && "invalid token" );
					return false;
				}
			}
			break;
		default:
			if( cUINodeSkin::ParseLine( parser, token ) == false )
			{
				return false;
			}
			break;
		}
	}
	return true;
}
