#include "StdAfx.h"
#include "ColumnQuickSlot.h"
#include "QuickManager.h"
#include "DragWindow.h"
#include "RadioButton.h"
#include "GameUIManager.h"
#include "SkillManager.h"
#include "SkillTipWindow.h"

#include "objectmanager.h"
#include "hero.h"
#include "CommunityScript.h"
#include "SkillScript.h"
#include "GameResourceManager.h"

cColumnQuickSlot::cColumnQuickSlot()
{
	mRadio[0] = 0;
	mRadio[1] = 0;
	mRadio[2] = 0;

	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
		mpNumImage[i] = 0;

	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cColumnQuickSlot::~cColumnQuickSlot()
{
	mRadio[0] = 0;
	mRadio[1] = 0;
	mRadio[2] = 0;

	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
		SAFE_DELETE( mpNumImage[i] );
}


void cColumnQuickSlot::OnShow()
{
	unsigned int tabIndex = QUICKMAN->GetTabIndex();
	if( mRadio[tabIndex] && mRadio[tabIndex]->IsPress() == false )
	{
		mRadio[tabIndex]->SetPressNoEvent( true, false );
	}
	cUIWindow::OnShow();
}

///
void cColumnQuickSlot::ChangeTab()
{
    unsigned int tabIndex = QUICKMAN->GetTabIndex();
	tabIndex++;
	if( tabIndex > 2 )
		tabIndex = 0;
	
	if( mRadio[tabIndex] )
		mRadio[tabIndex]->SetPress( true );
}

void cColumnQuickSlot::ChangeTab( int tabIndex )
{
	if( mRadio[tabIndex] )
		mRadio[tabIndex]->SetPress( true );
}

/// ǻ : 
bool cColumnQuickSlot::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mRadio[0] = (cRadioButton*)GetChild( eUIID_COLUMN_TAB1 );
	mRadio[1] = (cRadioButton*)GetChild( eUIID_COLUMN_TAB2 );
	mRadio[2] = (cRadioButton*)GetChild( eUIID_COLUMN_TAB3 );
	
	cString str;
	///  
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		str.Format( "QuickColumn_Icon%02d", i );
		cIcon* icon = new cIcon;
		if( icon->CreateBySkinName( str, this, i ) == false )
			return false;

		mIcon[i] = icon;
		QUICKMAN->BindColumnIcon( i, icon );
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cString skinName;
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		/// 
		skinName.Format( "QuickNumF%02d", i );
		cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( skinName.Cstr() );

		mpNumImage[i] = new cUIImage( pNodeSkin->mpTexture );
		if( mpNumImage[i] )
		{
			unsigned int x = mIcon[i]->GetAbsoluteRect().mLeft + 1;
			unsigned int y = mIcon[i]->GetAbsoluteRect().mTop + 1;

			unsigned int tx = pNodeSkin->mSkinInfo->mTexX;
			unsigned int ty = pNodeSkin->mSkinInfo->mTexY;
			unsigned int w = pNodeSkin->mSkinInfo->mWidth;
			unsigned int h = pNodeSkin->mSkinInfo->mHeight;
			mpNumImage[i]->SetTextureRect( tx, ty, tx + w, ty + h );
			mpNumImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
		}
	}
	return true;
}

void cColumnQuickSlot::UpdateRect()
{
	cUIWindow::UpdateRect();

	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		if( mpNumImage[i] )
		{
			unsigned int x = mIcon[i]->GetAbsoluteRect().mLeft + 1;
			unsigned int y = mIcon[i]->GetAbsoluteRect().mTop + 1;
			
			mpNumImage[i]->SetPos( x, y );
		}
	}
}

void cColumnQuickSlot::OnRender(cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		if( mpNumImage[i])
			mpNumImage[i]->Draw();
	}
}

void cColumnQuickSlot::OnCommand( cUINode*, unsigned int id )
{
	if( id == eUIID_COLUMN_ROTATE )
	{	
		Hide();

		///
		cUIWindow* rowQuick = (cUIWindow*)UIMAN->GetContainer( eUIID_ROW_QUICKSLOT );
		if( rowQuick )
		{
			rowQuick->ShowTop();
			QUICKMAN->SetRowQuick( true );
		}
	}
}

/// ǻ : 
void cColumnQuickSlot::OnRadioPressed( cUINode*, unsigned int id )
{
	unsigned int tabIndex = 0;
	switch( id )
	{
	case eUIID_COLUMN_TAB1:
		tabIndex = 0;
		break;
	case eUIID_COLUMN_TAB2:
		tabIndex = 1;
		break;
	case eUIID_COLUMN_TAB3:
		tabIndex = 2;
		break;
	default:
		assert(0);
		return;
	}

	///  Ǻ
	QUICKMAN->ChangeTab( tabIndex );
	UIMAN->HideTip();
}

void cColumnQuickSlot::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	if( id < 0 || id >= QUICKSLOT_COUNT )
	{
		assert(0 && "error id");
		return;
	}

	cIcon* icon = (cIcon*)caller;
	if( !icon )
	{
		assert(0);
		return;
	}

	eSHORTCUT_TYPE type = QUICKMAN->GetQuickType( id );
	if( type == eSHORTCUT_ITEM )
	{
		/// 
		unsigned int itemIndex = QUICKMAN->GetItemIndex( id );
		UIMAN->ShowItemTip( eTIP_QUICK, pos, itemIndex, UINT_MAX, &icon->GetGauge() );
	}
	else if( type == eSHORTCUT_SKILL )
	{
		/// ų
		unsigned int skillIndex = QUICKMAN->GetSkillIndex( id );

		/// ų  
		sKeepSkill* pInfo = SKILLMAN->GetKeepInfo( skillIndex );
		if( pInfo )
		{
			UIMAN->ShowSkillTip( eTIP_QUICK, GAMEUI->GetSkillTip(), pos, skillIndex, pInfo->mStep, false );
		}
	}
	else if( type == eSHORTCUT_COMMU )
	{
		unsigned int index = QUICKMAN->GetSkillIndex( id );
		sCommunitySkillInfo* pInfo = COMMUNITYSCRIPT->GetCommunityInfo( index );
		if( pInfo )
		{
			UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, UIMAN->GetUIText( pInfo->mTooltipIndex) );
		}
	}
}

void cColumnQuickSlot::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cIcon* icon = (cIcon*)caller;
	if( icon )
	{
		bool IsUse = QUICKMAN->IsUseSlot( id );

		/// Ͱ ִ Ը 巡 .
		if( IsUse == true )
			UIMAN->ShowDrag( this, DRAG_FROM_QUICKSLOT, icon, pos, shift );
	}
}

///  
void cColumnQuickSlot::OnIconRightClicked( cUINode*, unsigned int id, bool )
{
	QUICKMAN->OnMouseDown( id );
}

///  
void cColumnQuickSlot::OnIconDoubleClicked( cUINode*, unsigned int id )
{
	QUICKMAN->OnMouseDown( id );
}

//////////////////////////////////////////////////////////////////////// 
/// FS 
cFSColumnQuickSlot::cFSColumnQuickSlot()
{
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
		mIcon[i] = 0;
}

cFSColumnQuickSlot::~cFSColumnQuickSlot()
{
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
		SAFE_DELETE( mpNumImage[i] );
}

bool cFSColumnQuickSlot::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	cString str;
	///  
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		str.Format( "QuickFSColumn_Icon%02d", i );
		cIcon* icon = new cIcon;
		if( icon->CreateBySkinName( str, this, i ) == false )
			return false;

		mIcon[i] = icon;
		QUICKMAN->BindFSColumnIcon( i, icon );
	}

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cString skinName;
	for( unsigned int i = 0; i < QUICKSLOT_COUNT; ++i )
	{
		/// 
		skinName.Format( "QuickNum%02d", i );
		cUINodeSkin* pNodeSkin = pSkin->GetNodeSkin( skinName.Cstr() );

		mpNumImage[i] = new cUIImage( pNodeSkin->mpTexture );
		if( mpNumImage[i] )
		{
			unsigned int x = mIcon[i]->GetAbsoluteRect().mLeft + 1;
			unsigned int y = mIcon[i]->GetAbsoluteRect().mTop + 1;

			unsigned int tx = pNodeSkin->mSkinInfo->mTexX;
			unsigned int ty = pNodeSkin->mSkinInfo->mTexY;
			unsigned int w = pNodeSkin->mSkinInfo->mWidth;
			unsigned int h = pNodeSkin->mSkinInfo->mHeight;
			mpNumImage[i]->SetTextureRect( tx, ty, tx + w, ty + h );
			mpNumImage[i]->SetScreenRect( cUIRect( x, y, x + w, y + h ) );
		}
	}
	return true;
}

void cFSColumnQuickSlot::OnCommand( cUINode* caller, unsigned int id )
{
	if( id == eUIID_COLUMN_ROTATE_FS )
	{	
		Hide();

		cUIWindow* rowQuick = (cUIWindow*)UIMAN->GetContainer( eUIID_ROW_QUICKSLOT_FS );
		if( rowQuick )
		{
			rowQuick->ShowTop();
			QUICKMAN->SetRowQuickFS( true );
		}
	}
}

void cFSColumnQuickSlot::OnIconHovered(cUINode* caller, unsigned int id, const cUIPos& pos )
{
	if( id < 0 || id >= QUICKSLOT_COUNT )
	{
		assert(0 && "error id");
		return;
	}

	cIcon* icon = (cIcon*)caller;
	if( !icon )
	{
		assert(0);
		return;
	}

	eSHORTCUT_TYPE type = QUICKMAN->GetQuickType( id, true );
	if( type == eSHORTCUT_ITEM )
	{
		/// 
		unsigned int itemIndex = QUICKMAN->GetItemIndex( id, true );
		UIMAN->ShowItemTip( eTIP_QUICK, pos, itemIndex, UINT_MAX, &icon->GetGauge() );
	}
	else if( type == eSHORTCUT_SKILL )
	{
		/// ų
		unsigned int skillIndex = QUICKMAN->GetSkillIndex( id, true );
		sKeepSkill* pInfo = SKILLMAN->GetKeepInfo( skillIndex );
		if( pInfo )
		{
			UIMAN->ShowSkillTip( eTIP_QUICK, GAMEUI->GetSkillTip(), pos, skillIndex, pInfo->mStep, false );
		}
	}
	else if( type == eSHORTCUT_MONSKILL )
	{
		///  Ż
		short skillIndex = QUICKMAN->GetMonSkillIndex( id );
		if( skillIndex == -1 || skillIndex >= eMONSTERATTACK_MAX )
			return;

		unsigned long monIdx = HERO->GetTransMonsterClassIdx();
		sMonsterSkillScript* skill = SKILLSCRIPT->GetMonsterSkillInfo( monIdx, (eMONSTERATTACK_TYPE)skillIndex );
		if( !skill )
		{
			assert(0);
			return;
		}

		UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, GAMERESOURCEMAN->GetSkillToolTipText(skill->mToolTipIdx) );
	}
	else if( type == eSHORTCUT_COMMU )
	{
		unsigned int index = QUICKMAN->GetSkillIndex( id, true );
		sCommunitySkillInfo* pInfo = COMMUNITYSCRIPT->GetCommunityInfo( index );
		if( pInfo )
		{
			UIMAN->ShowCommunityTip( GAMEUI->GetSimpleTip(), pos, UIMAN->GetUIText( pInfo->mTooltipIndex) );
		}
	}
}

void cFSColumnQuickSlot::OnIconDragged( cUINode* caller, unsigned int id, const cUIPos& pos, bool shift )
{
	cIcon* icon = (cIcon*)caller;
	if( icon )
	{
		bool IsUse = QUICKMAN->IsUseSlot( id, true );

		/// Ͱ ִ Ը 巡 .
		if( IsUse == true )
			UIMAN->ShowDrag( this, DRAG_FROM_QUICKSLOT, icon, pos, shift );
	}
}

void cFSColumnQuickSlot::OnIconRightClicked( cUINode* caller, unsigned int id, bool shift )
{
	QUICKMAN->OnMouseDown( id, true );
}

void cFSColumnQuickSlot::OnIconDoubleClicked( cUINode* caller, unsigned int id )
{
	QUICKMAN->OnMouseDown( id, true );
}
