#include "stdafx.h"
#include "CoolTimeManager.h"
#include "Icon.h"
#include "QuickManager.h"
#include "Application.h"

cCoolTimeManager* cCoolTimeManager::mSingleton = 0;

cCoolTimeManager::cCoolTimeManager()
: mGroupMap( 128 )
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;
}

cCoolTimeManager::~cCoolTimeManager()
{
	Clear();

	/// ׷  
	{
		cGroupMap::cIterator i = mGroupMap.Begin();
		cGroupMap::cIterator end = mGroupMap.End();

		for( ; i != end; ++i )
		{
			sGroupData* p = (sGroupData*)(i->mSecond);
			if( p )
				p->mIndexArr.Clear();

			SAFE_DELETE(p);
		}
		mGroupMap.Clear();
	}

	///  Ÿ   
	{
		cCoolTimeMap::cIterator b = mCoolTimeMap.Begin();
		cCoolTimeMap::cIterator end = mCoolTimeMap.End();

		for( ; b != end; ++b )
		{
			sCoolTime* data = (sCoolTime*)(b->mSecond);
			SAFE_DELETE( data );
		}
		mCoolTimeMap.Clear();
	}
	
	/// Ÿ μ  
	{
		cProcessMap::cIterator b = mProcessMap.Begin();
		cProcessMap::cIterator end = mProcessMap.End();

		for( ; b != end; ++b )
		{
			sCoolTime* data = (sCoolTime*)(b->mSecond);
			SAFE_DELETE( data );
		}
		mProcessMap.Clear();
	}
}

bool cCoolTimeManager::Init()
{
	return true;
}

void cCoolTimeManager::Clear()
{
	/// μ  
	cProcessMap::cIterator b = mProcessMap.Begin();
	cProcessMap::cIterator end = mProcessMap.End();

	for( ; b != end; ++b )
	{
		sCoolTime* data = (sCoolTime*)(b->mSecond);
		SAFE_DELETE( data );
	}
	mProcessMap.Clear();
}

/// Ÿ μ ߰
bool cCoolTimeManager::AddProcessCool( unsigned long itemIndex, long restTime, long totalTime )
{
	sCoolTime* data = new sCoolTime;
	data->startTime = THEAPP->GetWorldAccumTime();
	data->restTime = restTime;
	data->totalTime = totalTime;

	if( mProcessMap.Insert( itemIndex, data ) == false )
	{
		assert( 0 && "failed to add cooltime" );
		SAFE_DELETE( data );
		return false;
	}
	return true;
}

///   Ÿ  Ѵ
void cCoolTimeManager::LoadData( unsigned long itemIndex, unsigned int groupnum, long cooltime )
{
	sCoolTime* coolData = new sCoolTime;
	coolData->groupNum = groupnum;
	coolData->startTime = 0;
	coolData->restTime = cooltime;
	coolData->totalTime = cooltime;

	///  
	if( mCoolTimeMap.Insert( itemIndex, coolData ) == false )
	{
		assert( 0 && "failed to add cooltime data" );
		return;
	}

	/// ׷  
	if( groupnum > 0 )
	{
		sGroupData* data = (sGroupData*)mGroupMap.GetAt( groupnum );
		if( data )
		{
			data->mIndexArr.PushBack( itemIndex );
		}
		else
		{
			sGroupData* p = new sGroupData;
			p->mIndexArr.PushBack( itemIndex );

			if( mGroupMap.Insert( groupnum, p ) == false )
			{
				assert(0);
				return;
			}
		}
	}
}

///  
void cCoolTimeManager::StartCoolTime( unsigned long itemIndex )
{
	///  ̿, Ÿӿ ãƼ μ ִ´.
	/// ׷̸ ׷  ø
	sCoolTime* coolData = GetCoolData( itemIndex );
	if( !coolData )
		return;
	
	/// 
	if( coolData->groupNum == 0 )
	{
		/// Ÿ μ ߰
		AddProcessCool( itemIndex, coolData->restTime, coolData->totalTime );

		/// UI  
		ITEMMAN->StartCoolTime( itemIndex, coolData->totalTime );

	}
	/// ׷Ÿ 
	else
	{
		/// ׷ Ʈ ̱
		sGroupData* group = (sGroupData*)mGroupMap.GetAt( coolData->groupNum );
		if( !group )
		{
			assert(0);
			return;
		}

		/// ׷ Ÿ 
		for( unsigned int i = 0; i < group->mIndexArr.GetSize(); ++i )
		{
			unsigned long groupItem = (unsigned long)group->mIndexArr[i];
			sCoolTime* groupData = GetCoolData( groupItem );

			if( !groupData )
				continue;

			/// ׷  Ÿ ƴ.
			sCoolTime* processData = GetProcessData( groupItem );

			if( processData == 0 )
			{
				/// ڱ Ÿ < Էµ ׷ Ÿ ̸, ڱŸ 
				if( groupData->totalTime <= coolData->totalTime )
				{
					AddProcessCool( groupItem, groupData->restTime, groupData->totalTime );
					ITEMMAN->StartCoolTime( groupItem, groupData->totalTime );
				}
				/// ڱ Ÿ > Էµ ׷ Ÿ ̸, ׷ Ÿ 
				else
				{
					AddProcessCool( groupItem, coolData->restTime, coolData->totalTime );
					ITEMMAN->StartCoolTime( groupItem, coolData->totalTime );
				}
			}
			/// ׷  Ÿ .
			else
			{
				/// ڱ  Ÿ > Էµ ׷Ÿ ̸, 
				/// ڱ  Ÿ < Էµ ׷Ÿ ̸, Էµ Ÿ  
				long elasedTime = THEAPP->GetWorldAccumTime() - processData->startTime;
				long restTime = processData->totalTime - elasedTime;
				
				/// Էµ ŸӰ ڱ   Ÿӵ Ѵ
				long totalTime = ( groupData->totalTime < coolData->totalTime ) ? groupData->totalTime : coolData->totalTime;

				if( restTime < totalTime )
				{
					/// ٽü
					processData->startTime = THEAPP->GetWorldAccumTime();
					processData->totalTime = totalTime;

					ITEMMAN->EndCoolTime( groupItem );
					ITEMMAN->StartCoolTime( groupItem, processData->totalTime );
				}
				
			}
		}
	}
}

///  ߰ ɶ 
void cCoolTimeManager::CopyCoolTime( unsigned long itemIndex )
{
	///  ϴ  ˻
	sCoolTime* coolData = GetCoolData( itemIndex );
	if( !coolData )
		return;

	/// ش  μ ̶ Ÿ 
	sCoolTime* processData = GetProcessData( itemIndex );
	if( processData )
		ITEMMAN->CopyCoolTime( itemIndex, processData->startTime, processData->restTime, processData->totalTime );
}

/// κ Ÿ û
void cCoolTimeManager::RequestQuickCool( unsigned int quickIndex, unsigned long itemIndex )
{
	///  ϴ  ˻
	sCoolTime* coolData = GetCoolData( itemIndex );
	if( !coolData )
		return;

	/// ش  μ ̶ Ÿ 
	sCoolTime* processData = GetProcessData( itemIndex );
	if( processData )
		QUICKMAN->SetItemCool( quickIndex, processData->startTime, processData->restTime, processData->totalTime );
}


///
void cCoolTimeManager::Process( unsigned long accumTime )
{
	/// μ  Ÿ  
	if( mProcessMap.GetSize() == 0 )
		return;

	cProcessMap::cIterator i = mProcessMap.Begin();
	cProcessMap::cIterator end = mProcessMap.End();

	for( ; i != end; )
	{
		sCoolTime* data = (sCoolTime*)(i->mSecond);
		unsigned long key = (unsigned long)(i->mFirst);
		if( !data )
			continue;

		++i;

		long elasedTime = accumTime - data->startTime;
		if( elasedTime > data->restTime )
		{
			QUICKMAN->ClearCoolTime( eSHORTCUT_ITEM, key );

			/// Ÿ  μ κ 
			mProcessMap.Erase( key );
			SAFE_DELETE( data );
		}
	}

}

/// κ  Ÿ  
void cCoolTimeManager::NetSetCool( sInventoryCooltime& cool )
{
	///  ð ٽ  
	AddProcessCool( cool.ItemIndex, cool.cooltime, cool.cooltime1 );
}

///
sCoolTime* cCoolTimeManager::GetCoolData( unsigned long itemIndex )
{
	sCoolTime* data = (sCoolTime*)mCoolTimeMap.GetAt( itemIndex );
	if( !data )
		return 0;
	return data;
}

///  μ Ÿ Ʈ ȹ
sCoolTime* cCoolTimeManager::GetProcessData( unsigned long itemIndex )
{
	sCoolTime* data = (sCoolTime*)mProcessMap.GetAt( itemIndex );
	if( !data )
		return 0;
	return data;
}

