#include "stdafx.h"
#include "d3dxfont.h"

cD3DXFont::cD3DXFont()
{
	mpD3dxFont = 0;

	mpSprite = 0;
}

cD3DXFont::~cD3DXFont()
{
	SAFE_RELEASE( mpSprite );
	SAFE_RELEASE( mpD3dxFont );
}

/* ------------------------------------------------------------------
 * Լ̸ :	cD3DXFont::CreateFont( HWND hwnd, LOGFONT* pLogFont )
 *      :	D3DXFont   Ʈ ü ⺻ Ѵ.
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cD3DXFont::CreateFont( HWND hwnd, LOGFONT* pLogFont, sCacheInfo& /*cacheInfo*/ )
{
	D3DXFONT_DESC* pFontDesc = NULL;
	D3DXFONT_DESC font;

	pFontDesc = &font;

	LOGFONT logfont;

	if( !pLogFont )
	{
		pLogFont = &logfont;

		font.Height = -12;
		font.Width = -font.Height / 2;
		font.Weight = FW_BOLD;
		font.Italic = FALSE;
		font.MipLevels = D3DX_DEFAULT;

		font.CharSet = DEFAULT_CHARSET;
		font.OutputPrecision = 0;
		font.Quality =  PROOF_QUALITY;//NONANTIALIASED_QUALITY;//PROOF_QUALITY;
		font.PitchAndFamily = 0;
		::lstrcpy( font.FaceName, _T("ü") );

		logfont.lfHeight = -12;
		logfont.lfWidth = -pLogFont->lfHeight / 2;
		logfont.lfEscapement = 0;
		logfont.lfOrientation = 0;
		logfont.lfWeight = FW_BOLD;
		logfont.lfItalic = 0;
		logfont.lfUnderline = 0;
		logfont.lfStrikeOut = 0;

		logfont.lfCharSet = DEFAULT_CHARSET;
		logfont.lfOutPrecision = 0;
		logfont.lfClipPrecision = 0;
		logfont.lfQuality =  PROOF_QUALITY;//NONANTIALIASED_QUALITY;//PROOF_QUALITY;
		logfont.lfPitchAndFamily = 0;
		::lstrcpy( font.FaceName, _T("ü") );
	}
	else
	{
		font.Height = pLogFont->lfHeight;
		font.Width = pLogFont->lfWeight;
		font.Weight = pLogFont->lfWeight;
		font.Italic = pLogFont->lfItalic;
		font.MipLevels = D3DX_DEFAULT;

		font.CharSet = pLogFont->lfCharSet;
		font.OutputPrecision = pLogFont->lfOutPrecision;
		font.Quality =  pLogFont->lfQuality;
		font.PitchAndFamily = pLogFont->lfPitchAndFamily;
		lstrcpy( font.FaceName, pLogFont->lfFaceName );
	}

	mpRenderer = (NiDX9Renderer*)NiRenderer::GetRenderer();
	if( !mpRenderer )
	{
		return false;
	}

	/// Font Ȯ  Ѵ.
	if( !cFontObject::SetFontInfo( hwnd, pLogFont ) )
	{
		return false;
	}

	/// Ϸ Ʈ Ѵ.
	HRESULT hr = D3DXCreateFontIndirect( mpRenderer->GetD3DDevice(), pFontDesc, &mpD3dxFont );
	if( FAILED(hr) )
	{
		assert(0);
		return false;
	}
/*
	hr = D3DXCreateSprite( mpRenderer->GetD3DDevice(), &mpSprite );
	if( FAILED(hr) )
	{
		SAFE_RELEASE(mpD3dxFont);
		return false;
	}
*/
	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cD3DXFont::DrawText( LPTSTR str, int strLen, RECT* pRect, unsigned long color )
{
	// THIS_ LPD3DXSPRITE pSprite, LPCSTR pString, INT Count, LPRECT pRect, DWORD Format, D3DCOLOR Color
	int aa = 0;
//	mpSprite->Begin( D3DXSPRITE_DONOTSAVESTATE );
	aa = mpD3dxFont->DrawText( NULL, str, strLen, pRect, DT_LEFT | DT_TOP | DT_NOCLIP, color );// | DT_NOCLIP, color );
//	mpSprite->End();

//	mpSprite->Draw()


	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	cD3DXFont::BeginRender()
 *      :	׸  ó
 * ǻ :	
 * ------------------------------------------------------------------ */
void cD3DXFont::BeginRender()
{
//	mpD3dxFont->Begin();
}

/* ------------------------------------------------------------------
 * Լ̸ :	cD3DXFont::EndRender()
 *      :	׸  ó
 * ǻ :	
 * ------------------------------------------------------------------ */
void cD3DXFont::EndRender()
{
//	mpD3dxFont->End();
}

/* ------------------------------------------------------------------
 * Լ̸ :	cD3DXFont::Invalidate()
 *      :	ġ ҽǽ ó
 * ǻ :	
 * ------------------------------------------------------------------ */
void cD3DXFont::Invalidate()
{
	if( mpSprite )
	{
		mpSprite->OnLostDevice();
	}

	if( mpD3dxFont )
	{
		mpD3dxFont->OnLostDevice();
	}
}

/* ------------------------------------------------------------------
 * Լ̸ :	cD3DXFont::Restore()
 *      :	ġ ҽ 缳 ó
 * ǻ :	
 * ------------------------------------------------------------------ */
void cD3DXFont::Restore()
{
	if( mpSprite )
	{
		mpSprite->OnResetDevice();
	}

	if( mpD3dxFont )
	{
		mpD3dxFont->OnResetDevice();
	}
}