#include "StdAfx.h"
#include "DMMsgWindow.h"
#include "Button.h"
#include "Label.h"

#include "Application.h"
#include "GameResourceManager.h"
#include "PVPManager.h"
#include "ObjectManager.h"
#include "Hero.h"
#include "Tarot_Common.h"
#include "ItemManager.h"
#include "CardBookWindow.h"
#include "GameUIManager.h"
#include "TarotManager.h"
#include "ItemMixManager.h"
#include "UIMsgboxEvent.h"


cDMMsgWindow::cDMMsgWindow()
: mpJoin(0)
, mpCancel(0)
, mpCaption(0)
, mpText(0)
{
	mLevelType = _T(" ");
}

cDMMsgWindow::~cDMMsgWindow()
{

}

void cDMMsgWindow::SetMsgInfo( unsigned long leftTime )
{
	mWindowCloseTime = THEAPP->GetWorldAccumTime() + leftTime;
	mLeftTime = leftTime / 1000;
}

void cDMMsgWindow::OnShow()
{
	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );

	mLevelType.Format( _T("Lv%d~Lv%d"), PVPMAN->GetMinLevel(), PVPMAN->GetMaxLevel() );

	cStringT Message;
	Message.Format( GAMERESOURCEMAN->GetGameText( 820 ), mLevelType.Cstr(), (mLeftTime%3600)/60, ((mLeftTime%600)%60)%60 );
	if( mpText )
		mpText->SetText( (LPCTSTR)Message.Cstr() );
}

void cDMMsgWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	/// ڽĵ Ʈ 
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	if( mWindowCloseTime <= accumTime )
	{
		Hide();
		return;
	}

	unsigned long leftTime = ( mWindowCloseTime - accumTime + 1000 ) / 1000;
	if( mLeftTime != leftTime )
	{
		mLeftTime = leftTime; 

		cStringT Message;
		Message.Format( GAMERESOURCEMAN->GetGameText( 820 ), mLevelType.Cstr(), (mLeftTime%3600)/60, ((mLeftTime%600)%60)%60 );
		if( mpText )
			mpText->SetText( (LPCTSTR)Message.Cstr() );
	}
}

bool cDMMsgWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;
		
	mpCaption = (cLabel*)GetChild( eUIID_GAME_DMMSG_CAPTION );
	mpText = (cLabel*)GetChild( eUIID_GAME_DMMSG_TEXT );
	mpJoin = (cButton*)GetChild( eUIID_GAME_DMMSG_JOIN );
	mpCancel = (cButton*)GetChild( eUIID_GAME_DMMSG_CANCEL );

	if( mpCaption )
	{
		mpCaption->SetTextColor( eCOLOR_WHITE );
		mpCaption->SetText( GAMERESOURCEMAN->GetGameText( 819 ) );
	}

	if( mpText )
		mpText->SetTextColor( eCOLOR_WHITE );

	return true;
}

void cDMMsgWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );
}

void cDMMsgWindow::OnCommand( cUINode* pcaller, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_DMMSG_JOIN:
		{
			/// , Ÿ, NPC ŷ
			eSTOPFLAG flag = HERO->GetStopFlag();
			switch( flag )
			{
			case eSTOP_OPENTAROT:		///   
			case eSTOP_READYTAROT:
				{
					MSG_REQ_TAROT_READER_CLOSE msg;
					msg.Category = NM_TAROT;
					msg.Protocol = NM_TAROT_READER_CLOSE_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

					TAROTMAN->ChangePage( ePAGE_NONE );
				}
				break;
			case eSTOP_USETAROT:		///  Ÿ 
				{
					MSG_REQ_TAROT_SEEKER_CLOSE msg;
					msg.Category = NM_TAROT;
					msg.Protocol = NM_TAROT_SEEKER_CLOSE_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

					TAROTMAN->ChangePage( ePAGE_NONE );
				}
				break;
			case eSTOP_OPENSTALL:		///   
				{
					MSG_REQ_ITEM_STALL_SELL_CLOSE msg;
					::memset( &msg, 0, sizeof(msg) );

					msg.Category = NM_ITEM;
					msg.Protocol = NM_ITEM_STALL_SELL_CLOSE_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
				break;
			case eSTOP_USESTALL:		///  ̿ 
				{
					MSG_REQ_ITEM_STALL_SELL_LEAVE msg;
					::memset( &msg, 0, sizeof(msg) );

					msg.Category = NM_ITEM;
					msg.Protocol = NM_ITEM_STALL_SELL_LEAVE_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
				break;
			case eSTOP_EXCHANGE:		/// ŷ.
				{
					MSG_REQ_ITEM_EXCHANGE_CANCEL msg;
					::memset( &msg, 0, sizeof(msg) );

					msg.Category = NM_ITEM;
					msg.Protocol = NM_ITEM_EXCHANGE_CANCEL_REQ;
					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
				break;
			case eSTOP_COLLECTIONBOOK:	/// ÷Ǻ 
				{
					MSGROOT Msg;
					Msg.Category = NM_PLAYER;
					Msg.Protocol = NM_PLAYER_COLLECTIONBOOK_CLOSE_REQ;
					NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
				}
				break;
			case eSTOP_NPCSPEECH:		/// NPCȭ
				{
					UIMAN->HideNpcBack();
				}
				break;
			case eSTOP_ITEMMIX:			/// 
				{
					ITEMMIXMAN->ItemMixCancel();
				}
				break;
			}

			/// ġ û
			MSGROOT msg;
			msg.Category = NM_PVP;
			msg.Protocol = NM_PVP_DM_JOIN_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			/// ̵ 
			if( HERO->GetState() == eOBJECT_STATE_ATTACK || HERO->GetState() == eOBJECT_STATE_MOVE )
				HERO->SetState( eOBJECT_STATE_IDLE );

			UIMAN->CreateModal( eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 843 ), //  ó 
								GAMERESOURCEMAN->GetGameText( 2 ), // ˸
								eSKIN_NONE
								);
		}
		break;
	case eUIID_GAME_DMMSG_CANCEL:
		break;
	default:
		assert(0);
		return;
	}
	Hide();
}

//////////////////////////////////////////////////////////////////////////
#include "UIMsgboxEvent.h"


cDMRevivalWindow::cDMRevivalWindow()
{

}

cDMRevivalWindow::~cDMRevivalWindow()
{

}

void cDMRevivalWindow::ShowModal()
{
	cUIWindow::ShowModal( eMBEVENT_NONE );
}

void cDMRevivalWindow::OnShow()
{
	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );

	mWindowCloseTime = THEAPP->GetWorldAccumTime() + PVP_DM_RESURRECTION_TIME;
	mLeftTime = PVP_DM_RESURRECTION_TIME / 1000;

	cStringT Message;
	Message.Format( GAMERESOURCEMAN->GetGameText( 833 ), mLeftTime );
	if( mpText )
		mpText->SetText( (LPCTSTR)Message.Cstr() );
}

bool cDMRevivalWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpCaption = (cLabel*)GetChild( eUIID_GAME_DMREVIVAL_CAPTION );
	mpText = (cLabel*)GetChild( eUIID_GAME_DMREVIVAL_TEXT );

	if( mpCaption )
	{
		mpCaption->SetTextColor( eCOLOR_WHITE );
		mpCaption->SetText( GAMERESOURCEMAN->GetGameText( 834 ) );
	}

	if( mpText )
		mpText->SetTextColor( eCOLOR_WHITE );

	return true;
}

void cDMRevivalWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	/// ڽĵ Ʈ 
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	if( mWindowCloseTime <= accumTime )
	{
		/// event 
		MSGROOT msg;
		msg.Category = NM_PVP;
		msg.Protocol = NM_PVP_RESURRECTION_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		Hide();
		return;
	}

	unsigned long leftTime = ( mWindowCloseTime - accumTime + 1000 ) / 1000;
	if( mLeftTime != leftTime )
	{
		mLeftTime = leftTime; 

		cStringT Message;
		Message.Format( GAMERESOURCEMAN->GetGameText( 833 ), mLeftTime );
		if( mpText )
			mpText->SetText( (LPCTSTR)Message.Cstr() );
	}
}

void cDMRevivalWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );
}