#include "StdAfx.h"
#include "DMScoreWindow.h"
#include "UIImageFont.h"
#include "Application.h"
#include "PVP_Common.h"
#include "PVPManager.h"
#include "FontAgent.h"
#include "NumberEditBox.h"
#include "Label.h"

#include "ObjectManager.h"
#include "Player.h"
#include "Protocol.h"
#include "ObjectManager.h"
#include "Hero.h"

cDMScoreWindow::cDMScoreWindow()
: mPlayTime(0)
, mStartTime(0)
, mTeamAFont(0)
, mTeamBFont(0)
, mTimeFont(0)
, mTimePos(0, 0)
, mTeamAPointPos(0, 0)
, mTeamBPointPos(0, 0)
, mTeamAPointSkinPos(0, 0)
, mTeamBPointSkinPos(0, 0)
, mpFireSkin(0)
, mpWaterSkin(0)
, mpWindSkin(0)
, mpEarthSkin(0)
{
	memset( mTeamAMark, 0, sizeof(mTeamAMark) );
	memset( mTeamBMark, 0, sizeof(mTeamBMark) );
}

cDMScoreWindow::~cDMScoreWindow()
{
	mTeamAFont = 0;
	mTeamBFont = 0;
	mTimeFont = 0;
}

void cDMScoreWindow::Clear()
{
	mStartTime = 0;
	mPlayTime = 0;

	SetPointTeamA(0);
	SetPointTeamB(0);
	SetTime( PVP_DM_FIGHT_TIME );

	for( int i = 0; i < 3; ++i )
	{
		if( mTeamAMark[i] )
			mTeamAMark[i]->Hide();
		if( mTeamBMark[i] )
			mTeamBMark[i]->Hide();
	}
}

void cDMScoreWindow::OnShow()
{
	cUIWindow::OnShow();

	/// Ʈ  ġ ϱ
	if( HERO->GetPVPTeam() == ePVPDM_TEAMTYPE_A )
	{
        mTeamAPointPos = mTeamAPointSkinPos;
		mTeamBPointPos = mTeamBPointSkinPos;
	}
	else
	{
		mTeamAPointPos = mTeamBPointSkinPos;
		mTeamBPointPos = mTeamAPointSkinPos;
	}
}

bool cDMScoreWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	for( int i = 0; i < 3; ++i )
	{
		mTeamAMark[i] = (cLabel*)GetChild( eUIID_GAME_DMSCORE_TEAMAMARK0 + i );
	}
	
	for( int i = 0; i < 3; ++i )
	{
		mTeamBMark[i] = (cLabel*)GetChild( eUIID_GAME_DMSCORE_TEAMBMARK0 + i );
	}

	mTeamAFont = UIMAN->GetImageFont( 1 );
	mTeamBFont = UIMAN->GetImageFont( 3 );
	mTimeFont = UIMAN->GetImageFont( 5 );

	SetPointTeamA(10);
	SetPointTeamB(5);
	SetTime( PVP_DM_FIGHT_TIME );

	cUISkin* pSkin = UIMAN->GetSkin();
	if( !pSkin )
	{
		assert(0);
		return false;
	}

	cUINodeSkin* timeSkin = pSkin->GetNodeSkin( "PVP_DMScore_Time" );
	if( timeSkin )
	{
		mTimePos.mX = timeSkin->mSkinInfo->mX;
		mTimePos.mY = timeSkin->mSkinInfo->mY;
	}

    cUINodeSkin* ourSkin = pSkin->GetNodeSkin( "PVP_DMScore_PointTeamA" );
	if( ourSkin )
	{
		mTeamAPointSkinPos.mX = ourSkin->mSkinInfo->mX;
		mTeamAPointSkinPos.mY = ourSkin->mSkinInfo->mY;
	}

	cUINodeSkin* enumySkin = pSkin->GetNodeSkin( "PVP_DMScore_PointTeamB" );
	if( enumySkin )
	{
		mTeamBPointSkinPos.mX = enumySkin->mSkinInfo->mX;
		mTeamBPointSkinPos.mY = enumySkin->mSkinInfo->mY;
	}

	mpFireSkin = pSkin->GetNodeSkin( "PVP_DMScore_MarkFire" );
	mpWaterSkin = pSkin->GetNodeSkin( "PVP_DMScore_MarkWater" );
	mpWindSkin = pSkin->GetNodeSkin( "PVP_DMScore_MarkWind" );
	mpEarthSkin = pSkin->GetNodeSkin( "PVP_DMScore_MarkEarth" );

	if( !mpFireSkin || !mpWaterSkin || !mpWindSkin || !mpEarthSkin )
	{
		assert(0);
		return false;
	}
	return true;
}

void cDMScoreWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mStartTime == 0 )
		return;

	///
	long elapsedTime = accumTime - mStartTime;
	mPlayTime -= elapsedTime;
	mStartTime = accumTime;
    
	int m = 0;
	int s = 0;
	if( mPlayTime < 0 )
	{
		mPlayTime = 0;
	}
	else
	{
		int restTime = mPlayTime / 1000;
		m = restTime / 60;
		s = (restTime % 60) % 60;
	}

	char timeStr[20]={0,};
	::sprintf( timeStr, "%02d:%02d", m, s );
	mTimeStr = timeStr;
}

void cDMScoreWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );

	int x = GetAbsoluteRect().mLeft;
	int y = GetAbsoluteRect().mTop;

	if( mTeamAFont )
		mTeamAFont->DrawText( mTeamAPointPos.mX + x, mTeamAPointPos.mY + y, mTeamAPointStr.Cstr() );

	if( mTimeFont )
		mTimeFont->DrawText( mTimePos.mX + x, mTimePos.mY + y, mTimeStr.Cstr() );
	
	if( mTeamBFont )
		mTeamBFont->DrawText( mTeamBPointPos.mX + x, mTeamBPointPos.mY + y, mTeamBPointStr.Cstr() );
}

void cDMScoreWindow::SetPointTeamA( unsigned int point )
{
	mTeamAPointStr.Format( "%d", point );
}

void cDMScoreWindow::SetPointTeamB( unsigned int point )
{
	mTeamBPointStr.Format( "%d", point );
}

/// ð 
void cDMScoreWindow::SetTime( long time )
{
	mPlayTime = time;
	
	int restTime = mPlayTime / 1000;
	int	m = restTime / 60;
	int	s = (restTime % 60) % 60;

	char timeStr[20]={0,};
	::sprintf( timeStr, "%02d:%02d", m, s );
	mTimeStr = timeStr;
}

void cDMScoreWindow::ActiveTime()
{
	mStartTime = THEAPP->GetWorldAccumTime();
}

void cDMScoreWindow::DeActiveTime()
{
	mStartTime = 0;
	SetTime( 0 );
}

/// true : Ʊ (a), false,  (b)
void cDMScoreWindow::SetTeamImage( bool fire, bool water, bool wind, bool earth )
{
	for( int i = 0; i < 3; ++i )
	{
		if( mTeamAMark[i] )
			mTeamAMark[i]->Hide();
		if( mTeamBMark[i] )
			mTeamBMark[i]->Hide();
	}

	int indexA = 0;
	int indexB = 0;

	/// fire
	if( fire == true )
	{
		if( mTeamAMark[indexA] )
		{
			mTeamAMark[indexA]->ChangeImage( mpFireSkin );
			mTeamAMark[indexA]->Show();
		}
		indexA++;
	}
	else
	{
		if( mTeamBMark[indexB] )
		{
			mTeamBMark[indexB]->ChangeImage( mpFireSkin );
			mTeamBMark[indexB]->Show();
		}
		indexB++;
	}

	/// water
	if( water == true )
	{
		if( mTeamAMark[indexA] )
		{
			mTeamAMark[indexA]->ChangeImage( mpWaterSkin );
			mTeamAMark[indexA]->Show();
		}
		indexA++;
	}
	else
	{
		if( mTeamBMark[indexB] )
		{
			mTeamBMark[indexB]->ChangeImage( mpWaterSkin );
			mTeamBMark[indexB]->Show();
		}
		indexB++;
	}

	/// wind
	if( wind == true )
	{
		if( mTeamAMark[indexA] )
		{
			mTeamAMark[indexA]->ChangeImage( mpWindSkin );
			mTeamAMark[indexA]->Show();
		}
		indexA++;
	}
	else
	{
		if( mTeamBMark[indexB] )
		{
			mTeamBMark[indexB]->ChangeImage( mpWindSkin );
			mTeamBMark[indexB]->Show();
		}
		indexB++;
	}

	/// earth
	if( earth == true )
	{
		if( mTeamAMark[indexA] )
		{
			mTeamAMark[indexA]->ChangeImage( mpEarthSkin );
			mTeamAMark[indexA]->Show();
		}
		indexA++;
	}
	else
	{
		if( mTeamBMark[indexB] )
		{
			mTeamBMark[indexB]->ChangeImage( mpEarthSkin );
			mTeamBMark[indexB]->Show();
		}
		indexB++;
	}
}

//////////////////////////////////////////////////////////////////////////
///

cDMRankingListWindow::cDMRankingListWindow()
: mpRankList(0)
{

}

cDMRankingListWindow::~cDMRankingListWindow()
{

}

bool cDMRankingListWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpRankList = (cListBox*)GetChild( eUIID_GAME_MIDDLERESULT_LIST );

	return true;
}

void cDMRankingListWindow::OnShow()
{
	cUIWindow::OnShow();

	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );

}

void cDMRankingListWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );
}


void cDMRankingListWindow::Clear()
{
	if( mpRankList )
		mpRankList->Clear();
}

void cDMRankingListWindow::AddPlayerRankInfo( sMyTeamInfo* info, bool leader )
{
	if( mpRankList == 0 || info == 0 )
	{
		assert(0);
		return;
	}

	/// 
	unsigned long color = mDefaultColor;
	if( info->mPlayerIdx == HERO->GetObjectID() )
		color = eCOLOR_YELLOW;

	cStringT str;
	str.Format( _T("%d"), mpRankList->GetRowCount()+1 );
	int row = mpRankList->AddRow( (LPCTSTR)str.Cstr(), color );

	/// ̵
	if( leader )
	{
		str.Format( _T("%s"), info->mName );
		mpRankList->AddColume( row, (LPCTSTR)str.Cstr(), color );
	}
	else
	{
		mpRankList->AddColume( row, info->mName, color );
	}

	///
	int textIdx = 0;
	switch( info->mForceType )
	{
	case eFORCETYPE_NONE:	textIdx = 119;	break;
	case eFORCETYPE_FIRE:	textIdx = 120;	break;
	case eFORCETYPE_WATER:  textIdx = 121;	break;
	case eFORCETYPE_WIND:	textIdx = 122;	break;
	case eFORCETYPE_EARTH:	textIdx = 123;	break;
	default: assert(0); return;
	}
	mpRankList->AddColume( row, UIMAN->GetUIText( textIdx ), color );

	/// ų 
	str.Format( _T("%d"), info->mKillCnt );
	mpRankList->AddColume( row, (LPCTSTR)str.Cstr(), color );

	/// DEATH
	str.Format( _T("%d"), info->mDeathCnt );
	mpRankList->AddColume( row, (LPCTSTR)str.Cstr(), color );
}

/////////////////////////////////////////////////////////////////////
////
cDMResultWindow::cDMResultWindow()
: mpReultList(0)
, mpPointList(0)
, mpMoney(0)
, mpEXP(0)
, mpSXP(0)
, mpWin(0)
, mpLose(0)
{

}

cDMResultWindow::~cDMResultWindow()
{

}

void cDMResultWindow::Clear()
{
	if( mpReultList )
		mpReultList->Clear();

	if( mpPointList )
		mpPointList->Clear();

	if( mpWin )
		mpWin->Hide();

	if( mpLose )
		mpLose->Hide();
}

void cDMResultWindow::OnShow()
{
	cUIWindow::OnShow();

	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );
}

bool cDMResultWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpReultList = (cListBox*)GetChild( eUIID_GAME_DMRESULT_LISTBOX );
	mpPointList = (cListBox*)GetChild( eUIID_GAME_DMRESULT_POINTLIST );
	mpMoney = (cLabel*)GetChild( eUIID_GAME_DMRESULT_MONEY );
	mpEXP = (cLabel*)GetChild( eUIID_GAME_DMRESULT_EXP );
	mpSXP = (cLabel*)GetChild( eUIID_GAME_DMRESULT_SXP );
	mpWin = GetChild( eUIID_GAME_DMRESULT_WIN );
	mpLose = GetChild( eUIID_GAME_DMRESULT_LOSE );
	return true;
}

void cDMResultWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );
}

void cDMResultWindow::OnCommand( cUINode* , unsigned int id )
{
	if( id == eUIID_GAME_DMRESULT_CLOSE )
	{
		/// ̵û
		MSGROOT msg;
		msg.Category = NM_PVP;
		msg.Protocol = NM_PVP_DM_END_REQ;
		NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

		Hide();
	}
}

void cDMResultWindow::SetResult( bool win )
{
	if( win )
	{
		if( mpWin )
			mpWin->Show();
	}
	else
	{
		if( mpLose )
			mpLose->Show();
	}
}

void cDMResultWindow::InsertRank( sMyTeamInfo* data, int ranki )
{
	if( mpReultList == 0 || data == 0 )
	{
		assert(0);
		return;
	}

	/// 
	cStringT str;

	unsigned long color = mDefaultColor;
	str.Format( _T("%d"), ranki+1 );
	int row = mpReultList->AddRow( (LPCTSTR)str.Cstr(), color );

	/// ̵
	mpReultList->AddColume( row, data->mName, color );

	int textIdx = 0;
	switch( data->mForceType )
	{
	case eFORCETYPE_NONE:	textIdx = 119;	break;
	case eFORCETYPE_FIRE:	textIdx = 120;	break;
	case eFORCETYPE_WATER:  textIdx = 121;	break;
	case eFORCETYPE_WIND:	textIdx = 122;	break;
	case eFORCETYPE_EARTH:	textIdx = 123;	break;
	default: assert(0); return;
	}

	/// 
	mpReultList->AddColume( row, UIMAN->GetUIText( textIdx ), color );

	/// ų 
	str.Format( _T("%d"), data->mKillCnt );
	mpReultList->AddColume( row, (LPCTSTR)str.Cstr(), color );

	/// DEATH
	str.Format( _T("%d"), data->mDeathCnt );
	mpReultList->AddColume( row, (LPCTSTR)str.Cstr(), color );

	///
	str.Format( _T("%d"), data->mScoreResult );
	mpReultList->AddColume( row, (LPCTSTR)str.Cstr(), color );
}

void cDMResultWindow::SetReward( unsigned long money, unsigned long exp, unsigned long sxp )
{
	if( mpMoney )
	{
		LPCTSTR moneyStr = cNumberEditBox::FormatNumber( money );
		mpMoney->SetText( moneyStr );
	}

	if( mpEXP )
		mpEXP->SetValue( exp );

	if( mpSXP )
		mpSXP->SetValue( sxp );
}

void cDMResultWindow::SetRewardForce( unsigned long point, unsigned long friendly )
{
	if( mpPointList )
	{
		TCHAR pStr[20] = {0,};
		TCHAR fStr[20] = {0,};

		::_stprintf( pStr, _T("%d"), point );
		::_stprintf( fStr, _T("%d"), friendly );

		int row = mpPointList->AddRow( pStr, mDefaultColor );
		mpPointList->AddColume( row, fStr, mDefaultColor );
	}
}



/*
//////////////////////////////////////////////////////////////////////////
////  Ʈڽ
cDMResultListBox::cDMResultListBox()
{

}

cDMResultListBox::~cDMResultListBox()
{

}

/// ǻ : Ʈ  ׷ֱ
void cDMResultListBox::RenderData( cUIFontItemKeeper* pKeeper )
{
	/// ü Ʈ  
	if( GetRowCount() <= 0 )
		return;

	/// Ų ޾ƿ 
	cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
	if( !pListSkin )
	{
		assert(0);
		return;
	}

	/// Ʈ ڽ ǥ ޾ƿ
	int textPosY = GetAbsoluteRect().mTop + mPrintPos.mY;

	unsigned int rowCount = GetRowCount();
	for( unsigned int row = 0; row < rowCount; ++row )
	{
		sRowData* rData = GetRowData( row );
		if( !rData )
			continue;

		if( row == MAX_ROW )
			textPosY = GetAbsoluteRect().mTop + mPrintPos.mY;

		/// image  
		if( rData->mImage )
		{
			cUIImage* image = rData->mImage;

			sListCtrlParam* pParam = pListSkin->mpImgParam;
			unsigned int imageX = pParam->mColumnX;
			unsigned int imageY = textPosY + (int)((mRowHeight-image->GetHeight())*0.5f);

			image->SetPos( GetAbsoluteRect().mLeft + imageX, imageY );
			image->Draw();
		}
		/// Ʈ  
		unsigned int colCount = rData->mColumes.GetSize();
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];

			///  ÷ param data  ( ġ  )
			sListCtrlParam* pParam = pListSkin->GetCtrlParam( col );

			unsigned int tX = 0;
			unsigned int tW = 0;
			eText_Align align = eALIGN_LEFT;

			if( pParam )
			{
				tX = pParam->mColumnX;
				tW = pParam->mColumnW;
				align = pParam->mAlign;
			}

			///   ǥ  
			unsigned int strWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_UI, (LPTSTR)data->mText.Cstr(), data->mText.GetLength() );
			int addY = (int)((mRowHeight-FONTAGENT->GetTextHeight(cFontAgent::eFont_UI))*0.5f);

			/// 8 ,  8 ʿ Ѵ
			int textposX = UpdateTextPos( align, strWidth, tX, tW );
			
			if( row >= MAX_ROW )
				textposX += (int)(GetAbsoluteRect().GetWidth() * 0.5);

			pKeeper->AddFontItem( cFontAgent::eFont_UI, (LPTSTR)data->mText.Cstr(), textposX, textPosY + addY, data->mTextColor );
		}

		textPosY += mRowHeight;
	}
}*/
