/* ==========================================================================
*      : DMScoreWindow.h
*      : 
*    : 谡
*    : 2008-09-03
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "ListBox.h"

class cLabel;
class cUIImageFont;
class cDMScoreWindow : public cUIWindow
{
public:
	cDMScoreWindow();
	virtual ~cDMScoreWindow();

	void Clear();

	void SetPointTeamA( unsigned int point );
	void SetPointTeamB( unsigned int point );
	void SetDestPoint( unsigned int point );
	void SetTime( long time );
	void SetTeamImage( bool fire, bool water, bool wind, bool earth );

	void ActiveTime();
	void DeActiveTime();

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	void OnRender( cUIFontItemKeeper* pKeeper );
	void OnShow();

private:
	/// Ʊ Ʈ
	cString mTeamAPointStr;
	cString mTeamBPointStr;

	///  ð
	long mPlayTime;
	long mStartTime;
	cString mTimeStr;

	/// Ʈ
	cUIImageFont* mTeamAFont;
	cUIImageFont* mTeamBFont;
	cUIImageFont* mTimeFont;

	///  Ų
	cUIPos			mTimePos;
	cUIPos			mTeamAPointSkinPos;
	cUIPos			mTeamBPointSkinPos;

	///   ̹ ǥ ġ
	cUIPos			mTeamAPointPos;
	cUIPos			mTeamBPointPos;

	///   ̹ ǥ ġ
	cLabel*			mTeamAMark[3];
	cLabel*			mTeamBMark[3];

	cUINodeSkin*	mpFireSkin;
	cUINodeSkin*	mpWaterSkin;
	cUINodeSkin*	mpWindSkin;
	cUINodeSkin*	mpEarthSkin;
};


//////////////////////////////////////////////////////////////////////////
/// ŷ
struct sMyTeamInfo;

class cDMRankingListWindow : public cUIWindow
{
public:
	cDMRankingListWindow();
	virtual ~cDMRankingListWindow();

	void Clear();
	void AddPlayerRankInfo( sMyTeamInfo* info, bool leader );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnShow();
	void UpdateSkin();

protected:
	cListBox*	mpRankList;
};



//////////////////////////////////////////////////////////////////////////
/// 
const int MAX_ROW = 9;

struct sMyTeamInfo;
class cDMResultWindow : public cUIWindow
{
public:
	cDMResultWindow();
	virtual ~cDMResultWindow();

	void Clear();
	void InsertRank( sMyTeamInfo* data, int ranki );
	void SetReward( unsigned long money, unsigned long exp, unsigned long sxp );
	void SetRewardForce( unsigned long point, unsigned long friendly );
	void SetResult( bool win );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* , unsigned int );
	void OnShow();
	void UpdateSkin();

private:
	///  Ʈڽ
	cListBox*	mpReultList;

	/// Ʈ  Ʈڽ
	cListBox*	mpPointList;

	///
	cLabel*		mpMoney;
	cLabel*		mpEXP;
	cLabel*		mpSXP;

	/// 
	cUINode*	mpWin;
	cUINode*	mpLose;
};

/*
//  Ʈ ڽ
class cDMResultListBox : public cListBox
{
public:
	cDMResultListBox();
	virtual ~cDMResultListBox();

protected:
	void RenderData( cUIFontItemKeeper* pKeeper );
};
*/