/* ====================================================================
*      :	DepthPlane.h
*      :	2D, 2.5D  ⺻ ü
*    :	̹
*    :	2007.3
* ǻ :	2.5D ü   Ϸ Ŭ  ӹ޾ƾ  ü
* =================================================================== */

#pragma once

///
class cPlane
{
public:
	virtual ~cPlane() {}

	virtual void Draw() = 0;

	/// ǥ ȯ ( world pos -> Screen pos )
	static void WorldPtToScreenPt( NiCamera* pCam, const NiPoint3& pt, float& posX, float& posY, bool InScreen = true );

protected:
	cPlane() {}
};

class cDepthPlaneObject;

///
class cDepthPlane
{
public:
	virtual ~cDepthPlane();

	/// Լ 
	void Render( NiRenderer* pRenderer );
	virtual void Render2D() {}

	/// RenderedTexture ϴ Լ
	void Compose( NiDX9Renderer* pRenderer );

	///  ϴ  ó
	void OnUpdate( NiCamera* pCamera, const NiPoint3& pos, float scale = 1.0f );

	inline NiGeometry* GetPlane() { return (NiGeometry*)mpRenderTargetPlane; }

protected:
	virtual void RenderFrame() = 0;

protected:
	cDepthPlane( unsigned int width, unsigned int height );

protected:
	cDepthPlaneObject*			mpRenderTargetPlane;

	NiColorA					mBackColor;

	NiRenderedTexturePtr		mpRenderedTexture;
	NiRenderTargetGroupPtr		mpRenderTargetGroup;
};