#include "StdAfx.h"
#include ".\depthplanedata.h"

cDepthPlaneData::cDepthPlaneData( unsigned int width, unsigned int height )
{
	/// 1.  4 Ѵ.
	m_usVertices = 4;
	m_usTriangles = m_usVertices - 2;

	///   ޸  FVF(vertex, color, tex1)
	m_pkVertex = NiNew NiPoint3[m_usVertices];
	m_pkNormal = 0;
	m_pkColor = NiNew NiColorA[m_usVertices];
	m_pkTexture = NiNew NiPoint2[m_usVertices];
	SetNumTextureSets(1);
	for( unsigned int i = 0; i < m_usVertices; i++)
	{
		m_pkVertex[i] = NiPoint3(0.0f,0.0f,0.0f);
		m_pkColor[i] = NiColorA::WHITE;
		m_pkTexture[i] = NiPoint2(0.0f, 0.0f);
	}

	/// ε 
	m_uiTriListLength = 3 * m_usTriangles;
	m_pusTriList = NiAlloc(unsigned short, m_uiTriListLength);

	/// ﰢ ε [0 1 2] [0 2 3]
	unsigned short* pusTriList = m_pusTriList;
//	for( unsigned short i = 0; i < m_usTriangles; i++)
//	{
		*pusTriList++ = 0;
		*pusTriList++ = 1;
		*pusTriList++ = 2;

		*pusTriList++ = 0;
		*pusTriList++ = 2;
		*pusTriList++ = 3;
//	}


	///  ϳ Ѵ.
	float left, top, right, bottom;
	left = -(float)width*0.5f;
	right = (float)width*0.5f;
	top = (float)height;
	bottom = 0.0f;

	int idx = 0;
	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;

	m_pkTexture[idx].x = 0.0f;
	m_pkTexture[idx].y = 0.0f;
	idx++;

	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;

	m_pkTexture[idx].x = 0.0f;
	m_pkTexture[idx].y = 1.0f;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;

	m_pkTexture[idx].x = 1.0f;
	m_pkTexture[idx].y = 1.0f;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;

	m_pkTexture[idx].x = 1.0f;
	m_pkTexture[idx].y = 0.0f;
	idx++;

	SetVertexCount( m_usVertices );
	SetTriangleCount( m_usTriangles );

	MarkAsChanged(COLOR_MASK|VERTEX_MASK|TEXTURE_MASK);

//	mBoundNeedsUpdate = true;

	mWidth = width;
	mHeight = height;
}

cDepthPlaneData::~cDepthPlaneData()
{
}

void cDepthPlaneData::SetColor( const NiColorA& color )
{
	for( unsigned int i = 0; i < m_usVertices; i++)
	{
		m_pkColor[i] = color;
	}
	MarkAsChanged(COLOR_MASK);
}

void cDepthPlaneData::SetAlpha( float alpha )
{
	for( unsigned int i = 0; i < m_usVertices; i++)
	{
		m_pkColor[i].a = alpha;
	}
	MarkAsChanged(COLOR_MASK);
}

void cDepthPlaneData::ReScale( float fXScale, float fYScale )
{
	if( fXScale <= 0.0f || fYScale <= 0.0f )
	{
		assert(0);
		return;
	}

	unsigned int width = (unsigned int)(mWidth * fXScale);
	unsigned int height = (unsigned int)(mHeight * fYScale);

	float left, top, right, bottom;
	left = -(float)width*0.5f;
	right = (float)width*0.5f;
	top = (float)height;
	bottom = 0.0f;

	int idx = 0;
	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;
	idx++;

	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;
	idx++;

	MarkAsChanged(VERTEX_MASK);
}

void cDepthPlaneData::ReSize( unsigned int width, unsigned int height )
{
	float left, top, right, bottom;
	left = -(float)width*0.5f;
	right = (float)width*0.5f;
	top = (float)height;
	bottom = 0.0f;

	int idx = 0;
	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;
	idx++;

	m_pkVertex[idx].x = left;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = bottom;
	idx++;

	m_pkVertex[idx].x = right;
	m_pkVertex[idx].y = 0.0f;
	m_pkVertex[idx].z = top;
	idx++;

	mWidth  = width;
	mHeight = height;

	MarkAsChanged(VERTEX_MASK);
//	mBoundNeedsUpdate = true;
}

void cDepthPlaneData::SetTextureRect( float left, float top, float right, float bottom )
{
	m_pkTexture[0].x = left;
	m_pkTexture[0].y = top;
	m_pkTexture[1].x = left;
	m_pkTexture[1].y = bottom;
	m_pkTexture[2].x = right;
	m_pkTexture[2].y = bottom;
	m_pkTexture[3].x = right;
	m_pkTexture[3].y = top;

	MarkAsChanged(TEXTURE_MASK);
}

void cDepthPlaneData::UpdateBound()
{
//	if( mBoundNeedsUpdate == false )
//		return;

//	mBoundNeedsUpdate = false;
	if (m_usVertices > 0)
		m_kBound.ComputeFromData(m_usVertices, m_pkVertex);
}