/* ====================================================================
*      :	DepthPlaneObject.h
*      :	2.5D  ⺻ ü
*    :	̹
*    :	2007.2
* ǻ :	
* =================================================================== */
#pragma once

#include "DepthPlaneData.h"

class cDepthPlane;

class cDepthPlaneObject : public NiTriShape
{
	friend class cDepthPlane;
public:
	cDepthPlaneObject( cDepthPlaneData* pdata );
	virtual ~cDepthPlaneObject();

	/// 
	void Draw( NiRenderer* pRenderer );

	virtual void RenderImmediate(NiRenderer* pkRenderer);


	///  4  ÷  
	void SetColor( const NiColorA& color );

	void SetAlpha( float alpha );

	///   
	void ReSize( unsigned int width, unsigned int height );

	///   
	void ReScale( float scaleX, float scaleY );

	///  UV ǥ 
	void SetTextureRect( float left, float top, float right, float bottom );

protected:
	/// ȭ鿡 µǾ ϴ 쿡  ó
	void OnUpdate( NiCamera* pcamera );

	/// ٿ ..
	virtual void UpdateWorldBound();

	///  ȸ 
	void RotateToCamera( const NiCamera* pCamera );

protected:
	cDepthPlaneData* Data();
	const cDepthPlaneData* Data() const;
};

inline cDepthPlaneData* cDepthPlaneObject::Data()
{
	cDepthPlaneData* p = NiSmartPointerCast(cDepthPlaneData,m_spModelData);

	return p;
}
inline const cDepthPlaneData* cDepthPlaneObject::Data() const
{
	cDepthPlaneData* p = NiSmartPointerCast(cDepthPlaneData,m_spModelData);

	return p;
}

inline void cDepthPlaneObject::RenderImmediate(NiRenderer* pkRenderer)
{
	NiTriShape::RenderImmediate( pkRenderer );
}
