#include "StdAfx.h"
#include "devsystem.h"
#include "rendersystem.h"

#include "FontAgent.h"

#include "Hero.h"
#include "ObjectManager.h"
#include "SkillManager.h"

#include "InputSystem.h"

#include "CameraManager.h"

#include "UIManager.h"
#include "UINode.h"

#include "ServerWindow.h"
#include "Button.h"
cDevSystem* cDevSystem::mpDevSystem = NULL;


cDevSystem::cDevSystem()
{
	mpDevSystem = this;
	mTxtColor = NiColorA(0.0f, 0.0f, 1.0f, 1.0f);

	mLastTime = 0;
	mFrames = 0;
	mFPS = 0.0f;

	mNode = 0;
	mTriangle = 0;

	mSolidRenderCount = 0;
	mDamageRenderCount = 0;
	mAlphaRenderCount = 0;
	mAlphaTestRenderCount = 0;

	mTerrainRenderCount = 0;

	mLoadState = 0;


	mScaleAccumTime[0] = 0;
	mAniLastTime[0] = 0;
	mScaleFactor[0] = 0.0f;

	mScaleAccumTime[1] = 0;
	mAniLastTime[1] = 0;
	mScaleFactor[1] = 0.0f;

}

cDevSystem::~cDevSystem()
{
	Exit();

	mpDevSystem = NULL;
}

/* ------------------------------------------------------------------
* Լ̸ :	Init()
*      :	ʱȭ
* ǻ :	
* ------------------------------------------------------------------ */
bool cDevSystem::Init()
{

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	Exit()
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
void cDevSystem::Exit()
{
}

/* ------------------------------------------------------------------
* Լ̸ :	Process( float time )
*      :	ó
* ǻ :	
* ------------------------------------------------------------------ */
void cDevSystem::Process( unsigned long accumTime )
{
	if( mLastTime < accumTime )
	{
		mFPS = (float)mFrames / (float)((accumTime-(mLastTime-1000))/1000);
		mLastTime = accumTime+1000;
		mFrames = 0;
	}
	else
		mFrames++;
}

/* ------------------------------------------------------------------
* Լ̸ :	DrawDevInfo()
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
void cDevSystem::DrawDevInfo()
{
/*
	const cRenderSystem::sRenderOption* option = RENDERSYS->GetOption();

	TCHAR flag[512] = {0,};
	TCHAR devtype[256] = {0,};
	TCHAR fbformat[256] = {0,};
	TCHAR dsformat[256] = {0,};
	TCHAR interval[256] = {0,};
	TCHAR swapeffect[256] = {0,};
	TCHAR fbmode[256] = {0,};
	TCHAR herostate[256] = {0,};
	TCHAR weaponstate[256] = {0, };

	if( option->Flags == 0)
		Sstrncpy( flag, 512, _T("USE_NOFLAGS"), 511 );

	else
	{
		if(option->Flags & NiDX9Renderer::USE_MANUALDEPTHSTENCIL)
			Sstrncat(flag, 512, _T("[USE_MANUALDEPTHSTENCIL]"), 50);
		if(option->Flags & NiDX9Renderer::USE_FULLSCREEN)
			Sstrncat(flag, 512, _T("[USE_FULLSCREEN]"), 50);
		if(option->Flags & NiDX9Renderer::USE_STENCIL)
			Sstrncat(flag, 512, _T("[USE_STENCIL]"), 50);
		if(option->Flags & NiDX9Renderer::USE_16BITBUFFERS)
			Sstrncat(flag, 512, _T("[USE_16BITBUFFERS]"), 50);
		if(option->Flags & NiDX9Renderer::USE_MULTITHREADED)
			Sstrncat(flag, 512, _T("[USE_MULTITHREADED]"), 50);
		if(option->Flags & NiDX9Renderer::USE_FPU_PRESERVE)
			Sstrncat(flag, 512, _T("[USE_FPU_PRESERVE]"), 50);
	}
	switch(option->DevDesc)
	{
	case NiDX9Renderer::DEVDESC_PURE:				Sstrncat(devtype, 256, _T("DEVDESC_PURE"), 50 );break;
	case NiDX9Renderer::DEVDESC_HAL_HWVERTEX:		Sstrncat(devtype, 256, _T("DEVDESC_HAL_HWVERTEX"), 50 );break;
	case NiDX9Renderer::DEVDESC_HAL_MIXEDVERTEX:	Sstrncat(devtype, 256, _T("DEVDESC_HAL_MIXEDVERTEX"), 50 );break;
	case NiDX9Renderer::DEVDESC_HAL_SWVERTEX:		Sstrncat(devtype, 256, _T("DEVDESC_HAL_SWVERTEX"), 50 );break;
	case NiDX9Renderer::DEVDESC_REF:				Sstrncat(devtype, 256, _T("DEVDESC_REF"), 50 );break;
	case NiDX9Renderer::DEVDESC_REF_HWVERTEX:		Sstrncat(devtype, 256, _T("DEVDESC_REF_HWVERTEX"), 50 );break;
	case NiDX9Renderer::DEVDESC_REF_MIXEDVERTEX:	Sstrncat(devtype, 256, _T("DEVDESC_REF_MIXEDVERTEX"), 50 );break;
	}
	switch(option->FBformat)
	{
	case NiDX9Renderer::FBFMT_UNKNOWN:			Sstrncat(fbformat, 256, _T("FBFMT_UNKNOWN"), 50 );break;
	case NiDX9Renderer::FBFMT_R8G8B8:			Sstrncat(fbformat, 256, _T("FBFMT_R8G8B8"), 50 );break;
	case NiDX9Renderer::FBFMT_A8R8G8B8:			Sstrncat(fbformat, 256, _T("FBFMT_A8R8G8B8"), 50 );break;
	case NiDX9Renderer::FBFMT_X8R8G8B8:			Sstrncat(fbformat, 256, _T("FBFMT_X8R8G8B8"), 50 );break;
	case NiDX9Renderer::FBFMT_R5G6B5:			Sstrncat(fbformat, 256, _T("FBFMT_R5G6B5"), 50 );break;
	case NiDX9Renderer::FBFMT_X1R5G5B5:			Sstrncat(fbformat, 256, _T("FBFMT_X1R5G5B5"), 50 );break;
	case NiDX9Renderer::FBFMT_A1R5G5B5:			Sstrncat(fbformat, 256, _T("FBFMT_A1R5G5B5"), 50 );break;
	case NiDX9Renderer::FBFMT_A4R4G4B4:			Sstrncat(fbformat, 256, _T("FBFMT_A4R4G4B4"), 50 );break;
	case NiDX9Renderer::FBFMT_R3G3B2:			Sstrncat(fbformat, 256, _T("FBFMT_R3G3B2"), 50 );break;
	case NiDX9Renderer::FBFMT_A8:				Sstrncat(fbformat, 256, _T("FBFMT_A8"), 50 );break;
	case NiDX9Renderer::FBFMT_A8R3G3B2:			Sstrncat(fbformat, 256, _T("FBFMT_A8R3G3B2"), 50 );break;
	case NiDX9Renderer::FBFMT_X4R4G4B4:			Sstrncat(fbformat, 256, _T("FBFMT_X4R4G4B4"), 50 );break;
	case NiDX9Renderer::FBFMT_R16F:				Sstrncat(fbformat, 256, _T("FBFMT_R16F"), 50 );break;
	case NiDX9Renderer::FBFMT_G16R16F:			Sstrncat(fbformat, 256, _T("FBFMT_G16R16F"), 50 );break;
	case NiDX9Renderer::FBFMT_A16B16G16R16F:	Sstrncat(fbformat, 256, _T("FBFMT_A16B16G16R16F"), 50 );break;
	case NiDX9Renderer::FBFMT_R32F:				Sstrncat(fbformat, 256, _T("FBFMT_R32F"), 50 );break;
	case NiDX9Renderer::FBFMT_G32R32F:			Sstrncat(fbformat, 256, _T("FBFMT_G32R32F"), 50 );break;
	case NiDX9Renderer::FBFMT_A32B32G32R32F:	Sstrncat(fbformat, 256, _T("FBFMT_A32B32G32R32F"), 50 );break;
	}
	switch(option->DSformat)
	{
	case NiDX9Renderer::DSFMT_UNKNOWN:			Sstrncat(dsformat, 256, _T("DSFMT_UNKNOWN"), 50 );break;
	case NiDX9Renderer::DSFMT_D16_LOCKABLE:		Sstrncat(dsformat, 256, _T("DSFMT_D16_LOCKABLE"), 50 );break;
	case NiDX9Renderer::DSFMT_D32:				Sstrncat(dsformat, 256, _T("DSFMT_D32"), 50 );break;
	case NiDX9Renderer::DSFMT_D15S1:			Sstrncat(dsformat, 256, _T("DSFMT_D15S1"), 50 );break;
	case NiDX9Renderer::DSFMT_D24S8:			Sstrncat(dsformat, 256, _T("DSFMT_D24S8"), 50 );break;
	case NiDX9Renderer::DSFMT_D16:				Sstrncat(dsformat, 256, _T("DSFMT_D16"), 50 );break;
	case NiDX9Renderer::DSFMT_D24X8:			Sstrncat(dsformat, 256, _T("DSFMT_D24X8"), 50 );break;
	case NiDX9Renderer::DSFMT_D24X4S4:			Sstrncat(dsformat, 256, _T("DSFMT_D24X4S4"), 50 );break;
	}
	switch(option->Interval)
	{
	case NiDX9Renderer::PRESENT_INTERVAL_IMMEDIATE:	Sstrncat(interval, 256, _T("PRESENT_INTERVAL_IMMEDIATE"), 50 );break;
	case NiDX9Renderer::PRESENT_INTERVAL_ONE:		Sstrncat(interval, 256, _T("PRESENT_INTERVAL_ONE"), 50 );break;
	case NiDX9Renderer::PRESENT_INTERVAL_TWO:		Sstrncat(interval, 256, _T("PRESENT_INTERVAL_TWO"), 50 );break;
	case NiDX9Renderer::PRESENT_INTERVAL_THREE:		Sstrncat(interval, 256, _T("PRESENT_INTERVAL_THREE"), 50 );break;
	case NiDX9Renderer::PRESENT_INTERVAL_FOUR:		Sstrncat(interval, 256, _T("PRESENT_INTERVAL_FOUR"), 50 );break;
	}
	switch(option->Swapeffect)
	{
	case NiDX9Renderer::SWAPEFFECT_DEFAULT:			Sstrncat(swapeffect, 256, _T("SWAPEFFECT_DEFAULT"), 50 );break;
	case NiDX9Renderer::SWAPEFFECT_DISCARD:			Sstrncat(swapeffect, 256, _T("SWAPEFFECT_DISCARD"), 50 );break;
	case NiDX9Renderer::SWAPEFFECT_FLIP:			Sstrncat(swapeffect, 256, _T("SWAPEFFECT_FLIP"), 50 );break;
	case NiDX9Renderer::SWAPEFFECT_COPY:			Sstrncat(swapeffect, 256, _T("SWAPEFFECT_COPY"), 50 );break;
	}
	switch(option->FBmode)
	{
	case NiDX9Renderer::FBMODE_DEFAULT:						Sstrncat(fbmode, 256, _T("FBMODE_DEFAULT"), 50 );break;
	case NiDX9Renderer::FBMODE_LOCKABLE:					Sstrncat(fbmode, 256, _T("FBMODE_LOCKABLE"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_2:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_2"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_3:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_3"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_4:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_4"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_5:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_5"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_6:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_6"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_7:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_7"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_8:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_8"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_9:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_9"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_10:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_10"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_11:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_11"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_12:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_12"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_13:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_13"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_14:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_14"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_15:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_15"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_16:				Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_16"), 50 );break;
	case NiDX9Renderer::FBMODE_MULTISAMPLES_NONMASKABLE:	Sstrncat(fbmode, 256, _T("FBMODE_MULTISAMPLES_NONMASKABLE"), 50 );break;
	}

	if( HERO )
	{
		switch( HERO->GetWeaponState() )
		{
		case eWEAPON_STATE_NONE:			Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_NONE"), 50 ); break;
		case eWEAPON_STATE_SWORD:			Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_SWORD"), 50 ); break;
		case eWEAPON_STATE_LONGSWORD:		Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_LONGSWORD"), 50 ); break;
		case eWEAPON_STATE_DOUBLESWORD:		Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_DOUBLESWORD"), 50 ); break;
		case eWEAPON_STATE_SHORTSWORD:		Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_SHORTSWORD"), 50 ); break;
		case eWEAPON_STATE_GUN:				Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_GUN"), 50 ); break;
		case eWEAPON_STATE_STAFF:			Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_STAFF"), 50 ); break;
		case eWEAPON_STATE_SHEILD:			Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_SHEILD"), 50 ); break;
		case eWEAPON_STATE_SWORD_SHEILD:	Sstrncat(weaponstate, 256, _T("eWEAPON_STATE_SWORD_SHEILD"), 50 ); break;
		}

		switch( HERO->GetState() )
		{
		case eOBJECT_STATE_IDLE:		Sstrncat(herostate, 256, _T("eOBJECT_STATE_IDLE"), 50 ); break;
		case eOBJECT_STATE_MOVE:		Sstrncat(herostate, 256, _T("eOBJECT_STATE_MOVE"), 50 ); break;
		case eOBJECT_STATE_ATTACK:		Sstrncat(herostate, 256, _T("eOBJECT_STATE_ATTACK"), 50 ); break;
		case eOBJECT_STATE_DIE:			Sstrncat(herostate, 256, _T("eOBJECT_STATE_DIE"), 50 ); break;
		case ePLAYER_STATE_ITEMPICK:	Sstrncat(herostate, 256, _T("ePLAYER_STATE_ITEMPICK"), 50 ); break;
		}
	}

	//#ifdef _DEBUG

	NiPoint3 camPos = NiPoint3::ZERO;
	NiPoint3 camDir = NiPoint3::ZERO;
	NiPoint3 camUVector = NiPoint3::ZERO;
	NiPoint3 camRVector = NiPoint3::ZERO;

	NiCamera* cam = CAMERAMAN->GetCurrentNi();
	if( cam )
	{
		camPos = cam->GetWorldLocation();

		camDir = cam->GetWorldDirection();
		camUVector = cam->GetWorldUpVector();
		camRVector = cam->GetWorldRightVector();
	}
*/
	TCHAR	str[256]=  {0,};

	POINT pos;
	pos.x = 10;
	pos.y = 10;

	::_stprintf( str, _T("*FPS : %d"), (int)mFPS );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*[Solid | AlphaTest | AlphaNoTest | Damage] : %d | %d | %d | %d"), mSolidRenderCount, mAlphaTestRenderCount, mAlphaRenderCount, mDamageRenderCount );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*[Terrain RenderCount] : %d"), mTerrainRenderCount );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*[HERO SHOW] : %s"),  mShowHero? _T("TRUE"):_T("FALSE") );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("[D:%d] [S:%d] [I:%d] [A:%d]"), SKILLMAN->GetDummySkillCount(),
		SKILLMAN->GetSkillCount(), SKILLMAN->GetInfluenceCount(), SKILLMAN->GetApplyCount() );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	mShowHero = false;

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("LoadState : %d"), mLoadState );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("HERO ANI INFO : [%d][%d][%f]"), mScaleAccumTime[0], mAniLastTime[0], mScaleFactor[0] );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("VEHICLE ANI INFO : [%d][%d][%f]"), mScaleAccumTime[1], mAniLastTime[1], mScaleFactor[1] );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xffffffff );

/*
	/// Camera Info
	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*CameraPos : %7.2f, %7.2f, %7.2f"), camPos.x, camPos.y, camPos.z );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*HERO State : %s"), herostate );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*HERO Weapon State : %s"), weaponstate );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	if( UIMAN && UIMAN->GetHoverNode() )
	{
		cUINode* pNode = UIMAN->GetHoverNode();
		const cString aa = pNode->GetSkinName();

		if( aa.GetLength() )
		{
			pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;

#ifdef _UNICODE
			TCHAR buffer[256] = {0,};
			ConvertToUnicode( aa.Cstr(), (LPWSTR)buffer, 256 );
			::_stprintf( str, _T("*UI HoverNode Check : %s"),  buffer );
#else
			::_stprintf( str, _T("*UI HoverNode Check : %s"),  aa.Cstr() );
#endif
			FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );
		}
	}

	if( UIMAN && UIMAN->GetCaptureNode() )
	{
		cUINode* pNode = UIMAN->GetCaptureNode();
		const cString aa = pNode->GetSkinName();
		if( aa.GetLength() )
		{
			pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;

#ifdef _UNICODE
			TCHAR buffer[256] = {0,};
			ConvertToUnicode( aa.Cstr(), (LPWSTR)buffer, 256 );
			::_stprintf( str, _T("*UI CaptureNode Check : %s"),  buffer );
#else
			::_stprintf( str, _T("*UI CaptureNode Check : %s"),  aa.Cstr() );
#endif
			FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );
		}
	}

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*Mouse Pos : %d | %d"), MOUSE->GetMouseX(), MOUSE->GetMouseY() );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("*Screen Size : %d | %d"), RENDERSYS->GetScreenWidth(), RENDERSYS->GetScreenHeight() );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("%s"), mTest.Cstr() );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	pos.y += FONTAGENT->GetTextHeight( cFontAgent::eFont_System ) + 8;
	::_stprintf( str, _T("[D:%d] [S:%d] [I:%d] [A:%d]"), SKILLMAN->GetDummySkillCount(),
		SKILLMAN->GetSkillCount(), SKILLMAN->GetInfluenceCount(), SKILLMAN->GetApplyCount() );
	FONTAGENT->DrawText( cFontAgent::eFont_System, str, ::lstrlen(str), &pos, 0xff0000ff );

	//#endif
*/
}