#include "StdAfx.h"
#include "displayobject.h"

#include "ResourceManager.h"
#include "PlayerSceneNode.h"
#include "GameResourceManager.h"
#include "ObjectNameCard.h"

cDisplayObject::cDisplayObject()
{
	mStandIdx = 0;
	mMapNum = 0;
	mSetName = false;
}

cDisplayObject::~cDisplayObject()
{
}

bool cDisplayObject::Create( sPlayerInfo* pBaseInfo, sPlayerWearInfo* pWearInfo, sPlayerWeaponInfo* pWeaponInfo, 
						 sPlayerExrInfo* pExrInfo, NiPoint3 sPos, NiMatrix3 sRot, float fScale )
{
	::memcpy( &mPlayerInfo, pBaseInfo, sizeof(sPlayerInfo) );
	::memcpy( &mPlayerWearInfo, pWearInfo, sizeof(sPlayerWearInfo) );
	::memcpy( &mPlayerWeaponInfo, pWeaponInfo, sizeof(sPlayerWeaponInfo) );
	pExrInfo;

	const char* strFile = GAMERESOURCEMAN->GetModelFileName( (mPlayerInfo.Race * eGENDER_MAX) + mPlayerInfo.Gender );
	cPlayerSceneNodeParam param;
	param.mpObject = this;
	param.mPathName = strFile;
	param.mTranslate = sPos;
	param.mRotate = sRot;
	param.mScale = fScale;
	param.mCreateNameCard = mSetName;
	param.mUseShadow = false;

	mpObjectSceneNode = CreateSceneNode( &param );
	if( mpObjectSceneNode == 0 )
	{
		assert(0);
		return false;
	}

	mpObjectSceneNode->ShowNameGauge( false );

	/// head  
	ChangeBaseHair( mPlayerInfo.HeadInfo[eHEAD_HAIR] );
	SetBaseFace();

	if( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC] != 0 )
		ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC], true );
	else
		ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE], true );

	///   
	for( unsigned int ui=0; ui<eWEAR_MAX; ui++ )
	{
		if( mPlayerWearInfo.WearIdx[ui] == 0 )
		{
			if( ui != eWEAR_HAT ) 
			{
				///   ؾ ϴ 
				ChangeBaseWear( ePART_BODY1 + ui );
			}
		}
		else
		{
			///  
			EquipWearItem( mPlayerWearInfo.WearIdx[ui] );
		}
	}

	///   
	/// ʱȭ ̹Ƿ  Ѵ..
	EquipWeaponItem( &mPlayerWeaponInfo );

	SetState( eOBJECT_STATE_IDLE );

	cPlayerNameCard* card = (cPlayerNameCard*)mpObjectSceneNode->GetNameCard();
	if( card )
	{
		TCHAR buf[50];
		::_stprintf(buf, _T("Lv %d"), mPlayerInfo.Level );
		card->SetGuildName( buf );
	}

	return true;
}

bool cDisplayObject::ReCreate( sPlayerInfo* pBaseInfo, sPlayerWearInfo* pWearInfo, sPlayerWeaponInfo* pWeaponInfo, NiPoint3 sPos, NiMatrix3 sRot, float fScale )
{
	RemoveObjectSceneNode();

	for( unsigned int i = 0; i < eHAND_ALL; i++ )
	{
		mWeaponObjectIndex[i] = UINT_MAX;
	}

	::memcpy( &mPlayerInfo, pBaseInfo, sizeof(sPlayerInfo) );
	::memcpy( &mPlayerWearInfo, pWearInfo, sizeof(sPlayerWearInfo) );
	::memcpy( &mPlayerWeaponInfo, pWeaponInfo, sizeof(sPlayerWeaponInfo) );

	const char* strFile = GAMERESOURCEMAN->GetModelFileName( (mPlayerInfo.Race * eGENDER_MAX) + mPlayerInfo.Gender );
	cPlayerSceneNodeParam param;
	param.mpObject = this;
	param.mPathName = strFile;
	param.mTranslate = sPos;
	param.mRotate = sRot;
	param.mScale = fScale;
	param.mCreateNameCard = false;
	param.mUseShadow = false;

	mpObjectSceneNode = CreateSceneNode( &param );
	if( mpObjectSceneNode == 0 )
	{
		assert(0);
		return false;
	}

	/// head  
	ChangeBaseHair( mPlayerInfo.HeadInfo[eHEAD_HAIR] );
	SetBaseFace();

	if( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC] != 0 )
		ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC], true );
	else
		ChangeFaceTexture( mPlayerInfo.HeadInfo[eHEAD_FACE], true );


	///   
	for( unsigned int ui=0; ui<eWEAR_MAX; ui++ )
	{
		if( mPlayerWearInfo.WearIdx[ui] == 0 )
		{
			if( ui != eWEAR_HAT ) 
			{
				///   ؾ ϴ 
				ChangeBaseWear( ePART_BODY1 + ui );
			}
		}
		else
		{
			///  
			EquipWearItem( mPlayerWearInfo.WearIdx[ui] );
		}
	}

	///   
	/// ʱȭ ̹Ƿ  Ѵ..
	EquipWeaponItem( &mPlayerWeaponInfo );

	SetState( eOBJECT_STATE_IDLE );

	return true;
}

void cDisplayObject::Update( unsigned long deltaTime, unsigned long accumTime )
{
	FaceProcess( deltaTime );

	/// ִϸ̼ ῡ  ó
	Interpret( accumTime );
}

const NiPoint3& cDisplayObject::GetCenterPos()
{
	return mpObjectSceneNode->GetObjectCenter();
}

void cDisplayObject::UpdateDisplayForm( sPlayerInfo* pBaseInfo, sPlayerWearInfo* pWearInfo, sPlayerWeaponInfo* pWeaponInfo )
{
	assert(pBaseInfo);
	assert(pWearInfo);
	assert(pWeaponInfo);

	/// update head info
	ChangeBaseHair( pBaseInfo->HeadInfo[eHEAD_HAIR] );
	ChangeFaceTexture( pBaseInfo->HeadInfo[eHEAD_FACE], true );
	mPlayerInfo.HeadInfo[eHEAD_FACE] = pBaseInfo->HeadInfo[eHEAD_FACE];

	/// update wear info
	for( unsigned int i=0;i<eWEAR_MAX;i++)
	{
		if( pWearInfo->WearIdx[i] == 0 )
		{
			if( i != eWEAR_HAT ) 
			{
				///   ؾ ϴ 
				ChangeBaseWear( ePART_BODY1 + i );
			}
		}
		else
		{
			///  
			EquipWearItem( pWearInfo->WearIdx[i] );
		}
	}

	/// update weapon info
	EquipWeaponItem( pWeaponInfo );
}

void cDisplayObject::Rotate( float angle )
{
	if( mpObjectSceneNode == 0 )
		return;

	NiMatrix3 rot;
	rot.MakeZRotation( angle );

	rot = rot * mpObjectSceneNode->GetRotate();
	mpObjectSceneNode->SetRotate( rot );
}

void cDisplayObject::SetRot( NiMatrix3& mat )
{
	assert(mpObjectSceneNode);
	mpObjectSceneNode->SetRotate( mat );
}


void cDisplayObject::ClearEffect()
{
//	assert(mpObjectSceneNode);
//	mpObjectSceneNode->ClearEffect();
}
