#include "stdafx.h"
#include "DragWindow.h"

#include "ItemIcon.h"
#include "SkillIcon.h"

#include "UIRootNode.h"
#include "ItemManager.h"
#include "GameUIManager.h"
#include "QuickManager.h"
#include "ObjectManager.h"
#include "hero.h"
#include "ChatManager.h"
#include "GameResourceManager.h"
#include "NpcDisjointWindow.h"
#include "EnhancedWindow.h"
#include "TradeWindow.h"
#include "UserSellWindow.h"
#include "UIMsgboxEvent.h"
#include "WareHouseWindow.h"
#include "PutCardWindow.h"
#include "CardBookWindow.h"
#include "TarotSheetWindow.h"
#include "ChatWindow.h"

cDragWindow::cDragWindow( eUINodeType type )
: cUIWindow( type )
, mpCaller(0)
, mShowIcon(0)
, mIconType(eICON_NULL)
{
}

cDragWindow::~cDragWindow()
{
}

void cDragWindow::Show( cUIWindow* pCaller, eDragFrom dragFrom, cIcon* icon, unsigned int iconType, const cUIPos& pos, bool shift )
{
	assert( icon );
	assert( iconType < eICON_MAX );

	mIconFrom = icon;
	mIconType = iconType;

	mShowIcon->ChangeImage( icon->GetIconParam() );
	mShowIcon->ShowNumber( false );
	mShowIcon->Show();

	switch( mIconType )
	{
	case eICON_NORMAL:
		QUICKMAN->DragIcon( mIconFrom );
		break;
	case eICON_ITEM:
		ITEMMAN->LinkIcon( (cItemIcon*)mIconFrom );
		break;
	}

	mpCaller = pCaller;
	mShiftDown = shift;
	mDragFrom = dragFrom;

	/// 巡 ġ 
	cUIPos newPos( (int)(pos.mX - GetAbsoluteRect().GetWidth() * 0.5), (int)(pos.mY - GetAbsoluteRect().GetHeight() * 0.5) );
	SetRelativePos( newPos );
	ShowModal( eMBEVENT_NONE );
	SetCapture();
}

/// ܺο .
void cDragWindow::Hide( bool onsound )
{
	cUIWindow::Hide( onsound );
	mpCaller = 0;

	ITEMMAN->UnLinkIcon( true );
	QUICKMAN->UnDragIcon();

	mIconFrom = 0;
	mIconType = eICON_NULL;
}

void cDragWindow::Hide( cUIWindow* pCaller )
{
	/// ڱ⸦ ȣ ݷ ƴϸ 
	if( pCaller == mpCaller )
		Hide();
}	

bool cDragWindow::OnCreate( cUINodeProperty* )
{
	mShowIcon = new cIcon;
	if( mShowIcon->CreateBySkinName( "Drag_Icon", this, 1 ) == false )
		return false;

	Hide( false );
	return true;
}

void cDragWindow::OnMouseMove( const cUIPos& pos )
{
	cUIPos newPos( (int)(pos.mX - GetAbsoluteRect().GetWidth() * 0.5), (int)(pos.mY - GetAbsoluteRect().GetHeight() * 0.5) );
	SetRelativePos( newPos );
}

void cDragWindow::OnLButtonUp( const cUIPos& pos )
{
	///  
	cUIWindow::Hide();
	mpCaller = 0;

	/// ׾ִµ  巡ϸ ó
	if( HERO->GetState() == eOBJECT_STATE_DIE )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 235 ) );
	}

	bool setColor = true;
	switch( mDragFrom )
	{
	case DRAG_FROM_INVENTORY:
		if( OnDragFromInventory( pos ) == true )
			setColor = false;
		break;
	case DRAG_FROM_NPC_STORE:
		OnDragFromNpcStore( pos );
		break;
	case DRAG_FROM_QUICKSLOT:
		OnDragFromQuickSlot( pos );
		break;
	case DRAG_FROM_TRADE:
		OnDragFromTradeWindow( pos );
		break;
	case DRAG_FROM_USERSELL:
		OnDragFromUserSellWindow( pos );
		break;
	case DRAG_FROM_CHATLINK:
		OnDragFromChatWindow( pos );
		break;
	case DRAG_FROM_SKILLWINDOW:
		OnDragFromSkillWindow( pos );
		break;
	case DRAG_FROM_COMMUNITYWINDOW:
		OnDragFromCommunityWindow( pos );
		break;
	}

	ITEMMAN->UnLinkIcon( setColor );
	QUICKMAN->UnDragIcon();
}

/// κ丮 -> ܺ 
bool cDragWindow::OnDragFromInventory( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );
	if( !node )
		return false;

	if( mIconType != eICON_ITEM )
		return false;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return false;

	/// 뿡  ó 
	if( node->GetID() == eUIID_INVENTORY_GARBAGE || 
		node->GetID() == eUIID_WAREHOUSE_TRASH ||
		node->GetID() == eUIID_WAREHOUSE2_TRASH ||
		node->GetID() == eUIID_BAG0_TRASH ||
		node->GetID() == eUIID_BAG1_TRASH ||
		node->GetID() == eUIID_BAG2_TRASH )
	{
		unsigned int slotIndex0 = itemIcon->GetSlotIndex();
		eItemIn in = ITEMMAN->GetItemIn( slotIndex0 );

		/// â ִ°  .
		if( in != ITEM_IN_EQUIP )
			GAMEUI->ShowItemDumpAskWindow( itemIcon->GetSlotIndex() );
		return false;
	}

	///  κ  
	unsigned int slotIndex0 = itemIcon->GetSlotIndex();
	eItemIn in = ITEMMAN->GetItemIn( slotIndex0 );
	assert( in != ITEM_IN_NULL );

	/// npc   üũ 
	cUIWindow* store = (cUIWindow*)GAMEUI->GetNpcStore();
	if( store && (node == (cUIContainer*)store || node->GetParent() == (cUIContainer*)store) )
	{
		if( in != ITEM_IN_INVEN_PRIVATE )
			return false;

		DragToNpcStore();
		return false;
	}

	/// Ǹų üũ
	cUserSellWindow* userSell = GAMEUI->GetUserSellWindow();
	if( userSell && (node == (cUIContainer*)userSell || node->GetParent() == (cUIContainer*)userSell) )
	{
		if( in != ITEM_IN_INVEN_PRIVATE )
			return false;

		if( userSell->GetStatus() == eUSERSELL_JOIN )
			return false;

		if( userSell->IsNetLock() == true )
			return false;

		if( userSell->IsOpen() == false )
		{
			CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 2509 ) );
		}
		else
		{
			GAMEUI->ShowMoneyWindow( eMONEY_NONE, eMBEVENT_USERSELL_ITEMMONEYADD, slotIndex0 );
		}
		return false;
	}

	/// ä üũ
	cChatWindow* chatWin = GAMEUI->GetChatWindow();
	if( chatWin && (node == (cUIContainer*)chatWin || node->GetParent() == (cUIContainer*)chatWin) )
	{
		if( in != ITEM_IN_INVEN_PRIVATE )
			return false;

		return chatWin->AddLinkItem( slotIndex0 );
	}

	/// ŷ üũ
	cTradeWindow* trade = GAMEUI->GetTradeWindow();
	if( trade && (node == (cUIContainer*)trade || node->GetParent() == (cUIContainer*)trade) )
	{
		if( in != ITEM_IN_INVEN_PRIVATE )
			return false;

		if( trade->IsNetLock() == true )
			return false;

		ITEMMAN->TryToTradeItemAdd( slotIndex0 );
		return false;
	}

	/// ī÷Ǻ üũ
	cCardBookWindow* cardBook = GAMEUI->GetCardBookWindow();
	if( cardBook && (node == (cUIContainer*)cardBook || node->GetParent() == (cUIContainer*)cardBook) )
	{
		if( in != ITEM_IN_INVEN_PRIVATE )
			return false;

		///  ˻
		/*if( cardBook->IsNetLock() == true )
		return false;*/

		cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
		cItemDefine* define = ITEMMAN->GetItemDefine( item0.GetIndex() );
		if( !define )
			return false;

		unsigned char type = define->GetType();
		unsigned char subtype = define->GetSubType();

		///  ÷Ǻ  ˻
		switch( cardBook->GetCurrentPage() )
		{
		case ePAGE_DATA:
			break;
		case ePAGE_TAROT:	/// Ÿ 
			if( type == ITEM_CARD && subtype == ITEM_CARD_TAROT )
			{
				/// Ÿ īΰ,
				cItemTarot* tarot = define->GetTarotDefine();
				if( !tarot )
					return false;
				
				cTarotSheetWindow* sheet = cardBook->GetTarotSheet();
				if( !sheet )
					return false;

				unsigned long registItemIdx = sheet->IsRegistItem( tarot->GetUniqueNumber() );
				unsigned int bookslotIndex = sheet->GetSlotIndex( tarot->GetUniqueNumber() );
				if( !(registItemIdx == ULONG_MAX || bookslotIndex == ULONG_MAX) )
				{
					eMSGBox_Event event = (registItemIdx == 0)? eMBEVENT_ITEM_CARDBOOK_TAROTNEW : eMBEVENT_ITEM_CARDBOOK_TAROTUPDATE;
					GAMEUI->ShowItemCardBook( event, slotIndex0, bookslotIndex, registItemIdx );
				}
			}
			else if( type == ITEM_SPREAD )
			{
				/// ΰ,
				cTarotSheetWindow* sheet = cardBook->GetTarotSheet();
				if( !sheet )
					return false;

				/// 
				unsigned int emptyItemSlot = sheet->GetEmptySlotIndex();
				unsigned long registItemIdx = sheet->IsRegistItem( emptyItemSlot - INVENTORY_TAROT_BEGIN );
				if( !(registItemIdx == ULONG_MAX ) )
				{
					eMSGBox_Event event = (registItemIdx == 0)? eMBEVENT_ITEM_CARDBOOK_SPREADNEW : eMBEVENT_ITEM_CARDBOOK_SPREADUPDATE;
					GAMEUI->ShowItemCardBook( event, slotIndex0, emptyItemSlot, registItemIdx );
				}
			}
			break;
		case ePAGE_MONSTER:
			break;
		case ePAGE_STORY:
			break;
		default:
			assert(0);
			break;
		}

		return false;
	}

	///  üũ
	if( node->IsKindof(eUINODE_ICON) )
	{
		cIcon* icon = (cIcon*)node;
		
		///  ó
		cUIContainer* con = node->GetParent();
		if( con && (con->GetID() == eUIID_ROW_QUICKSLOT || con->GetID() == eUIID_COLUMN_QUICKSLOT ||
			        con->GetID() == eUIID_ROW_QUICKSLOT_FS || con->GetID() == eUIID_COLUMN_QUICKSLOT_FS ) )
		{
			if( in != ITEM_IN_INVEN_PRIVATE )
				return false;

			if( DragToQuickSlot( DRAG_FROM_INVENTORY, icon ) == false )
				return false;
		}

		///  ó
		if( icon->GetIconType() == eICON_ITEM )
		{
			if( DragToItemSlot( icon ) == true )
				return true;
		}
	}
	return false;
}

/// ųâ -> ܺ
void cDragWindow::OnDragFromSkillWindow( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );

	if( node && node->IsKindof(eUINODE_ICON) )
	{
		cIcon* icon = (cIcon*)node;
		if( icon->GetIconType() == eICON_NORMAL )
		{
			///  ó
			DragToQuickSlot( DRAG_FROM_SKILLWINDOW, icon );
		}
	}
}

void cDragWindow::OnDragFromCommunityWindow( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );

	if( node && node->IsKindof(eUINODE_ICON) )
	{
		cIcon* icon = (cIcon*)node;
		if( icon->GetIconType() == eICON_NORMAL )
		{
			///  ó
			DragToQuickSlot( DRAG_FROM_COMMUNITYWINDOW, icon );
		}
	}
}

///  npc  -> inven 
void cDragWindow::OnDragFromNpcStore( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );

	if( mIconType != eICON_ITEM )
		return;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return;

	if( node && node->IsKindof(eUINODE_ICON) )
	{
		cItemIcon* icon = (cItemIcon*)node;

		unsigned int slotIndex = icon->GetSlotIndex();
		eItemIn in = ITEMMAN->GetItemIn( slotIndex );

		/// Npc  -> κ 
		if( in == ITEM_IN_INVEN_PRIVATE )
		{
			unsigned int itemIndex = itemIcon->GetItemIndex();
			assert( itemIndex );

			cItemDefine* itemDefine = ITEMMAN->GetItemDefine( itemIndex );
			assert( itemDefine );

			/// 1  ־ ԰
			if( ITEMMAN->CheckBuyItem( itemIndex, 1 ) == false )
				return;

			if( itemDefine->GetCapacity() == 1 )
			{
				GAMEUI->ShowItemBuyAskWindow( itemIndex, 1 );
			}
			else
			{
				GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_BUY, itemIndex );
			}
		}
	}
}

///
void cDragWindow::OnDragFromQuickSlot( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );

	if( !node )
		return;

	if( node->IsKindof(eUINODE_ICON) )
	{
		cIcon* icon = (cIcon*)node;
		if( icon->GetIconType() == eICON_NORMAL )
		{
			///  ó
			DragToQuickSlot( DRAG_FROM_QUICKSLOT, icon );
		}
	}
	else
	{
		QUICKMAN->DeleteData();
	}
}

void cDragWindow::OnDragFromTradeWindow( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );
	if( !node )
		return;

	if( mIconType != eICON_ITEM )
		return;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return;

	cTradeWindow* trade = (cTradeWindow*)GAMEUI->GetTradeWindow();
	if( trade )
	{
		if( trade->IsNetLock() == true )
			return;

		if( trade->GetStatus() != ItemExchangeBegin )
			return;

		cUIRect tradeRect = trade->GetAbsoluteRect();
		
		/// Ʈ̵   üũ
		if( tradeRect.ContainPoint( pos ) == true )
			return;
		
		///    
		int slot = trade->GetInvenSlot( itemIcon->GetID() );

		/// κ ԰, Ʈ̵   ִ´
		if( slot > -1 && ITEMMAN->TryToTradeItemDelete( slot, itemIcon->GetID() ) == false )
			return;
	}
}

void cDragWindow::OnDragFromChatWindow( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );
	if( !node )
		return;

	if( mIconType != eICON_ITEM )
		return;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return;

	cChatWindow* chatWin = (cChatWindow*)GAMEUI->GetChatWindow();
	if( chatWin )
	{
		cUIRect rect = chatWin->GetAbsoluteRect();

		/// ä   üũ
		if( rect.ContainPoint( pos ) == false )
		{
			///  
			chatWin->DeleteLinkItem();
		}
	}
}

void cDragWindow::OnDragFromUserSellWindow( const cUIPos& pos )
{
	cUINode* node = GetRoot()->GetNode( pos );
	if( !node )
		return;

	cUserSellWindow* userSell = (cUserSellWindow*)GAMEUI->GetUserSellWindow();
	if( !userSell )
		return;

	if( userSell->IsNetLock() == true )
		return;

	if( mIconType != eICON_ITEM )
		return;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return;

	/// Ǹ 
	if( userSell->GetStatus() == eUSERSELL_SELL )
	{
		cUIRect sellRect = userSell->GetAbsoluteRect();

		/// Ǹų ̸ 
		if( sellRect.ContainPoint( pos ) == true )
			return;

		///   
		int slot = userSell->GetSelectInvenSlot();

		/// κ ԰, Ǹų   
		if( slot > -1 && ITEMMAN->TryToUserSellDelete( slot ) == false )
			return;
	}
	/// Ż
	else if( userSell->GetStatus() == eUSERSELL_JOIN )
	{
		cUINode* node = GetRoot()->GetNode( pos );

		if( node && node->IsKindof( eUINODE_ICON ) )
		{
			cItemIcon* icon = (cItemIcon*)node;
			eItemIn in = ITEMMAN->GetItemIn( icon->GetSlotIndex() );

			/// â -> κ 
			if( in == ITEM_IN_INVEN_PRIVATE )
			{
				sUserSellData* data = userSell->GetSelectJoinData();
				sInventory* inv = &data->mThatInven;

				cItemDefine* itemDefine = ITEMMAN->GetItemDefine( inv->ItemIndex );

				if( itemDefine->GetCapacity() > 1 )
					GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_USERSELLBUY, inv->number, inv->ItemIndex, inv->count );
				else
					GAMEUI->ShowItemUserSellBuyAskWindow( inv->number, inv->ItemIndex, 1, data->mPrice );
			}	
		}
	}
}

///  巡
bool cDragWindow::DragToQuickSlot( eDragFrom dragFrom, cIcon* icon )
{
	cUIContainer* parent = icon->GetParent();
	unsigned int parentID = parent->GetID();

	///  Ȯΰ˻
	if( parentID != eUIID_COLUMN_QUICKSLOT && parentID != eUIID_ROW_QUICKSLOT &&
		parentID != eUIID_COLUMN_QUICKSLOT_FS && parentID != eUIID_ROW_QUICKSLOT_FS )
		return false;

	if( mIconFrom == 0 )
		return false;

	///  ġ  fs  Ǻ
	bool toIsFS = ( parentID == eUIID_COLUMN_QUICKSLOT || parentID == eUIID_ROW_QUICKSLOT ) ? false : true;
	
	///  Ż϶,  ų Կ  Ұ!! 
	if( toIsFS && HERO->IsTransformMonster() && icon->GetID() < QUICK_COUNT_MON )
		return false;

	/// Կ 
	if( dragFrom == DRAG_FROM_QUICKSLOT )
	{
		QUICKMAN->MoveData( icon->GetID(), mShowIcon, toIsFS );
	}
	else
	{
		QUICKMAN->AddData( icon->GetID(), mIconFrom, toIsFS );
	}
	return false;
}

///   κ ƴ  ̺Ʈ  巡ҽÿ ó.
///  ƴѺκе ̺Ʈ ߻ ϵ 
void cDragWindow::DragToNpcStore()
{
	if( mIconType != eICON_ITEM )
		return;

	cItemIcon* itemIcon = (cItemIcon*)mIconFrom;
	if( itemIcon == 0 )
		return;

	unsigned int slotIndex0 = itemIcon->GetSlotIndex();
	eItemIn in = ITEMMAN->GetItemIn( slotIndex0 );

	///  Ȳ Ͼ, ũ  ·  
	if( mShiftDown == false )
	{
		/// κ  -> Npc 
		if( in == ITEM_IN_INVEN_PRIVATE )
		{
			const cItem& item = ITEMMAN->GetItem( slotIndex0 );

			if( item.GetCount() == 0 )
				return;

			if( item.GetCount() == 1 )
			{
				GAMEUI->ShowItemSellAskWindow( slotIndex0, 1 );
			}
			else
			{
				GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_SELL, slotIndex0 );
			}
		}
	}
}

/// κ丮 -> NPC, κ丮, â,...
///    ؾϴ°  ( ݵ ش ġ  üũϴ° )
bool cDragWindow::DragToItemSlot( cIcon* icon )
{
	if( mIconType != eICON_ITEM )
		return false;

	cItemIcon* itemIconFrom = (cItemIcon*)mIconFrom;
	if( itemIconFrom == 0 )
		return false;

	cItemIcon* itemIcon = (cItemIcon*)icon;
	unsigned int slotIndex0 = itemIconFrom->GetSlotIndex();
	unsigned int slotIndex1 = itemIcon->GetSlotIndex();

	if( slotIndex0 == slotIndex1 )
		return false;

	eItemIn in = ITEMMAN->GetItemIn( slotIndex0 );
	eItemIn out = ITEMMAN->GetItemIn( slotIndex1 );

	if( in == ITEM_IN_NULL )
		return false;
	if( out == ITEM_IN_NULL )
		return false;

	cItem& item = ITEMMAN->GetItem( slotIndex0 );

	if( mShiftDown == false )
	{
		/// κ  -> Npc 
		if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_NPCSTORE )
		{
			if( item.GetCount() == 0 )
				return false;

			if( item.GetCount() == 1 )
				GAMEUI->ShowItemSellAskWindow( slotIndex0, 1 );
			else
				GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_SELL, slotIndex0 );
			return false;
		}
	}
	else
	{
		/// κ  -> κ 
		/// κ  <-> â 
		if( (in == ITEM_IN_INVEN_PRIVATE && in == out) ||
			(in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_WAREHOUSE_PRIVATE) ||
			(in == ITEM_IN_WAREHOUSE_PRIVATE && out == ITEM_IN_INVEN_PRIVATE) )
		{
			GAMEUI->ShowItemCountWindow( eMBEVENT_ITEMCOUNT_SPLIT, slotIndex0, slotIndex1 );
			return false;
		}
	}
	
	/// κ  ->  
	if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_DISJOINT )
	{
		///    
		cNpcDisjointWindow* disjoint = GAMEUI->GetNpcDisjointWindow();
		if( disjoint && disjoint->AddItem( slotIndex0 ) == false )
			return false;
	}
	/// κ  -> ȭ  
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_ENHANCED_ITEM )
	{
		/// ȭ  
		cEnhancedWindow* enhanced = GAMEUI->GetEnhancedWindow();
		if( enhanced && enhanced->AddItem( slotIndex0 ) == false )
			return false;
	}
	/// κ  -> ȭ ī 
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_ENHANCED_CARD )
	{
		/// ȭ ī 
		cEnhancedWindow* enhanced = GAMEUI->GetEnhancedWindow();
		if( enhanced && enhanced->AddCard( slotIndex0 ) == false )
			return false;
	}
	/// κ  -> ī  [] 
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_PUTCARD_ITEMSLOT )
	{
		///  
		cPutCardWindow* putcard = GAMEUI->GetPutCardWindow();
		if( putcard && putcard->AddItem( slotIndex0 ) == false )
			return false;
	}
	/// κ  -> ī  [ī] 
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_PUTCARD_CARDSLOT )
	{
		cPutCardWindow* putcard = GAMEUI->GetPutCardWindow();
		if( putcard && putcard->TestAddCard( slotIndex0, slotIndex1 ) == false )
			return false;
	}
	/// κ  -> ÷Ǻ [Ÿī]
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_CARDBOOK_TAROT )
	{
		cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
		cItemDefine* define = ITEMMAN->GetItemDefine( item0.GetIndex() );
		if( !define )
			return false;

		if( !(define->GetType() == ITEM_CARD && define->GetSubType() == ITEM_CARD_TAROT) )
			return false;
		
		/// Ÿ īΰ,
		cItemTarot* tarot = define->GetTarotDefine();
		if( !tarot )
			return false;

		cCardBookWindow* cardBook = (cCardBookWindow*)GAMEUI->GetCardBookWindow();
		cTarotSheetWindow* sheet = cardBook->GetTarotSheet();
		if( sheet )
		{
			unsigned long registItemIdx = sheet->IsRegistItem( tarot->GetUniqueNumber() );
			unsigned int bookslotIndex = sheet->GetSlotIndex( tarot->GetUniqueNumber() );
			if( !(registItemIdx == ULONG_MAX || bookslotIndex == ULONG_MAX) )
			{
				eMSGBox_Event event = (registItemIdx == 0)? eMBEVENT_ITEM_CARDBOOK_TAROTNEW : eMBEVENT_ITEM_CARDBOOK_TAROTUPDATE;
				GAMEUI->ShowItemCardBook( event, slotIndex0, bookslotIndex, registItemIdx );
			}
		}
		return false;
	}
	/// κ  -> ÷Ǻ []
	else if( in == ITEM_IN_INVEN_PRIVATE && out == ITEM_IN_CARDBOOK_SPREAD )
	{
		cItem& item0 = ITEMMAN->GetItem( slotIndex0 );
		cItemDefine* define = ITEMMAN->GetItemDefine( item0.GetIndex() );
		if( !define )
			return false;

		if( define->GetType() != ITEM_SPREAD )
			return false;

		/// ΰ,
		cCardBookWindow* cardBook = (cCardBookWindow*)GAMEUI->GetCardBookWindow();
		cTarotSheetWindow* sheet = cardBook->GetTarotSheet();
		if( sheet )
		{
			unsigned long registItemIdx = sheet->IsRegistItem( slotIndex1 - INVENTORY_TAROT_BEGIN );	
			if( !(registItemIdx == ULONG_MAX ) )
			{
				eMSGBox_Event event = (registItemIdx == 0)? eMBEVENT_ITEM_CARDBOOK_SPREADNEW : eMBEVENT_ITEM_CARDBOOK_SPREADUPDATE;
				GAMEUI->ShowItemCardBook( event, slotIndex0, slotIndex1, registItemIdx );
			}
		}	
		return false;
	}
	else if( out == ITEM_IN_NPCSTORE || out == ITEM_IN_DISJOINT ||
			out == ITEM_IN_ENHANCED_ITEM || out == ITEM_IN_ENHANCED_CARD ||
			out == ITEM_IN_PUTCARD_ITEMSLOT || out == ITEM_IN_CARDBOOK_SPREAD ||
			out == ITEM_IN_CARDBOOK_TAROT )
	{
		///  ߸Ǿ 
		return false;
	}
	else
	{
		///   ɸ ̸ 
		cItem& item1 = ITEMMAN->GetItem( slotIndex1 );
		if( item1.GetIndex() > 0 && item1.IsLock() == true )
			return false;

		if( ITEMMAN->TryToMoveItem( slotIndex0, slotIndex1, itemIconFrom ) == false )
			return false;
	}
	return true;
}
