/* ==========================================================================
*    : ̼
*    : 2007.07.11
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

#include "UIWindow.h"

/// 巡 ó
enum eDragFrom
{
	DRAG_FROM_INVENTORY,
	DRAG_FROM_NPC_STORE,
	DRAG_FROM_QUICKSLOT,
	DRAG_FROM_TRADE,
	DRAG_FROM_USERSELL,
	DRAG_FROM_CHATLINK,

	DRAG_FROM_SKILLWINDOW,
	DRAG_FROM_COMMUNITYWINDOW,
};

/// 巡 
class cDragWindow : public cUIWindow
{
public:
	cDragWindow( eUINodeType type = eUINODE_DRAGWINDOW );
	~cDragWindow();

	void Show( cUIWindow* pCaller, eDragFrom dragFrom, cIcon* icon, unsigned int iconType, const cUIPos& pos, bool shift );
	void Hide( bool onsound = true );
	void Hide( cUIWindow* pCaller );

protected:
	bool OnCreate( cUINodeProperty* prop );
	void OnMouseMove( const cUIPos& pos );
	void OnLButtonUp( const cUIPos& pos );
	bool OnDragFromInventory( const cUIPos& pos );
	void OnDragFromNpcStore( const cUIPos& pos );
	void OnDragFromQuickSlot( const cUIPos& pos );
	void OnDragFromSkillWindow( const cUIPos& pos );
	void OnDragFromCommunityWindow( const cUIPos& pos );
	void OnDragFromTradeWindow( const cUIPos& pos ); 
	void OnDragFromUserSellWindow( const cUIPos& pos ); 
	void OnDragFromChatWindow( const cUIPos& pos ); 

	/// 巡 Ȳ
	bool DragToQuickSlot( eDragFrom dragFrom, cIcon* icon );
	bool DragToItemSlot( cIcon* icon );
	void DragToNpcStore();

protected:
	/// Ʈ 
	bool mShiftDown;

	/// 巡 ó
	eDragFrom mDragFrom;

	/// 巡  ݷ 
	cUIWindow* mpCaller;

	unsigned int mIconType;
	cIcon* mIconFrom;

	cIcon* mShowIcon;
};
