/* =====================================================================
*      :	DramaturgyInfo.h , DramaturgyInfo.cpp
*      :	 Ŭ
*    :	
*    :    2006 10 16
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ :	.
* =======================================================================*/
#pragma once

class cParser;

enum eDRAMA_TYPE
{
	eDRAMA_SKILL = 0,		/// ų
	eDRAMA_INFULUENCE,		/// ȿ()
};

enum eDRAMAOBJ_KIND
{
	eDRAMAOBJ_EFFECT = 0,	/// Ʈ ü(nif)
	eDRAMAOBJ_SOUND,		///  ü
	eDRAMAOBJ_TRAILTEX,		///  ؽ
};

enum eDRAMAACTION
{
	eDRAMA_ACTION = 0,
	eDRAMA_ACTIVE,
	eDRAMA_DAMAGE,

	eDRAMA_BULLET,

	eDRAMA_TRAIL,
	eDRAMA_SHAKE,
	eDRAMA_FADEOUT,
};

enum eDRAMASTATE
{
	eDRAMASTATE_NONE = 0,
	eDRAMASTATE_CASTING,	/// ĳ
	eDRAMASTATE_ACTIVITY,	/// ߵ
	eDRAMASTATE_APPLY,		///  ( ¿ ߵ +  ó Ѵ.)

	eDRAMASTATE_MAX,

	eDRAMASTATE_CANCEL_WAIT,
};

struct sDramaObj
{
	eDRAMAOBJ_KIND	kind;
	cString			file;

	/// effect  
	NiMatrix3		rot;
	float			scale;

	/// sound  
	unsigned long	soundListIndex;

	sDramaObj()
	{
		rot = NiMatrix3::IDENTITY;
		scale = 1.0f;
	}
};

struct sDramaActionBase
{
	eDRAMAACTION	actionType;	
	unsigned long	time;

	sDramaActionBase*	pNext;

	sDramaActionBase() : pNext(0) 
	{
	}
};

struct sDramaAction : public sDramaActionBase
{
	unsigned long	lifeTime;

	bool			bLoop;
	bool			bFollow;

	unsigned short	objIdx;

	unsigned int	linkPos;
	NiPoint3		var;

	unsigned char	weaponType;

	sDramaAction()
	{
		var = NiPoint3::ZERO;
		weaponType = 0;
	}
};

struct sDamageAction : public sDramaActionBase
{
	float			percent;
};

struct sCrashInfo
{
	unsigned short	crashEffectIdx;
	unsigned int	crashLinkPos;
	NiPoint3		crashVar;
};

struct sBulletAction : public sDramaActionBase
{
	unsigned short	bulletID;

	float			speed;

	unsigned short	bulletEffectIdx;
	unsigned int	linkPos;
	unsigned int	targetLinkPos;
	NiPoint3		bulletVar;

	bool			existCrash;

	unsigned int	crashCount;
	sCrashInfo		crashInfo[5];

	sBulletAction() : existCrash(false)
	{
		crashCount = 0;
	}
};

struct sTrailAction : public sDramaActionBase
{
	unsigned long	lifeTime;

	unsigned short	texIdx;

	unsigned int	linkStart;
	unsigned int	linkEnd;

	float			lengthPer;
	float			speedFactor;

	sTrailAction() 
	{
		speedFactor = 1.0f;
		lengthPer = 100;
	}
};


///   
class  cDramaState
{
public:
	cDramaState()
	{
		mAnimationIdx = UINT_MAX;

		mActionCount = 0;
		mpBegin = mpEnd = 0;
	}
	~cDramaState()
	{
		sDramaActionBase* pAction = mpBegin;
		sDramaActionBase* pNext;
		for( unsigned int i=0;i<mActionCount;++i )
		{
			pNext = pAction->pNext;
			delete pAction;

			pAction = pNext;
		}
		mActionCount = 0;
	}

	void Push( sDramaActionBase* p )
	{
		p->pNext = 0;
		if( mpBegin == 0 )
		{
			mpBegin = mpEnd = p;
		}
		else
		{
			/// 
			if( mpBegin->time > p->time )
			{
				p->pNext = mpBegin;
				mpBegin = p;
			}
			else
			{
				sDramaActionBase* cur = mpBegin;
				sDramaActionBase* next = cur->pNext;
				for( unsigned int i = 0;i<mActionCount;i++ )
				{
					if( cur->time <= p->time )
					{
						if( next == 0 )
						{
							cur->pNext = mpEnd = p;
							break;
						}

						if( next->time >= p->time )
						{
							cur->pNext = p;
							p->pNext = next;
							break;
						}
					}
					else
					{
						assert(0);
					}

					cur = cur->pNext;
					next = cur->pNext;
				}
			}
		}

		mActionCount++;
	}
/*
	void PushFront( sDramaActionBase* p )
	{
		p->pNext = 0;
		if( mpBegin == 0 )
		{
			mpBegin = mpEnd = p;
		}
		else
		{
			p->pNext = mpBegin;
			mpBegin = p;
		}
		mActionCount++;
	}

	void PushBack( sDramaActionBase* p )
	{
		p->pNext = 0;
		if( mpBegin == 0 )
		{
			mpBegin = mpEnd = p;
		}
		else
		{
			mpEnd->pNext = p;
			mpEnd = p;
		}
		mActionCount++;
	}
*/
	sDramaActionBase*		GetStart() { return mpBegin; }

	unsigned int		mAnimationIdx;

protected:
	unsigned int		mActionCount;
	sDramaActionBase*	mpBegin;
	sDramaActionBase*	mpEnd;
};


/// skill  ȿ x:1Ī
class cDramaturgyInfo
{
public:
	cDramaturgyInfo( const char* pName );
	~cDramaturgyInfo();

	/// dramaobj  ʿ!!
	void LoadDramaObj();
	void LoadThreadDramaObj();

	bool LoadFile();

	sDramaActionBase*	GetStartAction( eDRAMASTATE state );
	unsigned int		GetAnimation( eDRAMASTATE state );
	sDramaObj*			GetDramaObj( unsigned short idx );
protected:
	/// list  ε
	bool LoadHeader( cParser& parser );
	bool LoadContents( eDRAMASTATE state, cParser& parser );

	unsigned int	GetLinkIndex( cString str );

protected:
	cString			mFileName;

	///   
	eDRAMA_TYPE		mType;

	///  ü 
	typedef tPointerHashMap<unsigned short,void*> cDramaObjMap;
	cDramaObjMap	mDramaObjMap;

	/// ߻ü   
	typedef cDramaObjMap cBulletMap;
	cBulletMap		mBulletMap;

	/// ĳ, ߵ,   
	cDramaState* mpDramaState[eDRAMASTATE_MAX];
};

