#include "StdAfx.h"
#include "DropItemSceneNode.h"
#include "NifAnimationInfo.h"

#include "NaviMesh.h"
#include "EffectSceneNode.h"

#include "SceneManager.h"
#include "ObjectManager.h"
#include "Hero.h"

cDropItemSceneNode::cDropItemSceneNode(eType type)
: cManagedStaticSceneNode(type)
, mDropIndex(UINT_MAX)
{
	memset( mOwner, 0, sizeof(0)*MAX_OWNER );
	mTimeToOwn = 0;

	mOwnerEffect = 0;
	mEffectIdxByManager = (unsigned long)-1;
}

cDropItemSceneNode::~cDropItemSceneNode()
{
	ClearEffect();
}

void cDropItemSceneNode::ClearEffect()
{
	if( mEffectIdxByManager != (unsigned long)-1 )
	{
		cEffectSceneNode* node = SCENEMAN->GetEffectSceneNode( mEffectIdxByManager );
		if( node )
		{
			assert( node == mOwnerEffect );
			node->Remove();
		}
		mOwnerEffect = 0;
		mEffectIdxByManager = (unsigned long)-1;
	}
}

void cDropItemSceneNode::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	if( mOwnerEffect )
	{
		if( SCENEMAN->IsValidEffectNode( mEffectIdxByManager, mOwnerEffect ) == false )
		{
			assert(0);
			GameErrorLog( "cDropItemSceneNode::OnProcess[%d,%d]", mDropIndex, mEffectIdxByManager );
		}
	}

	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdateTransform = true;
		mNifAniInfo->Update( deltaTime, accumTime );
	}

	cManagedStaticSceneNode::OnProcess( deltaTime, accumTime );

	if( mOwnerEffect == 0 )
	{
		if( mTimeToOwn <= deltaTime )
		{
			mTimeToOwn = 0;
			NiTransform trans;
			trans.MakeIdentity();
			trans.m_Translate = GetWorldTranslate();

			mOwnerEffect = SCENEMAN->CreateSelfEffect( "./Data/Effect/DropBox02.nif", true, trans, true );
			if( mOwnerEffect )
				mEffectIdxByManager = mOwnerEffect->GetIndexByManger();
		}
		else
		{
			mTimeToOwn -= deltaTime;
		}
	}

	if( mAlpha < 0.000001f )
		mCheckFrustum = false;
	else
		mCheckFrustum = true;
}

bool cDropItemSceneNode::Init( const cDropItemSceneNodeParam& param )
{
	if( param.mDropIndex == UINT_MAX )
	{
		assert(0);
		return false;
	}

	///   ޴´.
	mDropIndex = param.mDropIndex;
	mDropStartPos = param.mDropStartPos;
	mDropEndPos = param.mDropEndPos;

	bool createEff = false;

	mTimeToOwn = param.mTimeToOwn;
	if( mTimeToOwn == 0 )
		createEff = true;

	unsigned long heroId = HERO->GetObjectID();
	for( unsigned int i=0; i<MAX_OWNER; i++ )
	{
		mOwner[i] = param.mOwner[i];

		if( heroId == mOwner[i])
			createEff = true;
	}

	param.mTranslate.x = mDropEndPos.x;
	param.mTranslate.y = mDropEndPos.y;

	NAVIMESH->CalcHeight( &param.mTranslate.z, param.mTranslate.x, param.mTranslate.y );

	if( cManagedStaticSceneNode::Init( param ) == false )
	{
		return false;
	}

	if( createEff )
	{
		NiTransform trans;
		trans.MakeIdentity();
		trans.m_Translate = GetWorldTranslate();

		mOwnerEffect = SCENEMAN->CreateSelfEffect( "./Data/Effect/DropBox02.nif", true, trans, true );
		if( mOwnerEffect )
			mEffectIdxByManager = mOwnerEffect->GetIndexByManger();
	}
	return true;
}

bool cDropItemSceneNode::IsHeroOwner()
{
	return (mEffectIdxByManager != (unsigned long)-1);
}
