#pragma once
#include "staticscenenode.h"
#include "Item_Common.h"

class cDropItemSceneNodeParam : public cStaticSceneNodeParam
{
public:
	cDropItemSceneNodeParam();

public:
	/// Drop ǥ
	NiPoint2		mDropStartPos;
	NiPoint2		mDropEndPos;

	///   ε
	unsigned long	mDropIndex;

	/// 
	unsigned long	mOwner[ MAX_OWNER ];
	unsigned long	mTimeToOwn;
};

inline cDropItemSceneNodeParam::cDropItemSceneNodeParam()
: mDropIndex(UINT_MAX)
, mDropStartPos(0.0f, 0.0f)
, mDropEndPos(0.0f, 0.0f)
{
}


class cEffectSceneNode;

class cDropItemSceneNode : public cManagedStaticSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	//virtual void OnProcess( unsigned long time );

	inline unsigned long GetDropIndex() { return mDropIndex; }

	bool IsHeroOwner();

	void ClearEffect();

protected:
	cDropItemSceneNode( eType type = eDROPITEM );
	virtual ~cDropItemSceneNode();

	/// ʱȭ
	virtual bool Init( const cDropItemSceneNodeParam& param );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );

protected:
	///   ڿ ε
	unsigned long mDropIndex;

	/// Drop  ġ( ġ, ÷̾ ġ)
	NiPoint2	mDropStartPos;
	NiPoint2	mDropEndPos;

	unsigned long mOwner[MAX_OWNER];
	unsigned long mTimeToOwn;


	unsigned long		mEffectIdxByManager;
	cEffectSceneNode*	mOwnerEffect;
};