#include "StdAfx.h"
#include ".\duelbuff.h"

#include "GameUIManager.h"

#include "Skill_Common.h"
#include "SkillScript.h"
#include "icon.h"


cDuelBuff::cDuelBuff()
{
	mLeftAlign = true;
}

cDuelBuff::~cDuelBuff()
{
}

void cDuelBuff::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;

	unsigned int count = 0;
	cBuffIconList::cIterator i = (--mIconList.End());
	cBuffIconList::cIterator iend = (--mIconList.Begin());
	for( ; i != iend; --i )
	{
		sBuffIcon* p = (sBuffIcon*)(*i);
		if( p == 0 )
			continue;

		if( count == mRow*mColumn )
			continue;

		///  缳
		if( mUpdateList )
		{
			unsigned int sx = mStartX;
			unsigned int sy = mStartY;
			if( mpParent )
			{
				cUIRect parentAbsolute = mpParent->GetAbsoluteRect();
				sx += parentAbsolute.mLeft;
				sy += parentAbsolute.mTop;
			}

			unsigned int x = 0;
			unsigned int y = 0;
			if( mLeftAlign )
				x = sx + ((count%mColumn) * (mIconSize+mColumnSpace));
			else
				x = sx + ((mColumn-(count%mColumn)-1) * (mIconSize+mColumnSpace));

			y = sy + ((count/mColumn) * (mIconSize+mRowSpace));

			p->mImage.SetScreenRect( cUIRect(x, y, x+mIconSize, y+mIconSize) );
			p->mTextX = x;
			p->mTextY = y+mIconSize + 1;
		}

		if( mChangeOverIcon && mOverInfo.mOverIconIdx == count )
		{
			EventOverIcon( p, mOverInfo.mPos );
			mChangeOverIcon = false;
		}

		if( mRButtonClickIconIdx == count )
		{
			mRButtonClickIconIdx = (unsigned int)-1;

			if( p->mAuraType == false && p->mIsBuff )
			{
				MSG_REQ_INFLUENCE_DELETE Msg;
				Msg.Category = NM_SKILL;
				Msg.Protocol = NM_SKILL_INFLUENCE_DELETE_REQ;
				Msg.mUniqueIdx = p->mUniqueIdx;
				NETWORK->SendNetworkMsg( (char*)&Msg, sizeof( Msg ) );

				/// 
				NetLock();
			}
		}

		count++;
	}
}

void cDuelBuff::OnRender( cUIFontItemKeeper* /*pKeeper*/ )
{
	if( mUpdateList )
	{
		/// window 
		cUIRect r;
		r.mRight = mStartX + mColumn*(mIconSize+mColumnSpace) - mColumnSpace;
		r.mTop = mStartY;

		if( mLeftAlign )
		{
			r.mLeft = mStartX;
		}
		else
		{
			if( mIconList.GetSize() < mColumn )
				r.mLeft = mStartX + (mColumn - mIconList.GetSize())*(mIconSize+mColumnSpace);
			else
				r.mLeft = mStartX;
		}

		unsigned int row = min((mIconList.GetSize()-1)/mColumn + 1, mRow);
		r.mBottom = mStartY + row * (mIconSize+mRowSpace) - mRowSpace;

		SetRelativeRect( r );
	}

	unsigned int count = 0;
	cBuffIconList::cIterator i = (--mIconList.End());
	cBuffIconList::cIterator iend = (--mIconList.Begin());
	for( ; i != iend; --i )
	{
		if( count == mRow*mColumn )
			break;

		sBuffIcon* p = (sBuffIcon*)(*i);

		if( p->mShow )
			p->mImage.Draw();

		count++;
	}
}


void cDuelBuff::OnMouseMove( const cUIPos& pos )
{
	/// 1  üũ
	if( mOverCheck == false )
		return;
	mOverCheck = false;

	unsigned int x = mStartX;
	unsigned int y = mStartY;
	if( mpParent )
	{
		x += mpParent->GetAbsoluteRect().mLeft;
		y += mpParent->GetAbsoluteRect().mTop;
	}

	unsigned int col;
	for( col=0; col<mColumn; col++ )
	{
		unsigned int s = x + col*(mIconSize + mColumnSpace);
		if( s <= (unsigned int)pos.mX && (unsigned int)pos.mX <= s + mIconSize )
			break;
	}
	if( col == mColumn )
		return;

	if( mLeftAlign == false )
		col = mColumn-1 - col;

	unsigned int row;
	for( row=0; row<mRow; row++ )
	{
		unsigned int s = y + row*(mIconSize + mRowSpace);
		if( s <= (unsigned int)pos.mY && (unsigned int)pos.mY <= s + mIconSize )
			break;
	}
	if( row == mRow )
		return;

	unsigned int over = row*mColumn + col;
	if( mOverInfo.mOverIconIdx != over )
	{
		mChangeOverIcon = true;
		mOverInfo.mOverIconIdx = over;
		mOverInfo.mPos = pos;
	}
}

/// Ϲݹ  ٸ
void cDuelBuff::OnRButtonDown( const cUIPos& pos, bool /*ctrl*/, bool /*alt*/, bool /*shift*/ )
{
	unsigned int x = mStartX;
	unsigned int y = mStartY;

	if( mpParent )
	{
		x += mpParent->GetAbsoluteRect().mLeft;
		y += mpParent->GetAbsoluteRect().mTop;
	}

	unsigned int col;
	for( col=0; col<mColumn; col++ )
	{
		unsigned int s = x + col*(mIconSize + mColumnSpace);
		if( s <= (unsigned int)pos.mX && (unsigned int)pos.mX <= s + mIconSize )
			break;
	}
	if( col == mColumn )
		return;

	unsigned int row;
	for( row=0; row<mRow; row++ )
	{
		unsigned int s = y + row*(mIconSize + mRowSpace);
		if( s <= (unsigned int)pos.mY && (unsigned int)pos.mY <= s + mIconSize )
			break;
	}
	if( row == mRow )
		return;

	unsigned int over = row*mColumn + col;

	mRButtonClickIconIdx = over;
}


void cDuelBuff::EventOverIcon( sBuffBaseIcon* p, const cUIPos& pos )
{
	assert( p );
	cBuffToolTipWindow* pTip = GAMEUI->GetBuffTip();

	if( pTip )
	{
		mBuffTipShow = true;
		UIMAN->ShowBuffTip( pTip, pos, p->mUniqueIdx, p->mInfluenceIdx, false );
	}
}

void cDuelBuff::AddIcon( unsigned long uniqueIdx, unsigned long influenceIdx )
{
	sInfluenceScript* pInfo = SKILLSCRIPT->GetInfluenceInfo( influenceIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}
	cIconParam* pParam = UIMAN->GetIconParam( pInfo->mIconIdx );
	if( pParam == 0 )
	{
		assert(0);
		return;
	}

	sBuffIcon* p = new sBuffIcon;
	p->mTotalTime = pInfo->mContinuanceTime;

	p->mAuraType = (pInfo->mTypeDetail == eINFLUENCETYPEDETAIL_AURA);
	p->mIsBuff = (pInfo->mType == eINFLUENCETYPE_BUF);

	p->mUniqueIdx = uniqueIdx;
	p->mInfluenceIdx = influenceIdx;

	/// ̹ 
	p->mImage.SetTexture( pParam->mpTexture );

	/// ؽó  
	unsigned int tx = pParam->mTexPos.mX;
	unsigned int ty = pParam->mTexPos.mY;
	p->mImage.SetTextureRect( tx, ty, tx + ICON_SIZE, ty + ICON_SIZE );

	mIconList.PushBack( p );

	HideTip();

	mUpdateList = true;

	/// npc 찡 ̸ 켱 
	Show();

	mRButtonClickIconIdx = (unsigned int)-1;
}