/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"
#include "ActorManagerForPartition.h"
#include "TrailGeometry.h"

class cShadowGeometry;
class cEffectSceneNode;
class cSoundSceneNode;
class cObjectNameCard;
class cBubbleBase;
class cBaseObject;

struct sTextItem;




///    
class cDynamicSceneNodeParam : public cSceneNodeParam
{
public:
	cDynamicSceneNodeParam();

public:
	///
	//cString mPathName;// resource

	///   Ӱü νϽ
	cBaseObject*	mpObject;


	bool			mCreateNameCard;

	bool			mUseShadow;
};

inline cDynamicSceneNodeParam::cDynamicSceneNodeParam()
: mpObject( 0 )
//, mShadowType( eSHADOW_REAL )
{
	mCreateNameCard = true;
	mUseShadow = true;
}

struct sTrailInfo
{
	cRibbonGeometry*	mRibbonGeom;
	unsigned long		mLifeTime;

	unsigned int		mStartLink;
	unsigned int		mEndLink;

	bool				mLoop;

	sTrailInfo()
	{
		mRibbonGeom = 0;
		mLoop = false;
	}
	~sTrailInfo()
	{
		SAFE_NIDELETE(mRibbonGeom);
	}
};

///   
class cDynamicSceneNode : public cSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual bool OnVisible();

	virtual bool Pick( const cRay& ray );

	/// ̵
	virtual bool Move( float /*x*/, float /*y*/ ) { return true; }

	///  ü ٲ۴. ( ü ο ü üѴ.)
	virtual bool			ChangeParts( unsigned int /*partIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangeParts( unsigned int partsIdx, NiNode* pNode );

	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, NiTexture* /*pTex*/ );

	/// ̿ ü ũ ũ Ѵ. ( ߰  )
	virtual unsigned int	LinkObject( unsigned int /*dummyIdx*/, const char* /*fileName*/ ) { return UINT_MAX; }
	virtual unsigned int	LinkObject( unsigned int dummyIdx, NiNode* pNode );

	/// ũ 
	virtual void			UnLinkObject( unsigned int linkIdx );


	virtual cEffectSceneNode* 	LinkEffect( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool bLoop, bool bFollow );
	virtual void				UnLinkEffect( cEffectSceneNode* pnode );

	///  ü ũϴ  ƴϰ,
	virtual cSoundSceneNode*			LinkSound( unsigned long soundIdx, bool bLoop );
	virtual void						UnLinkSound( cSoundSceneNode* pnode );

	virtual cEffectSceneNode*	LinkDamage( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool IsMiss, bool zFalse );

	sTrailInfo*					LinkTrailEffect( cString str, unsigned long lifeTime, unsigned int link1, unsigned int link2, float lenPer, float factor );
	void						UnLinkTrailEffect( sTrailInfo* pInfo );

	virtual NiAVObject*				GetLinkObject( unsigned int linkId );

	/// 
	float	GetAniScaleFactor() { return mScaleFactor; }
	unsigned long	GetScaleAccumTime() { return mScaleAccumTime; }
	unsigned long	GetLastTime() { return mLastTime; }
	virtual void	UpdateAniScaleFactor( float factor );

	///  
	/// : ٿ ڽ ߽ ƴϴ.
	virtual const NiPoint3& GetObjectFoot() = 0;
	virtual const NiPoint3& GetObjectCenter() = 0;
	virtual const NiPoint3& GetObjectHead() = 0;

	///  ü
	virtual NiAVObject*		GetPartObject( unsigned int partsIdx );
	virtual NiNode*			GetDummyObject( unsigned int dummyIdx );
	virtual NiAVObject*		GetWeaponDummy( unsigned int /*objectIdx*/, bool /*left*/ ) { return 0; }

	///  ڸ 
	inline virtual cActorManagerForPartition* GetActorManager() { return mpActorManager; }

	///  ִϸ̼ 
	inline virtual cActorManagerForPartition::EventCode GetTargetAnimation() const { return mTargetAnimation; }

	inline unsigned long	GetTargetAnimationScaleEndTime() { return mTargetAnimationScaleEndTime; }
	inline unsigned long	GetTargetAnimationEndTime() { return mTargetAnimationEndTime; }
	virtual void SetTargetAnimation( unsigned int code );
	virtual bool UpdateTargetAnimation( unsigned int code );

	///  ü  
	inline cBaseObject* GetGameObject() { return mpGameObject; }

	inline float GetVisibleCamLen() { return mVisibleCamLength; }


	/// ü  Morpher ϱ ؼ..
	void StartMorpher();
	void StopMorpher();

	/// ǳ ǥ.
	virtual void ActiveChatBubble( LPTSTR msg, unsigned long color );
	virtual void ActiveChatBubble( sTextItem* text );

	inline void ShowNameGauge( bool show ) { mShowNameGauge = show; }

	/// ü ̸ǥ
	virtual void UpdateNameCardTextValue();
	virtual void UpdateNameCardGaugeValue();
	virtual void UpdateGuildName();
	virtual void UpdateGuildMark();

	/// 
	void GotoLastFrame();
	void AnimationReset();

	/// 
	NiAmbientLight* FindAmbientLight( NiAVObject* obj );

	void ClearEffect();
	void ClearSound();

	cObjectNameCard* GetNameCard() { return mpNameCard; }

	virtual void UpdateLinkEffect() {}

	void CalcScreenPos();

	inline virtual void HideHair( bool hide ) { mHideHair = hide; }

protected:
	cDynamicSceneNode( eType type = eDYNAMIC );
	virtual ~cDynamicSceneNode();

	/// ʱȭ
	virtual bool Init( const cDynamicSceneNodeParam& param );

	/// picking  ڽ, , Ǹ ü .
	void CollectPickData( NiAVObject* pobj );

	void LinkDataInit( NiAVObject* pobj );

	/// 
	virtual cObjectNameCard* CreateNameCard( cBaseObject* pObj ) = 0;

	///->
	/// ũ  ʱȭ Ѵ.
	virtual bool InitLinkInfo() = 0;

	/// Idleִϰ   ʱȭ Ѵ.
	virtual void InitializeRandomIdle() {}

	/// е带  ̴ 쿡 ó (ü ó ..)
	virtual void	UpdateBipedRootTransforms( unsigned long /*time*/ ) {}

	/// ÿ   ó ʿ
	virtual void AddToVisibleArray();
	virtual void AddDepthPlaneObject();

	virtual void ProcessTrail( unsigned long /*delta*/ ) {}

	void CollectGeomInfo( NiAVObject* obj );

protected:
	struct sBoneDataObj : public NiMemObject
	{
		///  
		NiSkinData::BoneData* pBoneData;

		///   
		NiTPrimitiveSet<NiSkinData::BoneVertData*> BoneVertData;
	};

	struct sLinkInfo : public NiMemObject
	{
		///  ε
		unsigned int DummyIndex;

		///  
		NiAVObject* pObject;
	};

protected:
	///  
	cActorManagerForPartition* mpActorManager;

	///  ִ ε
	cActorManagerForPartition::EventCode mTargetAnimation;

	unsigned long mTargetAnimationEndTime;
	unsigned long mTargetAnimationScaleEndTime;

	///    
	NiGeomMorpherController* mpMorpherController;
	bool mStopMorpherProcess;

	/// Idleִ 
	NiTPrimitiveArray<cActorManagerForPartition::EventCode>* mpRandomIdle;

	///  ̿ LinkǾ ü 
	NiTPrimitiveArray<sLinkInfo*>* mpLinkInfo;

	///  ɷ ִ Effect 
	typedef tList<unsigned long> cLinkIndexList;
	cLinkIndexList mEffectList;
	cLinkIndexList mSoundList;

	/// ü   
	NiNode*		mpHead;
	NiNode*		mpFoot;
	float		mHeadDist;	/// default 30.0f;

	int			mHeadScreenPosX;
	int			mHeadScreenPosY;
	int			mFootScreenPosX;
	int			mFootScreenPosY;


	/// ü  ǥϱ  ü
	cObjectNameCard*		mpNameCard;
	bool					mShowNameGauge;

	/// ǳ
	cBubbleBase*			mpChatBubble;

	typedef tList<void*> cPickDataList;
	cPickDataList mPickDataList;

	NiTPointerList<sTrailInfo*> mRibbonList;
	NiTPointerList<sTrailInfo*> mDeleteRibbonList;

protected:
	/// ִ ӵ 
	unsigned long	mScaleAccumTime;
	unsigned long	mLastTime;
	float	mScaleFactor;

	/// ִϸ̼ ε ϱ    ´.
	cModelInstance* mpModel;

	///  ü  ( Ӱü ϴ ٸ)
	cBaseObject*	mpGameObject;

	/// ׸ 
	cShadowGeometry* mShadowGeom;
	bool mNeedUpdateShadow;

	/// ȭ鿡  ī޶ Ÿ(AddToVisibleArray ȣȵǴ ü   .)
	float mVisibleCamLength;

	bool mUpdateGeomInfo;

	bool mHideHair;
};


///    Լ
/// ŷ Ÿ Ѵ.
class cDynamicSceneNodeCompareByCamDistance
{
public:
	bool operator () ( const void* left, const void* right ) const
	{
		if( left == 0 || right == 0 )
		{
			assert(0);
			return false;
		}
		return ( ((cDynamicSceneNode*)left)->GetVisibleCamLen() >= ((cDynamicSceneNode*)right)->GetVisibleCamLen() );
	};
};

