/* ==========================================================================
*      : EditBox.h
*      : 
*    : 谡
*    : 2006-10-12
* ǻ :
*===========================================================================*/
#pragma once
#include "UIIMENode.h"
#include "UINodeData.h"

class cPlaneObject;
class cEditBox : public cUIIMENode
{
public:
	cEditBox( eUINodeType type = eUINODE_EDITBOX );
	virtual ~cEditBox();

	/// Ʈ  ڿ  ( ܺο  ڿ )
	void SetText( LPCTSTR text, int align = 1 );
	void SetTextColor( eText_Color color );

	/// copy & paste  ֱ  
	void SetCopyPaste( bool flag );

	/// ü  
	void SetAllSelect();

	bool IsFocus() const;	/// Ŀ ִ  
	bool IsText() const;	/// Ʈ ο ؽƮ ִ 

protected:
	/// ̺Ʈ ó
	virtual bool OnCreate( cUINodeProperty* );
	virtual bool HandleEvent( const cUIEvent& event );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );
	virtual void OnRender( cUIFontItemKeeper* pKeeper );
	virtual void OnMouseMove( const cUIPos& pos );
	virtual void OnLButtonDown( const cUIPos& pos, bool ctrl, bool /*AltPress*/, bool /*shiftPress*/ );
	virtual void OnLButtonDoubleClick( const cUIPos& pos );
	virtual void OnLButtonUp( const cUIPos& pos );
	virtual void OnKeyDown( eKeyCode code );
	virtual void OnKeyUp( eKeyCode code );
	virtual void OnFocusLost();
	virtual void OnMouseLeft(const cUIPos& pos );
	virtual void OnCaptureLost( const cUIPos& pos );
	virtual bool SetSkin( const cUINodeSkin* pskin );
	virtual void UpdateRect();

	/// ڿ н ȯѴ 
	void ChangePassword();

	/// ĳ ̴ ð  
	void UpdateCaretTime( unsigned long accumTime );

	/// ؽƮ ǥ Ʈ 
	void UpdateText();

	/// ؽƮ ũѰ, Ʈ ѷ ؽƮ  
	void UpdateShowText();

	/// 巡 ̹ ġ,   
	void UpdateBackImage( const cUIPos& pos );

	/// Ʈ 콺 ̺Ʈ Ͼ, ǥ  ε 
	void UpdateMouseMoveInEdit( const cUIPos& pos, int& viewcaret, int& editcaret, bool directionfla );

	/// ĳ  
	void RenderCaret(cUIFontItemKeeper* pKeeper);

protected:
	/// ڿ 巡׽  ̹ 
	cPlaneObject* mSelectionImage;

	/// 巡  x ǥ
	cUIPos mSelectionStartPos;

protected:
	/// ؽó  
	cUIRect mOriginalTexRect;

	/// Ʈ ڽ   ġ
	cUIPos mEditingPos;

	/// Ʈ ġ 
	int mEditX, mEditY;

	/// Ʈε ( ÿ Ŀ   Ҵ ȣ )
	int mEditTabIndex;
 
	/// copy & paste  ֱ  
	bool mCopyFlag;

	/// ؽƮ 
	int mTextAlign;
	
	/// ĳ ð ÷ 
	bool mCaretTimeFlag;

	/// ĳ ð
	unsigned long mLastTick;

	/// ĳ ÷
	bool mShowCaretFlag;

	///  Ʈ ѷ ؽƮ 
	TCHAR mShowText[ MAX_TEXT_LENGTH ];

	///  µǴ ڿ  
	int mShowLen;

	unsigned long mTextColor;
};

inline bool cEditBox::IsFocus() const
{
	if( GetFocus() == this )
	{
		return true;
	}
	return false;
}

inline bool cEditBox::IsText() const
{
	if( mTextLength > 0 )
		return true;
	return false;
}

inline void cEditBox::SetCopyPaste( bool flag )
{
	mCopyFlag = flag;
}

inline void cEditBox::SetTextColor( eText_Color color )
{
	mTextColor = color;
}

///////////////////////////////////////////////////////////////////////////
class cEditBoxSkin : public cUINodeSkin
{
public:
	cEditBoxSkin( eUINodeType type = eUINODE_EDITBOX );
	virtual ~cEditBoxSkin();
	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ؽƮ 
	cStringT mText;
	/// Ʈ ġ
	cUIPos mEditPos;
	/// ؽƮ  ( 0 : , 1 :  )
	int mTextAlign;
	/// Ʈ Ҽ ִ ִ   ( 110   )
	int mMaxEditLength;
	/// Ʈ Ÿ 
	unsigned int mEditKind;

	/// ڰ µ width
	unsigned int mEditWidth;

public:
	/// Ʈڽ 巡  ̹ 
	NiTexture* mpSelectionTexture;
	sSkinInfo* mSelectionSkin;
};
