/* ==========================================================================
*    : ̹
*    : 2007.01.18
*      : Ʈ  
* ǻ : 
*===========================================================================*/
#pragma once
#include "SceneNode.h"

class cDynamicSceneNode;
class cNifAnimationInfo;

///   
class cEffectSceneNodeParam : public cSceneNodeParam
{
public:	
	cEffectSceneNodeParam();

public:
	/// follow ü
	cDynamicSceneNode* mpFollowSceneNode;
	unsigned int mDummyIdx;

	bool mFollowing;
	bool mLooping;
	bool mIsDistCheck;
};

inline cEffectSceneNodeParam::cEffectSceneNodeParam()
: mpFollowSceneNode(0)
, mDummyIdx((unsigned int)-1)
, mLooping(false)
, mFollowing(false)
, mIsDistCheck(true)
{
}

class cEffectSceneNode : public cSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );

	inline bool IsRemoved() { return mRemoved; }

	void		Remove();
	void		ParentNodeRemove();

	/// ܵü  (߻ü )
	bool InitSelfNode( const cString& pathName, bool distCheck, NiTransform& trans, bool bLoop );

	void SetLoopFlag( bool flag );
	bool GetLoopFlag();

	virtual bool IsViewNode();

	inline unsigned int GetDummyIdx() { return mDummyIdx; }

	inline bool IsDamageEffect() { return mIsDamage; }
	inline void EnableDamageEffectFlag() { mIsDamage = true; DisableZBuffer( mSceneNiNode ); }


protected:
	cEffectSceneNode( eType type = eEFFECT );
	virtual ~cEffectSceneNode();

	/// ũ ü ȹؾ Ѵ.
	virtual bool Init( const cEffectSceneNodeParam& param );
	virtual bool InitDamageEffect( const cEffectSceneNodeParam& param, bool IsMiss, bool zFalse );

	bool FindDamageGeom( NiNode* pNode, NiGeometry** pArray );

	void DisableZBuffer( NiAVObject* pObj );

	void RemoveSelf();

protected:
	/// ٴϱ...
//	unsigned long mFollowSceneNodeIdx;
	cDynamicSceneNode* mpFollowSceneNode;
	unsigned int mDummyIdx;

	/// ִ Ʈѷ 
	cNifAnimationInfo* mNifAniInfo;

	bool mRemoved;
	bool mFadeOut;

	bool mIsDamage;
	bool mIsDistCheck;
};

