/* ==========================================================================
*    : ̼
*    : 2008.04.28
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include <NiFile.h>

class cFileToRead;

///  
class cEngineFile : public NiFile
{
public:
	cEngineFile( cFileToRead* fileToRead );
	~cEngineFile();

	void Seek( unsigned int offset, int whence );
	unsigned int Read( void* buffer, unsigned int bytes );

	unsigned int GetLine( char* buffer, unsigned int maxBytes );
	unsigned int GetFileSize() const;

protected:
	cFileToRead* mFileToRead;
};

template <class T> inline
void StreamLoadBinary( cEngineFile& file, T& value )
{
	file.Read( &value, sizeof(T) );
}

template <class T> inline
void StreamLoadBinary( cEngineFile& file, T* value, unsigned int bytes )
{
	unsigned int r = file.Read( value, bytes );

	if( r != bytes )
	{
		assert(0);
		NiMessageBox("Failed file read.","Error");
	}
}

template <class T> inline
void BinaryStreamLoadEnum( cEngineFile& file, T* value )
{
	int temp;
	file.Read( &temp, sizeof(int) );
	*value = (T)temp;
}
