#include "StdAfx.h"
#include "EnhancedWindow.h"
#include "ItemManager.h"
#include "Button.h"
#include "GameUIManager.h"
#include "TipWindow.h"
#include "Gauge.h"
#include "GameResourceManager.h"
#include "ChatManager.h"
#include "ObjectManager.h"
#include "Hero.h"

cEnhancedWindow::cEnhancedWindow()
: mItemSlotIndex(UINT_MAX)
, mCardSlotIndex(UINT_MAX)
, mpStart(0)
, mpGaugeBar(0)
, mItemSlot(0)
, mCardSlot(0)
, mpSuccess(0)
, mpFailure(0)
{

}

cEnhancedWindow::~cEnhancedWindow()
{
}

void cEnhancedWindow::Clear( bool allclear )
{
	if( allclear == true )
	{
		if( mItemSlot )
		{
			mItemSlot->ChangeImage( 0 );
			mItemSlot->SetTipType( eTOOLTIP_NONE );
			mItemSlot->SetItemIndex( 0 );
		}

		///   ʱȭ
		if( mItemSlotIndex <= MAX_INVENTORY )
		{
			cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
			oldItem.SetLock( false );
			mItemSlotIndex = UINT_MAX;
		}
	}

	/// ī Ŭ
	if( mCardSlot )
	{
		mCardSlot->ChangeImage( 0 );
		mCardSlot->SetTipType( eTOOLTIP_NONE );
		mCardSlot->SetItemIndex( 0 );
	}
	
	if( mCardSlotIndex <= MAX_INVENTORY )
	{
		cItem& oldCard = ITEMMAN->GetItem( mCardSlotIndex );
		oldCard.SetLock( false );
		mCardSlotIndex = UINT_MAX;
	}
	
	if( mpGaugeBar )
		mpGaugeBar->ClearFront();
}

void cEnhancedWindow::ShowTop(bool hideOthers, bool onsound )
{
	if( HERO->GetStopFlag() != eSTOP_ITEMMIX )
		cUIWindow::ShowTop( hideOthers, onsound );
}

void cEnhancedWindow::OnShow()
{
	cUIWindow::OnShow();

	GAMEUI->HideItemSetWindow( this );
}

void cEnhancedWindow::OnHide()
{
	cUIWindow::OnHide();

	Clear( true );

	///  ó
	HideResult();
}

bool cEnhancedWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpStart = (cButton*)GetChild( eUIID_GAME_ENHANCED_START	);
	mpGaugeBar = (cGauge*)GetChild( eUIID_GAME_ENHANCED_GAUGEBAR );
	mpSuccess = GetChild( eUIID_GAME_ENHANCED_SUCCESS );
	mpFailure = GetChild( eUIID_GAME_ENHANCED_FAILURE );

	if( mpGaugeBar )
		mpGaugeBar->SetMaxValue( 100 );

	///  ó
	HideResult();

	/// ȭ   
	mItemSlot = new cItemIcon;
	if( mItemSlot->CreateBySkinName( "Enhanced_ItemSlot", this, 1 ) == false )
		return false;

	/// ȭ ī  
	mCardSlot = new cItemIcon;
	if( mCardSlot->CreateBySkinName( "Enhanced_CardSlot", this, 2 ) == false )
		return false;

	/// hover ̺Ʈ ó ̵ Ұ 
	mItemSlot->SetUsedFlag( false, false );
	mItemSlot->SetSlotIndex( ENHANCED_ITEM_SLOT );
	mItemSlot->SetLinked( true );		///  ̾ƴ϶ κκ  

	mCardSlot->SetUsedFlag( false, false );
	mCardSlot->SetSlotIndex( ENHANCED_CARD_SLOT );
	mCardSlot->SetLinked( true );
	return true;
}

void cEnhancedWindow::UpdateRect()
{
	cUIWindow::UpdateRect();
}

void cEnhancedWindow::OnRender( cUIFontItemKeeper* pKeeper )
{
	cUIWindow::OnRender( pKeeper );
}

void cEnhancedWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_ENHANCED_CLOSE:
		{
			 ITEMMAN->TryToEnhancedCancel();
		}
		break;
	case eUIID_GAME_ENHANCED_CANCEL:
		{
			ITEMMAN->TryToEnhancedCancel( false );
		}
		break;
	case eUIID_GAME_ENHANCED_START:
		if( mItemSlotIndex <= MAX_INVENTORY && mCardSlotIndex <= MAX_INVENTORY )
		{
			ITEMMAN->TryToEnhancedStart();
		}
		break;
	}
}

void cEnhancedWindow::OnGaugeEnd( cUINode* n , unsigned int )
{
	if( mpGaugeBar && n == mpGaugeBar )
	{
		if( ITEMMAN->TryToEnhanced( mItemSlotIndex, mCardSlotIndex ) == true )
		{
			if( mpGaugeBar )
				mpGaugeBar->ClearFront();
		}

		UIMAN->HideTip();
	}
}

bool cEnhancedWindow::AddItem( unsigned int slotIndex )
{
	if( mpStart->IsNetLock() == true )
		return false;

	if( slotIndex > MAX_INVENTORY )
		return false;

	///  
	HideResult();

	/// ȭ  
	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemDefine* define = item.GetDefine();
	if( !define )
	{
		assert(0);
		return false;
	}

	/// ,  Ÿ ƴϸ 
	if( !(define->GetType() == ITEM_WEAPON || define->GetType() == ITEM_WEAR) )
		return false;

	/// ȭܰ ˻ ( ִ ȭ  )
	if( item.GetEnhanceStep() == MAX_ITEM_ENHANCED )
		return false;

	/// ȭī 
	if( mCardSlotIndex <= MAX_INVENTORY )
	{
		cItem& card = ITEMMAN->GetItem( mCardSlotIndex );
		cItemDefine* cardDefine = card.GetDefine();
		if( !cardDefine )
			return false;

		///  + Ⱝȭī ƴϸ 
		char cardSubType = cardDefine->GetSubType();
		if( define->GetType() == ITEM_WEAPON )
		{
			if( item.GetEnhanceStep() < ITEM_ENHANCED_LV1_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV1 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV2_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV2 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV3_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV3 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV4_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV4 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV5 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
		}
		else if( define->GetType() == ITEM_WEAR )
		{
			///  + ȭī ƴϸ 
			if( item.GetEnhanceStep() < ITEM_ENHANCED_LV1_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV1 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV2_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV2 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV3_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV3 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV4_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV4 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV5 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
		}
	}
	
	/// 
	if( mItemSlotIndex != slotIndex )
	{
		if( mItemSlotIndex <= MAX_INVENTORY )
		{
			cItem& oldItem = ITEMMAN->GetItem( mItemSlotIndex );
			oldItem.SetLock( false );
		}

		///   ε
		mItemSlotIndex = slotIndex;
		item.SetLock( true );
	}

	///  ̹ ü
	if( mItemSlot )
	{
		mItemSlot->SetItemIndex( item.GetIndex() );
		mItemSlot->ChangeImage( define->GetIconParam() );
		mItemSlot->SetTipType( define->GetTipType() );
	}
	else
	{
		assert(0);
	}

	return true;
}

///
bool cEnhancedWindow::AddCard( unsigned int slotIndex )
{
	if( mpStart->IsNetLock() == true )
		return false;

	if( slotIndex > MAX_INVENTORY )
		return false;

	///  
	HideResult();

	/// ȭ ī 	
	cItem& item = ITEMMAN->GetItem( slotIndex );
	cItemDefine* cardDefine = item.GetDefine();
	if( !cardDefine )
	{
		assert(0);
		return false;
	}

	/// ȭī尡 ƴϸ 
	if( !( cardDefine->GetType() == ITEM_CARD && (cardDefine->GetSubType() >= ITEM_CARD_ENHANCE_WEAPON_LV1 && 
												  cardDefine->GetSubType() <= ITEM_CARD_ENHANCE_WEAR_LV5) ) )
		return false;

	///  ä, ,  и
	if( mItemSlotIndex <= MAX_INVENTORY )
	{
		cItem& item = ITEMMAN->GetItem( mItemSlotIndex );
		cItemDefine* define = item.GetDefine();
		if( !define )
			return false;

		///  + Ⱝȭī ƴϸ 
		char cardSubType = cardDefine->GetSubType();
		if( define->GetType() == ITEM_WEAPON )
		{
			if( item.GetEnhanceStep() < ITEM_ENHANCED_LV1_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV1 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV2_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV2 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV3_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV3 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV4_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV4 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAPON_LV5 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
		}
		else if( define->GetType() == ITEM_WEAR )
		{
			///  + ȭī ƴϸ 
			if( item.GetEnhanceStep() < ITEM_ENHANCED_LV1_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV1 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV2_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV2 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV3_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV3 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else if( item.GetEnhanceStep() < ITEM_ENHANCED_LV4_END )
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV4 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
			else
			{
				if( cardSubType != ITEM_CARD_ENHANCE_WEAR_LV5 ) 
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 262 ) );
					return false;
				}
			}
		}
	}
	
	/// 
	if( mCardSlotIndex != slotIndex )
	{
		if( mCardSlotIndex <= MAX_INVENTORY )
		{
			cItem& oldCard = ITEMMAN->GetItem( mCardSlotIndex );
			oldCard.SetLock( false );
		}

		///   ε
		mCardSlotIndex = slotIndex;
		item.SetLock( true );
	}

	/// ī  ̹ ü
	if( mCardSlot )
	{
		mCardSlot->SetItemIndex( item.GetIndex() );
		mCardSlot->ChangeImage( cardDefine->GetIconParam() );
		mCardSlot->SetTipType( cardDefine->GetTipType() );
	}
	else
	{
		assert(0);
	}

	return true;
}

void cEnhancedWindow::OnNetLock( int lockTry )
{
	if( mpStart )
		mpStart->NetLock( lockTry );
}

void cEnhancedWindow::OnNetUnLock( int lockTry )
{
	if( mpStart )
		mpStart->NetUnLock( lockTry );
}

void cEnhancedWindow::OnIconHovered( cUINode* caller, unsigned int id, const cUIPos& pos )
{
	cIcon* hoverIcon = (cIcon*)caller;
	if( hoverIcon == mItemSlot )
	{
		if( mItemSlotIndex > MAX_INVENTORY )
			return;

		cItem& item = ITEMMAN->GetItem( mItemSlotIndex );
        UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), mItemSlotIndex, 0 );
	}
	else
	{
		if( mCardSlotIndex > MAX_INVENTORY )
			return;

		cItem& item = ITEMMAN->GetItem( mCardSlotIndex );
		UIMAN->ShowItemTip( eTIP_ITEM, pos, item.GetIndex(), mCardSlotIndex, 0 );
	}
}

void cEnhancedWindow::HideResult()
{
	if( mpSuccess )
		mpSuccess->Hide();

	if( mpFailure )
		mpFailure->Hide();
}

void cEnhancedWindow::HideESC( bool onsound )
{
	ITEMMAN->TryToEnhancedCancel();
}

///  ̹ ֱ
void cEnhancedWindow::SetResult( bool success )
{
	if( success == true )
	{
		if( mpSuccess )
			mpSuccess->Show();
	}
	else
	{
		if( mpFailure )
			mpFailure->Show();
	}
}

void cEnhancedWindow::StartGauge()
{
	if( mpGaugeBar )
		mpGaugeBar->SetGaugeAni( 100 );
}

void cEnhancedWindow::StopGauge()
{
	if( mpGaugeBar )
		mpGaugeBar->ClearFront();
}