#include "StdAfx.h"
#include "ExitWindow.h"
#include "GameUIManager.h"
#include "Button.h"

#include "label.h"
#include "msgbox.h"
#include "GameResourceManager.h"

#include "ObjectManager.h"
#include "hero.h"

cExitWindow::cExitWindow()
: mpDisConnect(0)
, mpGameOut(0)
{

}
cExitWindow::~cExitWindow()
{
}

bool cExitWindow::UIStageIn()
{
	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);

	SetRelativePos( cUIPos( x, y) );
	return true;
}

void cExitWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);

	SetRelativePos( cUIPos( x, y) );
}

bool cExitWindow::OnCreate( cUINodeProperty* pproperty )
{
	if( cUIWindow::OnCreate( pproperty ) == false )
		return false;

	mpGameOut = (cButton*)GetChild( eUIID_GAME_EXIT_EXIT );
	mpDisConnect = (cButton*)GetChild( eUIID_GAME_EXIT_CHANGE );
	return true;
}

/// ǻ : 
void cExitWindow::OnCommand( cUINode*, unsigned int id )
{
	switch( id )
	{
	case eUIID_GAME_EXIT_CHANGE:
		GAMEUI->ReqFinish( false );
		break;
	case eUIID_GAME_EXIT_EXIT:
		GAMEUI->ReqFinish( true );
		break;
	default:
		assert(0);
		return;
	}

	Hide();
}

void cExitWindow::OnNetLock( int lockTry )
{
	if( mpGameOut )
		mpGameOut->NetLock( lockTry );
	if( mpDisConnect )
		mpDisConnect->NetLock( lockTry );
}

void cExitWindow::OnNetUnLock( int lockTry )
{
	if( mpGameOut )
		mpGameOut->NetUnLock( lockTry );
	if( mpDisConnect )
		mpDisConnect->NetUnLock( lockTry );
}



//////////////////////////////////////////////////////////////////////////

cExitMsgWindow::cExitMsgWindow()
:mpCaption(0)
, mpMsgText(0)
, mpCancelBtn(0)
{
	mDelayTime = 0;
	mStartCount = false;
}

cExitMsgWindow::~cExitMsgWindow()
{

}

void cExitMsgWindow::UpdateSkin()
{
	cUIWindow::UpdateSkin();

	/// ȭ ߾ӿ 
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);

	SetRelativePos( cUIPos( x, y) );
}

bool cExitMsgWindow::OnCreate( cUINodeProperty* property )
{
	if( cUIWindow::OnCreate( property ) == false )
		return false;

	//  û
	mpCaption = (cLabel*)GetChild( eUIID_EXITMSG_CAPTION );
	mpMsgText = (cLabel*)GetChild( eUIID_EXITMSG_TEXT );
	mpCancelBtn = (cButton*)GetChild( eUIID_EXITMSG_CANCEL );
	if( mpCaption )
		mpCaption->SetTextColor( eCOLOR_WHITE );

	if( mpMsgText )
		mpMsgText->SetTextColor( eCOLOR_WHITE );

	return true;
}

void cExitMsgWindow::OnProcess( unsigned long deltaTime, unsigned long accumTime )
{
	cUIWindow::OnProcess( deltaTime, accumTime );

	if( mVisible == false )
		return;
	if( mStartCount == false )
		return;

	if( mDelayTime <= deltaTime+500 )
	{
		mDelayTime = 0;
		mStartCount = false;

		if( mpCancelBtn )
			mpCancelBtn->SetEnabled( false );

		///  ó
		if( mExitEvent )
			GAMEUI->SendDisConnect();
		else
			GAMEUI->SendGameOut();
	}
	else
	{
		mDelayTime -= deltaTime;
	}

	if( mpMsgText )
	{
		cStringT Message;
		if( mExitEvent )
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 72 ), unsigned int(mDelayTime*0.001f) );
			mpMsgText->SetText( (LPCTSTR)Message.Cstr() );
		}
		else
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 74 ), unsigned int(mDelayTime*0.001f) );
			mpMsgText->SetText( (LPCTSTR)Message.Cstr() );
		}	
	}
}

void cExitMsgWindow::ShowExitMsg( bool exit )
{
	int x = (int)(( GetScreenWidth() - GetAbsoluteRect().GetWidth() ) * 0.5f);
	int y = (int)(( GetScreenHeight() - GetAbsoluteRect().GetHeight() ) * 0.35f);
	SetRelativePos( cUIPos( x, y) );

	mExitEvent = exit;
	mDelayTime = 5500;
	mStartCount = false;

	if( mpCancelBtn )
		mpCancelBtn->SetEnabled( true );

	if( mpCaption )
	{
		if( mExitEvent )
			mpCaption->SetText( GAMERESOURCEMAN->GetGameText(71) );
		else
			mpCaption->SetText( GAMERESOURCEMAN->GetGameText(73) );
	}

	if( mpMsgText )
	{
		cStringT Message;
		if( mExitEvent )
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 72 ), unsigned int(mDelayTime*0.001f) );
			mpMsgText->SetText( (LPCTSTR)Message.Cstr() );
		}
		else
		{
			Message.Format( GAMERESOURCEMAN->GetGameText( 74 ), unsigned int(mDelayTime*0.001f) );
			mpMsgText->SetText( (LPCTSTR)Message.Cstr() );
		}
	}

	ShowModal( eMBEVENT_NONE );
}

void cExitMsgWindow::OnCommand( cUINode* node, unsigned int id )
{
	switch( id )
	{
	case eUIID_EXITMSG_CANCEL:
		{
			///  û 
			MSGROOT Msg;
			Msg.Category = NM_PLAYER;
			Msg.Protocol = NM_PLAYER_GAMEFINISH_CANCEL_REQ;
			NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

			///
			mStartCount = 0;
			Hide();

			HERO->SetState( eOBJECT_STATE_IDLE );
		}
		break;
	}
}

bool cExitMsgWindow::HandleEvent( const cUIEvent& event )
{
	if( mEnabled == false || mVisible == false )
		return mpParent->HandleEvent( event );

	switch( event.mType )
	{
	case eUIEVENT_LBUTTON_DOWN:
	case eUIEVENT_LBUTTON_UP:
	case eUIEVENT_MOUSE_MOVE:
		{
			cUINode* pNode = this->GetNode( event.mPos );
			if( pNode && (pNode->GetType() == eUINODE_BUTTON || pNode->GetType() == eUINODE_EDITBOX ))
				pNode->HandleEvent( event );
			else
				cUIWindow::HandleEvent( event );
		}
		break;
	case eUIEVENT_COMMAND:
	case eUIEVENT_GAME_COMMAND:
		if( event.mID == eMESSAGE_BUTTON_NO )
		{
			///  û 
			MSGROOT Msg;
			Msg.Category = NM_PLAYER;
			Msg.Protocol = NM_PLAYER_GAMEFINISH_CANCEL_REQ;
			NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

			mStartCount = 0;
			HERO->SetState( eOBJECT_STATE_IDLE );
		}
		else
			cUIWindow::HandleEvent( event );
		break;
	default:
		cUIWindow::HandleEvent( event );
		break;
	}
	return true;
}
