#include "stdafx.h"
#include "FilePackSystem.h"

#include "FileFinder.h"
#include "File.h"
#include "MemFile.h"
#include "FilePack.h"

#define PACK_PASSWORD	L"dkdlfltmehdwjq10aks"
#define MAX_PACKS		128

enum eFolder
{
	FOLDER_BASE = 0,
	FOLDER_LAUNCHER,
	FOLDER_GUILDMARK,
	FOLDER_SOUND,
	FOLDER_DATA,
	FOLDER_MAP,
	FOLDER_SCRIPT,
	FOLDER_COUNT
};

const charT* gFolderNames[FOLDER_COUNT] =
{
	L".\\", L"Launcher\\", L"GuildMark\\", L"Sound", L"Data\\", L"Map\\", L"Script\\"
};

cFilePackSystem::cFilePackSystem()
: mFileIndexMap( 16384 )
{
	mFilePackArray.Reserve( MAX_PACKS );
}

cFilePackSystem::~cFilePackSystem()
{
	for( unsigned int i = 0, iend = mFilePackArray.GetSize(); i < iend; ++i )
	{
		delete (cFilePack*)mFilePackArray[i];
	}

	mFilePackArray.Clear();
}

bool cFilePackSystem::Init()
{
	///   ˻
	cFileFinder fileFinder;
	cStringT findPath;
	cStringT packName;
	cStringT pathName;

	for( unsigned int i = FOLDER_DATA; i < FOLDER_COUNT; ++i )
	{
		findPath.Format( L"%s*.pack", gFolderNames[i] );

		if( fileFinder.FindFirst( findPath.Cstr() ) == false )
			continue;

		do
		{
			cFilePack* pack = new cFilePack;

			///   
			packName.Format( L"%s%s", gFolderNames[i], fileFinder.GetFileName() );

			if( pack->Open( packName, cFilePack::OPEN_READONLY ) == false )
			{
				delete pack;
				MessageBox(NULL, _T("Failed Open pack file.. reinstall client."), _T("Error"), MB_OK | MB_ICONEXCLAMATION );
				continue;
			}

			/// н带 
			pack->SetPassword( PACK_PASSWORD );

			///   ߰
			unsigned int packIndex = mFilePackArray.GetSize();
			unsigned int fileIndex;

			mFilePackArray.PushBack( pack );

			///  ε ʿ ߰
			cFileInPackInfo fipi;

			for( unsigned int j = 0, jend = pack->GetNumFiles(); j < jend; ++j )
			{
				pack->GetFileInfo( &fipi, j );

				if( fipi.IsDirectory() )
					continue;

				fileIndex = j;
				fileIndex <<= 8;
				fileIndex += packIndex;

				///
				char cstr[MAX_PATH];
				ConvertToAscii( fipi.GetPathName().Cstr(), cstr, MAX_PATH );
				cString tempName = cstr;
				tempName.ToLower();

				mFileIndexMap.Insert( tempName, fileIndex );
			}
		}
		while( fileFinder.FindNext() );
	}
	fileFinder.Close();
	return true;
}

cFileToRead* cFilePackSystem::OpenFileToRead( const cString& pathName )
{
#if defined(_DEBUG) || defined(_DEVSYS) || defined(_DEVMODE)
	///  ýۿ ε
	cFileToRead* file = cFileSystem::OpenFileToRead( pathName );
	if( file )
		return file;

	/// ŷ ýۿ ε
	cString tempName = pathName;
	tempName.Replace( '/', '\\' );
	tempName.TrimLeft( ".\\" );
	tempName.ToLower();

	cFileIndexMap::cIterator i = mFileIndexMap.Find( tempName );

	if( i == mFileIndexMap.End() )
		return 0;

	cMemFileInPackToRead* fileInPack = new cMemFileInPackToRead;
	unsigned int packIndex = i->mSecond & 0xFF;
	int fileIndex = int(i->mSecond >> 8);

	if( fileInPack->Open( (cFilePack*)mFilePackArray[packIndex], fileIndex ) == false )
	{
		delete fileInPack;
		return 0;
	}
	return fileInPack;
#else
	/// ŷ ýۿ ε
	cString tempName = pathName;
	tempName.Replace( '/', '\\' );
	tempName.TrimLeft( ".\\" );
	tempName.ToLower();

	cFileIndexMap::cIterator i = mFileIndexMap.Find( tempName );

	if( i != mFileIndexMap.End() )
	{
		cMemFileInPackToRead* fileInPack = new cMemFileInPackToRead;
		unsigned int packIndex = i->mSecond & 0xFF;
		int fileIndex = int(i->mSecond >> 8);

		if( fileInPack->Open( (cFilePack*)mFilePackArray[packIndex], fileIndex ) == true )
		{
			return fileInPack;
		}
		delete fileInPack;
	}

	///  ýۿ ε
	return cFileSystem::OpenFileToRead( pathName );
#endif
}

cMemFileToRead* cFilePackSystem::OpenMemFileToRead( const cString& pathName )
{
// 系 ׽Ʈ   ýۿ  ε  ŷ ýۿ ã. [1/12/2009 Jo_2]
//#if defined(_DEBUG) || defined(_DEVSYS) || defined(_DEVMODE)
	///  ýۿ ε
	cMemFileToRead* file = cFileSystem::OpenMemFileToRead( pathName );
	if( file )
		return file;

	/// ŷ ýۿ ε
	cString tempName = pathName;
	tempName.Replace( '/', '\\' );
	tempName.TrimLeft( ".\\" );
	tempName.ToLower();

	cFileIndexMap::cIterator i = mFileIndexMap.Find( tempName );

	if( i == mFileIndexMap.End() )
		return 0;

	cMemFileInPackToRead* fileInPack = new cMemFileInPackToRead;
	unsigned int packIndex = i->mSecond & 0xFF;
	int fileIndex = int(i->mSecond >> 8);

	if( fileInPack->Open( (cFilePack*)mFilePackArray[packIndex], fileIndex ) == false )
	{
		delete fileInPack;
		return 0;
	}
	return fileInPack;

// #else
// 	/// ŷ ýۿ ε
// 	cString tempName = pathName;
// 	tempName.Replace( '/', '\\' );
// 	tempName.TrimLeft( ".\\" );
// 	tempName.ToLower();
// 
// 	cFileIndexMap::cIterator i = mFileIndexMap.Find( tempName );
// 
// 	if( i != mFileIndexMap.End() )
// 	{
// 		cMemFileInPackToRead* fileInPack = new cMemFileInPackToRead;
// 		unsigned int packIndex = i->mSecond & 0xFF;
// 		int fileIndex = int(i->mSecond >> 8);
// 
// 		if( fileInPack->Open( (cFilePack*)mFilePackArray[packIndex], fileIndex ) == true )
// 		{
// 			return fileInPack;
// 		}
// 		delete fileInPack;
// 	}
// 
// 	///  ýۿ ε
// 	return cFileSystem::OpenMemFileToRead( pathName );
// #endif
}
