/* ==========================================================================
*      : FilterManager.cpp
*      : 
*    : 谡
*    : 2007-08-23
* ǻ :
*===========================================================================*/
#pragma once

class cFilterManager
{
public:
	static cFilterManager* mSingleton;

public:
	cFilterManager();
	~cFilterManager();

	///
	bool Init();

	/// ü ġ ˻ (  ܾ ִ ˻ )
	bool CheckWholeMatch( LPCTSTR msg );

	/// κ ġ ˻ ( ԵǴ ܾ ִ ˻ )
	bool CheckPartMatch( LPCTSTR msg );

	void AddEmotionFilter( LPCTSTR text, unsigned long index );
	unsigned long GetEmontionIndex( LPCTSTR msg );

public:
	static cFilterManager* GetSingleton();

protected:
	/// ũƮ ε
	bool LoadFilter( const cString& pathName );

	/// ü ġ ã
	bool FindWholeMatch( const cStringT& str );

private:
	/// ϸ  ܾ 
	typedef tHashSet<cStringT> cWholeSet;
	cWholeSet	mWholeSet;

	/// ԵǾ ˻ ܾ
	typedef tHashMap<cStringT, void*> cPartMap;
	cPartMap	mPartMap;

	///
	typedef tHashMap<cStringT, unsigned long> cEmotionSibling;
	typedef tHashMap<cStringT, void*> cEmotionFilterMap;
	cEmotionFilterMap	mEmotionFilterMap;


	///  ڷ ۵Ǵ 迭
	typedef tArray<cStringT> cSiblingArr;
};

inline cFilterManager* cFilterManager::GetSingleton()
{
	return mSingleton;
}

#define FILTERMAN cFilterManager::GetSingleton()