#include "stdafx.h"
#include "FilterManager.h"
#include "Tokenizer.h"

///
bool cFilterManager::LoadFilter( const cString& pathName )
{
	/// Ͽ
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load filter script" );
		return false;
	}
	
	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	/// ü ġ ʹܾ ε
	while( tokenizer.IsEnd() == false )
	{
		tokenizer.GetNext( &str );

		if( str.Compare( "WholeMatch" ) == 0 )
			continue;

		///  ܾ κ  ε ٲ Ѵ
		if( str.Compare( "PartMatch" ) == 0 )
			break;

		str.ToLower();

		///  
		TCHAR buffer[256] = {0,};
		int len = ConvertToUnicode( str.Cstr(), buffer, 256 );
		assert( len > 0 );

		if( mWholeSet.Insert( buffer ) == false )
		{
			assert( 0 && "failed to insert filter set" );
			return false;
		}
	}

	/// κ ġ  ܾ ε 
	while( tokenizer.IsEnd() == false )
	{
		tokenizer.GetNext( &str );
		
		str.ToLower();

		///  
		TCHAR buffer[256] = {0,};
		int len = ConvertToUnicode( str.Cstr(), buffer, 256 );
		assert( len > 0 );

		/// Ű 
		TCHAR key[2] = {0,};
		::_tcsncpy( key, buffer, 1 );

		///
		cPartMap::cIterator i = mPartMap.Find( key );
		if( i == mPartMap.End() )
		{
			///  Ű   
			///  ڷ ۵Ǵ ܾ  迭
			cSiblingArr* pSiblingArr = new cSiblingArr;
			pSiblingArr->PushBack( buffer );

			if( mPartMap.Insert( key, pSiblingArr ) == false )
			{
				assert( 0 && "failed to insert partMatch word" );
				return false;
			}
		}
		else
		{	
			///  Ű ϸ 迭 ϱ
			cSiblingArr* pSiblingArr = (cSiblingArr*)(i->mSecond);
			pSiblingArr->PushBack( buffer );
		}	
	}
	return true;
}

bool cFilterManager::FindWholeMatch( const cStringT& str )
{
	cWholeSet::cIterator i = mWholeSet.Find( str );

	if( i == mWholeSet.End() )
		return false;
	else
		return true;
}