#include "stdafx.h"
#include "fontagent.h"

#include "FontObject.h"
#include "RenderSystem.h"

#include "D3DXFont.h"
#include "CacheFont.h"

#include "ObjectNameCard.h"

cFontAgent* cFontAgent::mpFontAgent = NULL;

cFontAgent::cFontAgent()
{
	mpFontAgent = this;

	mFontArray.Reserve( eFont_Max );
}

cFontAgent::~cFontAgent()
{
}

/* ------------------------------------------------------------------
 * Լ̸ :	
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cFontAgent::Init()
{
	sCacheInfo info;

	/// UI Ʈ ( UI,  SystemMsg )
	cFontObject* pFont = new cCacheFont;
	if( !pFont )
		return false;

	info.texNum = 2;
	pFont->CreateFont( RENDERSYS->GetHWND(), NULL, info );
	mFontArray.PushBack( pFont );

	/// UI Ʈ ( UI,  SystemMsg ) BOLD
	pFont = new cCacheFont;
	if( !pFont )
		return false;

	LOGFONT		font;
	font.lfHeight = -12;
	font.lfWidth = 0;//-font.lfHeight / 2;
	font.lfEscapement = 0;
	font.lfOrientation = 0;
	font.lfWeight = FW_BOLD;
	font.lfItalic = 0;
	font.lfUnderline = 0;
	font.lfStrikeOut = 0;
	font.lfCharSet = DEFAULT_CHARSET;
	font.lfOutPrecision = OUT_OUTLINE_PRECIS;
	font.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	font.lfQuality =  PROOF_QUALITY;
	font.lfPitchAndFamily = FF_SWISS;
	::lstrcpy( font.lfFaceName, _T("ü") );

	info.texNum = 2;
	pFont->CreateFont( RENDERSYS->GetHWND(), &font, info );
	mFontArray.PushBack( pFont );

	/// ý Ʈ (Tooltip, Name, GameInfo, SystemMsg)
	pFont = new cCacheFont;
	if( !pFont )
		return false;

	info.texNum = 2;
	pFont->CreateFont( RENDERSYS->GetHWND(), NULL, info );
	mFontArray.PushBack( pFont );

	/// äÿ
	pFont = new cCacheFont;
	if( !pFont )
		return false;

	info.texNum = 2;
	pFont->CreateFont( RENDERSYS->GetHWND(), NULL, info );
	mFontArray.PushBack( pFont );

	/// 
	pFont = new cCacheFont;
	if( !pFont )
		return false;

	font.lfHeight = -18;
	font.lfWidth = 0;//-font.lfHeight / 2;
	font.lfEscapement = 0;
	font.lfOrientation = 0;
	font.lfWeight = FW_BOLD;
	font.lfItalic = 0;
	font.lfUnderline = 0;
	font.lfStrikeOut = 0;
	font.lfCharSet = DEFAULT_CHARSET;
	font.lfOutPrecision = OUT_OUTLINE_PRECIS;
	font.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	font.lfQuality =  PROOF_QUALITY;
	font.lfPitchAndFamily = FF_SWISS;
	::lstrcpy( font.lfFaceName, _T("ü") );

	info.texNum = 1;
	pFont->CreateFont( RENDERSYS->GetHWND(), &font, info );
	mFontArray.PushBack( pFont );

	/// ̰ ִ 鿡 ׷ Ʈ
	pFont = new cCacheFont;
	if( !pFont )
		return false;

	info.texNum = 2;

	font.lfHeight = -12;
	font.lfWidth = 0;//-font.lfHeight / 2;
	font.lfEscapement = 0;
	font.lfOrientation = 0;
	font.lfWeight = FW_NORMAL;
	font.lfItalic = 0;
	font.lfUnderline = 0;
	font.lfStrikeOut = 0;

	font.lfCharSet = DEFAULT_CHARSET;
	font.lfOutPrecision = OUT_OUTLINE_PRECIS;
	font.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	font.lfQuality =  PROOF_QUALITY;
	font.lfPitchAndFamily = FF_SWISS;
	::lstrcpy( font.lfFaceName, _T("ü") );

	pFont->CreateFont( RENDERSYS->GetHWND(), &font, info );
	pFont->SetAlpha( false );
	mFontArray.PushBack( pFont );

	pFont = new cCacheFont;
	if( !pFont )
		return false;

	info.texNum = 1;
	pFont->CreateFont( RENDERSYS->GetHWND(), &font, info );
	mFontArray.PushBack( pFont );

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	cFontAgent::Exit()
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
void cFontAgent::Exit()
{
	if( mFontArray.GetSize() )
	{
		for( unsigned int i=0; i<mFontArray.GetSize(); i++ )
		{
			cFontObject* pFont = (cFontObject*)mFontArray[i];
			if( pFont )
			{
				SAFE_DELETE(pFont);
			}
		}
		mFontArray.Clear();

	}
}

/* ------------------------------------------------------------------
 * Լ̸ :	cFontAgent::Invalidate()
 *      :	ġ ҽǽ ȿ  ޸ 
 * ǻ :	
 * ------------------------------------------------------------------ */
void cFontAgent::Invalidate()
{
	for( unsigned int i=0; i<eFont_Max; i++ )
	{
		cFontObject* pFont = (cFontObject*)mFontArray[i];
		if( pFont )
		{
			pFont->Invalidate();
		}
	}
}

/* ------------------------------------------------------------------
 * Լ̸ :	cFontAgent::Restore()
 *      :	ġ ҽǽ ȿ  ޸ 
 * ǻ :	
 * ------------------------------------------------------------------ */
void cFontAgent::Restore()
{
	for( unsigned int i=0; i<eFont_Max; i++ )
	{
		cFontObject* pFont = (cFontObject*)mFontArray[i];
		if( pFont )
		{
			pFont->Restore();
		}
	}
}

/* ------------------------------------------------------------------
* Լ̸ :	
*      :	
* ǻ :	
* ------------------------------------------------------------------ */
void cFontAgent::DrawText( unsigned short fontIdx, LPTSTR text, int textLen, unsigned int posX, unsigned int posY, unsigned long textColor, bool useBack, unsigned long backColor )
{
	POINT ps;
	ps.x = (LONG)posX;
	ps.y = (LONG)posY;
	DrawText( fontIdx, text, textLen, &ps, textColor, useBack, backColor );
}

void cFontAgent::DrawText( unsigned short fontIdx, LPTSTR text, int textLen, POINT* textPos, unsigned long textColor, bool useBack, unsigned long backColor )
{
	///  ó
	if( fontIdx >= eFont_Max )
		return;

	if( textPos->x<0 || textPos->y<0 )
		return;

	if( textPos->x >= (int)RENDERSYS->GetScreenWidth() ||  textPos->y >= (int)RENDERSYS->GetScreenHeight() )
		return;

	cFontObject* pFont = (cFontObject*)mFontArray[fontIdx];
	if( pFont == NULL )
	{
		return;
	}

	if( textLen == -1 )
	{
		textLen = ::_tcslen( text );
	}

	if( textLen == 0 )
	{
		return;
	}

	/// ׷  
	RECT rect = { textPos->x, textPos->y, 0, 0 };
	rect.right = rect.left + GetTextExtent( fontIdx, text, textLen ) + GetTextWidth( fontIdx ) / 4;
	rect.bottom = rect.top + GetTextHeight( fontIdx );

	///  ȭ ̸ 
	if( rect.right < 0 || rect.bottom < 0 )
		return;
	if( rect.right > (LONG)RENDERSYS->GetScreenWidth() || rect.bottom  > (LONG)RENDERSYS->GetScreenHeight() )
		return;

	/// ޹
//	if( useBack )
//	{
/*
		cFontObject* pBackFont = (cFontObject*)mFontArray[fontIdx];
		RECT br = rect;
		br.left = rect.left+1;
		br.right = rect.right+1;
		br.top = rect.top;
		br.bottom = rect.bottom;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left-1;
		br.right = rect.right-1;
		br.top = rect.top;
		br.bottom = rect.bottom;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left;
		br.right = rect.right;
		br.top = rect.top+1;
		br.bottom = rect.bottom+1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left;
		br.right = rect.right;
		br.top = rect.top-1;
		br.bottom = rect.bottom-1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left+1;
		br.right = rect.right+1;
		br.top = rect.top+1;
		br.bottom = rect.bottom+1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left+1;
		br.right = rect.right+1;
		br.top = rect.top-1;
		br.bottom = rect.bottom-1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left-1;
		br.right = rect.right-1;
		br.top = rect.top+1;
		br.bottom = rect.bottom+1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left-1;
		br.right = rect.right-1;
		br.top = rect.top-1;
		br.bottom = rect.bottom-1;
		pBackFont->DrawText( text, textLen, &br, backColor );
*/
//	}
//	else
//	{
		cFontObject* pBackFont = (cFontObject*)mFontArray[fontIdx];
		RECT br = rect;
		br.left = rect.left+1;
		br.right = rect.right+1;
		br.top = rect.top;
		br.bottom = rect.bottom;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left;
		br.right = rect.right;
		br.top = rect.top+1;
		br.bottom = rect.bottom+1;
		pBackFont->DrawText( text, textLen, &br, backColor );

		br.left = rect.left+1;
		br.right = rect.right+1;
		br.top = rect.top+1;
		br.bottom = rect.bottom+1;
		pBackFont->DrawText( text, textLen, &br, backColor );
//	}

	/// ؽƮ ..
	pFont->DrawText( text, textLen, &rect, textColor );
}

/* ------------------------------------------------------------------
 * Լ̸ :	GetTextExtent( unsigned short fontIdx, char* text, unsigned int textLen )
 *      :	UI ڿ ̸ ˰ Ҷ Ѵ.
 * ǻ :	
 * ------------------------------------------------------------------ */
long cFontAgent::GetTextExtent( unsigned short fontIdx, LPCTSTR text, unsigned int textLen )
{
	cFontObject* pFont = (cFontObject*)mFontArray[fontIdx];
	if( !pFont ) 
	{
		return 0;
	}

	return pFont->GetTextExtent( RENDERSYS->GetHWND(), text, textLen);
}

/* ------------------------------------------------------------------
 * Լ̸ :	GetTextWidth( unsigned short fontIdx )
 *      :	۲ÿ   ʺ ȯ
 * ǻ :	
 * ------------------------------------------------------------------ */
long cFontAgent::GetTextWidth( unsigned short fontIdx )
{
	cFontObject* pFont = (cFontObject*)mFontArray[fontIdx];
	if( !pFont ) 
	{
		return 0;
	}

	return pFont->GetTextWidth();
}

/* ------------------------------------------------------------------
 * Լ̸ :	GetTextHeight( unsigned short fontIdx )
 *      :	  Ǵ ۲  ̸ ȯ
 * ǻ :	
 * ------------------------------------------------------------------ */
long cFontAgent::GetTextHeight( unsigned short fontIdx )
{
	cFontObject* pFont = (cFontObject*)mFontArray[fontIdx];
	if( !pFont ) 
	{
		return 0;
	}

	/// 1  ǥø ؼ ش.
	return pFont->GetTextHeight() + 1;
}