/* ====================================================================
*      :	FontObject.h
*      :	Ʈ ü ⺻ 
*    :	̹
*    :	2006.10.10
*
* ߰ :
*		߰¥ 	۾		߰
*		06.10.10	̹		 (  )
* 
* ǻ :	
* =================================================================== */

#pragma once

struct sCacheInfo
{
	unsigned int maxCacheItemNum;
	unsigned int texWidth;
	unsigned int texHeight;
	unsigned int texNum;

	sCacheInfo()
	{
		maxCacheItemNum = 1024;
		texWidth = 1024;
		texHeight = 256;
		texNum = 4;
	}
};

class cFontObject
{
public:
	virtual ~cFontObject();

	/// Ʈ 
	virtual bool	CreateFont( HWND hwnd, LOGFONT* pLogFont, sCacheInfo& cacheInfo ) = 0;

	///  óؾ ġ 
	virtual void	BeginRender()	{ }
	virtual void	EndRender()		{ }

	/// ġ ҽǽ ó ƾ
	virtual void	Invalidate()	{ }
	virtual void	Restore()		{ }

	///  
	virtual bool	DrawText( LPTSTR str, int strLen, RECT* pRect, unsigned long color, SIZE* pScreenSize = 0  ) = 0;

	/// Font ̿ ڿ  
	virtual long	GetTextExtent( HWND hwnd, LPCTSTR text, unsigned int textLen );

	inline long		GetTextWidth()	{ return mFontWidth; }
	inline long		GetTextHeight()	{ return mFontHeight; }

	/// ǻ : offscreen Ʈ ׸   ض!!
	virtual void SetAlpha( bool /*bAlpha*/ ) {}

protected:
	cFontObject();

	virtual bool	SetFontInfo( HWND hwnd, LOGFONT* pLogFont );

protected:
	///	Ӻ긮  ϴ Dx9ü
	NiDX9Renderer*		mpRenderer;

	/// Ʈڵ
	HFONT				mhFont;

	///	Ʈ  ⺻ 
	LOGFONT				mLogFont;
	unsigned short		mFontWidth;
	unsigned short		mFontHeight;
};