#include "stdafx.h"
#include "FreeCamera.h"

#include "InputSystem.h"

#include "box.h"
#include "NaviMesh.h"

cFreeCamera::cFreeCamera()
{
}

cFreeCamera::~cFreeCamera()
{
}

void cFreeCamera::OnProcessMouse( unsigned long time )
{
	float tspeed = mSpeed * (time * 0.001f);

	int dx = MOUSE->GetDeltaX();
	int dy = MOUSE->GetDeltaY();

	if( dx || dy )
	{
		if( MOUSE->RButtonPressed() )
		{
			float rspeed = 10.f * (time * 0.001f);

			if( dx )
			{
				float yawAngle = float(dx) * rspeed * NI_PI / 180.f;
				Yaw( yawAngle );
			}
			if( dy )
			{
				float pitchAngle = float(dy) * rspeed * NI_PI / 180.f;
				Pitch( pitchAngle );
			}
		}
		if( MOUSE->MButtonPressed() )
		{
			if( dx )
				Translate( NiPoint3::UNIT_X * float(dx) * tspeed * 0.5f );
			if( dy )
				Translate( NiPoint3::UNIT_Z * float(dy) * -tspeed * 0.5f );
		}
	}

	float dw = (float)MOUSE->GetWheel();
	if( dw )
		Translate( NiPoint3::UNIT_Y * dw );

	if( KEYBOARD->GetKeyPressed( KEY_W ) )
	{
		Translate( NiPoint3::UNIT_Y * +tspeed );
	}
	if( KEYBOARD->GetKeyPressed( KEY_S ) )
	{
		Translate( NiPoint3::UNIT_Y * -tspeed );
	}
	if( KEYBOARD->GetKeyPressed( KEY_A ) )
	{
		Translate( NiPoint3::UNIT_X * -tspeed );
	}
	if( KEYBOARD->GetKeyPressed( KEY_D ) )
	{
		Translate( NiPoint3::UNIT_X * +tspeed );
	}

	NiPoint3 pos = mNiCamera->GetWorldTranslate();

	/// ׺޽ÿ 浹 ˻
	const cBox& box = NAVIMESH->GetBoundBox();
	if( pos.x < box.GetMin().x || pos.y < box.GetMin().y ||
		pos.x > box.GetMax().x || pos.y > box.GetMax().y )
	{
		pos.x = 500.0f;
		pos.y = 500.0f;
	}

	float z;
	if( NAVIMESH->CalcHeight( &z, pos.x, pos.y) )
	{
		if( z+50.0f > pos.z )
			Translate( NiPoint3(0.0f,0.0f, z-pos.z+50.0f ) );
	}
}

void cFreeCamera::SetLookAt( const NiPoint3& target )
{
	if( mNiCamera->LookAtWorldPoint( mLookAt, -NiPoint3::UNIT_Z ) == false )
		return;

	NiMatrix3 mat = mNiCamera->GetRotate();
	mOrientNode->SetRotate( mOrientNode->GetRotate() * mat );
}


//void cFreeCamera::LookAt( const NiPoint3& target )
//{
//	mLookAt = target;
//	mpOrientNode->Update( 0.f );
//	mpNiCamera->LookAtWorldPoint( mLookAt, NiPoint3::UNIT_Y );
//}
//
//void cFreeCamera::LookAt( float x, float y, float z )
//{
//	mLookAt.x = x;
//	mLookAt.y = y;
//	mLookAt.z = z;
//	mpOrientNode->Update( 0.f );
//	mpNiCamera->LookAtWorldPoint( mLookAt, NiPoint3::UNIT_Y );
//}

/*
#include "StdAfx.h"
#include ".\freecamera.h"
#include "InputSystem.h"

///   : Ű Է Pressed óѴ.
bool cFreeCamera::ProcessKeyPressed( float time )
{
	/// Translate Variation
	bool used = false;
	if( !MOUSE->MButtonPressed() )
	{
		if( KEYBOARD->GetKeyPressed( KEY_W ) )
		{
			mTranslateVariation.z += 5.f*500.0f*time;
			used = true;
		}
		if( KEYBOARD->GetKeyPressed( KEY_S ) )
		{
			mTranslateVariation.z -= 5.f*500.0f*time;
			used = true;
		}
		if( KEYBOARD->GetKeyPressed( KEY_A ) )
		{
			mTranslateVariation.x -= 5.f*500.0f*time;
			used = true;
		}
		if( KEYBOARD->GetKeyPressed( KEY_D ) )
		{
			mTranslateVariation.x += 5.f*500.0f*time;
			used = true;
		}
	}
	return used;
}

void cFreeCamera::ProcessMouse( float time )
{
	/// Translate Variation
	if( MOUSE->MButtonPressed() )
	{
		mTranslateVariation.x -= MOUSE->GetMouseAxisX()*500.0f*time;
		mTranslateVariation.y += MOUSE->GetMouseAxisY()*500.0f*time;
	}

	/// Rotation Variation
	if( MOUSE->RButtonPressed() )
	{
		int x = MOUSE->GetMouseAxisX();
		int y = MOUSE->GetMouseAxisY();


		mYawVariation	 = -x * 0.00002f*500.0f*time;
		mPitchVariation  = -y * 0.00002f*500.0f*time;

		mYawVariation	+= mYawVariation * 0.08553f;
		mPitchVariation	+= mPitchVariation * 0.08553f;
	}
}

void cFreeCamera::SetTranslate()
{
	//////////////////////////////////////////////////////////////////////////
	//       Y                     Y					Z			
	// NI:   |__ Z         MAX:    |__ X		APP:	|__X
	//      /                     /					   /
	//    -X                     Z					 -Y	
	//////////////////////////////////////////////////////////////////////////

	//	WorldDirection()	* fVer + 
	//	WorldUpVector()		* fHor + 
	//	WorldRightVector()	* fZoom;


	NiPoint3 trans =	NiPoint3::UNIT_Y * mTranslateVariation.y + 
						NiPoint3::UNIT_Z * mTranslateVariation.x + 
						NiPoint3::UNIT_X * mTranslateVariation.z;

	NiPoint3 currentTrans = mpBaseCamera->GetTranslate();
	currentTrans += mpBaseCamera->GetRotate() * trans;

	mpBaseCamera->SetTranslate( currentTrans );
}

void cFreeCamera::SetRotate()
{
	NiPoint3 yawAxis	= NiPoint3::UNIT_ALL;
	NiPoint3 pitchAxis	= NiPoint3::UNIT_ALL;
	NiPoint3 rollAxis	= NiPoint3::UNIT_ALL;
	mOriginalRotation.GetCol( 1, yawAxis );
	mOriginalRotation.GetCol( 2, pitchAxis );
	mOriginalRotation.GetCol( 0, rollAxis );

	mYawAngle	+= mYawVariation * 2.0f * NI_PI;
	mPitchAngle	+= mPitchVariation * 2.0f * NI_PI;
	mRollAngle	+= mRollVariation * 2.0f * NI_PI;

	NiMatrix3 yaw = NiMatrix3::IDENTITY;
	NiMatrix3 pitch = NiMatrix3::IDENTITY;
	NiMatrix3 roll = NiMatrix3::IDENTITY;
	yaw.MakeRotation( mYawAngle, yawAxis );
	pitch.MakeRotation( mPitchAngle, pitchAxis );
	roll.MakeRotation( mRollAngle, rollAxis );

	NiMatrix3 mat = yaw*pitch*roll*mOriginalRotation;
	mat.Reorthogonalize();
	mpBaseCamera->SetRotate( mat );

	mYawVariation = 0.0f;
	mPitchVariation  = 0.0f;
	mRollVariation = 0.0f;
}
*/
