#include "StdAfx.h"
#include "FriendListbox.h"
#include "ListBox.h"
#include "UIImage.h"
#include "FontAgent.h"

cFriendListbox::cFriendListbox( eUINodeType type )
: cListBox( type )
{

}

cFriendListbox::~cFriendListbox()
{

}

/// ǻ : Ʈ  ׷ֱ
void cFriendListbox::RenderData( cUIFontItemKeeper* pKeeper )
{
	/// ü Ʈ  
	if( GetRowCount() <= 0 )
		return;

	/// Ų ޾ƿ 
	cListBoxSkin* pListSkin = (cListBoxSkin*)mpSkin;
	if( !pListSkin )
		return;

	/// Ʈ ڽ ǥ ޾ƿ
	int textposX = 0;
	int textPosY = GetAbsoluteRect().mTop;

	unsigned int rowCount = ( mMaxRowInPage > GetRowCount() )? GetRowCount() : mMaxRowInPage;
	for( unsigned int row = mTopRowIdx; row < mTopRowIdx + rowCount; ++row )
	{
		sRowData* rData = GetRowData( row );
		if( !rData )
			continue;

		/// image  
		if( rData->mImage )
		{
			cUIImage* image = rData->mImage;

			sListCtrlParam* pParam = pListSkin->mpImgParam;
			unsigned int imageX = pParam->mColumnX;
			unsigned int imageY = textPosY + (int)((mRowHeight-image->GetHeight())*0.5f);

			image->SetPos( GetAbsoluteRect().mLeft + imageX, imageY );
			image->Draw();
		}

		/// Ʈ  
		unsigned int colCount = rData->mColumes.GetSize();
		unsigned int fixposY = textPosY;
		for( unsigned int col = 0; col< colCount; ++col )
		{
			///  ÷  
			sData* data = rData->mColumes[col];
			sListCtrlParam* pParam = pListSkin->GetCtrlParam( col );

			unsigned int tX = 0;
			unsigned int tW = 0;
			eText_Align align = eALIGN_LEFT;

			if( pParam )
			{
				tX = pParam->mColumnX;
				tW = pParam->mColumnW;
				align = pParam->mAlign;
			}

			///   ǥ  
			unsigned int strWidth = FONTAGENT->GetTextExtent( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), data->mText.GetLength() );
			textposX = UpdateTextPos( align, strWidth, tX, tW );

			/// Hover   ٸ  ǥ
			unsigned color = data->mTextColor;
			if( mHoveredRowIdx != -1 && row - mTopRowIdx == (unsigned int)mHoveredRowIdx )
				color = eCOLOR_RED;

			pKeeper->AddFontItem( cFontAgent::eFont_System, (LPTSTR)data->mText.Cstr(), textposX, fixposY + 5, color );

			/// ι° ÷ʹ ٷ  ؿ ´
			fixposY += FONTAGENT->GetTextHeight(cFontAgent::eFont_System) + 2;
		}

		textPosY += mRowHeight;
	}
}