/* ==========================================================================
*      : FriendWindow.h
*      : 
*    : 谡
*    : 2007-07-06
* ǻ :
*===========================================================================*/
#pragma once
#include "UIWindow.h"
#include "Chat_Common.h"

const unsigned int MAXPAGE_NUM = 5;

/// ģ 
struct sFriendData
{
	long				mIdx;			/// Ʈ ε
	unsigned long		mFriendIdx;		/// ģ ε 
	cStringT			mName;			/// ̸
	BYTE				mGameIn;		/// ӻ
};

class cFriendListbox;
class cUIImage;
class cButton;
class cFriendWindow : public cUIWindow
{
public:
	cFriendWindow();
	virtual ~cFriendWindow();

	///
	void Clear();
	void AddFriend( MSG_RES_FRIEND_LIST* msgData );

	bool IsFriend( unsigned long playerIdx );

protected:
	bool OnCreate( cUINodeProperty* pproperty );
	void OnCommand( cUINode* pcaller, unsigned int id );
	void OnRadioPressed( cUINode* pcaller, unsigned int id );
	void OnListBoxChanged( cUINode* caller, unsigned int id );
	void OnShow();
	void UpdateSkin();
	void OnNetLock( int lockTry );
	void OnNetUnLock( int lockTry );

	void AddConnect( MSG_RES_FRIEND_LIST* msgData );
	void AddNotConnect( MSG_RES_FRIEND_LIST* msgData );

	/// ̹    
	void CreateImage( const cString& skinname );
	char GetFriendImage( char race, char gender );

	void Update();
	void UpdateButton();

	sFriendData* GetFriendData( int friendIdx );

private:
	/// ̹ 迭 
	typedef tPointerArray<void*> cImageArr;
	cImageArr		mImageArr;

	/// ģ
	typedef tPointerArray<void*> cFriendArr;
	cFriendArr			mFriendArr;

	/// ģ ư
	cFriendListbox*		mpFriendList;
	cButton* mParty;
	cButton* mAddFriend;
	cButton* mDelFriend;
	cButton* mWhisper;

	///  ư
	cUINode*		mpRadioNode[ MAXPAGE_NUM ];

	/// ư   
	cUIRect			mCheckRect;
};
