/* ==========================================================================
*    : ̼
*    : 2008.06.25
*      : 
* ǻ : 
*===========================================================================*/
#pragma once

enum eGMTOOL_SUBDLG_INDEX
{
	GMTOOL_SUBDLG_ITEM = 0,
	GMTOOL_SUBDLG_SKILL,
	GMTOOL_SUBDLG_PK,
	GMTOOL_SUBDLG_MONSTER,
	GMTOOL_SUBDLG_NOTE,
	GMTOOL_SUBDLG_CHAT,
	GMTOOL_SUBDLG_NOTICE,
	GMTOOL_SUBDLG_EVENT,
	GMTOOL_SUBDLG_WEBSITE,
	GMTOOL_SUBDLG_MAP,
	GMTOOL_SUBDLG_SPEED,
	GMTOOL_SUBDLG_CALL,
	GMTOOL_SUBDLG_STOP,
	GMTOOL_SUBDLG_KICK,
	GMTOOL_SUBDLG_EXPDROP,

	MAX_GMTOOL_SUBDLG
};

/// 
class cGMTool
{
	static cGMTool* mInstance;

public:
	cGMTool();
	virtual ~cGMTool();

	bool Init( HINSTANCE hinst, HWND hwnd );
	bool LoadData();
	void Exit();

	void OnMove();

public:
	static cGMTool* GetInstance();

	/// ޽ ó Լ
	static INT_PTR CALLBACK DlgProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgItemProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgSkillProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgPKProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgMonsterProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgChatProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgNoteProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgNoticeProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgEventProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgWebSiteProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgMapProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgSpeedProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgCallProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgStopProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgKickProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );
	static INT_PTR CALLBACK DlgExpDropProc( HWND wnd, UINT msg, WPARAM wparam, LPARAM lparam );

	void SetGMToolVisible( bool visible );

protected:
	void OnCommand( int id );
	void OnCommandItem( int id, int msg );
	void OnCommandMonster( int id, int msg );
	void OnCommandNotice( int id, int msg );
	void OnCommandSkill( int id, int msg );
	void OnCommandWebSite( int id, int msg );
	void OnCommandMap( int id, int msg );
	void OnCommandSpeed( int id, int msg );
	void OnCommandCall( int id, int msg );
 	void OnCommandStop( int id, int msg );
 	void OnCommandKick( int id, int msg );
	void OnCommandExpDrop( int id, int msg );

	void OnTimer();

	void InitDlgItem();
	void InitDlgMonster();
	void InitDlgNotice();
	void InitDlgSkill();
	void InitDlgWebSite();
	void InitDlgMap();
	void InitDlgSpeed();
	void InitDlgCall();
 	void InitDlgStop();
 	void InitDlgKick();
	void InitDlgExpDrop();

	bool LoadItemData();
	bool LoadMonsterData();
	bool LoadNoticeData();
	bool LoadSkillData();
	bool LoadMapData();

	void OnChildMove( eGMTOOL_SUBDLG_INDEX index );

	///   б
	/// µ Ͽ  ̸ŭ ڸ оδ.
	/// : ѱ 2Ʈ 1ڸ ŸǷ  ũ ּ textLen 2迩Ѵ.   ιڸ ߰ϹǷ ִ textLen-1 ŭ о δ.
	bool GetText( char* buffer, int textLen );

	BOOL SetDlgItemTextEx( eGMTOOL_SUBDLG_INDEX hwndIndex, int nControlID, int nStringID );

protected:
	void EventItemHighClass();
	void EventItemMiddleClass();
	void EventItemLowClass();
	void EventCardSlot();

protected:
	HWND mParentWnd;
	HWND mMainDlg;
	HWND mSubDlg[MAX_GMTOOL_SUBDLG];
	HMODULE mRichMod;
	HINSTANCE mInst;

	bool        mIsfileOpen;
	char        mCurrentPath[ MAX_PATH ];
	cFileLoader mNoticeFileLoader;
	int         mTimeInterval;
	int         mSpeed;
	bool        mIsInOn;
	short       mExpPercent;
	short       mSxpPercent;
	short       mDropPercent;
	POINT       mSubDlgPos[MAX_GMTOOL_SUBDLG];

public:
	static const int MAX_PERCENT =   999;
	static const int MIN_PERCENT =  -100;

};

inline void cGMTool::SetGMToolVisible( bool visible )
{
	ShowWindow( mMainDlg, visible==true ? SW_SHOW : SW_HIDE );
}

inline cGMTool* cGMTool::GetInstance()
{
	return mInstance;
}

inline void cGMTool::OnChildMove( eGMTOOL_SUBDLG_INDEX index )
{
	RECT rc0, rc1;
	::GetWindowRect( mParentWnd, &rc0 );
	::GetWindowRect( mSubDlg[index], &rc1 );
	mSubDlgPos[index].x = rc1.left - rc0.left;
	mSubDlgPos[index].y = rc1.top - rc0.top;
}

#define GMTOOL	cGMTool::GetInstance()
