#include "stdafx.h"
#include "GMTool.h"
#include "resource.h"

#include "GameResourceManager.h"
#include "ItemManager.h"
#include "Protocol_Cheat.h"
#include "Cheat_Common.h"

void cGMTool::InitDlgItem()
{
	HWND hWnd = mSubDlg[GMTOOL_SUBDLG_ITEM];
	SetDlgItemInt( hWnd, IDC_EDIT_ITEMCOUNT, 1, false );
	SetDlgItemInt( hWnd, IDC_EDIT_MONEY, 0, false );
	SendDlgItemMessage( hWnd, IDC_EDIT_MONEY, EM_SETLIMITTEXT, (WPARAM)9, 0 );
	SendDlgItemMessage( hWnd, IDC_EDIT_ITEMCOUNT, EM_SETLIMITTEXT, (WPARAM)4, 0 );

	/// ġ
	RECT rc0;
	::GetWindowRect( mMainDlg, &rc0 );
	int x = rc0.right;
	int y = rc0.top + GetSystemMetrics(SM_CYCAPTION);
	::SetWindowPos( hWnd, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );

	mSubDlgPos[GMTOOL_SUBDLG_ITEM].x = 0;
	mSubDlgPos[GMTOOL_SUBDLG_ITEM].y = GetSystemMetrics(SM_CYCAPTION);

}

///   ư ̺Ʈ
void cGMTool::OnCommandItem( int id, int msg )
{
	switch( id )
	{
	case IDC_COMBO_ITEMHIGH:
		if( msg == CBN_SELCHANGE )
		{
			EventItemHighClass();
		}
		break;
	case IDC_COMBO_ITEMMIDDLE:
		if( msg == CBN_SELCHANGE )
		{
			EventItemMiddleClass();
		}
		break;
	case IDC_COMBO_ITEMLOW:
		if( msg == CBN_SELCHANGE )
		{
			EventItemLowClass();
		}
		break;
	case IDC_COMBO_ITEMNAME:
		if( msg == CBN_SELCHANGE )
		{
			EventCardSlot();
		}
		break;
	case IDC_BUTTON_ITEMCANCEL:
		::ShowWindow( mSubDlg[GMTOOL_SUBDLG_ITEM], SW_HIDE );
		::SetActiveWindow( mParentWnd );
		break;
	case IDC_BUTTON_ITEMCREATE: ///  
		if( NETWORK->IsConnected() == true )
		{
			///  ε ޾ƿ
			HWND nameCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMNAME );
			int sel = SendMessage( nameCombo, CB_GETCURSEL, 0, 0 );
			unsigned long itemIndex = SendMessage( nameCombo, CB_GETITEMDATA, sel, 0 );

			/// ȭ  ޾ƿ
			HWND enhanceCombo = GetDlgItem( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ENHANCE );
			int enhance = SendMessage( enhanceCombo, CB_GETCURSEL, 0, 0 );

			///  ޾ƿ
			BOOL retcode;
			int count = GetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_EDIT_ITEMCOUNT, &retcode, false );
			if( retcode == false )
				return;

			if( count > 9999 )
				SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_ITEM],IDC_EDIT_ITEM_NOTICE, _T(" ʹ ϴ.") );

			if( count > 0 )
			{
				///   ˻
				if( ITEMMAN->IsLocked() )
					return;

				///   Ŷ
				MSG_REQ_CHEAT_MAKE msg;
				::memset( &msg, 0, sizeof( msg ) );

				msg.Category = NM_CHEAT;
				msg.Protocol = NM_CHEAT_MAKE_REQ;
				msg.mItemIndex = itemIndex;
				msg.mCount = count;
				msg.mEnhance = enhance;

				/// ī  
				unsigned int comboID[5] = { IDC_COMBO_PUTCARD1, IDC_COMBO_PUTCARD2, IDC_COMBO_PUTCARD3, IDC_COMBO_PUTCARD4, IDC_COMBO_PUTCARD5 };
				int cardSel[5];
				for( int i = 0; i < 5; ++i )
				{
					HWND combo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i] );
					cardSel[i] = SendMessage( combo, CB_GETCURSEL, 0, 0 );
					
					if( cardSel[i] > 0 ) 
					{
						msg.mCardSlot[i] = SendMessage( combo, CB_GETITEMDATA, cardSel[i], 0 );
					}
				}
				
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				/// ʱȭ
			//	SetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_EDIT_ITEMCOUNT, 0, false );
			}

			///  ޾ƿ
			unsigned long money = GetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_EDIT_MONEY, &retcode, false );
			if( retcode == false )
				return;

			if( money > 0 )
			{
				///   Ŷ
				MSG_REQ_CHEAT_GOLD msg;
				::memset( &msg, 0, sizeof( msg ) );

				msg.Category = NM_CHEAT;
				msg.Protocol = NM_CHEAT_GOLD_REQ;
				msg.mValue = money;
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				/// ʱȭ
				SetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_EDIT_MONEY, 0, false );
			}
		}
		break;
	default:
		return;
	}
}

bool cGMTool::LoadItemData()
{
	/// з ޺
	HWND highCombo = GetDlgItem( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMHIGH );
	if( ::IsWindow( highCombo ) == false )
	{
		assert(0);
		return false;
	}

	tArray<unsigned long>* highArr = ITEMMAN->GetHighClassArr();
	if( highArr )
	{
		for( unsigned int i=0; i< highArr->GetSize(); i++ )
		{
			unsigned long idx = (*highArr)[i];
			LPCTSTR highName = GAMERESOURCEMAN->GetCategoryName( idx );
			int key = SendMessage( highCombo, CB_ADDSTRING, 0, (LPARAM)(highName));
			SendMessage( highCombo, CB_SETITEMDATA, key, (LPARAM)idx );
		}
	}
	else
	{
		assert(0);
		return false;
	}

	/// ȭ Ʈ 
	HWND enhanceCombo = GetDlgItem( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ENHANCE );
	if( ::IsWindow( enhanceCombo ) == false )
	{
		assert(0);
		return false;
	}
	
	cStringT str;
	for( int i = 0; i <= MAX_ITEM_ENHANCED; ++i )
	{
		str.Format( GAMERESOURCEMAN->GetItemToolTipText( 2000087 ), i );
		SendMessage( enhanceCombo, CB_ADDSTRING, 0, (LPARAM)((LPCTSTR)str.Cstr()));
	}
	
	/// ִ  
	SendDlgItemMessage( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_EDIT_ITEMCOUNT, EM_LIMITTEXT, (WPARAM)4, 0 );


	/// ʱ⼱
	SendMessage( highCombo, CB_SETCURSEL, 0, 0 );
	EventItemHighClass();
	return true;
}

void cGMTool::EventItemHighClass()
{
	/// з õ 밡
	HWND highCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMHIGH);
	int i = SendMessage( highCombo, CB_GETCURSEL, 0, 0 );
	int highKey = SendMessage( highCombo, CB_GETITEMDATA, i, 0 );

	/// ߺз ʱȭ
	HWND midCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMMIDDLE );
	SendMessage( midCombo, CB_RESETCONTENT, 0, 0 );


	/// ߺз 
	tArray<unsigned long>* middleArr = ITEMMAN->GetMiddleClassArr( highKey );
	if( middleArr )
	{
		for( unsigned int i=0; i< middleArr->GetSize(); i++ )
		{
			unsigned long idx = (*middleArr)[i];
			LPCTSTR middleName = GAMERESOURCEMAN->GetCategoryName( idx );
			int key = SendMessage( midCombo, CB_ADDSTRING, 0, (LPARAM)(middleName));
			SendMessage( midCombo, CB_SETITEMDATA, key, (LPARAM)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	/// 
	SendMessage( midCombo, CB_SETCURSEL, 0, 0 );

	EventItemMiddleClass();
}

void cGMTool::EventItemMiddleClass()
{
	int i = 0;
	/// з õ 밡
	HWND highCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMHIGH);
	i = SendMessage( highCombo, CB_GETCURSEL, 0, 0 );
	int highKey = SendMessage( highCombo, CB_GETITEMDATA, i, 0 );

	/// ߺз õ 밡
	HWND midCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMMIDDLE );
	i = SendMessage( midCombo, CB_GETCURSEL, 0, 0 );
	int midKey = SendMessage( midCombo, CB_GETITEMDATA, i, 0 );

	/// Һз ʱȭ
	HWND lowCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMLOW );
	SendMessage( lowCombo, CB_RESETCONTENT, 0, 0 );

	/// Һз 
	tArray<unsigned long>* lowArr = ITEMMAN->GetLowClassArr( midKey + highKey );
	if( lowArr )
	{
		for( unsigned int i=0; i< lowArr->GetSize(); i++ )
		{
			unsigned long idx = (*lowArr)[i];
			LPCTSTR lowName = GAMERESOURCEMAN->GetCategoryName( idx );
			int key = SendMessage( lowCombo, CB_ADDSTRING, 0, (LPARAM)(lowName));
			SendMessage( lowCombo, CB_SETITEMDATA, key, (LPARAM)idx );
		}
	}
	else
	{
		assert(0);
		return;
	}

	/// 
	SendMessage( lowCombo, CB_SETCURSEL, 0, 0 );

	EventItemLowClass();
}

void cGMTool::EventItemLowClass()
{
	int i = 0;

	/// з õ 밡
	HWND highCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMHIGH);
	i = SendMessage( highCombo, CB_GETCURSEL, 0, 0 );
	int highKey = SendMessage( highCombo, CB_GETITEMDATA, i, 0 );

	/// ߺз õ 밡
	HWND midCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMMIDDLE );
	i = SendMessage( midCombo, CB_GETCURSEL, 0, 0 );
	int midKey = SendMessage( midCombo, CB_GETITEMDATA, i, 0 );

	/// Һз õ 밡
	HWND lowCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMLOW );
	i = SendMessage( lowCombo, CB_GETCURSEL, 0, 0 );
	int lowKey = SendMessage( lowCombo, CB_GETITEMDATA, i, 0 );

	/// ̸ ʱȭ
	HWND nameCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMNAME );
	SendMessage( nameCombo, CB_RESETCONTENT, 0, 0 );

	unsigned int totalCount = 0;

	/// ̸ 
	tArray<unsigned long>* ItemArr = ITEMMAN->GetItemCategoryArr( lowKey + midKey + highKey );
	if( ItemArr )
	{
		totalCount = ItemArr->GetSize();

		for( unsigned int i=0; i< ItemArr->GetSize(); i++ )
		{
			unsigned long idx = (*ItemArr)[i];
			LPCTSTR name = ITEMMAN->GetItemName( idx );
			int key = SendMessage( nameCombo, CB_ADDSTRING, 0, (LPARAM)(name));
			SendMessage( nameCombo, CB_SETITEMDATA, key, (LPARAM)idx );
		}
	}

#ifdef _GMTOOL
	/// GM Only

	/// ̸ 
	tArray<unsigned long>* GMItemArr = ITEMMAN->GetGMItemCategoryArr( lowKey + midKey + highKey );
	if( GMItemArr )
	{
		totalCount = GMItemArr->GetSize();

		for( unsigned int i=0; i< GMItemArr->GetSize(); i++ )
		{
			unsigned long idx = (*GMItemArr)[i];

			cStringT name;
			name.Format( _T("GM_%s"), ITEMMAN->GetItemName( idx ) );
			int key = SendMessage( nameCombo, CB_ADDSTRING, 0, (LPARAM)name.Cstr() );
			SendMessage( nameCombo, CB_SETITEMDATA, key, (LPARAM)idx );
		}
	}
#endif

	if( totalCount == 0 )
		return;

	SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ENHANCE), CB_SETCURSEL, 0, 0 );

	// ׿ 
	int sel = SendMessage( nameCombo, CB_SETCURSEL, 0, 0 );
	unsigned long setItemIndex = SendMessage( nameCombo, CB_GETITEMDATA, i, 0 );
	cItemDefine* define = ITEMMAN->GetItemDefine( setItemIndex );
	if( define )
	{
		unsigned char type = define->GetType();
		bool enable = ( !(type == ITEM_WEAPON || type == ITEM_WEAR) ) ? false : true;
		EnableWindow( GetDlgItem( mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ENHANCE ), enable );
	}

	///// ī  
	EventCardSlot();
}

/// ī  
void cGMTool::EventCardSlot()
{
	/// id  
	typedef tHashMap<long, void*> cItemDefineMap;
	cItemDefineMap& itemMap = ITEMMAN->GetDefineMap();

	unsigned int comboID[5] = { IDC_COMBO_PUTCARD1, IDC_COMBO_PUTCARD2, IDC_COMBO_PUTCARD3, IDC_COMBO_PUTCARD4, IDC_COMBO_PUTCARD5 };
	unsigned int slotID[5] = { IDC_EDIT_SLOTTYPE1, IDC_EDIT_SLOTTYPE2, IDC_EDIT_SLOTTYPE3, IDC_EDIT_SLOTTYPE4, IDC_EDIT_SLOTTYPE5 };

	/// ī޺
	for( int i = 0; i < 5; ++i )
	{
		EnableWindow( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i] ), false );
		SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i] ), CB_RESETCONTENT, 0, 0 );
		SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i]), CB_ADDSTRING, 0, (LPARAM)_T("-------------------------"));
	}

	///  ī Ÿ ʱȭ
	for( int i = 0; i < 5; ++i )
	{
		SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_ITEM], slotID[i], _T("") );
	}

	///  ε ޾ƿ
	HWND nameCombo = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], IDC_COMBO_ITEMNAME );
	int sel = SendMessage( nameCombo, CB_GETCURSEL, 0, 0 );
	unsigned long selItemIdx = SendMessage( nameCombo, CB_GETITEMDATA, sel, 0 );
	
	cItemDefine* define = ITEMMAN->GetItemDefine( selItemIdx );
	if( !define )
	{
		assert(0);
		return;
	}

	///   ƴϸ 
	unsigned char type = define->GetType();
	if( !(type == ITEM_WEAPON || type == ITEM_WEAR) )
		return;

	///   
	sItemPutCardSlot* data = define->GetPutCard();
	int count = define->GetPutSlotCount();
	if( data && count > 0 )
	{
		LPCTSTR str = 0;
		for( int i = 0; i < count; ++i )
		{
			/// 1. ī  Ÿ 
			switch( data->mSlotType[i] )
			{
			case ITEM_CARD_SLOT_NONE:	continue;
			case ITEM_CARD_SLOT_A:		str = _T("A");	break;
			case ITEM_CARD_SLOT_B:		str = _T("B");	break;
			case ITEM_CARD_SLOT_AB:		str = _T("AB");	break;
			case ITEM_CARD_SLOT_O:		str = _T("O");	break;
			}

			SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_ITEM], slotID[i], str );
			EnableWindow( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i]), true );
			SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i] ), CB_SETCURSEL, 0, 0 );

			/// 2.  ī ޺ 
			cItemDefineMap::cIterator mi = itemMap.Begin();
			cItemDefineMap::cIterator mend = itemMap.End();
			for( ; mi != mend; ++mi )
			{
				unsigned long cardIndex = (unsigned long)(mi->mFirst);
				cItemDefine* cardDefine = ITEMMAN->GetItemDefine( cardIndex );
				if( !cardDefine )
					continue;

				///  ī ƴϸ 
				if( cardDefine->GetType() != ITEM_CARD )
					continue;

				///  Ÿ ī ƴϸ 
				if( !(cardDefine->GetSubType() == ITEM_CARD_EQUIP_A || 
					 cardDefine->GetSubType() == ITEM_CARD_EQUIP_B || 
					 cardDefine->GetSubType() == ITEM_CARD_EQUIP_AB ||
					 cardDefine->GetSubType() == ITEM_CARD_EQUIP_O ) )
					continue;
					
				/// ش Կ  ִ Ǵ
				short cardType = cardDefine->GetSubType();
				if( data->mSlotType[i] == ITEM_CARD_SLOT_A )
				{
					if( !(cardType == ITEM_CARD_EQUIP_A || cardType == ITEM_CARD_EQUIP_O) )
						continue;
				}
				else if( data->mSlotType[i] == ITEM_CARD_SLOT_B )
				{
					if( !(cardType == ITEM_CARD_EQUIP_B || cardType == ITEM_CARD_EQUIP_O) )
						continue;
				}
				else if( data->mSlotType[i] == ITEM_CARD_SLOT_O )
				{
					if( cardType != ITEM_CARD_EQUIP_O )
						continue;
				}
				
				/// 
				LPCTSTR name = ITEMMAN->GetItemName( cardIndex );
				int key = SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i]), CB_ADDSTRING, 0, (LPARAM)(name));
				SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_ITEM], comboID[i]), CB_SETITEMDATA, key, (LPARAM)cardIndex );
			}
		}
	}
}