#include "stdafx.h"
#include "GMTool.h"
#include "ObjectManager.h"
#include "GameResourceManager.h"
#include "Protocol_Cheat.h"
#include "Hero.h"
#include "resource.h"


bool cGMTool::LoadMapData()
{
	/// з ޺
	HWND combo = GetDlgItem( mSubDlg[GMTOOL_SUBDLG_MAP], IDC_COMBO_MAP_LIST );
	if( ::IsWindow( combo ) == false )
	{
		assert(0);
		return false;
	}

	LPCTSTR highName = NULL;

	for( unsigned int i=MAP_MIN; i < MAP_COUNT+1; ++i )
	{
		highName = GAMERESOURCEMAN->GetMapName( i );
		if( highName == NULL )
		{
			assert(0 && "fail to get name" );
			return false;
		}

		/// CB_ADDSTRING ޽  ϸ Ҵ  ġ 
		LRESULT ret = SendMessage( combo, CB_ADDSTRING, 0, (LPARAM)(highName));
		if ( ret == CB_ERR || ret == CB_ERRSPACE )
			return false;
		
		/// ׸  Է.
		SendMessage( combo, CB_SETITEMDATA, ret, (LPARAM)i );

	}

	SendMessage( combo, CB_SETCURSEL, 0, 0 );
	
	return true;
}

void cGMTool::InitDlgMap()
{
	HWND hWnd = mSubDlg[GMTOOL_SUBDLG_MAP];

	SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_MAP],IDC_EDIT_MAP_NOTICE, _T("") );
	
	/// ġ 
	RECT rc0;
	::GetWindowRect( mMainDlg, &rc0 );
	int x = rc0.right;
	int y = rc0.top + GetSystemMetrics(SM_CYCAPTION);
	::SetWindowPos( hWnd, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );

	mSubDlgPos[GMTOOL_SUBDLG_MAP].x = 0;
	mSubDlgPos[GMTOOL_SUBDLG_MAP].y = GetSystemMetrics(SM_CYCAPTION);
}


void cGMTool::OnCommandMap( int id, int msg )
{
	switch( id )
	{
	case IDC_BUTTON_MAP_CANCEL:
		::ShowWindow( mSubDlg[GMTOOL_SUBDLG_MAP], SW_HIDE );
		::SetActiveWindow( mParentWnd );
		break;

	case IDC_BUTTON_MAP_TELEPORT:
		{
			///  ȣ ޾ƿ
			int select = SendDlgItemMessage( mSubDlg[GMTOOL_SUBDLG_MAP], IDC_COMBO_MAP_LIST, CB_GETCURSEL, 0, 0 );
			unsigned int mapIdx = SendDlgItemMessage( mSubDlg[GMTOOL_SUBDLG_MAP], IDC_COMBO_MAP_LIST, CB_GETITEMDATA, select, 0 );

			/// ġ ޾ 
			BOOL retcodeX, retcodeY;
			unsigned int posX, posY;
			
			posX = GetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_MAP], IDC_EDIT_MAP_POS_X, &retcodeX, false );
			posY = GetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_MAP], IDC_EDIT_MAP_POS_Y, &retcodeY, false );
			
			///  ɸͰ ε ȵǾٸ .
			if( HERO == NULL )
				return;

			if( retcodeX == FALSE || retcodeY == FALSE )
			{
				if( retcodeX ^ retcodeY )
				{
					SetDlgItemTextEx( GMTOOL_SUBDLG_MAP, IDC_EDIT_MAP_NOTICE, IDS_GMTOOL_MAP_ERROR_POS );
					return;
				}
				
				if( mapIdx == HERO->GetMapNum() )
				{
					SetDlgItemTextEx( GMTOOL_SUBDLG_MAP, IDC_EDIT_MAP_NOTICE, IDS_GMTOOL_MAP_ERROR_MAP );
					return;
				}
				
				/// ޽ 
				if( NETWORK->IsConnected() )
				{
					MSG_REQ_CHEAT_GO msg;
					::memset( &msg, 0, sizeof(msg) );
					msg.Category = NM_CHEAT;
					msg.Protocol = NM_CHEAT_GO_REQ;
					msg.mMapNum = mapIdx;
					msg.mDestX = 0;
					msg.mDestY = 0;

					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
				
			}
			else
			{
				/// ޽ 
				if( NETWORK->IsConnected() )
				{
					MSG_REQ_CHEAT_GO msg;
					::memset( &msg, 0, sizeof(msg) );
					msg.Category = NM_CHEAT;
					msg.Protocol = NM_CHEAT_GO_REQ;
					msg.mMapNum = mapIdx;
					msg.mDestX = (float)posX*100;
					msg.mDestY = (float)posY*100;

					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
			}

			::ShowWindow( mSubDlg[GMTOOL_SUBDLG_MAP], SW_HIDE );
		}
		break;

	case IDC_COMBO_MAP_LIST:
		if( msg == CBN_SELCHANGE )
		{
			SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_MAP],IDC_EDIT_MAP_POS_X, _T("") );
			SetDlgItemText( mSubDlg[GMTOOL_SUBDLG_MAP],IDC_EDIT_MAP_POS_Y, _T("") );
		}
		break;

	}

}