#include "stdafx.h"
#include "GMTool.h"
#include "resource.h"

#include "Monster_Common.h"
#include "MonsterScript.h"
#include "Protocol_Cheat.h"
#include "Cheat_Common.h"

#include "ObjectManager.h"
#include "Hero.h"

void cGMTool::InitDlgMonster()
{
	HWND hWnd = mSubDlg[GMTOOL_SUBDLG_MONSTER];
	
	/// Ʈڽ ⺻  
	SetDlgItemInt( hWnd, IDC_EDIT_MONSTERCOUNT, 1, false );

	/// ġ
	RECT rc0;
	::GetWindowRect( mMainDlg, &rc0 );
	int x = rc0.right;
	int y = rc0.top + GetSystemMetrics(SM_CYCAPTION);
	::SetWindowPos( hWnd, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );

	mSubDlgPos[GMTOOL_SUBDLG_MONSTER].x = 0;
	mSubDlgPos[GMTOOL_SUBDLG_MONSTER].y = GetSystemMetrics(SM_CYCAPTION);
}

///   ̺Ʈ 
void cGMTool::OnCommandMonster( int id, int msg )
{
	switch( id )
	{
	case IDC_BUTTON_MONCANCEL:
		::ShowWindow( mSubDlg[GMTOOL_SUBDLG_MONSTER], SW_HIDE );
		::SetActiveWindow( mParentWnd );
		break;
	case IDC_BUTTON_MONCREATE:	///  
		if( NETWORK->IsConnected() == true )
		{
			///  ε ޱ
			HWND hComDlg = GetDlgItem(mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_COMBO_MONSTERLIST);
			int i = SendMessage( hComDlg, CB_GETCURSEL, 0, 0 );
			long monIdx = SendMessage( hComDlg, CB_GETITEMDATA, i, 0 );

			///  ޱ
			BOOL retcode;
			int count = GetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_EDIT_MONSTERCOUNT, &retcode, false );
			if( retcode == false )
				return;

			if( count == 0 )
				return;

			if( count > 128 )
			{
				SetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_EDIT_MONSTERCOUNT, 128, false );
				count = 128;
			}

			/// 
			MSG_REQ_CHEAT_SUMMON msg;
			::memset( &msg, 0, sizeof( msg ) );

			msg.Category = NM_CHEAT;
			msg.Protocol = NM_CHEAT_SUMMON_REQ;
			msg.mMonsterNum = monIdx;
			msg.mValue = count;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			/// ʱȭ
			//SetDlgItemInt( mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_EDIT_MONSTERCOUNT, 1, false );
		}
		break;
	case IDC_BUTTON_MONDELETE:	///  
		if( NETWORK->IsConnected() == true )
		{
			cBaseObject* pTarget = HERO->GetTargetObject();
			if( pTarget == NULL )
				return;

			if( pTarget->GetObjectType() != eOBJECTTYPE_MONSTER )
				return;

			MSG_REQ_CHEAT_REMOVE msg;
			::memset( &msg, 0, sizeof( msg ) );

			msg.Category = NM_CHEAT;
			msg.Protocol = NM_CHEAT_REMOVE_REQ;
			msg.mObjIndex = pTarget->GetObjectID();
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case IDC_BUTTON_MONKILL:	///   (  & ġ  )
		if( NETWORK->IsConnected() == true )
		{
			cBaseObject* pTarget = HERO->GetTargetObject();
			if( pTarget == NULL )
				return;

			if( pTarget->GetObjectType() != eOBJECTTYPE_MONSTER )
				return;

			MSG_REQ_CHEAT_KILL msg;
			::memset( &msg, 0, sizeof( msg ) );

			msg.Category = NM_CHEAT;
			msg.Protocol = NM_CHEAT_KILL_REQ;
			msg.mObjIndex = pTarget->GetObjectID();
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case IDC_BUTTON_MONDELETE_RANGE:	///   ݰ 
		if( NETWORK->IsConnected() == true )
		{
			MSG_REQ_CHEAT_REMOVE_MONSTER msg;
			::memset( &msg, 0, sizeof( msg ) );

			msg.Category = NM_CHEAT;
			msg.Protocol = NM_CHEAT_REMOVE_MONSTER_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	}
}

bool cGMTool::LoadMonsterData()
{
	///  Ʈ  ޱ
	HWND nameCombo = GetDlgItem( mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_COMBO_MONSTERLIST );
	if( ::IsWindow( nameCombo ) == false )
	{
		assert(0);
		return false;
	}

	///   
	typedef const tPointerHashMap<unsigned long, void*> cMonsterHashMap;
	cMonsterHashMap* monsterMap = MONSTERSCRIPT->GetMonsterMap();
	if( !monsterMap )
		return false;

	cMonsterHashMap::cConstIterator i = monsterMap->Begin();
	cMonsterHashMap::cConstIterator end = monsterMap->End();
	for( ; i != end; ++i )
	{
		sMonsterScript* p = (sMonsterScript*)(i->mSecond);
		if( p )
		{
			int i = SendMessage( nameCombo, CB_ADDSTRING, 0, (LPARAM)(p->mName));
			SendMessage( nameCombo, CB_SETITEMDATA, i, (LPARAM)p->mMonsterClassIdx );
		}
	}

	/// ޺ ڽ ⺻  
	SendMessage( GetDlgItem(mSubDlg[GMTOOL_SUBDLG_MONSTER], IDC_COMBO_MONSTERLIST), CB_SETCURSEL, 0, 0 );
	return true;
}