/* ====================================================================
 *      :	GameResourceManager.h
 *      :	 ҽ(ũƮ ϵ) 
 *    :	̹
 *    :	2006.06
 *
 * ߰ :
 *		߰¥ 	۾		߰
 *		2006.06     ̹	    
 * 
 * ǻ :	
 * =================================================================== */
#pragma once

#include "Player_Common.h"

class cUIText;
class cUIFuncText;
class cParser;
class cStatusCalc_Client;
class cDamageCalc;
class cStatusScript;
class cMonsterScript;
class cNPCScript;
class cLevelScript;
class cSkillScript;
class cCommunityScript;
class cStageScript;
class cTotemScript;
class cPvPScript;
class cGatheringScript;
class cVehicleScript;
class cMakeSkillScript;

struct sMonsterScript;
struct sRegenMonsterScript;

class cBaseObject;
class cMonster;

struct sTextItem;

struct sMapInfo
{
	unsigned long mapNum;
	unsigned long folderIdx;

	bool useTile;

	cString	textureName;
};

struct sFaceEmoteInfo
{
	unsigned long	index;				/// list index
	unsigned char	type;				/// 0:base, 1:wink, 2:emote

	cString			textureName[eRACE_MAX*eGENDER_MAX];
};

struct sJobInfo
{
	unsigned long jobNameIndex;
	unsigned int jobImageIndex;
	unsigned int tx, ty, tw, th;
};

enum
{
	eData_Start = 0,
	eData_End,
	eData_Error,
};

class cGameResourceManager
{
public:
	static cGameResourceManager* mpGameResourceManager;

	cGameResourceManager();
	~cGameResourceManager();

	/// ʱȭ
	bool Init();

	/// ʱ ε  и
	bool LoadInitData1();
	bool LoadInitData2();
	bool LoadInitData3();
	void LoadEnd();

	inline unsigned int CheckInitData() { return mDataLoadFlag; }

	bool InitLogin();
	bool InitServer();

	/// 
	void Exit();

	///    ε
	void DataLoading();

	/// Item  
	//const char*			GetItemFileName( unsigned long itemFileIdx, char race, char gender );
	const char*			GetModelFileName( unsigned long modelIndex );

	///  ⺻ ϸ Ѵ.
	const char*			GetDefaultHairFileName( unsigned int hairIdx, char race, char gender );
	const char*			GetDefaultWearFileName( unsigned int part, char race, char gender );

	const char*			GetDefaultFaceFileName( char race, char gender );
	const char*			GetFaceTextureFileName( unsigned long idx, char race, char gender );

	inline unsigned int	GetDefaultFaceCount() { return mBaseFaceCount; }
	inline unsigned int	GetDefaultHairCount() { return mDefaultHairFileNameMap.GetSize(); }

	///   ȹ..
	LPCTSTR					GetJobName( unsigned long jobIdx );
	sJobInfo*				GetJobInfo( unsigned long jobIdx );
	void					GetDefaultJob( unsigned char race, tArray<unsigned long>* out );
	tArray<unsigned long>*	GetParentJob( unsigned long currentJob );
	unsigned int			GetJobLevel( unsigned long jobIdx );

	///   ȹ
	LPCTSTR		GetRaceName( unsigned char race );

	LPCTSTR		GetGameText( unsigned int textIdx );
	LPCTSTR		GetCategoryName( unsigned int textIdx );

	LPCTSTR		GetItemToolTipText( unsigned int textIdx );

	LPCTSTR		GetTarotText( unsigned int textIdx );
	LPCTSTR		GetCardBookText( unsigned int textIdx );

	LPCTSTR		GetSkillNameText( unsigned int textIdx );
	LPCTSTR		GetSkillToolTipText( unsigned int textIdx );

	LPCTSTR		GetNpcName( unsigned int nameIdx );
	LPCTSTR		GetMonsterName( unsigned int nameIdx );
	LPCTSTR		GetGatheringName( unsigned int nameIdx );
	LPCTSTR		GetQuestTitle( unsigned int nameIdx );
	LPCTSTR		GetHeroTitle( unsigned int titleIdx );
	LPCTSTR		GetTipText( unsigned int textIdx );
	LPCTSTR		GetMapName( unsigned int nameIdx );
	LPCTSTR		GetMapLoadTexture( unsigned int mapIdx );
	LPCTSTR		GetNpcTarotText( unsigned int textIdx );
	bool		IsMapUseTile( unsigned int mapIdx );
	unsigned long	GetMapFolderIdx( unsigned long mapIdx );


	unsigned long* GetTarotPattern();

	sTextItem*	GetMonsterTalk( unsigned long talkIdx, cBaseObject* mon, cBaseObject* target );

	///   谡 ִ  üũѴ.
	bool				IsCorrelateJob( unsigned long currentJob, unsigned long checkJob );

	/// 
	bool				IsCorrelateMageJob( unsigned long currentJob );

protected:

	/// Game Ǵ  ؽƮ εѴ.
	bool LoadGameText();

	bool LoadPlayerJob();
	bool LoadPlayerJobInfo( cParser& parser );
	bool LoadPlayerJobTree( cParser& parser, unsigned int depth );

	/// Skill ..
	///  ϵ  εȴ.
	bool LoadSkillInfo();

	///   ĳ ⺻  ..
	/// player, npc, monster  kfm
	bool LoadModelFileInfo();

	/// ĳ ⺻  nif..
	bool LoadCharacterBaseFileInfo();

	/// ĳ   ( / ؽ)
	bool LoadCharacterBaseHairFileInfo();
	bool LoadHair( cParser& parser );

	bool LoadMapInfo();
	bool LoadFaceEmotionInfo();

	bool LoadTarotDramaPattern();

	void AddRaceTree( unsigned char race, unsigned long jobIdx );

	///  ͸ ε Ұ쿡 Ϸ  .
	void RemovePlayerJobInfo();
	void RemoveAllModelFileName();
	void RemoveAllCharacterBaseFileInfo();

protected:
	static DWORD WINAPI LoadIntroStageInit( void* ptr );
	static DWORD WINAPI LoadLoginStageInit( void* ptr );
	static DWORD WINAPI LoadServerStageInit( void* ptr );

	DWORD	IntroLoadThread();
	DWORD	LoginLoadThread();
	DWORD	ServerLoadThread();

protected:

	HANDLE			mDataLoadThread;
	unsigned int	mDataLoadFlag;

	//////////////////////////////////////////////////////////////////////////
	// text 
	cUIText*	mpGameText;
	cUIText*	mpCategoryName;

	cUIText*	mpItemToolTipText;

	cUIText*	mpTarotCardText;
	cUIText*	mpCardBookText;

	cUIText*	mpSkillNameText;
	cUIText*	mpSkillToolTipText;

	cUIText*	mpNpcNameText;
	cUIText*	mpMonsterNameText;
	cUIText*	mpGatheringNameText;

	cUIText*	mpQuestTitleText;

	cUIText*	mpMapNameText;

	cUIText*	mpEmotionFilterText;

	/// ȣĪ ؽƮ
	cUIText*	mpTitleText;

	///   ؽƮ
	cUIText*	mpTipText;

	/// npc Ÿ  ؽƮ
	cUIText*	mpNpcTarotText;


	/// 
	cUIFuncText*	mpMonsterNote;
	sTextItem*		mTextItem;

	//////////////////////////////////////////////////////////////////////////
	//     ڷᱸ..
	typedef tPointerHashMap<unsigned long, void*>	cArrayHashMap;
	typedef tArray<void*>							cFileNameArray;
	typedef tArray<unsigned long>					cJobIndexArray;

	///  
	cArrayHashMap			mJobInfoMap;
	///  key ϴ   Ʈ ش.
	cArrayHashMap			mJobTree;	
	///  key ϴ   Ʈ ش.
	cArrayHashMap			mRaceTree;

	/// Item  3Dϸ..
	//cArrayHashMap			mItemFileMap;

	/// kfm ( NiString  )
	cArrayHashMap			mModelFileNameMap;

	/// Ӹ 
	cArrayHashMap			mDefaultHairFileNameMap;

	///  
	cArrayHashMap			mDefaultFaceFileNameMap;

	/// ε ->      1  ´.
	cArrayHashMap			mDefaultWearFileNameMap;

	cArrayHashMap			mMapInfoMap;

	cArrayHashMap			mTarotDramaPattern;

	cArrayHashMap			mFaceEmotionMap;
	unsigned int			mBaseFaceCount;

	///
	//////////////////////////////////////////////////////////////////////////


	//////////////////////////////////////////////////////////////////////////
	/// Loading μ  ڷᱸ..(εؾҰ͵..)

	/// ʿ ؽ ϵ
	NiTPrimitiveQueue<char*>*		mpMapTextureFileQueue;

	/// ü ϵ
	NiTPrimitiveQueue<char*>*		mpObjectFileQueue;

	///  ϵ
	NiTPrimitiveQueue<char*>*		mpModelFileQueue;

	///  ϵ
	NiTPrimitiveQueue<char*>*		mpSoundFileQueue;

	///
	//////////////////////////////////////////////////////////////////////////


	/// 070115 PKH  
	cStatusCalc_Client*	mpStatusCalc;
	cStatusScript*		mpStatusScript;

	/// 070130 PKH 
	cMonsterScript*		mpMonsterScript;

	/// NPC
	cNPCScript*			mpNpcScript;

	/// 070515 PKH  ̺
	cLevelScript*		mpLevelScript;

	/// 070615 PKH 
	cSkillScript*		mpSkillScript;

	cMakeSkillScript*	mpMakeSkillScript;

	///
	cCommunityScript*	mpCommunityScript;

	/// 
	cStageScript*		mpStageScript;

	///
	cTotemScript*		mpTotemScript;

	///
	cPvPScript*			mpPVPScript;

	/// ä ũƮ
	cGatheringScript*	mpGatheringScript;

	/// 
	cVehicleScript*		mpVehicleScript;
};

#define GAMERESOURCEMAN	cGameResourceManager::mpGameResourceManager
