#include "stdafx.h"
#include "GameStage.h"
#include "StageManager.h"

#include "Application.h"
#include "UIManager.h"
#include "MouseAgent.h"
#include "KeyboardAgent.h"

#include "CameraManager.h"
#include "ObjectManager.h"
#include "WorldManager.h"
#include "ItemManager.h"

#include "SkillExecuter.h"
#include "SkillManager.h"
#include "CommunityScript.h"
#include "ChatManager.h"
#include "PartyManager.h"
#include "ItemMixManager.h"

#include "GameUIManager.h"
#include "UIMsgboxEvent.h"
#include "UIID.h"

#include "Npc.h"
#include "Monster.h"
#include "Hero.h"

#include "MsgBox.h"
#include "FriendWindow.h"
#include "SmallMiniMapWindow.h"
#include "MiniMapWindow.h"
#include "TarotManager.h"
#include "TarotWindow.h"
#include "TarotControlWindow.h"
#include "InventoryWindow.h"
#include "NumberEditBox.h"
#include "CastingBar.h"
#include "WareHouseWindow.h"
#include "MoneyWindow.h"
#include "NpcWindow.h"
#include "RevivalWindow.h"
#include "MenuWindow.h"
#include "SkillWindow.h"
#include "UserSellWindow.h"
#include "ItemMsgWindow.h"
#include "ItemCountWindow.h"
#include "PutCardWindow.h"
#include "CardBookWindow.h"
#include "HeroInfoWindow.h"
#include "SocialWindow.h"
#include "LootingWindow.h"
#include "ChatWindow.h"
#include "TodayWordWindow.h"

#include "Skill_Common.h"
#include "Npc_Common.h"
#include "Quest_Common.h"
#include "Cheat_Common.h"
#include "Totem_Common.h"
#include "Gathering_Common.h"

#include "SkillStoreWindow.h"
#include "QuickManager.h"
#include "SceneManager.h"
#include "PartyManager.h"
#include "QuestManager.h"
#include "CheatManager.h"
#include "TitleManager.h"
#include "GuildManager.h"
#include "TipManager.h"

#include "UICursor.h"
#include "ChatBubble.h"

#include "NpcRewardWindow.h"
#include "ExitWindow.h"
#include "ObjectNameCard.h"
#include "Duel_Common.h"
#include "DuelManager.h"
#include "PVPManager.h"
#include "DMMsgWindow.h"
#include "GuildWindow.h"

// ̵
#include "Protocol_Cheat.h"

#include "rendersystem.h"

cGameStage::cGameStage()
: mpUI(0)
, mpDuelManager(0)
{
}

cGameStage::~cGameStage()
{
}

void cGameStage::Init( cStageManager* pStageManager )
{
	mpStageManager = pStageManager;
}

void cGameStage::InitStage()
{
	if( mInit ) return;

	/// UI
	mpUI = new cGameUIManager;
	mpUI->Init();

	mpDuelManager = new cDuelManager;

	mInit = true;
}

void cGameStage::Exit()
{
	/// UI
	SAFE_DELETE(mpDuelManager);
	SAFE_EXIT_DELETE( mpUI );

	mpStageManager = NULL;
}

void cGameStage::Open()
{
	RENDERSYS->SetWorldRendering( true );

	CAMERAMAN->Open();
	WORLDMAN->Open();

#ifdef NOCONNECT_SERVER
	OBJECTMANAGER->AddHero();
#endif

	OBJECTMANAGER->Open();
	SKILLMAN->Open();
	ITEMMAN->Open();

	/// UI
	mpUI->Open();
	mpDuelManager->Open();

	PVPMAN->Open();
}

void cGameStage::Close()
{
	///    Ұ
	PARTYMAN->Close();

	PVPMAN->Close();

	/// UI
	mpUI->Close();

	ITEMMAN->Close();
	SKILLMAN->Close();
	OBJECTMANAGER->Close();
	QUESTMAN->Close();
	TITLEMAN->Close();
	GUILDMAN->Close();
	ITEMMIXMAN->Close();

	OBJECTMAN->ClearHeroData();
	SCENEMAN->Clear();
}

void cGameStage::Process( unsigned long deltaTime, unsigned long accumTime )
{
	/// duel manager
	mpDuelManager->Process( deltaTime );

	///
	TIPMAN->Process( accumTime );

	/// UI
	mpUI->Process( deltaTime, accumTime );
}

void cGameStage::ProcessLButtonClick( cMouseAgent* pMouse )
{
	assert(pMouse);
	if( HERO == 0 || 
		HERO->GetState() == eOBJECT_STATE_DIE )
	{
		return;
	}

	/// npcȭ ..
	if( UIMAN->IsShowNpcBack() == true )
		return;

	int mouseX = pMouse->GetMouseEventX();
	int mouseY = pMouse->GetMouseEventY();

	if( SKILLEXECUTER->IsFieldSkillCharge() == true )
	{
		NiPoint3 pos;
		if( WORLDMAN->Pick( &pos, mouseX, mouseY ) == false )
		{
			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
			return;
		}
		if( WORLDMAN->EnableMove( mouseX, mouseY) == false )
		{
			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
			return;
		}

		if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) == false )
			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
		else
			SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), pos );

		return;
	}

	/// ̺κ  忡  üũϽÿ!!
#ifdef _GMTOOL
	if( pMouse->ControlPressed() == true )
	{
		NiPoint3 pos;
		if( WORLDMAN->Pick( &pos, mouseX, mouseY ) == false )
			return;

		if( NETWORK->IsConnected() == true )
		{
			MSG_REQ_MOVE Msg;
			Msg.Category = NM_CHEAT;
			Msg.Protocol = NM_CHEAT_TELEPORT_REQ;
			Msg.destX = pos.x;
			Msg.destY = pos.y;

			NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
		}

		if( WORLDMAN == 0 )
		{
			assert(0);
			return;
		}

		/// ̰ 
		if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) )
		{
			HERO->SetState( eOBJECT_STATE_IDLE );
			HERO->SetPos( pos );
		}
		else
		{
			assert(0);
			return;
		}

		return;
	}
#endif

	if( SKILLMAN->ProcessLButtonClick( mouseX, mouseY ) == false )
	{
		if( OBJECTMAN->ProcessLButtonClick( mouseX, mouseY ) == false )
		{
			/// Hero ̵ ó..
			OBJECTMAN->HeroGoto( mouseX, mouseY );
		}
	}
}

void cGameStage::ProcessLButtonDClick( cMouseAgent* pMouse )
{
	assert(pMouse);
	if( HERO == 0 || 
		HERO->GetState() == eOBJECT_STATE_DIE )
	{
		return;
	}

	/// npcȭ ..
	if( UIMAN->IsShowNpcBack() == true )
		return;

	int mouseX = pMouse->GetMouseEventX();
	int mouseY = pMouse->GetMouseEventY();

	if( SKILLMAN->ProcessLButtonDClick( mouseX, mouseY ) == false )
	{
		OBJECTMAN->ProcessLButtonDClick( mouseX, mouseY );
	}
}

void cGameStage::ProcessRButtonUp( cMouseAgent* pMouse )
{
	assert(pMouse);
	if( HERO == 0 || 
		HERO->GetState() == eOBJECT_STATE_DIE )
	{
		return;
	}

	/// npcȭ ..
	if( UIMAN->IsShowNpcBack() == true )
		return;

	int mouseX = pMouse->GetMouseEventX();
	int mouseY = pMouse->GetMouseEventY();

	OBJECTMAN->ProcessRButtonUp( mouseX, mouseY );
}


static unsigned long mMouseOverTime = 0;
void cGameStage::ProcessMouseover( unsigned long time, cMouseAgent* pMouse )
{
	/// npcȭ ..
	if( UIMAN->IsShowNpcBack() == true )
		return;

	assert(pMouse);
	int mouseX = pMouse->GetMouseX();
	int mouseY = pMouse->GetMouseY();

	if( SKILLEXECUTER->IsFieldSkillCharge() == true )
	{
		mMouseOverTime = 0;

		if( WORLDMAN->EnableMove( mouseX, mouseY) == false )
		{
			/// cursor X
			CURSOR->SetCursor( eCURSOR_MOVESTOP );
			return;
		}

		NiPoint3 pos;
		if( WORLDMAN->Pick( &pos, mouseX, mouseY ) == false )
			return;
		if( WORLDMAN->CalcHeight(&pos.z, pos.x, pos.y) == false )
			return;

		if( (HERO->GetPos() - pos).Length() > SKILLEXECUTER->GetChargeSkillRange() )
		{
			/// cursor X
			CURSOR->SetCursor( eCURSOR_MOVESTOP );
			return;
		}

		HERO->UpdateFieldTargetEffect( pos );

		CURSOR->SetCursor( eCURSOR_MAX );

		return;
	}

	if( mMouseOverTime > 200 )
	{
		mMouseOverTime = 0;

		if( OBJECTMAN->ProcessMouseOver( mouseX, mouseY ) == false )
		{
			/// navifield check
			if( WORLDMAN->EnableMove( mouseX, mouseY ) == false )
				CURSOR->SetCursor( eCURSOR_MOVESTOP );
			else
				CURSOR->SetCursor( eCURSOR_DEFAULT );
		}
	}
	else
	{
		mMouseOverTime += time;
	}
}

void cGameStage::ProcessKeyUpDown( unsigned long time, cKeyboardAgent* pKeyboard )
{
	if( pKeyboard->GetKeyPressed(KEY_CONTROL) )
	{
/*
		if( pKeyboard->GetKeyDown(KEY_V) )
		{
			/// â ̱/Ⱥ̱
			mpUI->ToggleGameUI();
			//SCENEMAN->SetScreenShotMode( !SCENEMAN->IsScreenShotMode() );
			return;
		}
*/
		if( pKeyboard->GetKeyDown( KEY_TAB ) )
		{
			mpUI->ShowGameUI();
			HERO->CheckTabPartyObject();
			return;
		}

//		if( pKeyboard->GetKeyDown( KEY_K ) )
//		{
//			HERO->RideVehicle();
//		}


#ifdef _GMTOOL
		if( pKeyboard->GetKeyDown(KEY_B) )
		{
			if( CAMERAMAN->GetCurrentIdx() == 0 )
			{
				NiPoint3 pos = CAMERAMAN->GetCurrentCameraPos();
				CAMERAMAN->ChangeCamera(2);
				CAMERAMAN->GetCurrent()->SetTranslate( pos );
			}
			else
				CAMERAMAN->ChangeCamera(0);
			return;
		}
#endif
	}

#ifdef _GMTOOL
	if( pKeyboard->GetKeyDown( KEY_W ) || pKeyboard->GetKeyDown( KEY_A ) ||
		pKeyboard->GetKeyDown( KEY_S ) || pKeyboard->GetKeyDown( KEY_D ) )
	{
		if( CAMERAMAN->GetCurrentIdx() != 0 )
			return;
	}
#endif

	if( UIMAN->IsShowNpcBack() == true )
	{
		/// Ÿ̸ 
		if( TAROTMAN->IsUsingTarot() )
			return;

		/// npc忡 Ű ó  Ѵ...
		if( pKeyboard->GetKeyDown(KEY_ESCAPE) )
		{
			UIMAN->Close();
		}
		return;
	}

	if( mpUI->IsShowCardBook() == true )
	{
		if( pKeyboard->GetKeyDown(KEY_ESCAPE) )
		{
			UIMAN->Close();
		}
		else if( pKeyboard->GetKeyDown( KEY_I ) )
		{
			/// κ丮â
			mpUI->ShowGameUI();
			mpUI->ToggleInventoryWindow();
		}
		else if( pKeyboard->GetKeyDown(KEY_RETURN) )
		{
			/// äâ Ŀ ش.
			mpUI->OnFocusChatWindow( KEY_RETURN );
		}
		else if( pKeyboard->GetKeyDown( KEY_B ) )
		{
			mpUI->ShowGameUI();
			mpUI->ToggleCardBookWindow();
		}
		return;
	}

	if( pKeyboard->GetKeyDown(KEY_ESCAPE) )
	{
		/// Ÿ̸ 
		if( TAROTMAN->IsUsingTarot() )
		{
			return;
		}
		if( SKILLEXECUTER->IsSkillCharge() ) 
		{
			/// ų  ̶ ...
			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
			return;
		}
		if( UIMAN->Close() )
		{
			/// â ʴ ݱ...
			return;
		}
		if( HERO->GetState() == ePLAYER_STATE_GATHERING && HERO->GatheringCancel() == true )
		{
			return;
		}
		if( SKILLEXECUTER->GetCurrentHeroSkillObject() )
		{
			cSkillObject* p = SKILLEXECUTER->GetCurrentHeroSkillObject();
			if( p->GetDramaState() == eDRAMASTATE_CASTING )
			{
				cCastingBar* pWin = (cCastingBar*)UIMAN->GetContainer( eUIID_GAME_CASTINGBAR );
				if( pWin )
				{
					if( pWin->GetPercent() < 98.0f )
					{
						/// cast stop
						p->WaitCancel();
						pWin->Hide();
						HERO->SetState( eOBJECT_STATE_IDLE );

						/// 070712 PKH ų û ޼ ߼
						MSG_REQ_SKILL_CAST_CANCEL Msg;
						Msg.Category = NM_SKILL;
						Msg.Protocol = NM_SKILL_CAST_CANCEL_REQ;
						Msg.mAttacker.index = HERO->GetObjectID();
						Msg.mAttacker.type = HERO->GetObjectType();

						NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
					}
				}
				/// ĳ  Ŷ ..
				SKILLEXECUTER->SetCurrentHeroSkillObject( 0 );
			}
			return;
		}

		//		if( HERO->IsProcessAfterAction() )
		//		{
		//			/// ó ó
		//
		//			return;
		//		}

		if( HERO->GetTargetObject() )
		{
			/// Ÿâ ...
			HERO->SetTargetObject( eOBJECTTYPE_NONE, 0 );
			return;
		}

		/// â ...
		mpUI->ShowExitWindow();
		return;
	}

	if( pKeyboard->GetKeyDown(KEY_RETURN) )
	{
		/// äâ Ŀ ش.
		mpUI->ShowGameUI();
		mpUI->OnFocusChatWindow( KEY_RETURN );
		return;
	}

	/// funcŰ..
	if( pKeyboard->GetKeyDown(KEY_F1) )
	{
		QUICKMAN->OnKeyDown( eKEY_F1 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F2) )
	{
		QUICKMAN->OnKeyDown( eKEY_F2 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F3) )
	{
		QUICKMAN->OnKeyDown( eKEY_F3 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F4) )
	{
		QUICKMAN->OnKeyDown( eKEY_F4 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F5) )
	{
		QUICKMAN->OnKeyDown( eKEY_F5 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F6) )
	{
		QUICKMAN->OnKeyDown( eKEY_F6 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F7) )
	{
		QUICKMAN->OnKeyDown( eKEY_F7 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F8) )
	{
		QUICKMAN->OnKeyDown( eKEY_F8 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F9) )
	{
		QUICKMAN->OnKeyDown( eKEY_F9 );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_F10) )
	{
		QUICKMAN->OnKeyDown( eKEY_F10 );
		return;
	}

	/// UIâ ON/OFF
	if( pKeyboard->GetKeyDown( KEY_O ) )
	{
		/// ɼâ
		mpUI->ShowGameUI();
		mpUI->ToggleOptionWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_G ) )
	{
		/// â
		mpUI->ShowGameUI();
		mpUI->ToggleGuildWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_H ) )
	{
		/// â
		mpUI->ShowGameUI();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_Q ) )
	{
		/// Ʈâ
		mpUI->ShowGameUI();
		mpUI->ToggleQuestWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_J ) )
	{
		mpUI->ShowGameUI();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_S ) )
	{
		/// ųâ
		mpUI->ShowGameUI();
		mpUI->ToggleSkillWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_D ) )
	{
		/// Űâ
		mpUI->ShowGameUI();
		mpUI->ToggleShortenKeyWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_F ) )
	{
		/// ģâ
		mpUI->ShowGameUI();
		mpUI->ToggleFriendWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_I ) )
	{
		/// κ丮â
		mpUI->ShowGameUI();
		mpUI->ToggleInventoryWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_T ) )
	{
		mpUI->ShowGameUI();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_N ) )
	{
		/// â
		mpUI->ShowGameUI();
		mpUI->ToggleNoteWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_M ))
	{
		/// ̴ϸâ
		mpUI->ShowGameUI();
		mpUI->ToggleSmallMiniMapWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_W ))
	{
		/// â
		mpUI->ShowGameUI();
		mpUI->ToggleMiniMapWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_V) )
	{
		/// â ̱/Ⱥ̱
		mpUI->ToggleGameUI();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_C) )
	{
		/// ĳ â
		mpUI->ShowGameUI();
		mpUI->ToggleHeroInfoWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_B) )
	{
		/// ÷Ǻ â
		mpUI->ShowGameUI();
		mpUI->ToggleCardBookWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_P) )
	{
		/// ȸâ
		mpUI->ShowGameUI();
		mpUI->ToggleSocialWindow();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_SLASH ) ) 
	{
		mpUI->OnFocusChatWindow( KEY_SLASH );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_APOSTROPHE ) ) 
	{
		mpUI->OnFocusChatWindow( KEY_APOSTROPHE );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_SEMICOLON ) ) 
	{
		mpUI->OnFocusChatWindow( KEY_SEMICOLON );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_PERIOD ) )
	{
		mpUI->OnFocusChatWindow( KEY_PERIOD );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_SPACE ) )
	{
		/// â ü 
		mpUI->ShowGameUI();
		mpUI->EventLootingSpacebar();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_R ) )
	{
		cChatWindow* win = mpUI->GetChatWindow();
		if( win )
			win->ApplyLastWhisperUser();
		return;
	}

	if( pKeyboard->GetKeyPressed(KEY_ALT) )
	{
		/// Ÿ  - HERO
		if( pKeyboard->GetKeyDown( KEY_1 ) )
		{
			if( SKILLEXECUTER->IsSkillCharge() == true )
			{
				/// ų ߵ
				SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), HERO );
			}
			else
			{
				HERO->SetTargetObject( eOBJECTTYPE_HERO, HERO->GetObjectID() );
			}	
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_2 ) )
		{
			cBaseObject* obj = mpUI->GetPartyObject( 0 );
			if( obj )
			{
				if( SKILLEXECUTER->IsSkillCharge() == true )
				{
					/// ų ߵ
					SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), obj );
				}
				else
				{
					/// Ÿ  - Ƽ1
					PARTYMAN->UpdateTarget( 0 );
				}
			}
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_3 ) )
		{
			cBaseObject* obj = mpUI->GetPartyObject( 1 );
			if( obj )
			{
				if( SKILLEXECUTER->IsSkillCharge() == true )
				{
					/// ų ߵ
					SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), obj );
				}
				else
				{
					/// Ÿ  - Ƽ1
					PARTYMAN->UpdateTarget( 1 );
				}
			}
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_4 ) )
		{
			cBaseObject* obj = mpUI->GetPartyObject( 2 );
			if( obj )
			{
				if( SKILLEXECUTER->IsSkillCharge() == true )
				{
					/// ų ߵ
					SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), obj );
				}
				else
				{
					/// Ÿ  - Ƽ3
					PARTYMAN->UpdateTarget( 2 );
				}
			}
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_5 ) )
		{
			cBaseObject* obj = mpUI->GetPartyObject( 3 );
			if( obj )
			{
				if( SKILLEXECUTER->IsSkillCharge() == true )
				{
					/// ų ߵ
					SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), obj );
				}
				else
				{
					/// Ÿ  - Ƽ3
					PARTYMAN->UpdateTarget( 3 );
				}
			}
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_6 ) )
		{
			cBaseObject* obj = mpUI->GetPartyObject( 4 );
			if( obj )
			{
				if( SKILLEXECUTER->IsSkillCharge() == true )
				{
					/// ų ߵ
					SKILLEXECUTER->ExecuteSkill( SKILLEXECUTER->GetChargeSkill(), obj );
				}
				else
				{
					/// Ÿ  - Ƽ3
					PARTYMAN->UpdateTarget( 4 );
				}
			}
			return;
		}
	}

	if( pKeyboard->GetKeyPressed(KEY_SHIFT) )
	{
		if( pKeyboard->GetKeyDown( KEY_1 ) )
		{
			mpUI->ChangeTab( 0 );
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_2 ) )
		{
			mpUI->ChangeTab( 1 );
			return;
		}
		else if( pKeyboard->GetKeyDown( KEY_3 ) )
		{
			mpUI->ChangeTab( 2 );
			return;
		}
	}

	/// â ..
	if( pKeyboard->GetKeyDown( KEY_TAB ) )
	{
		mpUI->ShowGameUI();
		HERO->CheckTabTargetObject();
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_OEM_3 ) )
	{
		/// ų ̸  
		if( HERO->IsReadyUseSkill() == false )
		{
			///  Ī ..
			HERO->WaitWeaponSwitch();
			return;
		}
		if( HERO->CheckSwichDelay() )
			return;

		///  Ⱑ ϳ  
		if( !ITEMMAN->IsEquipWeapon() )
			return;

		/// ̹ ⺯ û̸ 
		if( HERO->IsWeaponChanging() == true )
			return;

		if( ITEMMAN->TryToSwitchWeapon() )
			HERO->SetWeaponChangeFlag( true );

		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_1 ) )
	{
		QUICKMAN->OnKeyDown( eKEY_1 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_2 ) )
	{
		QUICKMAN->OnKeyDown( eKEY_2 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_3 ) )
	{
		QUICKMAN->OnKeyDown( eKEY_3 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_4 ) )
	{
		QUICKMAN->OnKeyDown( eKEY_4 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_5 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_5 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_6 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_6 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_7 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_7 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_8 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_8 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_9 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_9 );
		return;
	}
	else if( pKeyboard->GetKeyDown( KEY_0 ) )
	{
		///
		QUICKMAN->OnKeyDown( eKEY_0 );
		return;
	}

	/// ĳ  ..
	if( pKeyboard->GetKeyDown(KEY_E) )
	{
		///   ..
		mpUI->ShowGameUI();
		mpUI->ChangeTab();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_A) )
	{
		HERO->SetWaitMoveFlag( false );

		if( SKILLEXECUTER->IsSkillCharge() )
		{
			SKILLEXECUTER->ChargeOff( SKILLEXECUTER->GetChargeSkill() );
			return;
		}

		/// 
		if( HERO->GetState() != eOBJECT_STATE_ATTACK )
			SKILLEXECUTER->ExecuteAttack( HERO->GetTargetObject() );
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_Z) )
	{
		/// / ȯ
		HERO->ToggleIdleFlag();
		return;
	}
	else if( pKeyboard->GetKeyDown(KEY_X) )
	{
		HERO->ToggleSitDown();
		return;
	}

	cBaseStage::ProcessKeyUpDown( time, pKeyboard );
}

void cGameStage::NetworkMsgParser( unsigned long /*connectionindex*/, char* pMsg, unsigned long length )
{
	MSGROOT* pTemMsg = (MSGROOT*)pMsg;
	switch( pTemMsg->Category )
	{
	case NM_NPC:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_NPC_LIST_RES:
				{
					// ̴ϸʿ ߰ 
					cSmallMiniMapWindow* pSmall = mpUI->GetSmallMinimapWindow();
					cMiniMapWindow* pWide = mpUI->GetMinimapWindow();
					if( pSmall && pWide )
					{
						MSG_NPC_INFO* msg = (MSG_NPC_INFO*)pMsg;
						for( unsigned int i = 0; i < msg->mCount; ++i )
						{
							pSmall->AddNpc( &msg->mNpcInfo[i], true );
							pWide->AddNpc( &msg->mNpcInfo[i], false);
						}	
					}
					else
					{
						assert(0);
					}
				}
				break;
			case NM_NPC_SIGHT_IN_RES:
				{
					Msg_NpcGenerateInfo( pTemMsg );
				}
				break;
			case NM_NPC_SIGHT_OUT_RES:
				{
					MSG_NPCIDX* msg = (MSG_NPCIDX*)pMsg;
					OBJECTMANAGER->RemoveNpc( msg->mNpcIdx );
				}
				break;
			case NM_NPC_OPEN_RES:
				{
					MSG_RES_NPC_OPEN* pmsg = (MSG_RES_NPC_OPEN*)pMsg;
					if( pmsg->ErrorCode == ERROR_NPC_OPEN_SUCCESS )
					{
						// 
						cNpc* pNpc = (cNpc*)OBJECTMAN->GetNpc( pmsg->mNpcIdx );
						if( pNpc == 0 )
						{
							assert(0);
							return;
						}

						mpUI->ShowGameUI();
						HERO->StartNpcTalk( pmsg->mNpcIdx );
						mpUI->ShowNpcWindow( pNpc->GetClassId(), pmsg->mNpcIdx, pNpc->GetName() );
					}
					else
					{
						/// Ÿ  - ǥ 
						if( ERROR_NPC_OPEN_RANGE == pmsg->ErrorCode )
							HERO->FixPos( pmsg->mPosX, pmsg->mPosY );

						/// ȭ npc ٽ ȭû 
						switch( pmsg->ErrorCode )
						{
						case ERROR_NPC_OPEN_ALREADY:
							{
								UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_NONE, 
									GAMERESOURCEMAN->GetGameText( 431 ),
									GAMERESOURCEMAN->GetGameText( 301 ),
									eSKIN_OK
									);
							}
							break;
						case ERROR_NPC_OPEN_RANGE:
							{
								UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_NONE, 
									GAMERESOURCEMAN->GetGameText( 432 ),
									GAMERESOURCEMAN->GetGameText( 301 ),
									eSKIN_OK
									);
							}
							break;
						default:
							{
								UIMAN->CreateModal(	eStage_Game,
									eMBEVENT_NONE, 
									GAMERESOURCEMAN->GetGameText( 420 ),
									GAMERESOURCEMAN->GetGameText( 301 ),
									eSKIN_OK
									);
							}
						}
					}

					CURSOR->SetCursor( eCURSOR_DEFAULT );
				}
				break;
			case NM_NPC_OPEN_SYN:
				{
					MSG_SYN_NPC_OPEN* pmsg = (MSG_SYN_NPC_OPEN*)pMsg;

					cPlayer* pPlayer = OBJECTMAN->GetPlayer( pmsg->mCharacterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->FixPos( pmsg->mPosX, pmsg->mPosY );

						if( pPlayer->IsTransformMonster() )
							pPlayer->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
						else
							pPlayer->ChangeAnimation( ANITYPE_IDLE );

						pPlayer->SetStopFlag( eSTOP_NPCSPEECH );
						pPlayer->SetState( eOBJECT_STATE_STOP );	
					}
				}
				break;
			case NM_NPC_SKILL_ADD_ERR_RES:
				{
					MSG_ERROR* pResMsg = (MSG_ERROR*)pMsg;

					switch( pResMsg->ErrorCode )
					{
					case SKILL_ADD_ERR_MONEY:
						{
							/// ݾ 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6100 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_SP:
						{
							/// skill point 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6101 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_JOBSP:
						{
							///   ųƮ  
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6110 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_SKILLSTEP:
						{
							/// ų  ܰ 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6103 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_LEARNSKILL:
						{
							///   ų 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6104 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_LEARNSTEP:
						{
							///   ų ܰ 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6105 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_RACE:
						{
							///  
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6106 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_JOB:
						{
							///  
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6107 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_LEVEL:
						{
							///  
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6108 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_ALREADY:
						{
							/// ̹  ų ٽ 
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6109 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					case SKILL_ADD_ERR_NPC:
						{
							UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 420 ),
								GAMERESOURCEMAN->GetGameText( 301 ),
								eSKIN_OK
								);
						}
						break;
					default:
						{
							/// ׿  
							UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
								GAMERESOURCEMAN->GetGameText( 6102 ),
								GAMERESOURCEMAN->GetGameText( 301 ),	
								eSKIN_OK
								);
						}
						break;
					}

					cSkillStoreWindow* win = mpUI->GetSkillStoreWindow();
					if( win )
						win->NetUnLock();
				}
				break;
			case NM_NPC_SKILL_ADD_SUC_RES:
				{
					MSG_RES_NPC_SKILL_ADD* pResMsg = (MSG_RES_NPC_SKILL_ADD*)pMsg;

					cSkillStoreWindow* win = mpUI->GetSkillStoreWindow();
					if( win )
						win->NetUnLock();

					if( SKILLMAN->GetKeepInfo( pResMsg->mSkillClassIdx ) == 0 )
					{
						/// add
						SKILLMAN->AddKeepSkill( pResMsg->mSkillClassIdx, pResMsg->mSkillStep );
					}
					else
					{
						/// update
						SKILLMAN->UpdateSkillStep( pResMsg->mSkillClassIdx, pResMsg->mSkillStep );
					}

					/// 071024 PKH ͽ 
					HERO->CalcStatus();

					/// skill store 
					mpUI->UpdataSkillStorWindow();
					/// Ʈ ߰
					NiTransform trans;
					trans.MakeIdentity();
					trans.m_Translate = NiPoint3( 0.0f, 0.0f, 30.0f );

					HERO->SetLinkdEffect( eLINK_HEAD, "./Data/Effect/Eff_PC_Get_01.nif", &trans, false, false );
				}
				break;
			case NM_NPC_ITEM_MOV2_INVENTORY_RES:
				{
					MSG_RES_NPC_ITEM_MOV2_INVENTORY* msgData = (MSG_RES_NPC_ITEM_MOV2_INVENTORY*)pMsg;

					switch( msgData->ErrorCode )
					{
					case ERROR_ITEM_MOV2_INVENTORY_SUCCESS:
						{
							if( msgData->RowCount == 1 )
								ITEMMAN->NpcNetTryItem( NM_NPC_ITEM_MOV2_INVENTORY_RES );
							else if( msgData->RowCount == 2 )
								ITEMMAN->NpcNetTryItem( NM_NPC_ITEM_MOV2_INVENTORY_RES, msgData );
						}
						break;
					case ERROR_ITEM_MOV2_INVENTORY_MONEY:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 230 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_MOV2_INVENTORY_FAIL:
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 231 ) );
						break;
					case ERROR_ITEM_MOV2_INVENTORY_NOTYET:
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 223 ) );
						break;
					case ERROR_ITEM_MOV2_INVENTORY_NPC:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 420 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					default:
						assert(0);
						break;
					}

					if( ITEMMAN->GetItemTry() == ITEM_TRY_MOVE )
						ITEMMAN->UnlockItemTry( ITEM_TRY_MOVE );
					else if( ITEMMAN->GetItemTry() == ITEM_TRY_SPLIT )
						ITEMMAN->UnlockItemTry( ITEM_TRY_SPLIT );
					else
					{
						assert(0);
					}
				}
				break;
			case NM_NPC_ITEM_BUY_RES:
				{
					MSG_RES_NPC_ITEM_BUY* msgData = (MSG_RES_NPC_ITEM_BUY*)pMsg;

					switch( msgData->ErrorCode )
					{
					case ERROR_ITEM_BUY_SUCCESS:
						ITEMMAN->NpcNetTryItem( NM_NPC_ITEM_BUY_RES, msgData );
						break;
					case ERROR_ITEM_BUY_MONEY:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 200 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_BUY_FAIL:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 232 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_BUY_NOTYET:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 223 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_BUY_NPC:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 420 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					default:
						assert( 0 && "network error!" );
						break;
					}

					ITEMMAN->UnlockItemTry( ITEM_TRY_BUY );

					cUIWindow* store = (cUIWindow*)mpUI->GetNpcStore();
					if( store )
						store->NetUnLock();
				}
				break;
			case NM_NPC_ITEM_SELL_RES:
				{
					MSG_RES_NPC_ITEM_SELL* msgData = (MSG_RES_NPC_ITEM_SELL*)pMsg;

					switch( msgData->ErrorCode )
					{
					case ERROR_ITEM_SELL_SUCCESS:
						ITEMMAN->NpcNetTryItem( NM_NPC_ITEM_SELL_RES, msgData );
						break;
					case ERROR_ITEM_SELL_FAIL:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 233 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_SELL_NOTYET:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 223 ),	
							GAMERESOURCEMAN->GetGameText( 301 ),	 // 
							eSKIN_OK
							);
						break;
					case ERROR_ITEM_SELL_NPC:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 420 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					default:
						assert( 0 && "network error!" );
						break;	
					}

					ITEMMAN->UnlockItemTry( ITEM_TRY_SELL );
				}
				break;
			case NM_NPC_DEPOSIT_RES:
				{
					MSG_RES_NPC_DEPOSIT* msg = (MSG_RES_NPC_DEPOSIT*)pMsg;
					if( msg->ErrorCode == ERROR_NPC_DEPOSIT_FAIL )
					{	
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 55 ) );
					}

					cMoneyWindow* win = mpUI->GetMoneyWindow();
					if( win )
					{
						win->NetUnLock( eMONEY_IN );
					}
					else
					{
						assert(0);
					}
				}
				break;
			case NM_NPC_WITHDRAW_RES:
				{
					MSG_RES_NPC_WITHDRAW* msg = (MSG_RES_NPC_WITHDRAW*)pMsg;
					if( msg->ErrorCode == ERROR_NPC_WITHDRAW_FAIL )
					{	
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 56 ) );
					}

					cMoneyWindow* win = mpUI->GetMoneyWindow();
					assert( win );
					if( win )
					{
						win->NetUnLock( eMONEY_OUT );
					}
				}
				break;
			case NM_NPC_QUESTSTATUS_RES:
				{
					MSG_RES_NPC_QUESTSTATUS* msg = (MSG_RES_NPC_QUESTSTATUS*)pMsg;

					cSmallMiniMapWindow* smini = mpUI->GetSmallMinimapWindow();
					cMiniMapWindow* mini = mpUI->GetMinimapWindow();

					for( unsigned int i = 0; i < msg->rowCount; ++i )
					{
						sNpcQuestStatus& data = msg->table[i];

						cNpc* npc = OBJECTMAN->GetNpc( data.npcIdx );
						if( npc )
							npc->SetQuestStatus( data.status );

						if( smini && mini )	
						{
							smini->SetNpcQuestStatus( data.npcIdx, data.status );
							mini->SetNpcQuestStatus( data.npcIdx, data.status );
						}
					}
				}	
				break;
			case NM_NPC_QUESTLIST_RES:
				{
					/// NPC â  Ʈ ޴´.
					MSG_RES_NPC_QUESTLIST* msg = (MSG_RES_NPC_QUESTLIST*)pMsg;

					cNpcWindow* pNpcWindow = mpUI->GetNpcWindow();
					if( !pNpcWindow )
					{
						assert(0);
						return;
					}

					pNpcWindow->Clear();
					pNpcWindow->ShowDefaultPage();

					if( msg->ErrorCode == ERROR_QUESTLIST_SUCCESS )
					{
						/// Ϸ > ű >   
						// Ϸ 
						QUESTMAN->UpdateNpcQuest( msg->npcId, eNPCQUEST_COMPLETE );

						// ű 
						for( unsigned int i = 0; i < msg->rowCount; ++i )
						{
							unsigned long questIdx = msg->questIdxList[i];
							pNpcWindow->AddQuest( questIdx, eNPCQUEST_NEW );
						}

						//  
						QUESTMAN->UpdateNpcQuest( msg->npcId, eNPCQUEST_PLAYING );
					}
					else
					{
						UIMAN->CreateModal(	eStage_Game, eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 420 ),
							GAMERESOURCEMAN->GetGameText( 301 ),	
							eSKIN_OK
							);

						/// ݱ
						pNpcWindow->Hide();
					}
				}
				break;
			case NM_NPC_QUEST_ADD_RES:
				{
					/// Ʈ ߰  
					MSG_RES_QUEST_ADD* pmsg = (MSG_RES_QUEST_ADD*)pMsg;

					QUESTMAN->ResQuestAdd( pmsg );
				}
				break;
			case NM_NPC_QUEST_COMPLETE_RES:
				{
					/// Ʈ  Ϸ û  
					MSG_RES_NPC_QUEST_COMPLETE* pmsg = (MSG_RES_NPC_QUEST_COMPLETE*)pMsg;

					QUESTMAN->ResQuestComplete( pmsg );
				}
				break;
			case NM_NPC_QUEST_REWARD_RES:
				{
					/// Ʈ û  
					MSG_RES_NPC_QUEST_REWARD* pmsg = (MSG_RES_NPC_QUEST_REWARD*)pMsg;

					QUESTMAN->ResQuestReward( pmsg );
				}
				break;
			case NM_NPC_GUILD_CREATE_RES:
				{
					MSG_RES_NPC_GUILD_CREATE* pmsg = (MSG_RES_NPC_GUILD_CREATE*)pMsg;

					GUILDMAN->ResGuildCreate( pmsg );
				}
				break;
			case NM_NPC_CLOSE_SYN:
				{
					MSG_SYN_NPC_CLOSE* pmsg = (MSG_SYN_NPC_CLOSE*)pMsg;

					cPlayer* pPlayer = OBJECTMAN->GetPlayer( pmsg->mCharacterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->SetState( eOBJECT_STATE_IDLE );
						pPlayer->SetStopFlag( eSTOP_NONE );
					}
				}
				break;
			case NM_NPC_CLOSEFORCE_RES:
				{
					/// ġ ޼    
					///  ݱ 
					UIMAN->HideNpcBackNoMsg();
				}
				break;
			case NM_NPC_TAROT_OPEN_RES:
				{
					MSG_RES_NPC_TAROT_OPEN* pmsg = (MSG_RES_NPC_TAROT_OPEN*)pMsg;
					
					///    ó
					cTarotWindow* win = mpUI->GetTarotWindow();
					if( win )
						win->SetFortuneData( pmsg->fortuneData );

					TAROTMAN->ChangePage( ePAGE_NPCVIEW );
				}
				break;
			case NM_NPC_TAROT_JOIN_RES:
				{
					/// 
					MSG_RES_NPC_TAROT_JOIN* pmsg = (MSG_RES_NPC_TAROT_JOIN*)pMsg;
					
					cTarotWindow* win = mpUI->GetTarotWindow();
					if( win )
						win->NetUnLock( ePAGE_NPCVIEW );

					switch( pmsg->ErrorCode )
					{
					case ERROR_NPC_TAROT_JOIN_SUCESS:
						{
							TAROTMAN->ChangePage( ePAGE_NPCSELECT );
						}
						break;
					case ERROR_NPC_TAROT_JOIN_FAIL:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 334 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					case ERROR_NPC_TAROT_JOIN_MONEY:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 333 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					case ERROR_NPC_TAROT_JOIN_ONCE:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 332 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					}
				}
				break;
			case NM_NPC_TAROT_FORTUNE_RES:
				{
					///  ÿ  
					MSG_RES_NPC_TAROT_FORTUNE* pmsg = (MSG_RES_NPC_TAROT_FORTUNE*)pMsg;

					cTarotWindow* win = mpUI->GetTarotWindow();
					if( win )
						win->NetUnLock( ePAGE_SELECT );

					switch( pmsg->ErrorCode )
					{
					case ERROR_NPC_TAROT_FORTUNE_SUCESS:
						{
							TAROTMAN->ChangePage( ePAGE_NPCRESULT );
						}
						break;
					case ERROR_NPC_TAROT_FORTUNE_FAIL:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 334 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					case ERROR_NPC_TAROT_FORTUNE_ONCE:
						UIMAN->CreateModal(	eStage_Game,
							eMBEVENT_NONE, 
							GAMERESOURCEMAN->GetGameText( 332 ),
							GAMERESOURCEMAN->GetGameText( 301 ),
							eSKIN_OK
							);
						break;
					}
				}
				break;
			}
		}break;
	case NM_MONSTER:
		{
			switch( pTemMsg->Protocol )
			{
				/// 061122 PKH   Ǿִ  Ŭ̾Ʈ ε ޾Ƽ óѴ.
			case NM_MONSTER_SIGHT_IN_RES:
				{
					Msg_MonsterGenerateInfo( pTemMsg );	
				}
				break;
			case NM_MONSTER_REGEN_SYN:
				{
					MSG_MONSTER_INFO* msg = (MSG_MONSTER_INFO*)pMsg;
					OBJECTMANAGER->AddMonster( &msg->mMonsterInfo, true );

				}break;
			case NM_MONSTER_MOVE_SYN:
				{
					MSG_SYN_MOVE_MONSTER* pMessage = (MSG_SYN_MOVE_MONSTER*)pMsg;

					OBJECTMANAGER->MonsterGoto( pMessage->mMonsterIdx, pMessage->mPathArray, 
						pMessage->mCount, pMessage->mMoveSpeed, pMessage->mMoveSpeedType );
				}
				break;
			case NM_MONSTER_ACTIONMOVE_SYN:
				{
					MSG_SYN_ACTIONMOVE_MONSTER* pMessage = (MSG_SYN_ACTIONMOVE_MONSTER*)pMsg;

					OBJECTMANAGER->MonsterGoto( pMessage->mMonsterIdx, pMessage->mPathArray, 
						pMessage->mCount, pMessage->mMoveSpeed, eMOVESPEED_RUN,
						pMessage->mRange, &pMessage->mTarget );
				}
				break;

			case NM_MONSTER_HP_SYN:
				{
					MSG_SYN_MONSTER_HP* msg = (MSG_SYN_MONSTER_HP*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( msg->mMonsterIdx );
					if( pMonster != NULL )
					{
						pMonster->HPChange( msg->mHP, msg->mMaxHP, msg->mDie );
					}
				}break;
			case NM_MONSTER_SIGHT_OUT_RES:
				{
					MSG_MONSTER_SIGHTOUT* msg = (MSG_MONSTER_SIGHTOUT*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( msg->mMonsterIdx );
					if( pMonster == NULL )
					{
						assert(NULL);
						return;
					}

					OBJECTMANAGER->RemoveMonster( msg->mMonsterIdx );

				}break;
			case NM_MONSTER_MOVESPEED_SYN:
				{
					MSG_SYN_MONSTER_MOVESPEED* pSynMsg = (MSG_SYN_MONSTER_MOVESPEED*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster != NULL )
					{
						pMonster->SetMoveSpeed( pSynMsg->mMoveSpeed );
					}
				}
				break;
			case NM_MONSTER_MOVESTOP_SYN:
				{
					MSG_SYN_MONSTER_MOVESTOP* pSynMsg = (MSG_SYN_MONSTER_MOVESTOP*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster != NULL )
					{
						pMonster->MoveStop( pSynMsg->mMonsterPos.x, pSynMsg->mMonsterPos.y );						
					}
				}
				break;
			case NM_MONSTER_MODECHANGE_SYN:
				{
					MSG_SYN_MONSTER_MODECHANGE* pSynMsg = (MSG_SYN_MONSTER_MODECHANGE*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster != NULL )
					{
						pMonster->ChangeMonsterMode( pSynMsg->mModeIdx );
					}
				}
				break;
			case NM_MONSTER_IDLE2_ANI_SYN:
				{
					MSG_SYN_MONSTER_IDLE2ANI* pSynMsg = (MSG_SYN_MONSTER_IDLE2ANI*)pMsg;
					cMonster* pMonster = OBJECTMANAGER->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster != NULL )
					{
						pMonster->PlayIdle2Ani();					
					}
				}
				break;
			case NM_MONSTER_SPEECH_SYN:
				{
					MSG_SYN_MONSTER_SPEECH* pSynMsg = (MSG_SYN_MONSTER_SPEECH*)pMsg;
					cMonster* pMonster = OBJECTMAN->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster )
					{
						cBaseObject* target = OBJECTMAN->GetPlayer( pSynMsg->mCharacterIdx );

						sTextItem* text = GAMERESOURCEMAN->GetMonsterTalk( pSynMsg->mTalkIdx, pMonster, target );
						pMonster->ActiveChatBubble( text );

						if( pSynMsg->mViewType )
						{
							cStringT str;
							str += pMonster->GetName();
							str += _T(" :");

							sTextItem* check = text;
							while( check )
							{
								str += check->mText;
								check = check->mpNext;
							}

							if( pSynMsg->mViewType == eM_TALKVIEW_NORMAL )
							{
								CHATMANAGER->AddChatMsg( str.Cstr(), eCHAT_NORMAL );
							}
							else if( pSynMsg->mViewType == eM_TALKVIEW_SHOUT )
							{
								CHATMANAGER->AddChatMsg( str.Cstr(), eCHAT_SHOUT );
							}
						}
					}
				}
				break;
			case NM_MONSTER_MODESPEECH_SYN:
				{
					MSG_SYN_MOSTER_MODESPEECH* pSynMsg = (MSG_SYN_MOSTER_MODESPEECH*)pMsg;
					cMonster* pMonster = OBJECTMAN->GetMonster( pSynMsg->mMonsterIdx );
					if( pMonster )
					{
						cBaseObject* target = OBJECTMAN->GetPlayer( pSynMsg->mCharacterIdx );
						sTextItem* text = GAMERESOURCEMAN->GetMonsterTalk( pSynMsg->mTalkIdx, pMonster, target );

						cStringT str;
						str += pMonster->GetName();
						str += _T(" :");

						sTextItem* check = text;
						while( check )
						{
							str += check->mText;
							check = check->mpNext;
						}

						CHATMANAGER->AddChatMsg( str.Cstr(), eCHAT_SHOUT );
					}
				}
				break;
			case NM_MONSTER_DESTROY_SYN:
				{
					MSG_SYN_MONSTER_DESTROY* pSynMsg = (MSG_SYN_MONSTER_DESTROY*)pMsg;

					cMonster* monster = OBJECTMAN->GetMonster( pSynMsg->mMonsterIdx );
					if( monster )
					{
						monster->SetState( eOBJECT_STATE_IDLE );
						monster->SetState( eOBJECT_STATE_DIE, false );
					}
				}
				break;
			}
		}break;
	case NM_GATHERING:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_GATHERING_REGEN_SYN:
			case NM_GATHERING_SIGHT_IN_RES:
				{
					MSG_GATHERING_INFO* msg = (MSG_GATHERING_INFO*)pMsg;
					OBJECTMAN->AddGathering( msg->mObjectIdx, msg->mGatheringIdx, NiPoint3( msg->mPosX, msg->mPosY, msg->mAppendZ), msg->mDirection );
				}
				break;
			case NM_GATHERING_DEL_SYN:
			case NM_GATHERING_SIGHT_OUT_RES:
				{
					MSG_GATHERINGIDX* msg = (MSG_GATHERINGIDX*)pMsg;
					OBJECTMAN->RemoveGathering( msg->mObjectIdx );
				}
				break;
			case NM_GATHERING_START_RES:
				{
					MSG_ERROR* msg = (MSG_ERROR*)pMsg;
					if( msg->ErrorCode == ERROR_GATHERING_SUCCESS )
					{
						/// 
					}
					else
					{
						switch( msg->ErrorCode )
						{
						case ERROR_GATHERING_FAIL: CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 601 ) );break;
						case ERROR_GATHERING_LEVEL:CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 602 ) );break;
						case ERROR_GATHERING_ITEM:CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 603 ) );break;
						case ERROR_GATHERING_QUEST:CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 604 ) );break;
						case ERROR_GATHERING_MAKESKILL:CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 601 ) );break;
						default:break;
						}

						HERO->GatheringEnd();
					}
				}
				break;
			case NM_GATHERING_CANCEL_SUCCESS_RES:
				{
					/// 
				}
				break;
			case NM_GATHERING_START_SYN:
				{
					MSG_SYN_GATHERING_START* msg = (MSG_SYN_GATHERING_START*)pMsg;
					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIdx );
					if( player )
					{
						NiPoint3 pos = OBJECTMAN->GetGatherPos( msg->mObjectIdx );
						player->GatheringStart( msg->mObjectIdx, msg->mClassIdx, pos );
					}
				}
				break;
			case NM_GATHERING_CANCEL_SYN:
			case NM_GATHERING_END_SUCCESS_SYN:
				{
					MSG_SYN_GATHERING_END* msg = (MSG_SYN_GATHERING_END*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIdx );
					if( player && (player->GetState() == ePLAYER_STATE_GATHERING) )
						player->GatheringEnd();
				}
				break;
			case NM_GATHERING_END_FAILE_SYN:
				{
					MSG_SYN_GATHERING_END* msg = (MSG_SYN_GATHERING_END*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIdx );
					if( player && (player->GetState() == ePLAYER_STATE_GATHERING) )
						player->GatheringEnd();

					if( HERO == player )
					{
						/// ä  ޼ 
					}
				}
				break;
			}
		}break;
	case NM_PLAYER:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_PLAYER_LIST_RES:
				{
					MSG_PLAYERINFO* pmsg = (MSG_PLAYERINFO*)pMsg;

					/// 070626 PKH ÷̾ Ʈ ε 
					if( pmsg->ErrorCode == 0 )
					{
						OBJECTMANAGER->AddPlayerFromServerMsg( pTemMsg );
					}
					/// 070626 PKH ÷̾ Ʈ ε 
					else 
					{
						assert(NULL);
						return;
					}

				}
				break;
			case NM_PLAYER_GAMEIN_SYN:
				{
					OBJECTMANAGER->AddPlayerFromServerMsg( pTemMsg, true );
				}
				break;
			case NM_PLAYER_GAMEOUT_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;
					if( pmsg->ErrorCode == 0 )
					{
						mpStageManager->ChangeStage( eStage_Select );

						/// äâ Ŭ 
						CHATMANAGER->Clear();
					}
					else
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );
						HERO->SetState( eOBJECT_STATE_IDLE );
					}

					cExitWindow* win = mpUI->GetExitWindow();
					if( win )
						win->NetUnLock();

					cUIWindow* menuOption = mpUI->GetMenuOptionWindow();
					if( menuOption )
						menuOption->NetUnLock();
				}
				break;
			case NM_PLAYER_DISCONNECT_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;

					cExitWindow* win = mpUI->GetExitWindow();
					if( win )
						win->NetUnLock();

					cUIWindow* menuOption = mpUI->GetMenuOptionWindow();
					if( menuOption )
						menuOption->NetUnLock();

					if( pmsg->ErrorCode == 0 )
					{
						/// α׷ 
						::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
						::PostQuitMessage(0);
					}
					else
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );
						HERO->SetState( eOBJECT_STATE_IDLE );
					}
				}
				break;
			case NM_PLAYER_DISCONNECT_SYN:
				{
					MSG_CHARACTERIDX* pmsg = (MSG_CHARACTERIDX*)pMsg;
					OBJECTMANAGER->RemovePlayer( pmsg->mCharacterIdx );
				}
				break;

			case NM_PLAYER_GAMEFINISH_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;
					if( pmsg->ErrorCode == 0 )
					{
						cExitMsgWindow* win = mpUI->GetExitMsgWindow();
						if( win )
						{
							win->NetUnLock();
							win->StartCount();
						}

						HERO->SetState( eOBJECT_STATE_STOP );
						HERO->SetStopFlag( eSTOP_GAMEFINISH );
					}
					else
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );
						cExitMsgWindow* win = mpUI->GetExitMsgWindow();
						if( win )
						{
							win->NetUnLock();
							win->Hide(false);
						}
					}
				}
				break;
			case NM_PLAYER_MOVE_SYN:
				{
					MSG_SYN_MOVE* pmsg = (MSG_SYN_MOVE*)pMsg;
					OBJECTMANAGER->MovePlayer( pmsg->characterIdx, pmsg->destX, pmsg->destY, pmsg->moveSpeed );
				}
				break;
			case NM_PLAYER_MOVE_RES:
			case NM_PLAYER_ACTIONMOVE_RES:	/// Ŷ ̵ Ұ ϶ 
				{
					/// 070625 PKH  ǥ ű
					MSG_RES_ERR_MOVE* pmsg = (MSG_RES_ERR_MOVE*)pMsg;
					NiPoint3 pos = NiPoint3( pmsg->destX, pmsg->destY, 0.0f );
					if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) )
					{
						if( !(HERO->GetState() == eOBJECT_STATE_DIE || HERO->GetState() == eOBJECT_STATE_STOP) )
							HERO->SetState( eOBJECT_STATE_IDLE );

						HERO->SetPos( pos );

						TCHAR tempmsg[255] = {0,};
						_stprintf( tempmsg, _T("̵Ұ ") );
						CHATMANAGER->AddSystemMsg(eSYSTEM_NORMAL, tempmsg);
					}
				}
				break;
			case NM_PLAYER_ACTIONMOVE_SYN:
				{
					OBJECTMANAGER->ActionMovePlayer( pTemMsg );
				}
				break;
			case NM_PLAYER_MOVESPEED_SYN:
				{
					MSG_SYN_MOVESPEED* pSynMsg = (MSG_SYN_MOVESPEED*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharacterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->SetMoveSpeed( pSynMsg->moveSpeed );
					}
				}
				break;
			case NM_PLAYER_ATTACKSPEED_SYN:
				{
					MSG_SYN_ATTACKSPEED* pSynMsg = (MSG_SYN_ATTACKSPEED*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharacterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->SetAttackSpeed( pSynMsg->mAttackSpeed );
					}
				}
				break;
			case NM_PLAYER_CANTMOVE_SYN:
				{
					MSG_SYN_PLAYER_CANTMOVE* pSynMsg = (MSG_SYN_PLAYER_CANTMOVE*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharaterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->FixPos( pSynMsg->mCharacterPos.x, pSynMsg->mCharacterPos.y );
						pPlayer->SetCantMove( pSynMsg->mIsCantMove );
						if( pPlayer->GetState() == eOBJECT_STATE_MOVE )
							pPlayer->SetState( eOBJECT_STATE_IDLE );
					}
				}
				break;
			case NM_PLAYER_SLEEP_SYN:
				{
					MSG_SYN_PLAYER_SLEEP* pSynMsg = (MSG_SYN_PLAYER_SLEEP*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharaterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->FixPos( pSynMsg->mCharacterPos.x, pSynMsg->mCharacterPos.y );
						pPlayer->SetSleep( pSynMsg->mIsSleep );
						if( pPlayer->GetState() == eOBJECT_STATE_MOVE )
							pPlayer->SetState( eOBJECT_STATE_IDLE );
					}
				}
				break;
			case NM_PLAYER_STUN_SYN:
				{
					MSG_SYN_PLAYER_STUN* pSynMsg = (MSG_SYN_PLAYER_STUN*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharaterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->FixPos( pSynMsg->mCharacterPos.x, pSynMsg->mCharacterPos.y );
						pPlayer->SetStun( pSynMsg->mIsStun );
						if( pPlayer->GetState() == eOBJECT_STATE_MOVE )
							pPlayer->SetState( eOBJECT_STATE_IDLE );
					}
				}
				break;
			case NM_PLAYER_CANTSKILL_SYN:
				{
					MSG_SYN_PLAYER_CANTSKILL* pSynMsg = (MSG_SYN_PLAYER_CANTSKILL*)pMsg;
					if( HERO != NULL )
						HERO->SetCantSkill( pSynMsg->mIsCantSkill );
				}
				break;
			case NM_PLAYER_SCALE_SYN:
				{
					MSG_SYN_PLAYER_SIZE* pSynMsg = (MSG_SYN_PLAYER_SIZE*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharacterIdx );
					if( pPlayer != NULL )
					{
						pPlayer->SetFixedObjectSizeScale( pSynMsg->mScale );
					}
				}
				break;
			case NM_PLAYER_CHG_MONSTER_SYN:
				{
					MSG_SYN_PLAYER_CHG_MONSTER* pSynMsg = (MSG_SYN_PLAYER_CHG_MONSTER*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharacterIdx );
					if( pPlayer == 0 )
						return;

					/// target effect change
					bool reTarget = false;
					if( HERO->GetTargetObject() == pPlayer )
					{
						reTarget = true;
						HERO->SetTargetObject( eOBJECTTYPE_NONE, 0 );
					}

					if( pSynMsg->mMonsterIdx == 0 )
					{
						if( pPlayer->GetState() == eOBJECT_STATE_ATTACK || pPlayer->IsReadyUseSkill() == false )
							pPlayer->ReadyRestoreMonster();
						else
							pPlayer->RestoreMonster();
					}
					else
					{
						if( pPlayer->IsRideVehicle() == true )
						{
							pPlayer->AlightVehicle();
						}

						pPlayer->TransformMonster( pSynMsg->mMonsterIdx );
					}

					/// target effect change
					if( reTarget )
					{
						HERO->SetTargetObject( pPlayer->GetObjectType(), pPlayer->GetObjectID() );
					}
				}
				break;
			case NM_PLAYER_VEHICLE_SYN:
				{
					MSG_SYN_PLAYER_VEHICLE* pSynMsg = (MSG_SYN_PLAYER_VEHICLE*)pMsg;
					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pSynMsg->mCharacterIdx );
					if( pPlayer == 0 )
						return;

					/// target effect change
					bool reTarget = false;
					if( HERO->GetTargetObject() == pPlayer )
					{
						reTarget = true;
						HERO->SetTargetObject( eOBJECTTYPE_NONE, 0 );
					}

					if( pSynMsg->mVehicleIdx == 0 )
					{
						pPlayer->AlightVehicle();
					}
					else
					{
						pPlayer->RideVehicle( pSynMsg->mVehicleIdx );
					}

					/// target effect change
					if( reTarget )
					{
						HERO->SetTargetObject( pPlayer->GetObjectType(), pPlayer->GetObjectID() );
					}
				}
				break;
			case NM_PLAYER_EQUIP_WEAR_RES:
				{
					MSG_RES_PLAYER_EQUIP_WEAR* pmsg = (MSG_RES_PLAYER_EQUIP_WEAR*)pMsg;

					HERO->EquipWearInfo( (eWEAR_TYPE)pmsg->mType, pmsg->mWearInfo );
					HERO->CalcStatus();

				}
				break;
			case NM_PLAYER_EQUIP_WEAR_SYN:
				{
					MSG_SYN_PLAYER_EQUIP_WEAR* pmsg = (MSG_SYN_PLAYER_EQUIP_WEAR*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pmsg->mCharacterIdx );
					if( pPlayer )
						pPlayer->EquipWearInfo( (eWEAR_TYPE)pmsg->mType, pmsg->mWearInfo );
				}
				break;
			case NM_PLAYER_EQUIP_WEAPON_RES:
				{
					MSG_RES_PLAYER_EQUIP_WEAPON* pmsg = (MSG_RES_PLAYER_EQUIP_WEAPON*)pMsg;

					HERO->EquipWeaponInfo( (eWEAPON_STATE)pmsg->mWeaponState, &pmsg->mWeaponInfo );

					///  
					QUICKMAN->ChangeTabFS( ITEMMAN->GetActiveWeapon() );

					///  ų ˻
					QUICKMAN->CheckSkillIcon();
				}
				break;
			case NM_PLAYER_EQUIP_WEAPON_SYN:
				{
					MSG_SYN_PLAYER_EQUIP_WEAPON* pmsg = (MSG_SYN_PLAYER_EQUIP_WEAPON*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( pmsg->mCharacterIdx );
					if( pPlayer )
						pPlayer->EquipWeaponInfo( (eWEAPON_STATE)pmsg->mWeaponState, &pmsg->mWeaponInfo );
				}
				break;
			case NM_PLAYER_MAPCHANGE_RES:
				{
					/// ̵ / ó
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;
					if( pmsg->ErrorCode == 0 )
					{
						///  ޼ڽ 
						UIMAN->CloseAllMsgBox( false );

						Msg_MapChangeAck( (MSGROOT*)pMsg );
					}
					else
					{
						UIMAN->ModalEventFromGameSystem( false );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 98 ) );
					}
				}
				break;
			case NM_PLAYER_MONEY_RES:
				{
					MSG_RES_PLAYER_MONEY* msg = (MSG_RES_PLAYER_MONEY*)pMsg;

					/// ߸ Ͱ  ˻
					HERO->SetMoney( msg->mMoney );

					///  ݾ 
					cStringT str;

					LPCTSTR addMoney = 0;
					if( msg->mAddMoney < 0 )
					{
						addMoney = cNumberEditBox::FormatNumber( (-msg->mAddMoney) );
						str.Format( GAMERESOURCEMAN->GetGameText( 54 ), addMoney );
					}
					else if( msg->mAddMoney > 0 )
					{
						addMoney = cNumberEditBox::FormatNumber( msg->mAddMoney );
						str.Format( GAMERESOURCEMAN->GetGameText( 53 ), addMoney );

						if( msg->mObjectType == eOBJECTTYPE_MONSTER || msg->mObjectType == eOBJECTTYPE_GATHERING )
						{
							NiTransform trans;
							trans.MakeIdentity();
							trans.m_Translate = NiPoint3( 0.0f, 0.0f, 0.0f );

							HERO->SetLinkdEffect( eLINK_HEAD, "./Data/Effect/Eff_PC_Get_03.nif", &trans, false, true );
						}
					}
					else
					{
						assert(0);
						return;
					}

					CHATMANAGER->AddSystemMsg( eSYSTEM_GETMONEY, (LPCTSTR)str.Cstr() );

					/// κ â 
					cInventoryWindow* pWin = mpUI->GetInventoryWindow();
					if( pWin )
						pWin->SetMoney( msg->mMoney );
				}
				break;
			case NM_PLAYER_DEPOSIT_RES:
				{
					MSG_RES_PLAYER_DEPOSIT* msg = (MSG_RES_PLAYER_DEPOSIT*)pMsg;

					HERO->SetDeposit( msg->mDeposit );

					/// â 
					cWareHouseWindow* pWin = mpUI->GetWareHouseWindow();
					if( pWin )
						pWin->SetMoney( msg->mDeposit );

				}
				break;
			case NM_PLAYER_TAROT_POINT_RES:
				{
					MSG_RES_PLAYER_TAROT_POINT* msg = (MSG_RES_PLAYER_TAROT_POINT*)pMsg;

					HERO->SetTarotPoint( msg->mPoint );

					cStringT str;
					LPCTSTR pointStr;
					if( msg->mAddPoint > 0 )
					{
						pointStr = cNumberEditBox::FormatNumber( msg->mAddPoint );
						str.Format( GAMERESOURCEMAN->GetGameText( 150 ), pointStr );
					}
					else if( msg->mAddPoint < 0 )
					{
						pointStr = cNumberEditBox::FormatNumber( (-msg->mAddPoint) );
						str.Format( GAMERESOURCEMAN->GetGameText( 151 ), pointStr );
					}
					else
					{
						assert(0);
						return;
					}

					CHATMANAGER->AddSystemMsg( eSYSTEM_GETMONEY, (LPCTSTR)str.Cstr() );
				}
				break;
			case NM_PLAYER_PVP_POINT_RES:
				{
					MSG_RES_PLAYER_PVP_POINT* msg = (MSG_RES_PLAYER_PVP_POINT*)pMsg;

					HERO->SetPVPPoint( msg->mPoint );

					cStringT str;
					LPCTSTR pointStr;
					if( msg->mAddPoint > 0 )
					{
						pointStr = cNumberEditBox::FormatNumber( msg->mAddPoint );
						str.Format( GAMERESOURCEMAN->GetGameText( 152 ), pointStr );
					}
					else if( msg->mAddPoint < 0 )
					{
						pointStr = cNumberEditBox::FormatNumber( (-msg->mAddPoint) );
						str.Format( GAMERESOURCEMAN->GetGameText( 153 ), pointStr );
					}
					else
					{
						assert(0);
						return;
					}

					CHATMANAGER->AddSystemMsg( eSYSTEM_GETMONEY, (LPCTSTR)str.Cstr() );
				}
				break;
			case NM_PLAYER_HP_SYN:
				{
//#ifdef _GMTOOL
//					if( CHEATMAN->GetUndeadMode() )
//						break;
//#endif
					MSG_SYN_PLAYER_HP* msg = (MSG_SYN_PLAYER_HP*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( msg->mCharacterIdx );
					if( pPlayer )
						pPlayer->HPChange( msg->mHp, msg->mMaxHp, msg->mDie );
				}
				break;
			case NM_PLAYER_MAXHP_SYN:
				{
					MSG_SYN_PLAYER_MAXHP* msg = (MSG_SYN_PLAYER_MAXHP*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( msg->mCharacterIdx );
					if( pPlayer )
						pPlayer->SetMaxHP( msg->mMaxHp );
				}
				break;
			case NM_PLAYER_MP_SYN:
				{
					MSG_SYN_PLAYER_MP* msg = (MSG_SYN_PLAYER_MP*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( msg->mCharacterIdx );
					if( pPlayer )
						pPlayer->MPChange( msg->mMp, msg->mMaxMp );
				}
				break;
			case NM_PLAYER_MAXMP_SYN:
				{
					MSG_SYN_PLAYER_MAXMP* msg = (MSG_SYN_PLAYER_MAXMP*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( msg->mCharacterIdx );
					if( pPlayer )
						pPlayer->SetMaxMP( msg->mMaxMp );
				}
				break;
			case NM_PLAYER_RESURRECTION_RES:
				{
					MSG_RES_PLAYER_RESURRECTION* msg = (MSG_RES_PLAYER_RESURRECTION*)pMsg;

					cRevivalWindow* win = mpUI->GetReVivalWindow();
					if( win )
						win->NetUnLock();

					cDMRevivalWindow* dmWin = mpUI->GetDMRevivalWindow();

					/// Ȱ
					if( msg->ErrorCode != ERROR_PLAYER_RESURRECTION_SUCCESS )
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 903 ) );
						return;
					}

					if( HERO->GetState() != eOBJECT_STATE_DIE )
					{
						assert(NULL);
					}

					if( win && win->IsVisible() == true )
						win->Hide();

					if( dmWin && dmWin->IsVisible() == true )
						dmWin->Hide();

					cStringT str;

					HERO->SetState( eOBJECT_STATE_IDLE );
					HERO->HPChange( msg->mHP, msg->mMaxHP, false );
					HERO->MPChange( msg->mMP, msg->mMaxMP );
					HERO->SetExp( msg->mPlayerExp );
					HERO->FixPos( msg->mPosX, msg->mPosY, true );
					HERO->UpdateHeroInfo();

					cStringT exp = cNumberEditBox::FormatNumber( msg->mExpDown );

					/// Ȱ ޼
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 904 ) );

					/// ġ  ޼
					if( HERO->GetLevel() >= 10 && msg->mExpDown > 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 905 ), (LPCTSTR)exp.Cstr() );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}
				}
				break;
			case NM_PLAYER_RESURRECTION_SYN:
				{
					MSG_SYN_PLAYER_RESURRECTION* msg = (MSG_SYN_PLAYER_RESURRECTION*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( msg->mCharacterIdx );
					if( pPlayer == NULL )
					{
						assert(NULL);
						return;
					}

					if( pPlayer->GetState() != eOBJECT_STATE_DIE )
					{
						assert(NULL);
						return;
					}

					pPlayer->SetState( eOBJECT_STATE_IDLE );
					pPlayer->HPChange( msg->mHP, msg->mMaxHP, false );
					pPlayer->MPChange( msg->mMP, msg->mMaxMP );
					pPlayer->SetState( eOBJECT_STATE_IDLE );

					NiPoint3 pos( msg->mPosX, msg->mPosY, 0.0f );
					if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) == false )
					{
						assert(0);
						return;
					}

					pPlayer->SetPos( pos );
				}
				break;
			case NM_PLAYER_BLINK:
				{
					MSG_SYN_PLAYER_BLINK* syn = (MSG_SYN_PLAYER_BLINK*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( syn->mObjIndex );
					if( player == 0 )
					{
						assert(0);
						return;
					}

					/// ̰ 
					if( WORLDMAN == 0 )
					{
						assert(0);
						return;
					}

					NiPoint3 pos( (float)syn->mDestX, (float)syn->mDestY, 0.0f );
					if( WORLDMAN->CalcHeight( &pos.z, pos.x, pos.y ) == false )
					{
						assert(0);
						return;
					}

					player->SetState( eOBJECT_STATE_IDLE );
					player->SetPos( pos );
				}
				break;
			case NM_PLAYER_EXP_SXP_RES:
				{
					cStringT str;

					MSG_RES_EXP_SXP* resMsg = (MSG_RES_EXP_SXP*)pMsg;
					HERO->SetExp( resMsg->mTotalExp );
					HERO->SetSxp( resMsg->mTotalSxp );
					HERO->UpdateHeroInfo();

					cStringT exp = cNumberEditBox::FormatNumber( resMsg->mExp );
					cStringT sxp = cNumberEditBox::FormatNumber( resMsg->mSxp );

					str.Format( GAMERESOURCEMAN->GetGameText( 52 ), (LPCTSTR)exp.Cstr(), (LPCTSTR)sxp.Cstr() );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
				}
				break;
			case NM_PLAYER_LEVEL_RES:
				{
					MSG_RES_LEVEL* resMsg = (MSG_RES_LEVEL*)pMsg;

					HERO->SetLevel( resMsg->mLevel );
					HERO->HPChange( resMsg->mHP, resMsg->mMaxHP, false );
					HERO->MPChange( resMsg->mMP, resMsg->mMaxMP );

					cStringT str;

					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 50 ) );
					if( resMsg->mStr != 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 75 ), resMsg->mStr );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}
					if( resMsg->mDex != 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 76 ), resMsg->mDex );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}
					if( resMsg->mCon != 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 77 ), resMsg->mCon );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}
					if( resMsg->mInt != 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 78 ), resMsg->mInt );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}
					if( resMsg->mWis != 0 )
					{
						str.Format( GAMERESOURCEMAN->GetGameText( 79 ), resMsg->mWis );
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)str.Cstr() );
					}

					/// Ʈ 
					HERO->SetLinkdEffect( eLINK_FOOT, "./Data/Effect/Eff_PC_LVUp_01.nif", 0 );

				}
				break;
			case NM_PLAYER_LEVEL_SYN:
				{
					MSG_SYN_LEVEL* synMsg = (MSG_SYN_LEVEL*)pMsg;

					cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( synMsg->mCharacterIdx );
					if( pPlayer ) 
					{ 
						pPlayer->SetLevel( synMsg->mLevel );
						pPlayer->HPChange( synMsg->mHP, synMsg->mMaxHP, false );
						pPlayer->MPChange( synMsg->mMP, synMsg->mMaxMP );
						pPlayer->SetLinkdEffect( eLINK_FOOT, "./Data/Effect/Eff_PC_LVUp_01.nif", 0 );

						/// Ƽ Ȯ
						if( HERO->GetPartyIndex() > 0 && HERO->GetObjectID() != pPlayer->GetObjectID() )
						{
							if( HERO->GetPartyIndex() == pPlayer->GetPartyIndex() )
								PARTYMAN->UpdateLevelUp( synMsg->mCharacterIdx, synMsg->mLevel );
						}
					}
				}
				break;
			case NM_PLAYER_SKILLLEVEL_RES:
				{
					MSG_RES_SKILLLEVEL* resMsg = (MSG_RES_SKILLLEVEL*)pMsg;

					HERO->SetSkillLevel( resMsg->mSkillLevel );
					HERO->SetSkillPointRemain( resMsg->mSkillPoint, resMsg->mSkillPointTotal );
					mpUI->UpdateExpSxp();
					mpUI->UpdateSkillPoint();

					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 51 ) );
					HERO->SetLinkdEffect( eLINK_FOOT, "./Data/Effect/Eff_PC_SLVUp_01.nif", 0 );
				}
				break;
			case NM_PLAYER_STATE_IDLE_SYN:
				{
					MSG_SYN_PLAYER_STATE_IDLE* synMsg = (MSG_SYN_PLAYER_STATE_IDLE*)pMsg;

					cPlayer* pPlayer = OBJECTMAN->GetPlayer( synMsg->mCharacterIdx );
					if( pPlayer )
					{
						pPlayer->SetIdleFlag( (eIDLEFLAG)synMsg->mPlayerStateIdle );
					}
				}
				break;
			case NM_PLAYER_STATE_SITDOWN_RES:
				{
					MSG_RES_PLAYER_STATE_SITDWON* resMsg = (MSG_RES_PLAYER_STATE_SITDWON*)pMsg;

					if( resMsg->ErrorCode != 0 )
					{
						///  · ȭ
						if( resMsg->mSitDown == true )
							HERO->SitDown();
						else
							HERO->StandUp();
					}
				}
				break;
			case NM_PLAYER_STATE_SITDOWN_SYN:
				{
					MSG_SYN_PLAYER_STATE_SITDWON* synMsg = (MSG_SYN_PLAYER_STATE_SITDWON*)pMsg;

					cPlayer* p = OBJECTMAN->GetPlayer( synMsg->mCharacterIdx );
					if( p == 0 )
						return;

					if( synMsg->mSitDown == true )
						p->SitDown();
					else
						p->StandUp();
				}
				break;
			case NM_PLAYER_SP_RES:
				{
					MSG_RES_PLAYER_SP* resMsg = (MSG_RES_PLAYER_SP*)pMsg;

					HERO->SetSkillPointRemain( resMsg->mSP, resMsg->mTotalSP );
					HERO->SetJobUsedSkillPoint( resMsg->rowCount, resMsg->usedSP );

					///  
					mpUI->UpdateSkillPoint();
				}
				break;
			case NM_PLAYER_COMMUNITYSKILL_RES:
				{
					MSG_RES_PLAYER_COMMUNITYSKILL* pmsg = (MSG_RES_PLAYER_COMMUNITYSKILL*)pMsg;
					if( pmsg->ErrorCode == 0 )
					{
						/// 
						sCommunitySkillInfo* pInfo = COMMUNITYSCRIPT->GetCommunityInfo( pmsg->mCommunitySkillIdx );
						if( pInfo )
						{
							if( pInfo->mType != 0 )
							{
								HERO->ChangeAnimation( (ePLAYER_ANIMATIONTYPE)pInfo->mRoleIndex );
							}
							else
							{
								assert(0);
							}
						}
					}
					else
					{
						/// check server & client player state!!
						assert(0);
					}

					cSkillWindow* win = mpUI->GetSkillWindow();
					if( win )
						win->NetUnLockCommu();
				}
				break;
			case NM_PLAYER_COMMUNITYSKILL_SYN:
				{
					MSG_SYN_PLAYER_COMMUNITYSKILL* synMsg = (MSG_SYN_PLAYER_COMMUNITYSKILL*)pMsg;
					cPlayer* player = OBJECTMAN->GetPlayer( synMsg->mCharacterIdx );
					if( player )
					{
						sCommunitySkillInfo* pInfo = COMMUNITYSCRIPT->GetCommunityInfo( synMsg->mCommunitySkillIdx );
						if( pInfo )
						{
							if( pInfo->mType != 0 )
							{
								player->ChangeAnimation( (ePLAYER_ANIMATIONTYPE)pInfo->mRoleIndex );
							}
							else
							{
								assert(0);
							}
						}
					}
				}
				break;
			case NM_PLAYER_STATICFACE_SYN:
				{
					MSG_SYN_PLAYER_STATICFACE* synMsg = (MSG_SYN_PLAYER_STATICFACE*)pMsg;
					cPlayer* player = OBJECTMAN->GetPlayer( synMsg->mCharacterIdx );
					if( player )
						player->SetStaticFace( synMsg->mStaticFaceIdx );
				}
				break;
			case NM_PLAYER_COLLECTIONBOOK_OPEN_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;

					cCardBookWindow* cardbook = mpUI->GetCardBookWindow();
					assert(cardbook);

					if( pmsg->ErrorCode == ERROR_PLAYER_COLLECTIONBOOK_SUCCESS )
					{
						/// ÷Ǻ 
						if( cardbook )
							cardbook->ShowTop();

						///  
						HERO->SetStopFlag( eSTOP_COLLECTIONBOOK );
					}
					else
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 346 ) );
					}

					if( cardbook )
						cardbook->NetUnLock( eBook_Open );
				}	
				break;
			case NM_PLAYER_COLLECTIONBOOK_CLOSE_RES:
				{
					MSG_ERROR* pmsg = (MSG_ERROR*)pMsg;

					cCardBookWindow* cardbook = mpUI->GetCardBookWindow();
					assert(cardbook);

					if( pmsg->ErrorCode == ERROR_PLAYER_COLLECTIONBOOK_SUCCESS )
					{
						/// ÷Ǻ ݱ
						mpUI->HideCardBookWindow();

						HERO->SetStopFlag( eSTOP_NONE );
						HERO->SetState( eOBJECT_STATE_IDLE );
					}
					else
					{
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 347 ) );
					}

					if( cardbook )
						cardbook->NetUnLock( eBook_Close );
				}
				break;
			case NM_PLAYER_FORCE_SYN:
				{
					MSG_SYN_PLAYER_FORCE* pmsg = (MSG_SYN_PLAYER_FORCE*)pMsg;

					cPlayer* pPlayer = OBJECTMAN->GetPlayer( pmsg->mPlayerIdx );
					if( pPlayer != NULL )
						pPlayer->SetForceType( pmsg->mForceType );
				}
				break;
			case NM_PLAYER_FORCEVALUE_SYN:
				{
					MSG_SYN_PLAYER_FORCEVALUE* pmsg = (MSG_SYN_PLAYER_FORCEVALUE*)pMsg;
					cSocialWindow* social = mpUI->GetSocialWindow();

					switch( pmsg->mForceType )
					{
					case eFORCETYPE_FIRE:
						{
							if( pmsg->mValueType == 1 )
							{
								HERO->SetFirePoint( pmsg->mValue );

								if( social )
									social->SetFirePoint( pmsg->mValue );
							}
							else if( pmsg->mValueType == 2 )
								HERO->SetFireFriendly( pmsg->mValue );
							else
								assert(NULL);
						}
						break;
					case eFORCETYPE_WATER:
						{
							if( pmsg->mValueType == 1 )
							{
								HERO->SetWaterPoint( pmsg->mValue );

								if( social )
									social->SetWaterPoint( pmsg->mValue );
							}
							else if( pmsg->mValueType == 2 )
								HERO->SetWaterFriendly( pmsg->mValue );
							else
								assert(NULL);
						}
						break;
					case eFORCETYPE_WIND:
						{
							if( pmsg->mValueType == 1 )
							{
								HERO->SetWindPoint( pmsg->mValue );

								if( social )
									social->SetWindPoint( pmsg->mValue );
							}
							else if( pmsg->mValueType == 2 )
								HERO->SetWindFriendly( pmsg->mValue );
							else
								assert(NULL);
						}
						break;
					case eFORCETYPE_EARTH:
						{
							if( pmsg->mValueType == 1 )
							{
								HERO->SetEarthPoint( pmsg->mValue );

								if( social )
									social->SetEarthPoint( pmsg->mValue );
							}
							else if( pmsg->mValueType == 2 )
								HERO->SetEarthFriendly( pmsg->mValue );
							else
								assert(NULL);
						}
						break;
					}
				}
				break;
			case NM_PLAYER_JOB_RES:
				{
					///  
					MSG_RES_JOB* pmsg = (MSG_RES_JOB*)pMsg;

					///
					HERO->SetJob( (ePLAYER_JOB)pmsg->mJob );

					for( int i = 0 ; i < pmsg->mSkillListCnt ; ++i )
						SKILLMAN->AddKeepSkill( pmsg->mSkillClassIdx[i], 0 );

					if( pmsg->mSkillListCnt != 0 )
					{
						/// 071024 PKH ͽ 
						HERO->CalcStatus();

						/// skill store 
						mpUI->UpdataSkillStorWindow();
						/// Ʈ ߰
						NiTransform trans;
						trans.MakeIdentity();
						trans.m_Translate = NiPoint3( 0.0f, 0.0f, 30.0f );

						HERO->SetLinkdEffect( eLINK_HEAD, "./Data/Effect/Eff_PC_Get_01.nif", &trans, false, false );
					}

				}
				break;
			case NM_PLAYER_JOB_SYN:
				{
					MSG_SYN_JOB* pmsg = (MSG_SYN_JOB*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( pmsg->mPlayerIdx );
					if( player )
					{
						player->SetJob( (ePLAYER_JOB)pmsg->mJob );
					}
				}
				break;
			case NM_PLAYER_TITLE_ADD_RES:
			case NM_PLAYER_TITLE_LIST_RES:
			case NM_PLAYER_TITLE_SET_RES:
			case NM_PLAYER_TITLE_SET_SYN:
				{
					TITLEMAN->NetworkMsgParser( pMsg );
				}
				break;
			case NM_PLAYER_PARTY_SET_SYN:
				{
					MSG_SYN_PLAYER_PARTY_SET* msg = (MSG_SYN_PLAYER_PARTY_SET*)pMsg;
					
					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIndex );
					if( player )
					{
						player->SetPartyIndex( msg->mPartyIndex );
					}
				}
				break;
			case NM_PLAYER_GUILD_SET_SYN:
				{
					MSG_SYN_PLAYER_GUILD_SET* msg = (MSG_SYN_PLAYER_GUILD_SET*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIndex );
					if( player )
					{
						if( msg->mGuildIndex > 0 )
							player->SetGuild( msg->mGuildIndex, msg->mName, msg->mPosition, msg->mMarkIndex );
						else
							player->SetGuild( 0, _T(""), eGUILD_NONE, 0 );
					}
				}
				break;
			case NM_PLAYER_TODAYWORD_CHANGE_RES:
				{
					///  Ѹ 
					MSG_RES_PLAYER_TODAYWORD_CHANGE* msg = (MSG_RES_PLAYER_TODAYWORD_CHANGE*)pMsg;

					cTodayWordWindow* win = mpUI->GetTodayWordWindow();
					switch( msg->ErrorCode )
					{
					case ERROR_PLAYER_TODAYWORD_CHANGE_SUCCESS:
						{
							if( win )
								win->Hide();

							HERO->SetTodayWord( msg->mWord, msg->mWordColor );
							CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 338 ) );
						}
						break;
					case ERROR_PLAYER_TODAYWORD_CHANGE_INIT:
						HERO->SetTodayWord( msg->mWord, msg->mWordColor );
						break;
					case ERROR_PLAYER_TODAYWORD_CHANGE_FAIL:
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 339 ) );
						break;
					}

					if( msg->ErrorCode != ERROR_PLAYER_TODAYWORD_CHANGE_INIT )
					{
						if( win )
							win->NetUnLock();
					}
				}
				break;
			case NM_PLAYER_TODAYWORD_CHANGE_SYN:
				{
					MSG_SYN_PLAYER_TODAYWORD_CHANGE* msg = (MSG_SYN_PLAYER_TODAYWORD_CHANGE*)pMsg;

					cPlayer* player = OBJECTMAN->GetPlayer( msg->mCharacterIndex );
					if( player )
					{
						player->SetTodayWord( msg->mWord, msg->mWordColor );
					}
				}
				break;
			case NM_PLAYER_SKILLRESET_RES:
				{
					MSG_ERROR* msg = (MSG_ERROR*)pMsg;

					switch( msg->ErrorCode )
					{
					case ERROR_SKILLRESET_STATE:
					case ERROR_SKILLRESET_ITEM:
					case ERROR_SKILLRESET_DBERROR:
						CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 6111 ) );
						break;
					}
				}
				break;
			} //switch( pTemMsg->Protocol )
		} //case NM_PLAYER:
		break;
	case NM_TOTEM:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_TOTEM_SIGHT_IN_RES:
				{
					MSG_TOTEM_INFO* pmsg = (MSG_TOTEM_INFO*)pMsg;
					OBJECTMAN->AddTotem( pmsg->mObjectIdx, pmsg->mCreateInfClassIdx, NiPoint3(pmsg->mPosX, pmsg->mPosY, 0.0f) );
				}
				break;
			case NM_TOTEM_SIGHT_OUT_RES:
				{
					MSG_TOTEMIDX* pmsg = (MSG_TOTEMIDX*)pMsg;
					OBJECTMAN->RemoveTotem( pmsg->mObjectIdx );
				}
				break;
			} //switch( pTemMsg->Protocol )
		} //case NM_TOTEM:
		break;
	case NM_SKILL:
		{
			SKILLMAN->NetworkMsgParser(pMsg);
		}
		break;
	case NM_CHAT:
		{
			CHATMANAGER->NetworkMsgParser(pMsg);
		}
		break;
	case NM_TAROT:
		{
			TAROTMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_ITEM:
		{
			ITEMMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_CHEAT:
		{
			CHEATMAN->NetworkMsgParser( pTemMsg );
		}
		break;
	case NM_PARTY:
		{
			PARTYMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_QUEST:
		{
			QUESTMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_PVP:
		{
			PVPMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_DUEL:
		{
			switch( pTemMsg->Protocol )
			{
			case NM_DUEL_ADD_RES:
				{
					MSG_RES_DUEL_ADD* pSynMsg = (MSG_RES_DUEL_ADD*)pMsg;
					switch( pSynMsg->ErrorCode )
					{
					case ERR_DUEL_ADD_SUCCESS:
						{
							/// 
							UIMAN->ModalEventFromGameSystem( false );

							/// HERO  â 
							MSG_RES_DUEL_ADD* pResMsg = (MSG_RES_DUEL_ADD*)pMsg;
							HERO->ViewMsgDuelReq( pResMsg->mAttackerIdx );
						}
						break;
					case ERR_DUEL_ADD_FAIL:
						{
							/// 
							///  û Ұ -  û
							cStringT Message;
							Message.Format( GAMERESOURCEMAN->GetGameText( 805 ) );
							CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
						}
						break;
					case ERR_DUEL_ADD_OPTIONREFUSE:
						{
							/// ɼ   -  û
							CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 2702 ) );
						}
						break;
					}
				}
				break;     
			case NM_DUEL_ACCEPT_RES:
				{
					MSG_RES_DUEL_ACCEPT* pResMsg = (MSG_RES_DUEL_ACCEPT*)pMsg;
					if( pResMsg->ErrorCode == ERR_DUEL_ACCEPT_SUCCESS )
					{
						/// duel count start
						DUELMAN->StartCount( pResMsg->mEnemyIdx, pResMsg->mCenterPos );
						HERO->SetDuelEffect();

						/// enemy info
						cPlayer* player = OBJECTMAN->GetPlayer( pResMsg->mEnemyIdx );
						if( player )
							player->SetDuelEffect();
					}
					else
					{
						HERO->DuelNoStartMsg( pResMsg->ErrorCode );
					}
				}
				break;
			case NM_DUEL_ACCEPT_SYN:
				{
					MSG_SYN_DUEL_ACCEPT* pResMsg = (MSG_SYN_DUEL_ACCEPT*)pMsg;
					cPlayer* player = OBJECTMAN->GetPlayer( pResMsg->mAttackerIdx );
					if( player )
						player->SetDuelEffect();

					player = OBJECTMAN->GetPlayer( pResMsg->mTargetIdx );
					if( player )
						player->SetDuelEffect();
				}
				break;
			case NM_DUEL_START_RES:
				{
					DUELMAN->StartDuel();
				}
				break;
			case NM_DUEL_FIGHT_OUTRANGE_RES:
				{
					DUELMAN->SetOutofBound( true );
				}
				break;
			case NM_DUEL_FIGHT_INRANGE_RES:
				{
					DUELMAN->SetOutofBound( false );
				}
				break;
			case NM_DUEL_WINNER_SYN:
				{
					MSG_SYN_DUEL_WINNER* pSynMsg = (MSG_SYN_DUEL_WINNER*)pMsg;

					///
					HERO->ClearDuelEffect();
					HERO->SetState( eOBJECT_STATE_IDLE );
					if( HERO->IsTransformMonster() )
						HERO->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
					else
						HERO->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 904 );

					cPlayer* player = OBJECTMAN->GetPlayer( pSynMsg->mLoserIdx );
					if( player )
					{
						player->ClearDuelEffect();
						player->SetState( eOBJECT_STATE_IDLE );

						if( player->IsTransformMonster() )
							player->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
						else
							player->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 903 );
					}

					///   
					DUELMAN->EndDuel();

					///   ޼ ó
					cStringT Message;
					Message.Format( GAMERESOURCEMAN->GetGameText( 807 ), pSynMsg->mWinnerName, pSynMsg->mLoserName, 
						pSynMsg->mWinnerName, pSynMsg->mStraightWin );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
				}
				break;
			case NM_DUEL_LOSER_SYN:
				{
					MSG_SYN_DUEL_LOSER* pSynMsg = (MSG_SYN_DUEL_LOSER*)pMsg;

					///
					HERO->ClearDuelEffect();
					HERO->SetState( eOBJECT_STATE_IDLE );
					if( HERO->IsTransformMonster() )
						HERO->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
					else
						HERO->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 903 );

					cPlayer* player = OBJECTMAN->GetPlayer( pSynMsg->mWinnerIdx );
					if( player )
					{
						player->ClearDuelEffect();
						player->SetState( eOBJECT_STATE_IDLE );

						if( player->IsTransformMonster() )
							player->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
						else
							player->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 904 );
					}

					///   
					DUELMAN->EndDuel();

					///   ޼ ó
					cStringT Message;
					Message.Format( GAMERESOURCEMAN->GetGameText( 807 ), pSynMsg->mWinnerName, pSynMsg->mLoserName, 
						pSynMsg->mWinnerName, pSynMsg->mStraightWin );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
				}
				break;
			case NM_DUEL_END_SYN:
				{
					MSG_SYN_DUEL_END* pSynMsg = (MSG_SYN_DUEL_END*)pMsg;

					///
					cPlayer* player = OBJECTMAN->GetPlayer( pSynMsg->mWinnerIdx );
					if( player )
					{
						player->ClearDuelEffect();
						player->SetState( eOBJECT_STATE_IDLE );

						if( player->IsTransformMonster() )
							player->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
						else
							player->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 903 );
					}

					player = OBJECTMAN->GetPlayer( pSynMsg->mLoserIdx );
					if( player )
					{
						player->ClearDuelEffect();
						player->SetState( eOBJECT_STATE_IDLE );

						if( player->IsTransformMonster() )
							player->ChangeAnimation_TransMon( (eMONSTER_ANIMATIONTYPE)M_ANITYPE_IDLE1 );
						else
							player->ChangeAnimation( (ePLAYER_ANIMATIONTYPE) 904 );
					}

					///   ޼ ó
					cStringT Message;
					Message.Format( GAMERESOURCEMAN->GetGameText( 807 ), pSynMsg->mWinnerName, pSynMsg->mLoserName, 
						pSynMsg->mWinnerName, pSynMsg->mStraightWin );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
				}
				break;
			}
		}
		break;
	case NM_GUILD:
		{
			GUILDMAN->NetworkMsgParser( pMsg );
		}
		break;
	case NM_MAKESKILL:
		{
			ITEMMIXMAN->NetworkMsgParserGame( pMsg );
		}
		break;
	}

	length = 0;
}

void cGameStage::Msg_MapChangeAck( MSGROOT* pMsg )
{
	MSG_PLAYERINFO* pmsg = (MSG_PLAYERINFO*)pMsg;
	mpStageManager->SetMapIdx( pmsg->MapNum );

	mpStageManager->ChangeStage( eStage_MapChange );

	///   HEROü 
	OBJECTMANAGER->AddHeroFromServerMsg( pMsg );
}

void cGameStage::Msg_NpcGenerateInfo( MSGROOT* pMsg )
{
	MSG_NPC_INFO* pMessage = (MSG_NPC_INFO*)pMsg;

	for( int i = 0 ; i < (int)pMessage->mCount ; ++i )
	{
		/// 061122 PKH     ŭ  ߰
		sNpcData* npc = &pMessage->mNpcInfo[i];
		if( npc )
			OBJECTMANAGER->AddNpc( npc );
	}
}

void cGameStage::Msg_MonsterGenerateInfo( MSGROOT* pMsg )
{
	MSG_MONSTER_INFO* pMessage = (MSG_MONSTER_INFO*)pMsg;

	sMonsterData* monster = &pMessage->mMonsterInfo;
	sMonsterInfluence* pInfluence = pMessage->mInfluence;

	if( monster )
	{
		OBJECTMANAGER->AddMonster( monster );

		cMonster* pMonster = OBJECTMAN->GetMonster( monster->mMonsterIdx );
		if( pMonster )
		{
			for( unsigned long i = 0 ; i < pMessage->mCount ; ++i )
			{
				cInfluenceObject* p = SKILLMAN->CreateInfluenceObject( pInfluence[i].mUniqueIdx, 
					pInfluence[i].mInfluenceClassIdx, 0, pMonster, true );
				if( p )
				{
					p->StartProcess( -1, true );
				}
				else
				{
					assert(0);
					return;
				}
			}
		}
	}
}

///
void cGameStage::MsgBoxEventParser( unsigned int event, unsigned int result, void* exData )
{
	switch( event )
	{
	case eMBEVENT_NONE:
		return;
		/// ģ߰
	case eMBEVENT_FRIEND_ADD:
		{
			if( result == eMESSAGE_BUTTON_YES )
			{
				/// ģ Ȯ
				cUIWindow* pWin = (cUIWindow*)UIMAN->GetModalBox();
				if( !(pWin && pWin->IsKindof( eUINODE_MESSAGEBOX )) )
					return;

				cMsgBox* pBox = (cMsgBox*)pWin;
				/// ̸  
				if( pBox->GetLength() == 0 )
					return;

				/// ڱڽ ̸ ϸ 
				int result = ::_tcscmp( HERO->GetName(), pBox->GetEditText() );
				if( result == 0 )
				{
					cStringT Message;
					Message.Format( GAMERESOURCEMAN->GetGameText( 42 ) );
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, (LPCTSTR)Message.Cstr() );
				}
				else
				{
					///  ģ ߰ û
					MSG_REQ_FRIEND_ADD msg;
					::memset( &msg, 0, sizeof( msg ) );

					msg.Category = NM_CHAT;
					msg.Protocol = NM_CHAT_FRIEND_ADD_REQ;
					Sstrncpy( msg.Name, MAX_NAME_BUFFER_SIZE, pBox->GetEditText(), MAX_NAME_SIZE );

					NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
				}
			}
		}
		break;
	case eMBEVENT_FRIEND_ADD_REQ:
		{
			cFriendWindow* pFriend = (cFriendWindow*)mpUI->GetFriendWindow();
			if( !pFriend )
			{
				assert(0);
				return;
			}

			/// κ ģ߰ û
			if( result == eMESSAGE_BUTTON_YES )
			{
				/// 
				MSG_REQ_FRIEND_REP msg;
				::memset( &msg, 0, sizeof( msg ) );

				msg.Category = NM_CHAT;
				msg.Protocol = NM_CHAT_FRIEND_REP_REQ;
				msg.Idx = (unsigned long)exData;
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			}
			else
			{
				/// ź
				MSG_REQ_FRIEND_DEL msg;
				::memset( &msg, 0, sizeof( msg ) );

				msg.Category = NM_CHAT;
				msg.Protocol = NM_CHAT_FRIEND_DEL_REQ;
				msg.Idx = (unsigned long)exData;

				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
			}	
		}
		break;
		/// ģ 
	case eMBEVENT_FRIEND_DELETE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			///  Ȯ
			cFriendWindow* pFriend = mpUI->GetFriendWindow();
			if( pFriend )
			{
				///  ģ  û
				MSG_REQ_FRIEND_DEL msg;
				::memset( &msg, 0, sizeof( msg ) );

				msg.Category = NM_CHAT;
				msg.Protocol = NM_CHAT_FRIEND_DEL_REQ;
				msg.Idx = (long)exData;

				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
			}
		}
		break;
	case eMBEVENT_TAROTSEEKER_START:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// 
			MSG_REQ_TAROT_SEEKER_JOIN msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_SEEKER_JOIN_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			cTarotWindow* win = mpUI->GetTarotWindow();
			assert(win);
			win->NetLock( ePAGE_VIEW );
		}
		break;
	case eMBEVENT_TAROTSELECT_EXIT:
	case eMBEVENT_TAROTRESULT_EXIT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// 
			MSG_REQ_TAROT_SEEKER_CLOSE msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_SEEKER_CLOSE_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			cTarotWindow* win = mpUI->GetTarotWindow();
			if( win )
			{
				win->NetLock( ePAGE_SELECT );
				win->NetLock( ePAGE_RESULT );
			}
		}
		break;
	case eMBEVENT_TAROTLEADER_EXIT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// ڰ Ÿ 
			///  ݱ
			MSG_REQ_TAROT_READER_CLOSE msg;
			msg.Category = NM_TAROT;
			msg.Protocol = NM_TAROT_READER_CLOSE_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			cTarotControlWindow* win = mpUI->GetTarotControlWindow();
			if( win )
				win->NetLock();
		}
		break;
	case eMBEVENT_NPCTAROT_START:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// 
			MSG_REQ_NPC_TAROT_JOIN msg;
			msg.Category = NM_NPC;
			msg.Protocol = NM_NPC_TAROT_JOIN_REQ;
			msg.npcIndex = HERO->GetNpcIdx();
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

			cTarotWindow* win = mpUI->GetTarotWindow();
			if( win )
				win->NetLock( ePAGE_NPCVIEW );
		}
		break;
	case eMBEVENT_NPCTAROT_EXIT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			cTarotWindow* win = mpUI->GetTarotWindow();
			if( win )
				win->Hide();

			UIMAN->HideNpcBack();
			TAROTMAN->ChangePage( ePAGE_NONE );
		}
		break;
	case eMBEVENT_SKILL_BUY:
		{
			cSkillStoreWindow::sSkillRowData* data = (cSkillStoreWindow::sSkillRowData*)exData;
			if( data == 0 )
			{
				assert(0);
				return;
			}
			if( result == eMESSAGE_BUTTON_YES )
			{
				if( SKILLMAN->CheckBuySkill( data->mSkillIdx, data->mTrainStep ) == false )
					return;

				/// packet
				MSG_REQ_NPC_SKILL_ADD msg;
				msg.Category = NM_NPC;
				msg.Protocol = NM_NPC_SKILL_ADD_REQ;
				msg.mNpcIdx = HERO->GetNpcIdx();
				msg.mSkillClassIdx = data->mSkillIdx;
				msg.mSkillStep = data->mTrainStep;
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				cSkillStoreWindow* win = mpUI->GetSkillStoreWindow();
				if( win )
					win->NetLock();
			}
		}
		break;
	case eMBEVENT_PARTY_ADD_REQ:
		{
			/// Ƽ Կû ޼   
			char reply = (result == eMESSAGE_BUTTON_YES) ? 1 : 0;

			/// Կû 
			MSG_REQ_PARTY_REP msg;
			msg.Category = NM_PARTY;
			msg.Protocol = NM_PARTY_REP_REQ;
			msg.Reply = reply;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case eMBEVENT_PARTY_CHANGELEADER_REQ:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ƽ  ޽
			PARTYMAN->RequestChangeLeader();
		}
		break;
	case eMBEVENT_PARTY_THROW:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ƽ ߹
			PARTYMAN->RequestThrow();
		}
		break;
	case eMBEVENT_PARTY_OUT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ƽ Ż
			PARTYMAN->RequestPartyOut();
		}
		break;
	case eMBEVENT_QUEST_ADDBYITEM:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ƿھ  
			QUESTMAN->QuestAddByItem( (unsigned int)exData );
		}
		break;
	case eMBEVENT_QUEST_DELETE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ʈ  
			QUESTMAN->QuestDelete( (unsigned int)exData );
		}
		break;
	case eMBEVENT_QUEST_REWARDJOB:
	case eMBEVENT_QUEST_REWARDFORCE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// Ʈ  &   Ȯ
			QUESTMAN->QuestComplete();
		}
		break;
	case eMBEVENT_TRADE_REQUEST:
		/// ŷû
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// ³
			ITEMMAN->TryToTradeAccept();
		}
		else
		{
			/// 
			ITEMMAN->TryToTradeReject();
		}
		break;
	case eMBEVENT_TRADE_MONEYIN:
		{
			cMoneyWindow* win = mpUI->GetMoneyWindow();
			if( !win )
				return;

			/// ŷݾ Է
			if( result == eUIID_MONEY_OK )
			{
				if( win->GetMoney() > HERO->GetMoney() )
					win->SetMoney( HERO->GetMoney() );

				ITEMMAN->TryToTradeMoneyAdd( win->GetMoney() );
				win->NetLock();
			}
		}
		break;
	case eMBEVENT_WAREHOUSE_MONEYIN:
		{
			cMoneyWindow* win = mpUI->GetMoneyWindow();
			if( !win )
				return;

			/// â Ա
			if( result == eUIID_MONEY_OK )
			{
				if( win->GetMoney() > HERO->GetMoney() )
					win->SetMoney( HERO->GetMoney() );

				if( win->GetMoney() == 0 )
					return;

				MSG_REQ_NPC_DEPOSIT msg;
				::memset( &msg, 0, sizeof(msg) );

				msg.Category = NM_NPC;
				msg.Protocol = NM_NPC_DEPOSIT_REQ;
				msg.npcIdx = HERO->GetNpcIdx();
				msg.money = win->GetMoney();
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				/// 
				win->NetLock( eMONEY_IN );
			}
		}
		break;
	case eMBEVENT_WAREHOUSE_MONEYOUT:
		{
			cMoneyWindow* win = mpUI->GetMoneyWindow();
			if( !win )
				return;

			/// â 
			if( result == eUIID_MONEY_OK )
			{
				if( win->GetMoney() > HERO->GetDeposit() )
					win->SetMoney( HERO->GetDeposit() );

				if( win->GetMoney() == 0 )
					return;

				MSG_REQ_NPC_WITHDRAW msg;
				::memset( &msg, 0, sizeof(msg) );

				msg.Category = NM_NPC;
				msg.Protocol = NM_NPC_WITHDRAW_REQ;
				msg.npcIdx = HERO->GetNpcIdx();
				msg.money = win->GetMoney();
				NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );

				/// 
				win->NetLock( eMONEY_OUT );
			}
		}
		break;
	case eMBEVENT_USERSELL_ITEMMONEYADD:
		{
			cMoneyWindow* moneyWin = mpUI->GetMoneyWindow();
			if( !moneyWin )
				return;

			cUserSellWindow* sellWin = mpUI->GetUserSellWindow();
			if( !sellWin )
				return;

			///  ߰
			if( result == eUIID_MONEY_OK )
			{
				if( moneyWin->GetMoney() == 0 )
					return;

				ITEMMAN->TryToUserSellAdd( moneyWin->GetSlotIndex(), moneyWin->GetMoney() );
			}	
		}
		break;
	case eMBEVENT_USERSELL_ITEMMONEYMODIFY:
		{
			cUserSellWindow* sellWin = mpUI->GetUserSellWindow();
			if( !sellWin )
				return;

			cMoneyWindow* moneyWin = mpUI->GetMoneyWindow();
			if( !moneyWin )
				return;

			int invenSlot = sellWin->GetSelectInvenSlot();

			if( result == eUIID_MONEY_MODIFY )
			{
				if( moneyWin->GetMoney() == 0 )
				{
					/// 
					ITEMMAN->TryToUserSellDelete( invenSlot );
				}
				else
				{
					///  
					ITEMMAN->TryToUserSellAdd( invenSlot, moneyWin->GetMoney() );
				}
			}
			else if( result == eUIID_MONEY_DELETE )
			{
				/// 
				ITEMMAN->TryToUserSellDelete( invenSlot );
			}
		}
		break;
	case eMBEVENT_USERSELL_ITEMMONEYCANCEL:
		{
			cUserSellWindow* sellWin = mpUI->GetUserSellWindow();
			if( !sellWin )
				return;

			int invenSlot = sellWin->GetSelectInvenSlot();

			sUserSellData* data = sellWin->GetSelectSellData();
			if( data )
			{
				///   
				ITEMMAN->TryToUserSellAdd( invenSlot, data->mPrice );
			}
		}
		break;
	case eMBEVENT_ITEM_SELL:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			if( win && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToSellItem( win->GetSlotIndex0(), win->GetCount() );
		}
		break;
	case eMBEVENT_ITEM_DUMP:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			if( win && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToDumpItem( win->GetSlotIndex0() );
		}	
		break;
	case eMBEVENT_ITEM_BUY:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			if( win && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToBuyItem( win->GetItemIndex(), win->GetCount() );
		}
		break;
	case eMBEVENT_ITEM_USERSELLBUY:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			if( win && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToUserSellGet( win->GetSlotIndex0(), win->GetCount() );
		}
		break;
	case eMBEVENT_ITEMCOUNT_BUY:
		{
			cItemCountWindow* win = mpUI->GetItemCountWindow();
			if( win && result == eUIID_ITEMCOUNT_OK )
				mpUI->ShowItemBuyAskWindow( win->GetItemIndex(), (unsigned short)(win->GetCount()) );
		}
		break;
	case eMBEVENT_ITEMCOUNT_SELL:
		{
			cItemCountWindow* win = mpUI->GetItemCountWindow();
			if( win && result == eUIID_ITEMCOUNT_OK )
				mpUI->ShowItemSellAskWindow( win->GetSlotIndex0(), (unsigned short)(win->GetCount()) );
		}
		break;
	case eMBEVENT_ITEMCOUNT_SPLIT:
		{
			cItemCountWindow* win = mpUI->GetItemCountWindow();
			if( win && result == eUIID_ITEMCOUNT_OK )
				ITEMMAN->TryToSplitItem( win->GetSlotIndex0(), win->GetSlotIndex1(), (unsigned short)(win->GetCount()) );
		}
		break;
	case eMBEVENT_ITEMCOUNT_USERSELLBUY:
		{
			cItemCountWindow* win = mpUI->GetItemCountWindow();
			cUserSellWindow* sell = mpUI->GetUserSellWindow();

			if( win && sell && result == eUIID_ITEMCOUNT_OK )
			{
				if( win->GetCount() == 0 )
					return;

				sUserSellData* data = sell->GetSelectJoinData();
				mpUI->ShowItemUserSellBuyAskWindow( win->GetSlotIndex0(), win->GetItemIndex(), 
					win->GetCount(), data->mPrice );
			}
		}
		break;
	case eMBEVENT_ITEM_PUTCARD_NEW:
	case eMBEVENT_ITEM_PUTCARD_UPDATE:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			cPutCardWindow* put = mpUI->GetPutCardWindow();
			if( win && put && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToPutCard( put->GetItemSlotIndex(), win->GetSlotIndex0(), win->GetSlotIndex1() );
		}
		break;
	case eMBEVENT_ITEM_CARDBOOK_TAROTNEW:
	case eMBEVENT_ITEM_CARDBOOK_TAROTUPDATE:
	case eMBEVENT_ITEM_CARDBOOK_SPREADNEW:
	case eMBEVENT_ITEM_CARDBOOK_SPREADUPDATE:
		{
			cItemMsgWindow* win = mpUI->GetItemMsgWindow();
			if( win && result == eUIID_ITEMMSG_YES )
				ITEMMAN->TryToCardBookAdd( win->GetSlotIndex0(), win->GetSlotIndex1() );
		}
		break;
	case eMBEVENT_MAPCHANGE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			MSG_REQ_PLAYER_MAPCHANGE Msg;
			Msg.Category = NM_PLAYER;
			Msg.Protocol = NM_PLAYER_MAPCHANGE_REQ;
			Msg.mMapChangePosIndex = (unsigned long)exData;

			NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

			UIMAN->CreateModal( eStage_Game,
				eMBEVENT_NONE, 
				GAMERESOURCEMAN->GetGameText( 67 ), //  ó 
				GAMERESOURCEMAN->GetGameText( 2 ), // ˸
				eSKIN_NONE
				);
		}
		break;
	case eMBEVENT_REVIVAL_STAND:
		if( result == eMESSAGE_BUTTON_YES )
		{
			cRevivalWindow* win = mpUI->GetReVivalWindow();
			if( win )
				win->NetLock();

			/// ڸȰ
			MSG_REQ_PLAYER_RESURRECTION msg;
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_RESURRECTION_REQ;
			msg.mFlag = eRESURRECTIONTYPE_STAND;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case eMBEVENT_REVIVAL_SKILL:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// ųȰ
			MSG_REQ_PLAYER_RESURRECTION msg;
			msg.Category = NM_PLAYER;
			msg.Protocol = NM_PLAYER_RESURRECTION_REQ;
			msg.mFlag = eRESURRECTIONTYPE_SKILL;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
		/// ŷ Ұ ɼ  ȹ 
	case eMBEVENT_ITEM_NOTEXCHANGE_GET:
		if( result == eMESSAGE_BUTTON_YES )
		{
			cLootingWindow* looting = mpUI->GetLootingWindow();
			if( looting )
			{
				if( (unsigned int)exData == ITEM_GET_ALL )
				{
					/// ü
					ITEMMAN->TryToGetItem( (unsigned int)ITEM_GET_ALL, 0 );
				}
				else
				{
					/// 
					sLootData* data = looting->GetSelectData();
					if( data )
						ITEMMAN->TryToGetItem( data->itemDefineIndex, data->count );
				}
			}
		}
		break;
	case eMBEVENT_GUILD_CREATE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			UIMAN->CreateModal(	eStage_Game,
								eMBEVENT_GUILD_INPUTNAME, 
								GAMERESOURCEMAN->GetGameText( 1234 ),	// û ޽
								GAMERESOURCEMAN->GetGameText( 1233 ),	//  
								eSKIN_EDIT, (void*)exData, 0, false, false, MAX_GUILDNAME_SIZE );
		}		
		else
		{
			UIMAN->HideNpcBack();
		}
		break;
	case eMBEVENT_GUILD_INPUTNAME:
		if( result == eMESSAGE_BUTTON_YES )
		{
			///  ׽Ʈ
			cUIWindow* pWin = (cUIWindow*)UIMAN->GetModalBox();
			if( pWin && pWin->IsKindof( eUINODE_MESSAGEBOX ) )
			{
				cMsgBox* pBox = (cMsgBox*)pWin;
				if( pBox->GetLength() > 0 )
				{
					GUILDMAN->SetTempData( pBox->GetEditText(), (unsigned long)exData );

					/// Ȯ
					cStringT str;
					str.Format( GAMERESOURCEMAN->GetGameText( 1235 ), pBox->GetEditText() );
					UIMAN->CreateModal(	eStage_Game,
						eMBEVENT_GUILD_CHECKNAME, 
						(LPCTSTR)str.Cstr(),	//  Ȯ
						GAMERESOURCEMAN->GetGameText( 1233 ),	//  
						eSKIN_YESNO
						);
				}			
				else
				{
					UIMAN->HideNpcBack();
					GUILDMAN->ClearTempData();
				}
			}
		}
		else
		{
			UIMAN->HideNpcBack();
			GUILDMAN->ClearTempData();
		}
		break;
	case eMBEVENT_GUILD_CHECKNAME:
		if( result == eMESSAGE_BUTTON_YES )
		{
			if( GUILDMAN->GuildCreate() == false )
				GUILDMAN->ClearTempData();
		}

		/// npc back ݱ
		UIMAN->HideNpcBack();
		break;
	case eMBEVENT_PVP_DM_NOTREADY:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// pvp out û
			MSGROOT msg;
			msg.Category = NM_PVP;
			msg.Protocol = NM_PVP_DM_END_REQ;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case eMBEVENT_GUILD_ADD:
		{
			// ʴ 
			char reply = (result == eMESSAGE_BUTTON_YES) ? 1 : 0;

			MSG_REQ_GUILD_REPLY msg;
			msg.Category = NM_GUILD;
			msg.Protocol = NM_GUILD_REPLY_REQ;
			msg.reply = reply;
			NETWORK->SendNetworkMsg( (char*)&msg, sizeof(msg) );
		}
		break;
	case eMBEVENT_GUILD_MEMBERDROP:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// 
			GUILDMAN->GuildCut( (unsigned long)exData );
		}
		break;
	case eMBEVENT_GUILD_OUT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			///  Ż
			GUILDMAN->GuildOut();
		}
		break;
	case eMBEVENT_GUILD_BREAK:
		if( result == eMESSAGE_BUTTON_YES )
		{
			///  
			GUILDMAN->GuildDelete();
		}
		break;
	case eMBEVENT_GUILD_ADDUSERNAME:
		if( result == eMESSAGE_BUTTON_YES )
		{
			/// ʴ  Է
			cUIWindow* pWin = (cUIWindow*)UIMAN->GetModalBox();
			if( pWin && pWin->IsKindof( eUINODE_MESSAGEBOX ) )
			{
				cMsgBox* pBox = (cMsgBox*)pWin;
				if( pBox->GetLength() > 0 )
				{
					GUILDMAN->GuildAdd( pBox->GetEditText() );
				}			
				else
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 30 ) );
				}
			}
		}
		break;
	case eMBEVENT_GUILD_GIVEPOSITION:
		if( result == eMESSAGE_BUTTON_YES )
		{
			///   
			cGuildWindow* win = mpUI->GetGuildWindow();
			if( win )
			{
				sGuildUserInfo* info = win->GetSelectUserInfo();
				if( info )
				{
					GUILDMAN->GuildGivePosition( info->characterIdx, info->position, (char)exData );
				}
				else
				{
					CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 1242 ) );
				}
			}
		}
		break;
	case eMBEVENT_TODAYWORD_EXIT:
		if( result == eMESSAGE_BUTTON_YES )
		{
			mpUI->HideTodayWordWindow();
		}
		break;
	case eMBEVENT_ITEMMIX_GIVEUP:
		if( result == eMESSAGE_BUTTON_YES )
		{
			ITEMMIXMAN->ItemMixCancel( false );
		}
		break;
	case eMBEVENT_ITEMMIX_DELETE:
		if( result == eMESSAGE_BUTTON_YES )
		{
			ITEMMIXMAN->ItemMixDelete( (unsigned char)exData );
		}
		break;
	case eMBEVENT_PLAYER_KICKED:
		{
			/// α׷ 
			::PostMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
			::PostQuitMessage(0);
		}
		break;
	default:
		assert(0);
		return;
	}
}
