#include "stdafx.h"
#include "GameUIManager.h"

#include "RenderSystem.h"
#include "StageManager.h"
#include "UIBackWindow.h"
#include "ChatWindow.h"
#include "TargetWindow.h"
#include "HeroInfoWindow.h"
#include "CastingBar.h"
#include "HeroStateWindow.h"
#include "MenuWindow.h"
#include "NpcWindow.h"
#include "NpcStoreWindow.h"
#include "InventoryWindow.h"
#include "WareHouseWindow.h"
#include "ItemCountWindow.h"
#include "ItemMsgWindow.h"
#include "TradeWindow.h"
#include "DragWindow.h"
#include "TipWindow.h"
#include "MiniMapWindow.h"
#include "OptionWindow.h"
#include "SmallMiniMapWindow.h"
#include "SkillWindow.h"
#include "SkillStoreWindow.h"
#include "BuffWindow.h"
#include "ColumnQuickSlot.h"
#include "RowQuickSlot.h"
#include "NoteWindow.h"
#include "FriendWindow.h"
#include "TarotWindow.h"
#include "TarotControlWindow.h"
#include "UserSellWindow.h"
#include "UserSellSearchWindow.h"
#include "BagWindow.h"
#include "ExitWindow.h"
#include "LootingWindow.h"
#include "RevivalWindow.h"
#include "PartyWindow.h"
#include "PartyStateWindow.h"
#include "QuestWindow.h"
#include "NpcRewardWindow.h"
#include "NpcDisjointWindow.h"
#include "SendNoteWindow.h"
#include "ReceiveNoteWindow.h"
#include "EnhancedWindow.h"
#include "QuestSimpleWindow.h"
#include "MoneyWindow.h"
#include "PutCardWindow.h"
#include "DuelMsgWindow.h"
#include "DuelWindow.h"
#include "PartyManager.h"
#include "CardBookWindow.h"
#include "ChatExtraWindow.h"
#include "SocialWindow.h"
#include "DMScoreWindow.h"
#include "DMMsgWindow.h"
#include "TitleWindow.h"
#include "GuildWindow.h"
#include "RButtonMenuWindow.h"
#include "ShortenKeyWindow.h"
#include "TodayWordWindow.h"
#include "ItemMixWindow.h"

#include "ItemTipWindow.h"
#include "SkillTipWindow.h"
#include "BuffToolTipWindow.h"
#include "SimpleTipWindow.h"

#include "UIManager.h"
#include "UIRootNode.h"

#include "QuestManager.h"
#include "PVPManager.h"
#include "ObjectManager.h"
#include "ChatManager.h"
#include "hero.h"
#include "UIMsgboxEvent.h"
#include "Application.h"
#include "KeyboardAgent.h"
#include "ObjectManager.h"
#include "TarotManager.h"
#include "CheatManager.h"
#include "ItemMixManager.h"
#include "Hero.h"

cGameUIManager* cGameUIManager::mpSingleton = 0;

#define POSHEARDER_VER		4
#define CHARHEARDER_VER		1


cGameUIManager::cGameUIManager(void)
: mpChatWindow(0)
, mpTargetWindow(0)
, mpHeroInfoWindow(0)
, mpInventoryWindow( 0 )
, mpWareHouseWindow( 0 )
, mpWareHouse2Window( 0 )
, mpItemCountWindow( 0 )
, mpItemMsgWindow(0)
, mpTradeWindow( 0 )
, mpDragWindow( 0 )
, mpCastingBar(0)
, mpChatManager(0)
, mpHeroStateWindow(0)
, mpSkillWindow(0)
, mpSkillStoreWindow(0)
, mpBuffWindow(0)
, mpDeBuffWindow(0)
, mpNpcWindow( 0 )
, mpNpcBackWindow( 0 )
, mpNpcStoreWindow( 0 )
, mpMiniMapWindow( 0 )
, mpOptionWindow(0)
, mpSmallMiniMapWindow(0)
, mpColumnQuickSlot(0)
, mpRowQuickSlot(0)
, mpNoteWindow(0)
, mpFriendWindow(0)
, mpTarotWindow(0)
, mpTarotControlWindow(0)
, mpUserSellWindow(0)
, mpItemTip(0)
, mpSkillTip(0)
, mpBuffTip(0)
, mpSimpleTip(0)
, mpUserSellSearchWindow(0)
, mpMenuButtonWindow(0)
, mpMenuHero(0)
, mpMenuCommu(0)
, mpMenuOption(0)
, mpExitWindow(0)
, mpExitMsgWindow(0)
, mpLootingWindow(0)
, mpRevivalWindow(0)
, mpPartyWindow(0)
, mpPartyMenu(0)
, mpPartyDivideMenu(0)
, mpMoneyWindow(0)
, mpQuestWindow(0)
, mpNpcRewardWindow(0)
, mpNpcDisjointWindow(0)
, mpEnhancedWindow(0)
, mpQuestSimpleWindow(0)
, mpPutCardWindow(0)
, mpDuelMsgWindow(0)
, mpDuelWindow(0)
, mpCardBookWindow(0)
, mpSendNoteWindow(0)
, mpReceiveNoteWindow(0)
, mpSocialWindow(0)
, mpDMScoreWindow(0)
, mpDMResultWindow(0)
, mpFSColumnQuickSlot(0)
, mpFSRowQuickSlot(0)
, mpDMMsgWindow(0)
, mpDMRevivalWindow(0)
, mpDMRankingListWindow(0)
, mpChatButtonWindow(0)
, mpChatItemTip(0)
, mpTitleWindow(0)
, mpGuildWindow(0)
, mpRButtonMenuWindow(0)
, mpGuildButtonWindow(0)
, mpGuildMarkWindow(0)
, mpGuildSendNoteWindow(0)
, mpShortenKeyWindow(0)
, mpTodayWordWindow(0)
, mpItemMixWindow(0)
, mChatBoxMaxRow(0)
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;

	mInitAllUI = false;

	for( int i = 0; i < 3; ++i )
		mpBagWindow[i] = 0;
	
	for( int i = 0; i < 5; ++i )
		mpPartyStateWindow[i] = 0;

	for( int i = 0; i < 3; ++i )
		mpChatExtraWindow[i] = 0;

	mDuelMode = false;

	mQuestCharacterIdx = 0;
}

cGameUIManager::~cGameUIManager()
{
	cSaveWindowPos::cIterator i = mSaveWindowInfo.Begin();
	cSaveWindowPos::cIterator end = mSaveWindowInfo.End();
	for( ; i!=end; i++ )
	{
		delete (sWindowPosData*)(i->mSecond);
	}
	mSaveWindowInfo.Clear();

	mpSingleton = 0;
}

void cGameUIManager::Init()
{
	UIMAN->SetCurrentStage( eStage_Game );

	/// ä    ʱȭ
	mpChatManager = new cChatManager;
	if( !mpChatManager || !mpChatManager->Init() )
	{
		SAFE_DELETE( mpChatManager );
		return;
	}

	/// ̴ϸ 
	mpMiniMapWindow = new cMiniMapWindow;
	mpMiniMapWindow->CreateByPropertyName( "P_MiniMap_Window", 0 );

	///  ̴ϸ 
	mpSmallMiniMapWindow = new cSmallMiniMapWindow;
	mpSmallMiniMapWindow->CreateByPropertyName( "P_SmallMiniMap_Window", 0 );

	/// äâ ư 
	mpChatButtonWindow = new cChatButtonWindow;
	mpChatButtonWindow->CreateByPropertyName( "P_ChatButtonWindow", 0 );
	UIMAN->AddEventOtherClick( mpChatButtonWindow );
	
	/// ä
	mpChatWindow = new cChatWindow;
	mpChatWindow->CreateByPropertyName( "P_ChatWindow", 0 );
	
	/// Ȯ ä
	for( int i = 0; i < 3; ++i )
	{
		mpChatExtraWindow[i] = new cChatExtraWindow;
		mpChatExtraWindow[i]->CreateByPropertyName( "P_ChatExtraWindow", 0 );
		mpChatExtraWindow[i]->SetPos( i );

		if( mpChatWindow )
			mpChatWindow->AddExtraWindow( (cUIWindow*)mpChatExtraWindow[i] );
	}

	if( mpChatExtraWindow[0] )
		mpChatExtraWindow[0]->ShowTop();

	/// Ÿ  
	mpTargetWindow = new cTargetWindow;
	mpTargetWindow->CreateByPropertyName( "P_TargetWindow", 0 );

	/// ĳ  
	mpHeroInfoWindow = new cHeroInfoWindow;
	mpHeroInfoWindow->CreateByPropertyName( "P_HeroInfoWindow", 0 );

	/// ĳ 
	mpCastingBar = new cCastingBar;
	mpCastingBar->CreateByPropertyName( "P_CastingBar", 0 );
	
	/// ĳ   (   )
	mpHeroStateWindow = new cHeroStateWindow;
	mpHeroStateWindow->CreateByPropertyName( "P_HeroStateWindow", 0 );

	/// Npc 
	mpNpcWindow = new cNpcWindow;
	mpNpcWindow->CreateByPropertyName( "P_NpcTelling_Window", 0 );

	/// npc   
	mpNpcRewardWindow = new cNpcRewardWindow;
	mpNpcRewardWindow->CreateByPropertyName( "P_NpcReward_Window", mpNpcWindow );

	/// Npc  
	mpNpcBackWindow = new cUIBackWindow;
	mpNpcBackWindow->SetOnlyBackground( true );
	mpNpcBackWindow->CreateBySkinName( "NpcBack_Window", 0, 1 );
	UIMAN->SetNpcBackWindow( mpNpcBackWindow );

	/// Npc  
	mpNpcStoreWindow = new cNpcStoreWindow;
	mpNpcStoreWindow->CreateByPropertyName( "P_NpcStore_Window", 0 );

	///  ()
	mpColumnQuickSlot = new cColumnQuickSlot;
	mpColumnQuickSlot->CreateByPropertyName( "P_ColumnQuickSlot", 0 );

	///  ()
	mpRowQuickSlot = new cRowQuickSlot;
	mpRowQuickSlot->CreateByPropertyName( "P_RowQuickSlot", 0 );

	/// FS 
	mpFSColumnQuickSlot = new cFSColumnQuickSlot;
	mpFSColumnQuickSlot->CreateByPropertyName( "P_FSColumnQuickSlot", 0 );

	/// FS 
	mpFSRowQuickSlot = new cFSRowQuickSlot;
	mpFSRowQuickSlot->CreateByPropertyName( "P_FSRowQuickSlot", 0 );

	/// κ丮 
	mpInventoryWindow = new cInventoryWindow;
	mpInventoryWindow->CreateByPropertyName( "P_Inventory_Window", 0 );

	///  
	mpBagWindow[0] = new cBagWindow( mpInventoryWindow, 0 );
	mpBagWindow[0]->CreateByPropertyName( "P_Bag0_Window", 0 );

	mpBagWindow[1] = new cBagWindow( mpInventoryWindow, 1 );
	mpBagWindow[1]->CreateByPropertyName( "P_Bag1_Window", 0 );

	mpBagWindow[2] = new cBagWindow( mpInventoryWindow, 2 );
	mpBagWindow[2]->CreateByPropertyName( "P_Bag2_Window", 0 );

	///   
	mpItemCountWindow = new cItemCountWindow;
	mpItemCountWindow->CreateByPropertyName( "P_ItemCount_Window", 0 );

	/// â 
	mpWareHouseWindow = new cWareHouseWindow;
	mpWareHouseWindow->CreateByPropertyName( "P_WareHouse_Window", 0 );

	mpWareHouse2Window = new cWareHouse2Window( mpWareHouseWindow );
	mpWareHouse2Window->CreateByPropertyName( "P_WareHouse2_Window", 0 );

	mpMoneyWindow = new cMoneyWindow;
	mpMoneyWindow->CreateByPropertyName( "P_Money_Window", 0 );

	/// ŷ 
	mpTradeWindow = new cTradeWindow;
	mpTradeWindow->CreateByPropertyName( "P_Trade_Window", 0 );

	/// ų 
	mpSkillWindow = new cSkillWindow;
	mpSkillWindow->CreateByPropertyName( "P_SkillWindow", 0 );

	mpSkillStoreWindow = new cSkillStoreWindow;
	mpSkillStoreWindow->CreateByPropertyName( "P_SkillStoreWindow", 0 );

	///  â
	mpBuffWindow = new cBuffWindow;
	mpBuffWindow->CreateByPropertyName( "P_BuffWindow", 0 );
	mpBuffWindow->SetHeroBuff( true );

	///  â
	mpDeBuffWindow = new cBuffWindow;
	mpDeBuffWindow->CreateByPropertyName( "P_DeBuffWindow", 0 );
	mpDeBuffWindow->SetHeroBuff( true );

	/// 巡 
	mpDragWindow = new cDragWindow;
	mpDragWindow->CreateByPropertyName( "P_Drag_Window", 0 );
	UIMAN->SetDragWindow( mpDragWindow );

	///  
	mpItemTip = new cItemTipWindow;
	mpItemTip->CreateByPropertyName( "P_ItemTip", 0 );

	/// ų  
	mpSkillTip = new cSkillTipWindow;
	mpSkillTip->CreateByPropertyName( "P_SkillTip", 0 );

	///    
	mpBuffTip = new cBuffToolTipWindow;
	mpBuffTip->CreateByPropertyName( "P_BuffTip", 0 );

	///
	mpSimpleTip = new cSimpleTipWindow;
	mpSimpleTip->CreateByPropertyName( "P_SimpleTip", 0 );

	/// ä  
	mpChatItemTip = new cChatTipWindow;
	mpChatItemTip->CreateByPropertyName( "P_ChatItemTip", 0 );
	UIMAN->SetChatItemTipWindow( mpChatItemTip );

	/// ϴ ư 
	mpMenuButtonWindow = new cMenuButtonWindow;
	mpMenuButtonWindow->CreateByPropertyName( "P_MenuButtonWindow", 0 );

	/// ϴܸ޴ 
	mpMenuHero = new cMenuHeroWindow;
	mpMenuHero->CreateByPropertyName( "P_MenuHeroWindow", 0 );
	mpMenuButtonWindow->AddMenu( eMENU_HERO, mpMenuHero );

	mpMenuCommu = new cMenuCommuityWindow;
	mpMenuCommu->CreateByPropertyName( "P_MenuCommunityWindow", 0 );
	mpMenuButtonWindow->AddMenu( eMENU_COMMU, mpMenuCommu );

	mpMenuOption = new cMenuOptionWindow;
	mpMenuOption->CreateByPropertyName( "P_MenuOptionWindow", 0 );
	mpMenuButtonWindow->AddMenu( eMENU_OPTION, mpMenuOption );
	
	/// ý  
	mpOptionWindow = new cOptionWindow;
	mpOptionWindow->CreateByPropertyName( "P_Option_Window", 0 );

	///  Ŵ 
	mpNoteWindow = new cNoteWindow;
	mpNoteWindow->CreateByPropertyName( "P_NoteWindow", 0 );

	///   
	mpSendNoteWindow = new cSendNoteWindow;
	mpSendNoteWindow->CreateByPropertyName( "P_SendNoteWindow", 0 );

	///  ޱ 
	mpReceiveNoteWindow = new cReceiveNoteWindow;
	mpReceiveNoteWindow->CreateByPropertyName( "P_ReceiveNoteWindow", 0 );

	/// ģ  
	mpFriendWindow = new cFriendWindow;
	mpFriendWindow->CreateByPropertyName( "P_FriendWindow", 0 );

	mpTarotWindow = new cTarotWindow;
	mpTarotWindow->CreateByPropertyName( "P_TarotWindow", 0 );

	/// Ÿ   (  )
	mpTarotControlWindow = new cTarotControlWindow;
	mpTarotControlWindow->CreateByPropertyName( "P_TarotControlWindow", 0 );

	///  
	mpUserSellWindow = new cUserSellWindow;
	mpUserSellWindow->CreateByPropertyName( "P_UserSellWindow", 0 );

	///  ˻
	mpUserSellSearchWindow = new cUserSellSearchWindow;
	mpUserSellSearchWindow->CreateByPropertyName( "P_UserSellSearchWindow", 0 );

	///   
	mpExitWindow = new cExitWindow;
	mpExitWindow->CreateByPropertyName( "P_ExitWindow", 0 );

	mpExitMsgWindow = new cExitMsgWindow;
	mpExitMsgWindow->CreateByPropertyName( "P_ExitMsg_Window", 0 );

	///   
	mpLootingWindow	= new cLootingWindow;
	mpLootingWindow->CreateByPropertyName( "P_LootingWindow", 0 );

	/// Ȱ 
	mpRevivalWindow = new cRevivalWindow;
	mpRevivalWindow->CreateByPropertyName( "P_RevivalWindow", 0 );

	/// Ƽ  
	mpPartyWindow = new cPartyWindow;
	mpPartyWindow->CreateByPropertyName( "P_PartyWindow", 0 );

	/// Ƽ  
	mpPartyMenu = new cPartyMenu;
	mpPartyMenu->CreateByPropertyName( "P_PartyMenu", 0 );
	UIMAN->AddEventOtherClick( mpPartyMenu );

	/// Ƽ йŸ  
	mpPartyDivideMenu = new cPartyDivideMenu;
	mpPartyDivideMenu->CreateByPropertyName( "P_PartyDivdeMenu", 0 );

	/// Ƽ  
	cUIProperty* p = UIMAN->GetProperty();
	cUINodeProperty* pPartyProp = p->GetNodeProperty( "P_PartyStateWindow" );
	assert( pPartyProp );
	if( pPartyProp )
	{
		for( int i = 0; i < 5; ++i )
		{
			mpPartyStateWindow[i] = new cPartyStateWindow;
			mpPartyStateWindow[i]->CreateByPropertyId( pPartyProp, 0, eUIID_GAME_PARTYSTATE_WINDOW1 + i );
			mpPartyStateWindow[i]->InitPosition( i );
		}
	}

	/// Ʈ 
	mpQuestWindow = new cQuestWindow;
	mpQuestWindow->CreateByPropertyName( "P_QuestWindow", 0 );

	///   
	mpNpcDisjointWindow = new cNpcDisjointWindow;
	mpNpcDisjointWindow->CreateByPropertyName( "P_NpcDisjointWindow", 0 );

	///  ȭ 
	mpEnhancedWindow = new cEnhancedWindow;
	mpEnhancedWindow->CreateByPropertyName( "P_EnhancedWindow", 0 );

	/// Ʈ   
	mpQuestSimpleWindow = new cQuestSimpleWindow;
	mpQuestSimpleWindow->CreateByPropertyName( "P_QuestSimpleWindow", 0 );

	mpItemMsgWindow = new cItemMsgWindow;
	mpItemMsgWindow->CreateByPropertyName( "P_ItemMsg_Window", 0 );

	/// ī  
	mpPutCardWindow = new cPutCardWindow;
	mpPutCardWindow->CreateByPropertyName( "P_PutCardWindow", 0 );

	///  
	mpDuelMsgWindow = new cDuelMsgWindow;
	mpDuelMsgWindow->CreateByPropertyName( "P_DuelMsg_Window", 0 );

	mpDuelWindow = new cDuelWindow;
	mpDuelWindow->CreateByPropertyName( "P_DuelWindow", 0, true );

	/// ī ÷ 
	mpCardBookWindow = new cCardBookWindow;
	mpCardBookWindow->CreateByPropertyName( "P_CardBook_Window", 0 );

	/// ȸ 
	mpSocialWindow = new cSocialWindow;
	mpSocialWindow->CreateByPropertyName( "P_SocialWindow", 0 );

	/// ġ  
	mpDMScoreWindow = new cDMScoreWindow;
	mpDMScoreWindow->CreateByPropertyName( "P_PVP_DMScoreWindow", 0 );
	mpDMScoreWindow->ShowTop();

	/// Ranking window
	mpDMRankingListWindow = new cDMRankingListWindow;
	mpDMRankingListWindow->CreateByPropertyName( "P_PVP_DMMiddleResultWindow", 0 );

	/// ġ  
	mpDMResultWindow = new cDMResultWindow;
	mpDMResultWindow->CreateByPropertyName( "P_PVP_DMResultWindow", 0 );

	/// ġ  
	mpDMMsgWindow = new cDMMsgWindow;
	mpDMMsgWindow->CreateByPropertyName( "P_PVP_DMMsgWindow", 0 );

	mpDMRevivalWindow = new cDMRevivalWindow;
	mpDMRevivalWindow->CreateByPropertyName( "P_PVP_RevivalWindow", 0 );
	
	/// ȣĪ 
	mpTitleWindow = new cTitleWindow;
	mpTitleWindow->CreateByPropertyName( "P_HeroTitleWindow", 0 );

	///   
	mpGuildWindow =	new cGuildWindow;
	mpGuildWindow->CreateByPropertyName( "P_GuildWindow", 0 );

	///   ư 
	mpGuildButtonWindow = new cGuildButtonWindow;
	mpGuildButtonWindow->CreateByPropertyName( "P_GuildPosition_Window", 0 );

	///  ũ  
	mpGuildMarkWindow = new cGuildMarkWindow;
	mpGuildMarkWindow->CreateByPropertyName( "P_GuildMark_Window", 0 );

	///   
	mpGuildSendNoteWindow = new cGuildSendNoteWindow;
	mpGuildSendNoteWindow->CreateByPropertyName( "P_GuildSendNoteWindow", 0 );

	///   
	mpShortenKeyWindow = new cShortenKeyWindow;
	mpShortenKeyWindow->CreateByPropertyName( "P_ShortenKey_Window", 0 );

	/// Popup Menu window
	mpRButtonMenuWindow = new cRButtonMenuWindow;
	mpRButtonMenuWindow->CreateByPropertyName( "P_RButtonMenu", 0 );

	///  Ѹ 
	mpTodayWordWindow = new cTodayWordWindow;
	mpTodayWordWindow->CreateByPropertyName( "P_TodayWordWindow", 0 );

	///   
	mpItemMixWindow = new cItemMixWindow;
	mpItemMixWindow->CreateByPropertyName( "P_ItemMixWindow", 0 );

	mInitAllUI = true;

	///
	if( LoadWindowPos("./Option/user.opt") == false )
	{
		mChatWinOption[0].checkNormal = true;
		mChatWinOption[0].checkParty = true;
		mChatWinOption[0].checkGuild = true;
		mChatWinOption[0].checkShout = true;
		mChatWinOption[0].checkTrade = true;
		mChatWinOption[0].checkWhisper = true;
		mChatWinOption[0].checkSystem = false;

		mChatWinOption[1].checkNormal = false;
		mChatWinOption[1].checkParty = false;
		mChatWinOption[1].checkGuild = false;
		mChatWinOption[1].checkShout = false;
		mChatWinOption[1].checkTrade = false;
		mChatWinOption[1].checkWhisper = false;
		mChatWinOption[1].checkSystem = true;

		for( unsigned int i=2;i<4; i++ )
		{
			mChatWinOption[i].checkNormal = false;
			mChatWinOption[i].checkParty = false;
			mChatWinOption[i].checkGuild = false;
			mChatWinOption[i].checkShout = false;
			mChatWinOption[i].checkTrade = false;
			mChatWinOption[i].checkWhisper = false;
			mChatWinOption[i].checkSystem = false;
		}

		mMiniWinPer = 50.0f;
	}

	///
	ApplyWindowPos();
}

void cGameUIManager::Exit()
{
	for( int i = 0; i < 5; ++i )
	{
		mpPartyStateWindow[i]->Clear();
		mpPartyStateWindow[i] = 0;
	}

	for( int i = 0; i < 3; ++i )
		mpBagWindow[i] = 0;
	
	mpItemMixWindow = 0;
	mpTodayWordWindow = 0;
	mpShortenKeyWindow = 0;
	mpRButtonMenuWindow = 0;
	mpGuildSendNoteWindow = 0;
	mpGuildMarkWindow = 0;
	mpGuildButtonWindow = 0;
	mpGuildWindow = 0;
	mpTitleWindow = 0;
	mpChatButtonWindow = 0;
	mpDMRankingListWindow = 0;
	mpDMRevivalWindow = 0;
	mpDMMsgWindow = 0;
	mpDMResultWindow = 0;
	mpDMScoreWindow = 0;
	mpSocialWindow = 0;
	mpReceiveNoteWindow = 0;
	mpSendNoteWindow = 0;
	mpCardBookWindow = 0;
	mpDuelMsgWindow = 0;
	mpDuelWindow = 0;
	mpPutCardWindow = 0;
	mpQuestSimpleWindow = 0;
	mpEnhancedWindow = 0;
	mpNpcDisjointWindow = 0;
	mpQuestWindow = 0;
	mpMoneyWindow = 0;
	mpPartyDivideMenu = 0;
	mpPartyMenu = 0;
	mpPartyWindow = 0;
	mpRevivalWindow = 0;
	mpLootingWindow = 0;
	mpExitWindow = 0;
	mpExitMsgWindow = 0;
	mpUserSellSearchWindow = 0;
	mpUserSellWindow = 0;
	mpTarotControlWindow = 0;
	mpTarotWindow = 0;
	mpFriendWindow = 0;
	mpNoteWindow = 0;
	mpSmallMiniMapWindow = 0;
	mpMiniMapWindow = 0;
	mpOptionWindow = 0;
	mpMenuHero = 0;
	mpMenuCommu = 0;
	mpMenuOption = 0;
	mpMenuButtonWindow = 0;
	mpSkillWindow = 0;
	mpSkillStoreWindow = 0;
	mpBuffWindow = 0;
	mpDeBuffWindow = 0;
	mpInventoryWindow = 0;
	mpNpcRewardWindow = 0;
	mpNpcWindow = 0;
	mpNpcBackWindow = 0;
	mpNpcStoreWindow = 0;
	mpHeroStateWindow = 0;
	mpHeroInfoWindow = 0;
	mpTargetWindow = 0;
	mpChatWindow = 0;
	mpCastingBar = 0;
	
	if( mpChatManager )
	{
		SAFE_DELETE( mpChatManager );
	}
}

void cGameUIManager::Open()
{
	UIMAN->SetCurrentStage( eStage_Game );

	mpHeroInfoWindow->Hide( false );
	mpSkillWindow->Hide( false );
	mpSkillStoreWindow->Hide( false );
	mpBuffWindow->Hide( false );
	mpDeBuffWindow->Hide( false );
	mpNoteWindow->Hide( false );
	mpFriendWindow->Hide( false );
	mpTarotWindow->Hide( false );
	mpTarotControlWindow->Hide( false );
	mpUserSellWindow->Hide( false );
	mpExitWindow->Hide( false );
	mpExitMsgWindow->Hide( false );
	mpLootingWindow->Hide( false );
	mpRevivalWindow->Hide( false );
	mpPartyWindow->Hide( false );
	mpPartyMenu->Hide( false );
	mpPartyDivideMenu->Hide( false );
	mpCastingBar->Hide( false );
	mpDragWindow->Hide( false );
	mpQuestWindow->Hide( false );
	mpNpcDisjointWindow->Hide( false );
	mpEnhancedWindow->Hide( false );
	mpQuestSimpleWindow->Hide( false );
	mpPutCardWindow->Hide( false );
	mpOptionWindow->Hide( false );
	mpSocialWindow->Hide( false );
	mpDMScoreWindow->Hide( false );
	mpDMResultWindow->Hide( false );
	mpDMMsgWindow->Hide( false );
	mpChatButtonWindow->Hide( false );
	mpChatItemTip->Hide( false );
	mpTitleWindow->Hide( false );
	mpGuildWindow->Hide( false );
	mpGuildButtonWindow->Hide( false );
	mpDMRankingListWindow->Hide( false );
	mpDMRevivalWindow->Hide( false );
	mpDuelMsgWindow->Hide( false );
	mpDuelWindow->Hide( false );
	mpReceiveNoteWindow->Hide( false );
	mpSendNoteWindow->Hide( false );
	mpRButtonMenuWindow->Hide( false );
	mpGuildMarkWindow->Hide( false );
	mpGuildSendNoteWindow->Hide( false );
	mpShortenKeyWindow->Hide( false );
	mpTodayWordWindow->Hide( false );
	mpItemMixWindow->Hide( false );

	mpCardBookWindow->UIStageIn();
	mpCardBookWindow->Hide( false );

	for( int i = 0; i < 5; ++i )
	{
        mpPartyStateWindow[i]->Hide( false );
		mpPartyStateWindow[i]->Clear();
	}

	mpChatWindow->ShowTop( false, false );

	mpHeroStateWindow->ShowTop( false, false );
	mpMenuButtonWindow->ShowTop( false, false );
		
	/// κ ʱȭ
	mpInventoryWindow->UIStageIn();
	mpInventoryWindow->Hide( false );

	if( QUICKMAN->IsRowQuick() == true )
	{
		mpRowQuickSlot->ShowTop( false, false );
		mpColumnQuickSlot->Hide();
	}
	else
	{
		mpRowQuickSlot->Hide();
		mpColumnQuickSlot->ShowTop( false, false );
	}

	if( QUICKMAN->IsRowQuickFS() == true )
	{
		mpFSRowQuickSlot->ShowTop( false, false );
		mpFSColumnQuickSlot->Hide();
	}
	else
	{
		mpFSRowQuickSlot->Hide();
		mpFSColumnQuickSlot->ShowTop( false, false );
	}

	/// ̴ϸ ʱȭ
	mpMiniMapWindow->UIStageIn();
	mpSmallMiniMapWindow->UIStageIn();
	mpSmallMiniMapWindow->ShowTop( false, false );

	mpNpcWindow->UIStageIn();
	mpTargetWindow->UIStageIn();

	///
	if( mQuestCharacterIdx != HERO->GetObjectID() )
	{
		char name[MAX_NAME_BUFFER_SIZE];	/// ̵
		ConvertToAscii( HERO->GetName(), name, MAX_NAME_BUFFER_SIZE );

		cString str;
		str.Format( "./Option/%s_%d.opc",  name, HERO->GetObjectID()%1000 );

		LoadWindowOption_Character( str );
	}
}

void cGameUIManager::Close()
{
	SaveWindowPos("./Option/user.opt");

	char name[MAX_NAME_BUFFER_SIZE];	/// ̵
	ConvertToAscii( HERO->GetName(), name, MAX_NAME_BUFFER_SIZE );

	cString str;
	str.Format( "./Option/%s_%d.opc",  name, HERO->GetObjectID()%1000 );

	SaveWindowOption_Character( str );

	UIMAN->SetCurrentStage( eStage_Game );
	
	mpChatWindow->Hide( false );
	mpHeroInfoWindow->Hide( false );
	mpHeroStateWindow->Hide( false );
	mpRevivalWindow->Hide( false );
	mpMenuButtonWindow->Hide( false );
	mpMenuHero->Hide( false );
	mpMenuCommu->Hide( false );
	mpMenuOption->Hide( false );
	mpOptionWindow->Hide( false );
	mpCastingBar->Hide( false );
	mpTargetWindow->Hide( false );
	mpFSColumnQuickSlot->Hide( false );
	mpFSRowQuickSlot->Hide( false );
	mpColumnQuickSlot->Hide( false );
	mpRowQuickSlot->Hide( false );
	mpFriendWindow->Hide( false );
	mpTargetWindow->Hide( false );
	mpTarotControlWindow->Hide( false );
	mpUserSellWindow->Hide( false );
	mpUserSellSearchWindow->Hide( false );
	mpExitWindow->Hide( false );
	mpExitMsgWindow->Hide( false );
	mpLootingWindow->Hide( false );
	mpPartyWindow->Hide( false );
	mpPartyMenu->Hide( false );
	mpPartyDivideMenu->Hide( false );
	mpDragWindow->Hide( false );
	mpQuestWindow->Hide( false );
	mpNpcDisjointWindow->Hide( false );
	mpEnhancedWindow->Hide( false );
	mpQuestSimpleWindow->Hide( false );
	mpPutCardWindow->Hide( false );
	mpDuelMsgWindow->Hide( false );
	mpDuelWindow->Hide( false );
	mpReceiveNoteWindow->Hide( false );
	mpSendNoteWindow->Hide( false );
	mpCardBookWindow->Hide( false );
	mpSocialWindow->Hide( false );
	mpDMScoreWindow->Hide( false );
	mpDMResultWindow->Hide( false );
	mpDMMsgWindow->Hide( false );
	mpDMRankingListWindow->Hide( false );
	mpDMRevivalWindow->Hide( false );
	mpChatButtonWindow->Hide( false );
	mpChatItemTip->Hide( false );
	mpTitleWindow->Hide( false );
	mpGuildWindow->Hide( false );
	mpGuildButtonWindow->Hide( false );
	mpRButtonMenuWindow->Hide( false );
	mpGuildSendNoteWindow->Hide( false );
	mpShortenKeyWindow->Hide( false );
	mpTodayWordWindow->Hide( false );
	mpItemMixWindow->Hide( false );

	mpSkillWindow->Clear();
	mpSkillWindow->Hide( false );

	mpSkillStoreWindow->Hide( false );

	mpNoteWindow->Clear();
	mpNoteWindow->Hide( false );

	mpBuffWindow->Clear();
	mpBuffWindow->Hide( false );

	mpDeBuffWindow->Clear();
	mpDeBuffWindow->Hide( false );

	mpMiniMapWindow->Clear();
	mpMiniMapWindow->Hide( false );

	mpSmallMiniMapWindow->Clear();
	mpSmallMiniMapWindow->Hide( false );

	mpInventoryWindow->Hide( false );

	mpNpcWindow->Close();
	mpNpcWindow->Hide();

	mpGuildMarkWindow->Hide( false );

	for( int i = 0; i < 5; ++i )
	{
		mpPartyStateWindow[i]->Clear();
		mpPartyStateWindow[i]->Hide( false );
	}

	///  ui lock Ǯ 
	UIMAN->CloseAllMsgBox( false );
	UIMAN->NetUnLockAllUI();	

#ifdef _GMTOOL
	CHEATMAN->Clear();
#endif
}

void cGameUIManager::Process( unsigned long deltaTime, unsigned long accumTime )
{

}

void cGameUIManager::ChangeTab()
{
	assert( mpRowQuickSlot );
	assert( mpColumnQuickSlot );

	if( mpRowQuickSlot && mpColumnQuickSlot )
	{
		///   巡 ʱȭ
		UIMAN->HideDrag( mpRowQuickSlot );
		UIMAN->HideDrag( mpColumnQuickSlot );

		mpRowQuickSlot->ChangeTab();
		mpColumnQuickSlot->ChangeTab();
	}
}

void cGameUIManager::ChangeTab( int tabIndex )
{
	assert( mpRowQuickSlot );
	assert( mpColumnQuickSlot );

	if( mpRowQuickSlot && mpColumnQuickSlot )
	{
		///   巡 ʱȭ
		UIMAN->HideDrag( mpRowQuickSlot );
		UIMAN->HideDrag( mpColumnQuickSlot );

		mpRowQuickSlot->ChangeTab( tabIndex );
		mpColumnQuickSlot->ChangeTab( tabIndex );
	}
}

bool cGameUIManager::CheckHeroState()
{
	/// hero   ˻
	if( HERO->GetState() == eOBJECT_STATE_STOP )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );

		/*int state = HERO->GetStopFlag();
		switch( state )
		{
		case eSTOP_READYTAROT:
		case eSTOP_OPENTAROT:
		case eSTOP_ENTERTAROT:
		case eSTOP_USETAROT:
		case eSTOP_OPENSTALL:
		case eSTOP_USESTALL:
		case eSTOP_EXCHANGE:
		case eSTOP_ITEMMIX:
			{
				CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );
				return false;
			}
			break;
		default:
			break;
		}*/
	}
	return true;
}

void cGameUIManager::ReqFinish( bool exitEvent )
{
	if( CheckHeroState() == false )
		return;

	if( HERO->GetState() != eOBJECT_STATE_IDLE )
	{
		CHATMANAGER->AddSystemMsg( eSYSTEM_NORMAL, GAMERESOURCEMAN->GetGameText( 58 ) );
		return;
	}

	///   5
	MSGROOT Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_GAMEFINISH_REQ;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

//	HERO->SetState( eOBJECT_STATE_STOP );
//	HERO->SetStopFlag( eSTOP_GAMEFINISH );

	if( mpExitMsgWindow )
	{
		mpExitMsgWindow->ShowExitMsg( exitEvent );
		mpExitMsgWindow->NetLock();
	}

	if( mpExitWindow )
		mpExitWindow->Hide(false);
}


void cGameUIManager::SendDisConnect()
{
//	if( CheckHeroState() == false )
//		return;

	///  
	MSGROOT Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_DISCONNECT_REQ;
	if( NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) ) == false )
	{
		/// α׷ 
		::SendMessage( THEAPP->GetHWND(), WM_CLOSE, 0, 0 );
		::PostQuitMessage(0);
	}

	///  ui 
	if( mpExitWindow )
		mpExitWindow->NetLock();

//	if( mpMenuWindow )
//		mpMenuWindow->NetLock();
}

void cGameUIManager::SendGameOut()
{
//	if( CheckHeroState() == false )
//		return;

	/// ĳ â ̵
	MSGROOT Msg;
	Msg.Category = NM_PLAYER;
	Msg.Protocol = NM_PLAYER_GAMEOUT_REQ;
	NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );

	///  ui 
	if( mpExitWindow )
		mpExitWindow->NetLock();

//	if( mpMenuWindow )
//		mpMenuWindow->NetLock();
}

void cGameUIManager::NetLockParty( int lockTry )
{
	if( mpPartyMenu )
		mpPartyMenu->NetLock( lockTry );

	if( mpFriendWindow )
		mpFriendWindow->NetLock( lockTry );

	if( mpPartyDivideMenu )
		mpPartyDivideMenu->NetLock( lockTry );
}

void cGameUIManager::NetUnLockParty( int lockTry )
{
	if( mpPartyMenu )
		mpPartyMenu->NetUnLock( lockTry );

	if( mpFriendWindow )
		mpFriendWindow->NetUnLock( lockTry );

	if( mpPartyDivideMenu )
		mpPartyDivideMenu->NetUnLock( lockTry );
}

void cGameUIManager::OnFocusChatWindow( unsigned long key, LPCTSTR addstring )
{
	assert(mpChatWindow);
	if( mpChatWindow )
	{
		cStringT str;
		switch( key )
		{
		case KEY_RETURN:
			break;
		case KEY_SLASH:			/// "/" ڵԷ
			str.Format(_T("/"));
			break;
		case KEY_APOSTROPHE:	/// ӼӸ ڵԷ
			{
				if( ::_tcslen(addstring) == 0 )
					str.Format( UIMAN->GetUIText(10001) );
				else
					str.Format( _T("%s%s "), UIMAN->GetUIText(10001), addstring );
			}
			break;
		case KEY_SEMICOLON:		/// Ƽ ڵԷ
			str.Format( UIMAN->GetUIText(10013) );
			break;
		case KEY_PERIOD:		/// ġ ڵԷ
			str.Format( UIMAN->GetUIText(10023) );
			break;
		}

		if( key != KEY_RETURN )
			mpChatWindow->SetChatText( (LPCTSTR)str.Cstr() );

		///
		mpChatWindow->SetFocusToEdit();
	}
}

/// ¿  ó
void cGameUIManager::HideUIByDie()
{
	if( mpTarotControlWindow )
		mpTarotControlWindow->Hide();

	if( mpTarotWindow )
		mpTarotWindow->Hide();

	if( mpUserSellWindow )
		mpUserSellWindow->Hide();

	if( mpTradeWindow )
		mpTradeWindow->Hide();

	if( mpCardBookWindow )
		mpCardBookWindow->Hide();

	if( mpEnhancedWindow )
		mpEnhancedWindow->Hide();

	if( mpItemMixWindow )
		mpItemMixWindow->Hide();

	///
	HideAllNpcWindow();

	TAROTMAN->ChangePage( ePAGE_NONE );
	ITEMMAN->ClearUserSellTarget();

	HERO->DeActiveTarotBubble();
	HERO->DeActiveUserSellBubble();

	/// Ȱâ  
	if( PVPMAN->IsEnableBattle() == true )
	{
		/// show 10' wait msgbox
		assert(mpDMRevivalWindow);
		mpDMRevivalWindow->ShowModal();
	}
	else
		ShowRevivalWindow();
}

void cGameUIManager::HideItemSetWindow( cUIWindow* exceptWin )
{
	assert( mpItemMixWindow );
	assert( mpPutCardWindow );
	assert( mpEnhancedWindow );

	if( mpItemMixWindow != exceptWin )
		mpItemMixWindow->Hide();

	if( mpPutCardWindow != exceptWin )
		mpPutCardWindow->Hide();

	if( mpEnhancedWindow != exceptWin )
		mpEnhancedWindow->Hide();
}

void cGameUIManager::ToggleOptionWindow()
{
	assert(mpOptionWindow);

	if( mpOptionWindow )
		mpOptionWindow->Toggle();
}

void cGameUIManager::ToggleHeroInfoWindow()
{
	assert(mpHeroInfoWindow);

	if( mpHeroInfoWindow )
	{
		mpHeroInfoWindow->Toggle();

		/// hero Ѵ.
		if( mpHeroInfoWindow->IsVisible() )
			UpdateHeroInfo();
	}
}

void cGameUIManager::ToggleInventoryWindow()
{
	assert( mpInventoryWindow );

	if( mpInventoryWindow )
	{
		mpInventoryWindow->Toggle();
		if( mpInventoryWindow->IsVisible() )
		{
			mpItemCountWindow->Hide();
		}
	}
}

void cGameUIManager::ToggleBagWindow( unsigned int i )
{
	assert( mpBagWindow[i] );

	if( mpBagWindow[i] )
		mpBagWindow[i]->Toggle();
}

void cGameUIManager::ToggleWareHouse2Window()
{
	assert( mpWareHouse2Window );

	if( mpWareHouse2Window )
		mpWareHouse2Window->Toggle();
}


void cGameUIManager::ToggleSmallMiniMapWindow()
{
	if( mDuelMode )
		return;

	assert(mpSmallMiniMapWindow);

	if( mpSmallMiniMapWindow )
		mpSmallMiniMapWindow->Toggle();
}

void cGameUIManager::ToggleMiniMapWindow()
{
	assert(mpMiniMapWindow);

	if( mpMiniMapWindow )
		mpMiniMapWindow->Toggle();
}

///
void cGameUIManager::ToggleNoteWindow()
{
	assert( mpNoteWindow );

	if( mpNoteWindow )
		mpNoteWindow->Toggle();
}

///
void cGameUIManager::ToggleFriendWindow()
{
	assert( mpFriendWindow );

	if( mpFriendWindow )
		mpFriendWindow->Toggle();
}

void cGameUIManager::ToggleSkillWindow()
{
	assert( mpSkillWindow );

	if( mpSkillWindow )
		mpSkillWindow->Toggle();
}

void cGameUIManager::ToggleQuestWindow()
{
	assert( mpQuestWindow );

	if( mpQuestWindow )
		mpQuestWindow->Toggle();
}

void cGameUIManager::TogglePartyMenu()
{
	assert( mpPartyMenu );

	if( mpPartyMenu )
		mpPartyMenu->Toggle();
}

void cGameUIManager::TogglePartyDivideMenu()
{
	assert( mpPartyDivideMenu );

	if( mpPartyDivideMenu )
		mpPartyDivideMenu->Toggle();
}

void cGameUIManager::ToggleUserSellSearchWindow()
{
	assert( mpUserSellSearchWindow );

	if( mpUserSellSearchWindow )
		mpUserSellSearchWindow->Toggle();
}

void cGameUIManager::TogglePutCardWindow()
{
	if( mpPutCardWindow )
		mpPutCardWindow->Toggle();
}

void cGameUIManager::ToggleCardBookWindow()
{
	if( mpCardBookWindow )
		mpCardBookWindow->Toggle();
}

void cGameUIManager::ToggleSocialWindow()
{
	if( mpSocialWindow )
		mpSocialWindow->Toggle();
}

void cGameUIManager::ToggleGuildWindow()
{
	if( mpGuildWindow )
		mpGuildWindow->Toggle();
}

void cGameUIManager::ToggleShortenKeyWindow()
{
	if( mpShortenKeyWindow )
		mpShortenKeyWindow->Toggle();
}

void cGameUIManager::ClearPartyWindow()
{
	assert( mpPartyWindow );

	if( mpPartyWindow )
	{
		mpPartyWindow->Hide();
		mpPartyWindow->Clear();
	}
}

void cGameUIManager::ShowGameUI()
{
	cUIRootNode* pRoot = UIMAN->GetRootNode();
	if( pRoot )
		pRoot->Show();
}

void cGameUIManager::ToggleGameUI()
{
	///  UI ü ON / OFF
	cUIRootNode* pRoot = UIMAN->GetRootNode();
	if( pRoot )
	{
		if( pRoot->IsVisible() )
		{
			pRoot->Hide();

			HERO->ShowNameGauge( false );
		}
		else
		{
			pRoot->Show();

			///  Ⱥδ
			HERO->ShowNameGauge( true );
		}
	}
}

void cGameUIManager::ShowWareHouse()
{
	assert( mpWareHouseWindow );

	if( mpWareHouseWindow )
	{
		mpWareHouseWindow->Reset();
		mpWareHouseWindow->ShowTop();
	}
}

void cGameUIManager::ShowSkillWindow()
{
	assert( mpSkillWindow );

	if( mpSkillWindow )
	{
		mpSkillWindow->Reset();
		mpSkillWindow->ShowTop();
	}
}

void cGameUIManager::ShowSkillStore( unsigned long npcId )
{
	assert( mpSkillStoreWindow );

	if( mpSkillStoreWindow )
	{
		mpSkillStoreWindow->Reset();
		mpSkillStoreWindow->Show( npcId );
	}
}

void cGameUIManager::ShowNpcWindow( unsigned int npcClassIdx, unsigned long npcIndex, LPTSTR npcName )
{
	assert( mpNpcWindow );

	if( mpNpcWindow )
		mpNpcWindow->Show( npcClassIdx, npcIndex, npcName );
}

void cGameUIManager::ShowNpcDisjointWindow()
{
	assert( mpNpcDisjointWindow );

	if( mpNpcDisjointWindow )
	{
		mpNpcDisjointWindow->Reset();
		mpNpcDisjointWindow->ShowTop();
	}
}

void cGameUIManager::ShowCardBookWindow()
{
	assert( mpCardBookWindow );

	if( mpCardBookWindow )
		mpCardBookWindow->SendCardBookOpen();
}

bool cGameUIManager::IsShowCardBook()
{
	if( mpCardBookWindow )
		return mpCardBookWindow->IsVisible();
	return false;
}

void cGameUIManager::ShowHeroInfoWindow()
{
	assert( mpHeroInfoWindow );

	if( mpHeroInfoWindow )
		mpHeroInfoWindow->ShowTop();
}

void cGameUIManager::ShowInventoryWindow()
{
	assert( mpInventoryWindow );

	if( mpInventoryWindow )
	{
		mpInventoryWindow->Reset();
		mpInventoryWindow->ShowTop();
	}
}

void cGameUIManager::ShowNoteWindow()
{
	assert( mpNoteWindow );

	if( mpNoteWindow )
		mpNoteWindow->ShowTop();
}

void cGameUIManager::ShowFriendWindow()
{
	assert( mpFriendWindow );

	if( mpFriendWindow )
		mpFriendWindow->ShowTop();
}

void cGameUIManager::ShowOptionWindow()
{
	assert( mpOptionWindow );

	if( mpOptionWindow )
		mpOptionWindow->ShowTop();
}

void cGameUIManager::ShowTarotWindow( unsigned char page )
{
	assert( mpTarotWindow );
	mpTarotWindow->ChangeTarotPage( page );
}

void cGameUIManager::ShowTarotControlWindow()
{
	if( mpTarotWindow )
		mpTarotWindow->ChangeTarotPage( 0 );

	assert(mpTarotControlWindow);
	if( mpTarotControlWindow )
		mpTarotControlWindow->ShowTop();
}

void cGameUIManager::ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int i0, unsigned int i1 )
{
	assert( mpItemCountWindow );

	if( mpItemCountWindow )
		mpItemCountWindow->ShowModal( eventtype, i0, i1 );
}

void cGameUIManager::ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int itemIndex )
{
	assert( mpItemCountWindow );

	if( mpItemCountWindow )
		mpItemCountWindow->ShowModal( eventtype, itemIndex );
}

void cGameUIManager::ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int slotIndex, unsigned int itemIndex, unsigned int maxValue )
{
	assert( mpItemCountWindow );

	if( mpItemCountWindow )
		mpItemCountWindow->ShowModal( eventtype, slotIndex, itemIndex, maxValue );
}

void cGameUIManager::ShowItemDumpAskWindow( unsigned int slotIndex )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eMBEVENT_ITEM_DUMP, slotIndex, 0, 0, 0 );
}

void cGameUIManager::ShowItemBuyAskWindow( unsigned long itemIndex, unsigned short count )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eMBEVENT_ITEM_BUY, 0, itemIndex, count, 0 );
}

void cGameUIManager::ShowItemSellAskWindow( unsigned int slotIndex, unsigned short count )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eMBEVENT_ITEM_SELL, slotIndex, 0, count, 0 );
}

void cGameUIManager::ShowItemUserSellBuyAskWindow( unsigned int slotIndex, unsigned long itemIndex, 
												   unsigned short count, unsigned long price )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eMBEVENT_ITEM_USERSELLBUY, slotIndex, itemIndex, count, price );
}

void cGameUIManager::ShowItemPutCard( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int putSlot, unsigned long itemIndex )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eventtype, slotIndex0, putSlot, itemIndex );
}	

void cGameUIManager::ShowItemCardBook( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int slotIndex1, unsigned long itemIndex )
{
	if( mpItemMsgWindow )
		mpItemMsgWindow->ShowModal( eventtype, slotIndex0, slotIndex1, itemIndex );
}

void cGameUIManager::ShowMoneyWindow( eMoneyType type, eMSGBox_Event eventtype, unsigned int slotIndex )
{
	assert( mpMoneyWindow );

	if( mpMoneyWindow )
		mpMoneyWindow->ShowMoney( type, eventtype, slotIndex );
}

void cGameUIManager::ShowMoneyModifyWindow( eMoneyType type, eMSGBox_Event eventtype, unsigned int slotIndex )
{
	assert( mpMoneyWindow );

	if( mpMoneyWindow )
		mpMoneyWindow->ShowMoneyModify( type, eventtype, slotIndex );
}

void cGameUIManager::ShowNpcStoreWindow( unsigned long npcIndex )
{
	assert( mpNpcStoreWindow );

	if( mpNpcStoreWindow )
	{
		mpNpcStoreWindow->Reset();
		mpNpcStoreWindow->Show( npcIndex );
	}
}

void cGameUIManager::ShowTradeWindow()
{
	assert( mpTradeWindow );

	if( mpTradeWindow )
		mpTradeWindow->ShowTop();

	if( mpInventoryWindow )
	{
		mpInventoryWindow->Reset();
		mpInventoryWindow->ShowTop();
	}
}

void cGameUIManager::ShowExitWindow()
{
	assert( mpExitWindow );

	if( mpExitWindow )
	{
		mpExitWindow->UIStageIn();
		mpExitWindow->ShowTop();
	}
}

void cGameUIManager::ShowQuestWindow()
{
	assert( mpQuestWindow );

	if( mpQuestWindow )
	{
		mpQuestWindow->Reset();
		mpQuestWindow->ShowTop();
	}
}

void cGameUIManager::ShowLootingWindow()
{
	assert( mpLootingWindow );

	if( mpLootingWindow )
	{
		mpLootingWindow->Reset();
		mpLootingWindow->ShowTop();
	}
}

void cGameUIManager::ShowRevivalWindow()
{
	assert( mpRevivalWindow );

	if( mpRevivalWindow )
	{
		mpRevivalWindow->Reset();
		mpRevivalWindow->ShowTop();
	}
}

void cGameUIManager::ShowDMMsgWindow( unsigned long leftTime )
{
	assert( mpDMMsgWindow );
	
	if( mpDMMsgWindow )
	{
		UIMAN->ModalEventFromGameSystem( false );

		mpDMMsgWindow->Reset();
		mpDMMsgWindow->SetMsgInfo( leftTime );
		mpDMMsgWindow->ShowTop();
	}
}

void cGameUIManager::ShowGuildWindow()
{
	assert( mpGuildWindow );

	if( mpGuildWindow )
		mpGuildWindow->ShowTop();
}

void cGameUIManager::ShowNpcTarotWindow( unsigned long deckIdx, unsigned long price, unsigned long* spreadArr, short size )
{
	assert( mpTarotWindow );

	if( mpTarotWindow )
	{
		mpTarotWindow->SetNpcTarotDeck( TAROTMAN->GetNpcTarotDeck( deckIdx ) );
		mpTarotWindow->SetNpcSpread( spreadArr, size );
		mpTarotWindow->SetPrice( price );

		MSGROOT Msg;
		Msg.Category = NM_NPC;
		Msg.Protocol = NM_NPC_TAROT_OPEN_REQ;
		NETWORK->SendNetworkMsg( (char*)&Msg, sizeof(Msg) );
	}
}

void cGameUIManager::ShowTodayWordWindow()
{
	assert( mpTodayWordWindow );

	if( mpTodayWordWindow )
		mpTodayWordWindow->ShowTop();
}

void cGameUIManager::HidePartyDivideMenu()
{
	if( mpPartyDivideMenu )
		mpPartyDivideMenu->Hide();
}

void cGameUIManager::HidePartyMenu()
{
	if( mpPartyMenu )
		mpPartyMenu->Hide();
}

void cGameUIManager::HideTarotControlWindow()
{
	assert( mpTarotControlWindow );

	if( mpTarotControlWindow )
		mpTarotControlWindow->Hide();
}

void cGameUIManager::HideLootingWindow()
{
	if( mpLootingWindow && mpLootingWindow->IsVisible() == true )
		mpLootingWindow->Hide();
}

void cGameUIManager::HideAllNpcWindow()
{
	if( mpNpcWindow )
		mpNpcWindow->Hide();

	if( mpNpcStoreWindow )
		mpNpcStoreWindow->Hide();
}

void cGameUIManager::HideTradeWindow()
{
	if( mpTradeWindow )
		mpTradeWindow->Hide();
}

void cGameUIManager::HideCardBookWindow()
{
	if( mpCardBookWindow )
		mpCardBookWindow->Hide();
}

void cGameUIManager::HideTodayWordWindow()
{
	if( mpTodayWordWindow )
		mpTodayWordWindow->Hide();
}

///  ӽ HERO  
void cGameUIManager::InitHeroInfo()
{
	assert(mpHeroStateWindow);
	assert(mpHeroInfoWindow);

	if( mpHeroStateWindow )
		mpHeroStateWindow->UIStageIn();

	if( mpHeroInfoWindow )
		mpHeroInfoWindow->UIStageIn();

	if( mpSocialWindow )
		mpSocialWindow->UpdatePoint();
}

void cGameUIManager::UpdateHeroInfo()
{
	assert( mpHeroStateWindow );
	assert( mpHeroInfoWindow );
	
	if( mpHeroStateWindow )
        mpHeroStateWindow->UpdateHeroInfo();

	if( mpHeroInfoWindow )
		mpHeroInfoWindow->UpdateHeroInfo();
}

void cGameUIManager::UpdateHeroHPMP()
{
	assert( mpHeroStateWindow );
	assert( mpHeroInfoWindow );

	if( mpHeroStateWindow )
		mpHeroStateWindow->UpdateHeroHPMP();

	if( mpHeroInfoWindow )
		mpHeroInfoWindow->UpdateHeroHPMP();
}

void cGameUIManager::UpdateExpSxp()
{
	assert( mpHeroStateWindow );
	assert( mpHeroInfoWindow );

	if( mpHeroStateWindow )
		mpHeroStateWindow->UpdateExpSxp();

	if( mpHeroInfoWindow )
		mpHeroInfoWindow->UpdateExpSxp();
}

///  ųƮ Ʈ 
void cGameUIManager::UpdateSkillPoint()
{
	assert(mpSkillWindow);
	assert(mpSkillStoreWindow);

	if( mpSkillWindow )
	{
		mpSkillWindow->UpdateSkillPoint();

		if( mpSkillWindow->IsVisible() )
			mpSkillWindow->UpdateSkillUsePoint();
	}

	if( mpSkillStoreWindow )
		mpSkillStoreWindow->UpdateSkillPoint();
}

void cGameUIManager::UpdataSkillStorWindow()
{
	assert(mpSkillStoreWindow);

    if( mpSkillStoreWindow && mpSkillStoreWindow->IsVisible() == true )
		mpSkillStoreWindow->UpdatePage();
}

void cGameUIManager::UpdateMinimap()
{
	if( mpSmallMiniMapWindow )
		mpSmallMiniMapWindow->SetMapData();

	if( mpMiniMapWindow )
		mpMiniMapWindow->SetMapData();
}

cBaseObject* cGameUIManager::GetPartyObject( int i )
{
	if( mpPartyStateWindow[i] && mpPartyStateWindow[i]->IsVisible() == true )
	{
		return OBJECTMAN->GetObject( eOBJECTTYPE_PLAYER, mpPartyStateWindow[i]->GetUserIndex() );
	}
	return 0;
}

/// ü   
void cGameUIManager::EventLootingSpacebar()
{
	if( PVPMAN->IsEnableBattle() == true )
		return;

	/// ü  û
	if( mpLootingWindow && mpLootingWindow->IsVisible() == true )
	{
		mpLootingWindow->OnCommand( 0, eUIID_GAME_LOOTING_ALL );
	}
	else
	{
		/// Near DropItem Click
		ITEMMAN->CheckNearestDropItem();
	}
}

void cGameUIManager::SetDuelMode( bool mode )
{
	mDuelMode = mode;

	if( mDuelMode )
	{
		if( mpSmallMiniMapWindow )
			mpSmallMiniMapWindow->Hide(false);
		if( mpHeroStateWindow )
			mpHeroStateWindow->Hide(false);
		if( mpBuffWindow )
			mpBuffWindow->Hide(false);
		if( mpDeBuffWindow )
			mpDeBuffWindow->Hide(false);

		if( mpTargetWindow )
		{
			mpTargetWindow->SetHoldView( true );
			//mpTargetWindow->SetEnabled( false );
		}
	}
	else
	{
		if( mpSmallMiniMapWindow )
			mpSmallMiniMapWindow->Show(false);
		if( mpHeroStateWindow )
			mpHeroStateWindow->Show(false);
		if( mpBuffWindow )
			mpBuffWindow->Show(false);
		if( mpDeBuffWindow )
			mpDeBuffWindow->Show(false);

		if( mpTargetWindow )
		{
			mpTargetWindow->SetHoldView( false );
			//mpTargetWindow->SetEnabled( true );
		}
	}
}

bool cGameUIManager::LoadWindowOption_Character( const cString& pathName )
{
	mQuestCharacterIdx = HERO->GetObjectID();

	mQuestCheckArr.Clear();

	cFileLoader loader;
	if( loader.Open( pathName, true ) == false )
		return false;

	sWindowOptCharacter header;
	if( loader.Read( &header, sizeof(sWindowOptCharacter) ) != sizeof(sWindowOptCharacter) )
	{
		return false;
	}

	switch( header.version )
	{
	case 1:
		break;
	default:
		{
			assert(0);
		}
		return false;
	}

	unsigned long  questIdx;
	for( unsigned int i=0; i<header.questCount;i++ )
	{
		loader.ReadInt( (int*)&questIdx );
		mQuestCheckArr.PushBack( questIdx );
	}

	return true;
}

void cGameUIManager::SaveWindowOption_Character( const cString& pathName )
{
	UpdateWindowOption_Character();

	///
	if( ::FileExist( "Option" ) == false )
	{
		::CreateDirectory( L"Option", 0 );
	}

	cFileSaver saver;
	if( saver.Open( pathName ) == false )
	{
		assert( 0 && "failed to open file to save UI pos file" );
		return;
	}

	sWindowOptCharacter header;
	header.version = CHARHEARDER_VER;
	header.questCount =mQuestCheckArr.GetSize();
	if( saver.Write( &header, sizeof(sWindowOptCharacter) ) != sizeof(sWindowOptCharacter) )
	{
		assert( 0 && "failed to write character window option file header" );
		return;
	}

	for( unsigned int i=0; i<header.questCount; i++)
	{
		if( saver.WriteInt( mQuestCheckArr[i] ) == false )
		{
			assert( 0 && "failed to write quest index" );
			return;
		}
	}
}

bool cGameUIManager::LoadWindowPos( const cString& pathName )
{
	cFileLoader loader;
	if( loader.Open( pathName, true ) == false )
		return false;

	sWindowPosHeader header;
	if( loader.Read( &header, sizeof(sWindowPosHeader) ) != sizeof(sWindowPosHeader) )
	{
		return false;
	}

	switch( header.version )
	{
	case 1:
		break;
	case 2:
		{
			/// 캰 ɼ
			for( unsigned int i=0; i<4; i++ )
			{
				loader.Read( &(mChatWinOption[i]), sizeof(sChatWinOption)-sizeof(bool) );
				mChatWinOption[i].checkSystem = false;
			}

			loader.ReadFloat( &mMiniWinPer );
		}
		break;
	case 3:
		{
			/// 캰 ɼ
			for( unsigned int i=0; i<4; i++ )
				loader.Read( &(mChatWinOption[i]), sizeof(sChatWinOption) );

			loader.ReadFloat( &mMiniWinPer );
		}
		break;
	case 4:
		{
			/// 캰 ɼ
			for( unsigned int i=0; i<4; i++ )
				loader.Read( &(mChatWinOption[i]), sizeof(sChatWinOption) );

			loader.ReadFloat( &mMiniWinPer );
			loader.ReadInt( &mChatBoxMaxRow );
		}
		break;
	default:
		{
			assert(0);
		}
		return false;
	}

	if( header.dataCount == 0 )
		return false;

	for( unsigned int i=0;i< header.dataCount; i++ )
	{
		sWindowPosData* data = new sWindowPosData;
		loader.Read( data, sizeof(sWindowPosData) );

		/// 
		if( mSaveWindowInfo.Insert( data->index, data ) == false )
		{
			assert(0);
		}
	}
	return true;
}

void cGameUIManager::SaveWindowPos( const cString& pathName )
{
	UpdateWindowPos();

	///
	if( ::FileExist( "Option" ) == false )
	{
		::CreateDirectory( L"Option", 0 );
	}

	cFileSaver saver;
	if( saver.Open( pathName ) == false )
	{
		assert( 0 && "failed to open file to save UI pos file" );
		return;
	}

	sWindowPosHeader header;
	header.version = POSHEARDER_VER;
	header.dataCount = mSaveWindowInfo.GetSize();
	if( saver.Write( &header, sizeof(sWindowPosHeader) ) != sizeof(sWindowPosHeader) )
	{
		assert( 0 && "failed to write UI pos file header" );
		return;
	}

	///
	for( unsigned int i=0; i<4; i++ )
	{
		if( saver.Write( &(mChatWinOption[i]), sizeof(sChatWinOption) ) == false )
		{
			assert( 0 && "failed to write chat option" );
			return;
		}
	}

	///
	if( saver.WriteFloat( mMiniWinPer) == false )
	{
		assert( 0 && "failed to write minimap option" );
		return;
	}

	if( saver.WriteInt( mChatBoxMaxRow ) == false )
	{
		assert( 0 && "failed to write chat max row" );
		return;
	}

	///
	{
		cSaveWindowPos::cIterator i = mSaveWindowInfo.Begin();
		cSaveWindowPos::cIterator end = mSaveWindowInfo.End();
		for( ; i!=end; i++ )
		{
			sWindowPosData* data = (sWindowPosData*)(i->mSecond);

			saver.Write( data, sizeof(sWindowPosData) );
		}
	}
}

void cGameUIManager::ApplyWindowPos()
{
	/// chatting window
	mpChatWindow->SetPress( mChatWinOption[0].checkNormal,
							mChatWinOption[0].checkParty,
							mChatWinOption[0].checkGuild,
							mChatWinOption[0].checkShout,
							mChatWinOption[0].checkTrade,
							mChatWinOption[0].checkWhisper,
							mChatWinOption[0].checkSystem );

	/// chatting extra window
	for( unsigned int k=1; k<4; k++ )
	{
		mpChatExtraWindow[k-1]->SetPress( mChatWinOption[k].checkNormal,
											mChatWinOption[k].checkParty,
											mChatWinOption[k].checkGuild,
											mChatWinOption[k].checkShout,
											mChatWinOption[k].checkTrade,
											mChatWinOption[k].checkWhisper, 
											mChatWinOption[k].checkSystem );
	}

	///
	mpSmallMiniMapWindow->SetImagePercent( mMiniWinPer );
	mpChatWindow->InitBoxSize( mChatBoxMaxRow );

	///
	if( mSaveWindowInfo.GetSize() == 0 )
		return;

	cSaveWindowPos::cIterator i = mSaveWindowInfo.Begin();
	cSaveWindowPos::cIterator end = mSaveWindowInfo.End();
	for( ; i!=end; i++ )
	{
		bool applyShow = true;
		sWindowPosData* data = (sWindowPosData*)(i->mSecond);

		cUIWindow* win = 0;
		switch( data->index )
		{
		case CHATWIN_POS:		win = mpChatWindow;			break;
		case ECHATWIN1_POS:		win = mpChatExtraWindow[0]; break;
		case ECHATWIN2_POS:		win = mpChatExtraWindow[1]; break;
		case ECHATWIN3_POS:		win = mpChatExtraWindow[2]; break;
		case HEROSTATWIN_POS:	win = mpHeroStateWindow;	break;
		case HEROINFOWIN_POS:	win = mpHeroInfoWindow;		break;
		case TARGETWIN_POS:		win = mpTargetWindow;		break;
		case INVENWIN_POS:		win = mpInventoryWindow;	break;
		case BAGWIN1_POS:		win = mpBagWindow[0];		break;
		case BAGWIN2_POS:		win = mpBagWindow[1];		break;
		case BAGWIN3_POS:		win = mpBagWindow[2];		break;
		case SKILLWIN_POS:		win = mpSkillWindow;		break;
		case OPTWIN_POS:		win = mpOptionWindow;		break;
		case MINIMAPWIN_POS:	win = mpSmallMiniMapWindow;	break;
		case CQUICK_POS:		win = mpColumnQuickSlot;	break;
		case RQUICK_POS:		win = mpRowQuickSlot;		break;
		case FSCQUICK_POS:		win = mpFSColumnQuickSlot;	break;
		case FSRQUICK_POS:		win = mpFSRowQuickSlot;		break;
		case PARTYWIN_POS:		win = mpPartyWindow;		 applyShow = false;	break;
		case PARTYSTATWIN1_POS:	win = mpPartyStateWindow[0]; applyShow = false; break;
		case PARTYSTATWIN2_POS:	win = mpPartyStateWindow[1]; applyShow = false; break;
		case PARTYSTATWIN3_POS:	win = mpPartyStateWindow[2]; applyShow = false; break;
		case PARTYSTATWIN4_POS:	win = mpPartyStateWindow[3]; applyShow = false; break;
		case PARTYSTATWIN5_POS:	win = mpPartyStateWindow[4]; applyShow = false; break;
		case NOTEWIN_POS:		win = mpNoteWindow;			break;
		case FRIENDWIN_POS:		win = mpFriendWindow;		break;
		case TAROTCON_POS:		win = mpTarotControlWindow;	break;
		case SELLWIN_POS:		win = mpUserSellWindow;		break;
		case SELLSEARCHWIN_POS:	win = mpUserSellSearchWindow;break;
		case LOOTWIN_POS:		win = mpLootingWindow;		break;
		case QUESTWIN_POS:		win = mpQuestWindow;		break;
		case SQUESTWIN_POS:		win = mpQuestSimpleWindow;	break;
		case DISJOINT_POS:		win = mpNpcDisjointWindow;	break;
		case SENDNOTE_POS:		win = mpSendNoteWindow;		break;
		case RECEIVENOTE_POS:	win = mpReceiveNoteWindow;	break;
		case ENHANCEDWIN_POS:	win = mpEnhancedWindow;		break;
		case PUTCARD_POS:		win = mpPutCardWindow;		break;
		case SOCIALWIN_POS:		win = mpSocialWindow;		break;
		case TITLEWIN_POS:		win = mpTitleWindow;		break;
		case GUILDWIN_POS:		win = mpGuildWindow;		break;
		default:win = 0; break;
		}

		if( win == 0 )
			continue;

		win->SetRelativePos( cUIPos( (int)data->pos.x, (int)data->pos.y ) );

		if( applyShow == false )
			continue;

		if( data->showFlag >= 1 )
		{
			win->Show( false );

			if( data->index == RQUICK_POS )
				QUICKMAN->SetRowQuick( true );
			else if( data->index == FSRQUICK_POS )
				QUICKMAN->SetRowQuickFS( true );
		}
		else
			win->Hide( false );
	}
}

void cGameUIManager::ApplyWinodwOption_Character()
{
	///
	for( unsigned int i=0;i<mQuestCheckArr.GetSize();i++ )
		QUESTMAN->AddQuestSelect( mQuestCheckArr[i], true );
}

void cGameUIManager::UpdateWindowPos()
{
	bool holdView;
	for( unsigned int i=0; i<POS_END; i++ )
	{
		holdView = false;

		cUIWindow* win = 0;
		switch( i )
		{
		case CHATWIN_POS:		win = mpChatWindow;			holdView = true;	break;
		case ECHATWIN1_POS:		win = mpChatExtraWindow[0]; break;
		case ECHATWIN2_POS:		win = mpChatExtraWindow[1]; break;
		case ECHATWIN3_POS:		win = mpChatExtraWindow[2]; break;
		case HEROSTATWIN_POS:	win = mpHeroStateWindow;	holdView = true;	break;
		case HEROINFOWIN_POS:	win = mpHeroInfoWindow;		break;
		case TARGETWIN_POS:		win = mpTargetWindow;		break;
		case INVENWIN_POS:		win = mpInventoryWindow;	break;
		case BAGWIN1_POS:		win = mpBagWindow[0];		break;
		case BAGWIN2_POS:		win = mpBagWindow[1];		break;
		case BAGWIN3_POS:		win = mpBagWindow[2];		break;
		case SKILLWIN_POS:		win = mpSkillWindow;		break;
		case OPTWIN_POS:		win = mpOptionWindow;		break;
		case MINIMAPWIN_POS:	win = mpSmallMiniMapWindow;	break;
		case CQUICK_POS:		win = mpColumnQuickSlot;	holdView = QUICKMAN->IsRowQuick()? false:true; break;
		case RQUICK_POS:		win = mpRowQuickSlot;		holdView = QUICKMAN->IsRowQuick()? true:false; break;
		case FSCQUICK_POS:		win = mpFSColumnQuickSlot;	holdView = QUICKMAN->IsRowQuickFS()? false:true; break;
		case FSRQUICK_POS:		win = mpFSRowQuickSlot;		holdView = QUICKMAN->IsRowQuickFS()? true:false; break;
		case PARTYWIN_POS:		win = mpPartyWindow;		break;
		case PARTYSTATWIN1_POS:	win = mpPartyStateWindow[0];break;
		case PARTYSTATWIN2_POS:	win = mpPartyStateWindow[1];break;
		case PARTYSTATWIN3_POS:	win = mpPartyStateWindow[2];break;
		case PARTYSTATWIN4_POS:	win = mpPartyStateWindow[3];break;
		case PARTYSTATWIN5_POS:	win = mpPartyStateWindow[4];break;
		case NOTEWIN_POS:		win = mpNoteWindow;			break;
		case FRIENDWIN_POS:		win = mpFriendWindow;		break;
		case TAROTCON_POS:		win = mpTarotControlWindow;	break;
		case SELLWIN_POS:		win = mpUserSellWindow;		break;
		case SELLSEARCHWIN_POS:	win = mpUserSellSearchWindow;break;
		case LOOTWIN_POS:		win = mpLootingWindow;		break;
		case QUESTWIN_POS:		win = mpQuestWindow;		break;
		case SQUESTWIN_POS:		win = mpQuestSimpleWindow;	break;
		case DISJOINT_POS:		win = mpNpcDisjointWindow;	break;
		case SENDNOTE_POS:		win = mpSendNoteWindow;		break;
		case RECEIVENOTE_POS:	win = mpReceiveNoteWindow;	break;
		case ENHANCEDWIN_POS:	win = mpEnhancedWindow;		break;
		case PUTCARD_POS:		win = mpPutCardWindow;		break;
		case SOCIALWIN_POS:		win = mpSocialWindow;		break;
		case TITLEWIN_POS:		win = mpTitleWindow;		break;
		case GUILDWIN_POS:		win = mpGuildWindow;		break;
		default:win = 0; break;
		}

		if( win == 0 )
			continue;

		sWindowPosData* data = (sWindowPosData*)mSaveWindowInfo.GetAt( i );
		if( data == 0 )
		{
			data = new sWindowPosData;
			data->index = i;

			if( mSaveWindowInfo.Insert( data->index, data ) == false )
			{
				assert(0);
				continue;
			}
		}

		cUIRect rt= win->GetAbsoluteRect();
		data->pos = NiPoint2( (float)rt.mLeft, (float)rt.mTop );

		if( holdView )
			data->showFlag = 1;
		else
		{
			data->showFlag = win->IsVisible()? 1:0;

			if( i == TARGETWIN_POS )
				data->showFlag = 0;
		}
	}

	/// windows extra option
	/// chatting
	mChatWinOption[0].checkNormal = mpChatWindow->IsPressNormal();
	mChatWinOption[0].checkParty = mpChatWindow->IsPressParty();
	mChatWinOption[0].checkGuild = mpChatWindow->IsPressGuild();
	mChatWinOption[0].checkShout = mpChatWindow->IsPressShout();
	mChatWinOption[0].checkTrade = mpChatWindow->IsPressTrade();
	mChatWinOption[0].checkWhisper = mpChatWindow->IsPressWhisper();
	mChatWinOption[0].checkSystem = mpChatWindow->IsPressSystem();

	/// chatting extra
	for( unsigned int i=1; i<4; i++ )
	{
		mChatWinOption[i].checkNormal = mpChatExtraWindow[i-1]->IsPressNormal();
		mChatWinOption[i].checkParty = mpChatExtraWindow[i-1]->IsPressParty();
		mChatWinOption[i].checkGuild = mpChatExtraWindow[i-1]->IsPressGuild();
		mChatWinOption[i].checkShout = mpChatExtraWindow[i-1]->IsPressShout();
		mChatWinOption[i].checkTrade = mpChatExtraWindow[i-1]->IsPressTrade();
		mChatWinOption[i].checkWhisper = mpChatExtraWindow[i-1]->IsPressWhisper();
		mChatWinOption[i].checkSystem = mpChatExtraWindow[i-1]->IsPressSystem();
	}

	///
	mChatBoxMaxRow = mpChatWindow->GetMaxRowInPage();
	mMiniWinPer = mpSmallMiniMapWindow->GetImagePercent();
}

void cGameUIManager::UpdateWindowOption_Character()
{
	///
	mQuestCheckArr.Clear();

	tHashSet<unsigned long>& questSet = QUESTMAN->GetSelectedSet();
	tHashSet<unsigned long>::cIterator itr = questSet.Begin();
	tHashSet<unsigned long>::cIterator end = questSet.End();
	for( ; itr!=end; itr++ )
	{
		unsigned long questIdx = (unsigned long)(*itr);
		mQuestCheckArr.PushBack( questIdx );
	}
}
