/* ==========================================================================
*      : 
*    : 谡
*    : 2006-12-21
* ǻ :
*===========================================================================*/
#pragma once
#include "Chat_Common.h"

enum eWINPOSIDX
{
	CHATWIN_POS = 0,	/// hold
	ECHATWIN1_POS,
	ECHATWIN2_POS,
	ECHATWIN3_POS,

	HEROSTATWIN_POS,	/// hold
	HEROINFOWIN_POS,
	TARGETWIN_POS,

	INVENWIN_POS,
	BAGWIN1_POS,
	BAGWIN2_POS,
	BAGWIN3_POS,

	SKILLWIN_POS,
	OPTWIN_POS,
	MINIMAPWIN_POS,

	CQUICK_POS,			/// hold or hide
	RQUICK_POS,			/// hold or hide
	FSCQUICK_POS,		/// hold or hide
	FSRQUICK_POS,		/// hold or hide

	PARTYWIN_POS,
	PARTYSTATWIN1_POS,
	PARTYSTATWIN2_POS,
	PARTYSTATWIN3_POS,
	PARTYSTATWIN4_POS,
	PARTYSTATWIN5_POS,

	NOTEWIN_POS,
	FRIENDWIN_POS,
	TAROTCON_POS,
	SELLWIN_POS,
	SELLSEARCHWIN_POS,
	LOOTWIN_POS,

	QUESTWIN_POS,
	SQUESTWIN_POS,

	DISJOINT_POS,
	SENDNOTE_POS,
	RECEIVENOTE_POS,
	ENHANCEDWIN_POS,
	PUTCARD_POS,
	SOCIALWIN_POS,
	TITLEWIN_POS,
	GUILDWIN_POS,

	POS_END,
};

class cBaseObject;
enum eMSGBox_Event;

class cUIWindow;
class cUIBackWindow;
class cChatManager;
class cChatWindow;
class cTargetWindow;
class cHeroInfoWindow;
class cCastingBar;
class cDestroyWarningWindow;
class cDropWarningWindow;
class cHeroStateWindow;
class cNpcWindow;
class cNpcStoreWindow;
class cInventoryWindow;
class cBagWindow;
class cWareHouseWindow;
class cWareHouse2Window;
class cItemCountWindow;
class cItemMsgWindow;
class cTradeWindow;
class cSkillWindow;
class cBuffWindow;
class cDragWindow;
class cMenuButtonWindow;
class cMiniMapWindow;
class cOptionWindow;
class cSkillStoreWindow;
class cSmallMiniMapWindow;
class cColumnQuickSlot;
class cRowQuickSlot;
class cNoteWindow;
class cFriendWindow;
class cTarotWindow;
class cTarotControlWindow;
class cUserSellWindow;
class cUserSellSearchWindow;
class cItemTipWindow;
class cSkillTipWindow;
class cBuffToolTipWindow;
class cSimpleTipWindow;
class cExitWindow;
class cExitMsgWindow;
class cLootingWindow;
class cRevivalWindow;
class cPartyWindow;
class cPartyStateWindow;
class cPartyMenu;
class cPartyDivideMenu;
class cMoneyWindow;
class cQuestWindow;
class cNpcRewardWindow;
class cNpcDisjointWindow;
class cSendNoteWindow;
class cReceiveNoteWindow;
class cEnhancedWindow;
class cQuestSimpleWindow;
class cMoneyWindow;
class cPutCardWindow;
class cDuelMsgWindow;
class cDuelWindow;
class cCardBookWindow;
class cChatExtraWindow;
class cFSColumnQuickSlot;
class cFSRowQuickSlot;
class cSocialWindow;
class cDMScoreWindow;
class cDMResultWindow;
class cDMMsgWindow;
class cDMRevivalWindow;
class cDMRankingListWindow;
class cChatButtonWindow;
class cTitleWindow;
class cMenuHeroWindow;
class cMenuCommuityWindow;
class cMenuOptionWindow;
class cGuildWindow;
class cChatTipWindow;
class cRButtonMenuWindow;
class cGuildButtonWindow;
class cGuildMarkWindow;
class cGuildSendNoteWindow;
class cShortenKeyWindow;
class cNpcTarotWindow;
class cTodayWordWindow;
class cItemMixWindow;

enum eItemTry;
enum eMoneyType;

/// save window pos struct
struct sWindowPosHeader
{
	unsigned short	version;
	unsigned int	dataCount;
};

struct sWindowPosData
{
	unsigned long	index;
	NiPoint2		pos;
	unsigned char	showFlag; // 0: hide, 1: show, 2: holdView
};

struct sChatWinOption
{
	bool	checkNormal;
	bool	checkParty;
	bool	checkGuild;
	bool	checkShout;
	bool	checkTrade;
	bool	checkWhisper;
	bool	checkSystem;
};

struct sWindowOptCharacter
{
	unsigned short version;
	unsigned int questCount;
};

///

class cGameUIManager
{
	static cGameUIManager* mpSingleton;

public:
	cGameUIManager();
	~cGameUIManager();

	void Init();
	void Exit();
	void Open();
	void Close();
	void Process( unsigned long deltaTime, unsigned long accumTime );

	void InitHeroInfo();
	void UpdateHeroInfo();	///   
	void UpdateHeroHPMP();	/// HP,MP 
	void UpdateExpSxp();
	void UpdateSkillPoint();
	void UpdataSkillStorWindow();		///  濡   
	void UpdateMinimap();

	/// Ʈũ 
	void ReqFinish( bool exitEvent );

	void SendGameOut();
	void SendDisConnect();
	void NetLockParty( int lockTry );	/// Ƽ ִ  UI LOCK
	void NetUnLockParty( int lockTry );

	///   ü 
	void ChangeTab();
	void ChangeTab( int tabIndex );

	///    ȯ Լ..
	void OnFocusChatWindow( unsigned long key, LPCTSTR addstring = _T("") );

	bool IsDuelMode() { return mDuelMode; }
	void SetDuelMode( bool mode );

	bool IsShowCardBook();

	/// hero ¿  ui ݱ 
	void HideUIByDie();

	///   Ʈ  ݱ(â, ȭâ, īâ)
	void HideItemSetWindow( cUIWindow* exceptWin );

	///
	void ShowGameUI();
	void ToggleGameUI();
	void ToggleOptionWindow();
	void ToggleHeroInfoWindow();
	void ToggleInventoryWindow();
	void ToggleWareHouse2Window();
	void ToggleSmallMiniMapWindow();
	void ToggleNoteWindow();
	void ToggleFriendWindow();
	void ToggleMiniMapWindow();
	void ToggleSkillWindow();
	void TogglePartyMenu();			/// Ƽ޴
	void TogglePartyDivideMenu();	/// Ƽ й޴
	void ToggleBagWindow( unsigned int index );
	void ToggleQuestWindow();
	void ToggleUserSellSearchWindow();
	void TogglePutCardWindow();
	void ToggleCardBookWindow();
	void ToggleSocialWindow();
	void ToggleGuildWindow();
	void ToggleShortenKeyWindow();
	
	void ClearPartyWindow();		/// Ƽ
	void HidePartyMenu();			/// Ƽ޴
	void HidePartyDivideMenu();		/// Ƽ й޴
	void HideLootingWindow();		/// ݱ - 鼭  Ŷ 
	void HideAllNpcWindow();		/// npc ִ   ݱ
	void HideTarotControlWindow();
	void HideTradeWindow();	
	void HideCardBookWindow();
	void HideTodayWordWindow();

    void ShowHeroInfoWindow();
	void ShowInventoryWindow();
	void ShowNoteWindow();
	void ShowFriendWindow();
	void ShowOptionWindow();
	void ShowLootingWindow();					///    
	void ShowRevivalWindow();					/// Ȱ 
	void ShowTarotWindow( unsigned char page );	/// Ÿΰ,  
	void ShowTarotControlWindow();
	void ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int slotIndex1 );
	void ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int itemIndex );
	void ShowItemCountWindow( eMSGBox_Event eventtype, unsigned int slotIndex, unsigned int itemIndex, unsigned int maxValue );
	void ShowMoneyWindow( eMoneyType type, eMSGBox_Event eventtype, unsigned int slotIndex = UINT_MAX );
	void ShowMoneyModifyWindow( eMoneyType type, eMSGBox_Event eventtype, unsigned int slotIndex = UINT_MAX );
	void ShowTradeWindow();
	void ShowWareHouse();
	void ShowNpcStoreWindow( unsigned long npcIndex );
	void ShowSkillWindow();
	void ShowSkillStore( unsigned long npcId );
	void ShowNpcWindow( unsigned int npcClassIdx, unsigned long npcIndex, LPTSTR npcName );
	void ShowExitWindow();
	void ShowQuestWindow();
	void ShowNpcDisjointWindow();
	void ShowCardBookWindow();
	void ShowColumnMonSlot();
	void ShowDMMsgWindow( unsigned long leftTime );
	void ShowGuildWindow();
	void ShowNpcTarotWindow( unsigned long deckIdx, unsigned long price, unsigned long* spreadArr, short size );
	void ShowTodayWordWindow();
	
	void ShowItemDumpAskWindow( unsigned int slotIndex );
	void ShowItemBuyAskWindow( unsigned long itemIndex, unsigned short count );
	void ShowItemSellAskWindow( unsigned int slotIndex, unsigned short count );
	void ShowItemUserSellBuyAskWindow( unsigned int slotIndex, unsigned long itemIndex, 
									   unsigned short count, unsigned long price );
	void ShowItemPutCard( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int putSlot, unsigned long itemIndex );
	void ShowItemCardBook( eMSGBox_Event eventtype, unsigned int slotIndex0, unsigned int slotIndex1, unsigned long itemIndex );
	
	/// 쿡 ̽ ̺Ʈ ֱ
	void EventLootingSpacebar();

	cBaseObject* GetPartyObject( int i );

	cInventoryWindow*		GetInventoryWindow()	{ return mpInventoryWindow; }
	cTradeWindow*			GetTradeWindow()		{ return mpTradeWindow; }
	cItemTipWindow*			GetItemTip()			{ return mpItemTip; }
	cSkillTipWindow*		GetSkillTip()			{ return mpSkillTip; }
	cBuffToolTipWindow*		GetBuffTip()			{ return mpBuffTip; }
	cSimpleTipWindow*		GetSimpleTip()			{ return mpSimpleTip; }
	cBuffWindow*			GetBuffWindow()			{ return mpBuffWindow; }
	cBuffWindow*			GetDeBuffWindow()		{ return mpDeBuffWindow; }
	cSkillWindow*			GetSkillWindow()		{ return mpSkillWindow; }
	cTargetWindow*			GetTargetWindow()		{ return mpTargetWindow; }
	cHeroInfoWindow*		GetHeroInfoWindow()		{ return mpHeroInfoWindow; }
	cHeroStateWindow*		GetHeroStateWindow()	{ return mpHeroStateWindow; }
	cPartyWindow*			GetPartyWindow()		{ return mpPartyWindow; }
	cPartyDivideMenu*		GetPartyDivideMenu()	{ return mpPartyDivideMenu; }
	cTarotWindow*			GetTarotWindow()		{ return mpTarotWindow; }
	cTarotControlWindow*	GetTarotControlWindow() { return mpTarotControlWindow; }
	cLootingWindow*			GetLootingWindow()		{ return mpLootingWindow; }
	cSmallMiniMapWindow*	GetSmallMinimapWindow() { return mpSmallMiniMapWindow; }
	cMiniMapWindow*			GetMinimapWindow()		{ return mpMiniMapWindow; }
	cFriendWindow*			GetFriendWindow()		{ return mpFriendWindow; }
	cMenuButtonWindow*		GetMenuButtonWindow()	{ return mpMenuButtonWindow; }
	cMenuOptionWindow*		GetMenuOptionWindow()	{ return mpMenuOption; }
	cRevivalWindow*			GetReVivalWindow()		{ return mpRevivalWindow; }
	cNpcStoreWindow*		GetNpcStore()			{ return mpNpcStoreWindow; }
	cWareHouseWindow*		GetWareHouseWindow()	{ return mpWareHouseWindow; }
	cWareHouse2Window*		GetWareHouse2Window()	{ return mpWareHouse2Window; }
	cMoneyWindow*			GetMoneyWindow()		{ return mpMoneyWindow; }
	cQuestWindow*			GetQuestWindow()		{ return mpQuestWindow; }
	cNpcWindow*				GetNpcWindow()			{ return mpNpcWindow; }
	cNpcRewardWindow*		GetNpcRewardWindow()	{ return mpNpcRewardWindow; }
	cNpcDisjointWindow*		GetNpcDisjointWindow()	{ return mpNpcDisjointWindow; }
	cNoteWindow*			GetNoteWindow()			{ return mpNoteWindow; }
	cExitWindow*			GetExitWindow()			{ return mpExitWindow; }
	cExitMsgWindow*			GetExitMsgWindow()		{ return mpExitMsgWindow; }
	cEnhancedWindow*		GetEnhancedWindow()		{ return mpEnhancedWindow; }
	cQuestSimpleWindow*		GetQuestSimpleWindow()	{ return mpQuestSimpleWindow; }
	cUserSellWindow*		GetUserSellWindow()		{ return mpUserSellWindow; }
	cItemMsgWindow*			GetItemMsgWindow()		{ return mpItemMsgWindow; }
	cItemCountWindow*		GetItemCountWindow()	{ return mpItemCountWindow; }
	cUserSellSearchWindow*  GetUserSellSearchWindow() { return mpUserSellSearchWindow; }
	cPutCardWindow*			GetPutCardWindow()		{ return mpPutCardWindow; }
	cDuelMsgWindow*			GetDuelMsgWindow()		{ return mpDuelMsgWindow; }
	cDuelWindow*			GetDuelWindow()			{ return mpDuelWindow; }
	cCardBookWindow*		GetCardBookWindow()		{ return mpCardBookWindow; }
	cSendNoteWindow*		GetSendNoteWindow()		{ return mpSendNoteWindow; }
	cReceiveNoteWindow*		GetReceiveNoteWindow()	{ return mpReceiveNoteWindow; }
	cSkillStoreWindow*		GetSkillStoreWindow()	{ return mpSkillStoreWindow; }
	cColumnQuickSlot*		GetColumnQuick()		{ return mpColumnQuickSlot; }
	cRowQuickSlot*			GetRowQuick()			{ return mpRowQuickSlot; }
	cSocialWindow*			GetSocialWindow()		{ return mpSocialWindow; }
	cDMScoreWindow*			GetDMScoreWindow()		{ return mpDMScoreWindow; }
	cDMResultWindow*		GetDMResultWindow()		{ return mpDMResultWindow; }
	cDMRevivalWindow*		GetDMRevivalWindow()	{ return mpDMRevivalWindow; }
	cDMRankingListWindow*	GetDMRankingListWindow() { return mpDMRankingListWindow; }
	cChatButtonWindow*		GetChatButtonWindow()	{ return mpChatButtonWindow; }
	cChatWindow*			GetChatWindow()			{ return mpChatWindow; }
	cTitleWindow*			GetTitleWindow()		{ return mpTitleWindow; }
	cGuildWindow*			GetGuildWindow()		{ return mpGuildWindow; }
	cFSColumnQuickSlot*		GetFSColumnQuickSlot()  { return mpFSColumnQuickSlot; }
	cFSRowQuickSlot*		GetFSRowQuickSlot()		{ return mpFSRowQuickSlot; }
	cColumnQuickSlot*		GetColumnQuickSlot()	{ return mpColumnQuickSlot; }
	cRowQuickSlot*			GetRowQuickSlot()		{ return mpRowQuickSlot; }
	cGuildButtonWindow*		GetGuildButtonWindow()  { return mpGuildButtonWindow; }
	cGuildMarkWindow*		GetGuildMarkWindow()	{ return mpGuildMarkWindow; }
	cGuildSendNoteWindow*	GetGuildSendNoteWindow() { return mpGuildSendNoteWindow; }
	cTodayWordWindow*		GetTodayWordWindow()	{ return mpTodayWordWindow; }
	cItemMixWindow*			GetItemMixWindow()		{ return mpItemMixWindow; }

	cBagWindow*				GetBagWindow( unsigned int i ) { return mpBagWindow[i]; }
	cChatExtraWindow*		GetChatExtraWindow( unsigned int i ) { return mpChatExtraWindow[i]; }
	cPartyStateWindow*		GetPartyStateWindow( unsigned int i );

	cRButtonMenuWindow*		GetRButtonMenuWindow() { return mpRButtonMenuWindow; }

	void ApplyWinodwOption_Character();

public:
	/// ü 
	static cGameUIManager* GetSingleton();

protected:
	bool CheckHeroState();

	/// window player save pos
	bool LoadWindowPos( const cString& pathName );
	void SaveWindowPos( const cString& pathName );

	bool LoadWindowOption_Character( const cString& pathName );
	void SaveWindowOption_Character( const cString& pathName );

	void UpdateWindowOption_Character();

	void ApplyWindowPos();
	void UpdateWindowPos();

protected:
	/// ü ui  .
	bool	mInitAllUI;

	/// ä 
	cChatManager* mpChatManager;

	/// ä 
	cChatWindow* mpChatWindow;

	/// ä Ȯ 
	cChatExtraWindow* mpChatExtraWindow[3];

	/// Ÿ 
	cTargetWindow* mpTargetWindow;

	/// Hero  
	cHeroInfoWindow* mpHeroInfoWindow;

	/// Hero   ( ȭ   )
	cHeroStateWindow* mpHeroStateWindow;

	/// Npc 
	cUIBackWindow* mpNpcBackWindow;
	cNpcWindow* mpNpcWindow;
	cNpcStoreWindow* mpNpcStoreWindow;

	/// κ丮 
	cInventoryWindow* mpInventoryWindow;

	///  
	cBagWindow* mpBagWindow[3];

	/// â 
	cWareHouseWindow* mpWareHouseWindow;
	cWareHouse2Window* mpWareHouse2Window;
	cMoneyWindow*	mpMoneyWindow;

	/// 
	cItemCountWindow* mpItemCountWindow;

	///  ޼ 
	cItemMsgWindow* mpItemMsgWindow;

	/// ŷ 
	cTradeWindow* mpTradeWindow;

	/// ų 
	cSkillWindow* mpSkillWindow;

	cSkillStoreWindow* mpSkillStoreWindow;

	cBuffWindow* mpBuffWindow;
	cBuffWindow* mpDeBuffWindow;

	/// 巡 
	cDragWindow* mpDragWindow;

	///  
	cItemTipWindow* mpItemTip;
	cSkillTipWindow* mpSkillTip;
	cBuffToolTipWindow* mpBuffTip;
	cSimpleTipWindow* mpSimpleTip;
	cChatTipWindow*	mpChatItemTip;

	/// ϴ ư 
	cMenuButtonWindow* mpMenuButtonWindow;
	
	/// ϴ ޴ 
	cMenuHeroWindow*		mpMenuHero;
	cMenuCommuityWindow*	mpMenuCommu;
	cMenuOptionWindow*		mpMenuOption;

	/// ̴ϸ 
	cMiniMapWindow* mpMiniMapWindow;

	/// ĳ 
	cCastingBar* mpCastingBar;

	/// ɼ 
	cOptionWindow* mpOptionWindow;

	/// small ̴ϸ 
	cSmallMiniMapWindow* mpSmallMiniMapWindow;

	///  Ŵ 
	cNoteWindow* mpNoteWindow;

	///  
	cSendNoteWindow* mpSendNoteWindow;

	///  ޱ
	cReceiveNoteWindow* mpReceiveNoteWindow;

	/// ģ 
	cFriendWindow* mpFriendWindow;

	///  ()
	cColumnQuickSlot* mpColumnQuickSlot;

	///  ()
	cRowQuickSlot* mpRowQuickSlot;

	/// FS 
	cFSColumnQuickSlot* mpFSColumnQuickSlot;

	/// FS 
	cFSRowQuickSlot* mpFSRowQuickSlot;

	/// Ÿ  ..
	cTarotWindow*		mpTarotWindow;

	/// Ÿ    (  )
	cTarotControlWindow* mpTarotControlWindow;

	///    
	cUserSellWindow* mpUserSellWindow;
	cUserSellSearchWindow* mpUserSellSearchWindow;

	///   
	cExitWindow*	mpExitWindow;
	cExitMsgWindow* mpExitMsgWindow;

	///    
	cLootingWindow*		mpLootingWindow;

	/// Ȱ 
	cRevivalWindow*		mpRevivalWindow;

	/// Ƽ  
	cPartyWindow*	mpPartyWindow;

	/// Ƽ  
	cPartyStateWindow*	mpPartyStateWindow[5];

	/// Ƽ ޴
	cPartyMenu*		mpPartyMenu;

	/// Ƽ й ޴
	cPartyDivideMenu*	mpPartyDivideMenu;

	/// Ʈ 
	cQuestWindow*	mpQuestWindow;

	/// npc   
	cNpcRewardWindow*	mpNpcRewardWindow;

	/// npc  
	cNpcDisjointWindow*	 mpNpcDisjointWindow;

	///  ȭ 
	cEnhancedWindow*	mpEnhancedWindow;

	/// Ʈ   
	cQuestSimpleWindow*	mpQuestSimpleWindow;

	/// ī 
	cPutCardWindow*		mpPutCardWindow;

	///  
	cDuelMsgWindow*		mpDuelMsgWindow;
	cDuelWindow*		mpDuelWindow;
	bool				mDuelMode;

	/// ī ÷ 
	cCardBookWindow*	mpCardBookWindow;

	/// ȸ 
	cSocialWindow*		mpSocialWindow;

	/// ġ  
	cDMScoreWindow*		mpDMScoreWindow;
	cDMRankingListWindow* mpDMRankingListWindow;

	/// ġ  
	cDMResultWindow*	mpDMResultWindow;

	///
	cDMMsgWindow*		mpDMMsgWindow;
	cDMRevivalWindow*	mpDMRevivalWindow;

	///
	cChatButtonWindow*	mpChatButtonWindow;

	/// ȣĪ 
	cTitleWindow*		mpTitleWindow;

	///   ư 
	cGuildButtonWindow* mpGuildButtonWindow;

	///  
	cGuildWindow*		mpGuildWindow;

	/// 帶ũ  
	cGuildMarkWindow*	mpGuildMarkWindow;

	///  ü  
	cGuildSendNoteWindow*	mpGuildSendNoteWindow;

	///   
	cShortenKeyWindow*	mpShortenKeyWindow;

	///
	cRButtonMenuWindow*	mpRButtonMenuWindow;

	///  Ѹ 
	cTodayWordWindow*	mpTodayWordWindow;

	///   
	cItemMixWindow*		mpItemMixWindow;

	/// save window pos
	typedef tPointerHashMap<unsigned long, void*> cSaveWindowPos;
	typedef tArray<unsigned long> cSaveQuestArr;
	cSaveWindowPos	mSaveWindowInfo;

	sChatWinOption	mChatWinOption[4];
	int				mChatBoxMaxRow;
	float			mMiniWinPer;

	unsigned long	mQuestCharacterIdx;
	cSaveQuestArr	mQuestCheckArr;
};

inline cPartyStateWindow* cGameUIManager::GetPartyStateWindow( unsigned int i )
{
	if( i >= 0 && i < 5 )
		return mpPartyStateWindow[i];
	else
		return 0;
}

inline cGameUIManager* cGameUIManager::GetSingleton()
{
	return mpSingleton;
}

#define GAMEUI cGameUIManager::GetSingleton()
