#pragma once
#include "staticscenenode.h"

class cNameCard;

class cGatheringSceneNodeParam : public cStaticSceneNodeParam
{
public:
	cGatheringSceneNodeParam();

public:

	///   ε
	unsigned long mObjectIdx;

	unsigned long mClassIdx;
	unsigned char mType;
};

inline cGatheringSceneNodeParam::cGatheringSceneNodeParam()
: mObjectIdx(0)
, mClassIdx(0)
{
}

class cEffectSceneNode;

class cGatheringSceneNode : public cManagedStaticSceneNode
{
	friend class cSceneManager;

public:
	inline unsigned long GetGatheringIndex() { return mObjectIdx; }

	inline unsigned long GetGatheringClassIdx() { return mClassIdx; }

	inline bool IsRemove() { return mRemoveFlag; }

	bool IsEnableQuest();

	void Remove();

protected:
	cGatheringSceneNode( eType type = eGATHERING );
	virtual ~cGatheringSceneNode();

	/// ʱȭ
	virtual bool Init( const cGatheringSceneNodeParam& param );
	virtual void OnProcess( unsigned long deltaTime, unsigned long accumTime );

	virtual void AddToVisibleArray();

	void AddEffect();
	void ClearEffect();

protected:
	unsigned long mObjectIdx;

	unsigned long mClassIdx;

	unsigned long mQuestIdx;

	bool mRemoveFlag;

	/// ü  ǥϱ  ü
	cNameCard* mpNameCard;
	float mNameHeight;

	unsigned long		mEffectCheckTimer;

	unsigned long		mEffectIdxByManager;
	cEffectSceneNode*	mEnableGatheringEffect;
};
